/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Details of the input device.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDeviceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDeviceSummary.Builder, InputDeviceSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(InputDeviceSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionState").getter(getter(InputDeviceSummary::connectionStateAsString))
            .setter(setter(Builder::connectionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionState").build()).build();

    private static final SdkField<String> DEVICE_SETTINGS_SYNC_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceSettingsSyncState").getter(getter(InputDeviceSummary::deviceSettingsSyncStateAsString))
            .setter(setter(Builder::deviceSettingsSyncState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceSettingsSyncState").build())
            .build();

    private static final SdkField<String> DEVICE_UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceUpdateStatus").getter(getter(InputDeviceSummary::deviceUpdateStatusAsString))
            .setter(setter(Builder::deviceUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceUpdateStatus").build())
            .build();

    private static final SdkField<InputDeviceHdSettings> HD_DEVICE_SETTINGS_FIELD = SdkField
            .<InputDeviceHdSettings> builder(MarshallingType.SDK_POJO).memberName("HdDeviceSettings")
            .getter(getter(InputDeviceSummary::hdDeviceSettings)).setter(setter(Builder::hdDeviceSettings))
            .constructor(InputDeviceHdSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdDeviceSettings").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(InputDeviceSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MacAddress").getter(getter(InputDeviceSummary::macAddress)).setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InputDeviceSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<InputDeviceNetworkSettings> NETWORK_SETTINGS_FIELD = SdkField
            .<InputDeviceNetworkSettings> builder(MarshallingType.SDK_POJO).memberName("NetworkSettings")
            .getter(getter(InputDeviceSummary::networkSettings)).setter(setter(Builder::networkSettings))
            .constructor(InputDeviceNetworkSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettings").build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumber").getter(getter(InputDeviceSummary::serialNumber)).setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serialNumber").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(InputDeviceSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<InputDeviceUhdSettings> UHD_DEVICE_SETTINGS_FIELD = SdkField
            .<InputDeviceUhdSettings> builder(MarshallingType.SDK_POJO).memberName("UhdDeviceSettings")
            .getter(getter(InputDeviceSummary::uhdDeviceSettings)).setter(setter(Builder::uhdDeviceSettings))
            .constructor(InputDeviceUhdSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uhdDeviceSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONNECTION_STATE_FIELD, DEVICE_SETTINGS_SYNC_STATE_FIELD, DEVICE_UPDATE_STATUS_FIELD, HD_DEVICE_SETTINGS_FIELD,
            ID_FIELD, MAC_ADDRESS_FIELD, NAME_FIELD, NETWORK_SETTINGS_FIELD, SERIAL_NUMBER_FIELD, TYPE_FIELD,
            UHD_DEVICE_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String connectionState;

    private final String deviceSettingsSyncState;

    private final String deviceUpdateStatus;

    private final InputDeviceHdSettings hdDeviceSettings;

    private final String id;

    private final String macAddress;

    private final String name;

    private final InputDeviceNetworkSettings networkSettings;

    private final String serialNumber;

    private final String type;

    private final InputDeviceUhdSettings uhdDeviceSettings;

    private InputDeviceSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.connectionState = builder.connectionState;
        this.deviceSettingsSyncState = builder.deviceSettingsSyncState;
        this.deviceUpdateStatus = builder.deviceUpdateStatus;
        this.hdDeviceSettings = builder.hdDeviceSettings;
        this.id = builder.id;
        this.macAddress = builder.macAddress;
        this.name = builder.name;
        this.networkSettings = builder.networkSettings;
        this.serialNumber = builder.serialNumber;
        this.type = builder.type;
        this.uhdDeviceSettings = builder.uhdDeviceSettings;
    }

    /**
     * The unique ARN of the input device.
     * 
     * @return The unique ARN of the input device.
     */
    public final String arn() {
        return arn;
    }

    /**
     * The state of the connection between the input device and AWS.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link InputDeviceConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection between the input device and AWS.
     * @see InputDeviceConnectionState
     */
    public final InputDeviceConnectionState connectionState() {
        return InputDeviceConnectionState.fromValue(connectionState);
    }

    /**
     * The state of the connection between the input device and AWS.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link InputDeviceConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection between the input device and AWS.
     * @see InputDeviceConnectionState
     */
    public final String connectionStateAsString() {
        return connectionState;
    }

    /**
     * The status of the action to synchronize the device configuration. If you change the configuration of the input
     * device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not
     * update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not
     * updated its configuration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceSettingsSyncState} will return {@link DeviceSettingsSyncState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceSettingsSyncStateAsString}.
     * </p>
     * 
     * @return The status of the action to synchronize the device configuration. If you change the configuration of the
     *         input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device
     *         might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means
     *         that it has not updated its configuration.
     * @see DeviceSettingsSyncState
     */
    public final DeviceSettingsSyncState deviceSettingsSyncState() {
        return DeviceSettingsSyncState.fromValue(deviceSettingsSyncState);
    }

    /**
     * The status of the action to synchronize the device configuration. If you change the configuration of the input
     * device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not
     * update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not
     * updated its configuration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceSettingsSyncState} will return {@link DeviceSettingsSyncState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceSettingsSyncStateAsString}.
     * </p>
     * 
     * @return The status of the action to synchronize the device configuration. If you change the configuration of the
     *         input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device
     *         might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means
     *         that it has not updated its configuration.
     * @see DeviceSettingsSyncState
     */
    public final String deviceSettingsSyncStateAsString() {
        return deviceSettingsSyncState;
    }

    /**
     * The status of software on the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceUpdateStatus} will return {@link DeviceUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deviceUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of software on the input device.
     * @see DeviceUpdateStatus
     */
    public final DeviceUpdateStatus deviceUpdateStatus() {
        return DeviceUpdateStatus.fromValue(deviceUpdateStatus);
    }

    /**
     * The status of software on the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceUpdateStatus} will return {@link DeviceUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deviceUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of software on the input device.
     * @see DeviceUpdateStatus
     */
    public final String deviceUpdateStatusAsString() {
        return deviceUpdateStatus;
    }

    /**
     * Settings that describe an input device that is type HD.
     * 
     * @return Settings that describe an input device that is type HD.
     */
    public final InputDeviceHdSettings hdDeviceSettings() {
        return hdDeviceSettings;
    }

    /**
     * The unique ID of the input device.
     * 
     * @return The unique ID of the input device.
     */
    public final String id() {
        return id;
    }

    /**
     * The network MAC address of the input device.
     * 
     * @return The network MAC address of the input device.
     */
    public final String macAddress() {
        return macAddress;
    }

    /**
     * A name that you specify for the input device.
     * 
     * @return A name that you specify for the input device.
     */
    public final String name() {
        return name;
    }

    /**
     * Network settings for the input device.
     * 
     * @return Network settings for the input device.
     */
    public final InputDeviceNetworkSettings networkSettings() {
        return networkSettings;
    }

    /**
     * The unique serial number of the input device.
     * 
     * @return The unique serial number of the input device.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * The type of the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InputDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the input device.
     * @see InputDeviceType
     */
    public final InputDeviceType type() {
        return InputDeviceType.fromValue(type);
    }

    /**
     * The type of the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InputDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the input device.
     * @see InputDeviceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Settings that describe an input device that is type UHD.
     * 
     * @return Settings that describe an input device that is type UHD.
     */
    public final InputDeviceUhdSettings uhdDeviceSettings() {
        return uhdDeviceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceSettingsSyncStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hdDeviceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkSettings());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uhdDeviceSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceSummary)) {
            return false;
        }
        InputDeviceSummary other = (InputDeviceSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(connectionStateAsString(), other.connectionStateAsString())
                && Objects.equals(deviceSettingsSyncStateAsString(), other.deviceSettingsSyncStateAsString())
                && Objects.equals(deviceUpdateStatusAsString(), other.deviceUpdateStatusAsString())
                && Objects.equals(hdDeviceSettings(), other.hdDeviceSettings()) && Objects.equals(id(), other.id())
                && Objects.equals(macAddress(), other.macAddress()) && Objects.equals(name(), other.name())
                && Objects.equals(networkSettings(), other.networkSettings())
                && Objects.equals(serialNumber(), other.serialNumber()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(uhdDeviceSettings(), other.uhdDeviceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDeviceSummary").add("Arn", arn()).add("ConnectionState", connectionStateAsString())
                .add("DeviceSettingsSyncState", deviceSettingsSyncStateAsString())
                .add("DeviceUpdateStatus", deviceUpdateStatusAsString()).add("HdDeviceSettings", hdDeviceSettings())
                .add("Id", id()).add("MacAddress", macAddress()).add("Name", name()).add("NetworkSettings", networkSettings())
                .add("SerialNumber", serialNumber()).add("Type", typeAsString()).add("UhdDeviceSettings", uhdDeviceSettings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ConnectionState":
            return Optional.ofNullable(clazz.cast(connectionStateAsString()));
        case "DeviceSettingsSyncState":
            return Optional.ofNullable(clazz.cast(deviceSettingsSyncStateAsString()));
        case "DeviceUpdateStatus":
            return Optional.ofNullable(clazz.cast(deviceUpdateStatusAsString()));
        case "HdDeviceSettings":
            return Optional.ofNullable(clazz.cast(hdDeviceSettings()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MacAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkSettings":
            return Optional.ofNullable(clazz.cast(networkSettings()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "UhdDeviceSettings":
            return Optional.ofNullable(clazz.cast(uhdDeviceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceSummary, T> g) {
        return obj -> g.apply((InputDeviceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDeviceSummary> {
        /**
         * The unique ARN of the input device.
         * 
         * @param arn
         *        The unique ARN of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The state of the connection between the input device and AWS.
         * 
         * @param connectionState
         *        The state of the connection between the input device and AWS.
         * @see InputDeviceConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConnectionState
         */
        Builder connectionState(String connectionState);

        /**
         * The state of the connection between the input device and AWS.
         * 
         * @param connectionState
         *        The state of the connection between the input device and AWS.
         * @see InputDeviceConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConnectionState
         */
        Builder connectionState(InputDeviceConnectionState connectionState);

        /**
         * The status of the action to synchronize the device configuration. If you change the configuration of the
         * input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might
         * not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it
         * has not updated its configuration.
         * 
         * @param deviceSettingsSyncState
         *        The status of the action to synchronize the device configuration. If you change the configuration of
         *        the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The
         *        device might not update itself immediately. SYNCED means the device has updated its configuration.
         *        SYNCING means that it has not updated its configuration.
         * @see DeviceSettingsSyncState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceSettingsSyncState
         */
        Builder deviceSettingsSyncState(String deviceSettingsSyncState);

        /**
         * The status of the action to synchronize the device configuration. If you change the configuration of the
         * input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might
         * not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it
         * has not updated its configuration.
         * 
         * @param deviceSettingsSyncState
         *        The status of the action to synchronize the device configuration. If you change the configuration of
         *        the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The
         *        device might not update itself immediately. SYNCED means the device has updated its configuration.
         *        SYNCING means that it has not updated its configuration.
         * @see DeviceSettingsSyncState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceSettingsSyncState
         */
        Builder deviceSettingsSyncState(DeviceSettingsSyncState deviceSettingsSyncState);

        /**
         * The status of software on the input device.
         * 
         * @param deviceUpdateStatus
         *        The status of software on the input device.
         * @see DeviceUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceUpdateStatus
         */
        Builder deviceUpdateStatus(String deviceUpdateStatus);

        /**
         * The status of software on the input device.
         * 
         * @param deviceUpdateStatus
         *        The status of software on the input device.
         * @see DeviceUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceUpdateStatus
         */
        Builder deviceUpdateStatus(DeviceUpdateStatus deviceUpdateStatus);

        /**
         * Settings that describe an input device that is type HD.
         * 
         * @param hdDeviceSettings
         *        Settings that describe an input device that is type HD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hdDeviceSettings(InputDeviceHdSettings hdDeviceSettings);

        /**
         * Settings that describe an input device that is type HD. This is a convenience that creates an instance of the
         * {@link InputDeviceHdSettings.Builder} avoiding the need to create one manually via
         * {@link InputDeviceHdSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDeviceHdSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #hdDeviceSettings(InputDeviceHdSettings)}.
         * 
         * @param hdDeviceSettings
         *        a consumer that will call methods on {@link InputDeviceHdSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hdDeviceSettings(InputDeviceHdSettings)
         */
        default Builder hdDeviceSettings(Consumer<InputDeviceHdSettings.Builder> hdDeviceSettings) {
            return hdDeviceSettings(InputDeviceHdSettings.builder().applyMutation(hdDeviceSettings).build());
        }

        /**
         * The unique ID of the input device.
         * 
         * @param id
         *        The unique ID of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The network MAC address of the input device.
         * 
         * @param macAddress
         *        The network MAC address of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * A name that you specify for the input device.
         * 
         * @param name
         *        A name that you specify for the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Network settings for the input device.
         * 
         * @param networkSettings
         *        Network settings for the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettings(InputDeviceNetworkSettings networkSettings);

        /**
         * Network settings for the input device. This is a convenience that creates an instance of the
         * {@link InputDeviceNetworkSettings.Builder} avoiding the need to create one manually via
         * {@link InputDeviceNetworkSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDeviceNetworkSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #networkSettings(InputDeviceNetworkSettings)}.
         * 
         * @param networkSettings
         *        a consumer that will call methods on {@link InputDeviceNetworkSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSettings(InputDeviceNetworkSettings)
         */
        default Builder networkSettings(Consumer<InputDeviceNetworkSettings.Builder> networkSettings) {
            return networkSettings(InputDeviceNetworkSettings.builder().applyMutation(networkSettings).build());
        }

        /**
         * The unique serial number of the input device.
         * 
         * @param serialNumber
         *        The unique serial number of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * The type of the input device.
         * 
         * @param type
         *        The type of the input device.
         * @see InputDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceType
         */
        Builder type(String type);

        /**
         * The type of the input device.
         * 
         * @param type
         *        The type of the input device.
         * @see InputDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceType
         */
        Builder type(InputDeviceType type);

        /**
         * Settings that describe an input device that is type UHD.
         * 
         * @param uhdDeviceSettings
         *        Settings that describe an input device that is type UHD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uhdDeviceSettings(InputDeviceUhdSettings uhdDeviceSettings);

        /**
         * Settings that describe an input device that is type UHD. This is a convenience that creates an instance of
         * the {@link InputDeviceUhdSettings.Builder} avoiding the need to create one manually via
         * {@link InputDeviceUhdSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDeviceUhdSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #uhdDeviceSettings(InputDeviceUhdSettings)}.
         * 
         * @param uhdDeviceSettings
         *        a consumer that will call methods on {@link InputDeviceUhdSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uhdDeviceSettings(InputDeviceUhdSettings)
         */
        default Builder uhdDeviceSettings(Consumer<InputDeviceUhdSettings.Builder> uhdDeviceSettings) {
            return uhdDeviceSettings(InputDeviceUhdSettings.builder().applyMutation(uhdDeviceSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String connectionState;

        private String deviceSettingsSyncState;

        private String deviceUpdateStatus;

        private InputDeviceHdSettings hdDeviceSettings;

        private String id;

        private String macAddress;

        private String name;

        private InputDeviceNetworkSettings networkSettings;

        private String serialNumber;

        private String type;

        private InputDeviceUhdSettings uhdDeviceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceSummary model) {
            arn(model.arn);
            connectionState(model.connectionState);
            deviceSettingsSyncState(model.deviceSettingsSyncState);
            deviceUpdateStatus(model.deviceUpdateStatus);
            hdDeviceSettings(model.hdDeviceSettings);
            id(model.id);
            macAddress(model.macAddress);
            name(model.name);
            networkSettings(model.networkSettings);
            serialNumber(model.serialNumber);
            type(model.type);
            uhdDeviceSettings(model.uhdDeviceSettings);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getConnectionState() {
            return connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(InputDeviceConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        public final String getDeviceSettingsSyncState() {
            return deviceSettingsSyncState;
        }

        @Override
        public final Builder deviceSettingsSyncState(String deviceSettingsSyncState) {
            this.deviceSettingsSyncState = deviceSettingsSyncState;
            return this;
        }

        @Override
        public final Builder deviceSettingsSyncState(DeviceSettingsSyncState deviceSettingsSyncState) {
            this.deviceSettingsSyncState(deviceSettingsSyncState == null ? null : deviceSettingsSyncState.toString());
            return this;
        }

        public final void setDeviceSettingsSyncState(String deviceSettingsSyncState) {
            this.deviceSettingsSyncState = deviceSettingsSyncState;
        }

        public final String getDeviceUpdateStatus() {
            return deviceUpdateStatus;
        }

        @Override
        public final Builder deviceUpdateStatus(String deviceUpdateStatus) {
            this.deviceUpdateStatus = deviceUpdateStatus;
            return this;
        }

        @Override
        public final Builder deviceUpdateStatus(DeviceUpdateStatus deviceUpdateStatus) {
            this.deviceUpdateStatus(deviceUpdateStatus == null ? null : deviceUpdateStatus.toString());
            return this;
        }

        public final void setDeviceUpdateStatus(String deviceUpdateStatus) {
            this.deviceUpdateStatus = deviceUpdateStatus;
        }

        public final InputDeviceHdSettings.Builder getHdDeviceSettings() {
            return hdDeviceSettings != null ? hdDeviceSettings.toBuilder() : null;
        }

        @Override
        public final Builder hdDeviceSettings(InputDeviceHdSettings hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings;
            return this;
        }

        public final void setHdDeviceSettings(InputDeviceHdSettings.BuilderImpl hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings != null ? hdDeviceSettings.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final InputDeviceNetworkSettings.Builder getNetworkSettings() {
            return networkSettings != null ? networkSettings.toBuilder() : null;
        }

        @Override
        public final Builder networkSettings(InputDeviceNetworkSettings networkSettings) {
            this.networkSettings = networkSettings;
            return this;
        }

        public final void setNetworkSettings(InputDeviceNetworkSettings.BuilderImpl networkSettings) {
            this.networkSettings = networkSettings != null ? networkSettings.build() : null;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputDeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final InputDeviceUhdSettings.Builder getUhdDeviceSettings() {
            return uhdDeviceSettings != null ? uhdDeviceSettings.toBuilder() : null;
        }

        @Override
        public final Builder uhdDeviceSettings(InputDeviceUhdSettings uhdDeviceSettings) {
            this.uhdDeviceSettings = uhdDeviceSettings;
            return this;
        }

        public final void setUhdDeviceSettings(InputDeviceUhdSettings.BuilderImpl uhdDeviceSettings) {
            this.uhdDeviceSettings = uhdDeviceSettings != null ? uhdDeviceSettings.build() : null;
        }

        @Override
        public InputDeviceSummary build() {
            return new InputDeviceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
