/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for InputAttachment
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputAttachment implements SdkPojo, Serializable, ToCopyableBuilder<InputAttachment.Builder, InputAttachment> {
    private static final SdkField<AutomaticInputFailoverSettings> AUTOMATIC_INPUT_FAILOVER_SETTINGS_FIELD = SdkField
            .<AutomaticInputFailoverSettings> builder(MarshallingType.SDK_POJO)
            .memberName("AutomaticInputFailoverSettings")
            .getter(getter(InputAttachment::automaticInputFailoverSettings))
            .setter(setter(Builder::automaticInputFailoverSettings))
            .constructor(AutomaticInputFailoverSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticInputFailoverSettings")
                    .build()).build();

    private static final SdkField<String> INPUT_ATTACHMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputAttachmentName").getter(getter(InputAttachment::inputAttachmentName))
            .setter(setter(Builder::inputAttachmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachmentName").build())
            .build();

    private static final SdkField<String> INPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputId").getter(getter(InputAttachment::inputId)).setter(setter(Builder::inputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputId").build()).build();

    private static final SdkField<InputSettings> INPUT_SETTINGS_FIELD = SdkField
            .<InputSettings> builder(MarshallingType.SDK_POJO).memberName("InputSettings")
            .getter(getter(InputAttachment::inputSettings)).setter(setter(Builder::inputSettings))
            .constructor(InputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATIC_INPUT_FAILOVER_SETTINGS_FIELD, INPUT_ATTACHMENT_NAME_FIELD, INPUT_ID_FIELD, INPUT_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutomaticInputFailoverSettings automaticInputFailoverSettings;

    private final String inputAttachmentName;

    private final String inputId;

    private final InputSettings inputSettings;

    private InputAttachment(BuilderImpl builder) {
        this.automaticInputFailoverSettings = builder.automaticInputFailoverSettings;
        this.inputAttachmentName = builder.inputAttachmentName;
        this.inputId = builder.inputId;
        this.inputSettings = builder.inputSettings;
    }

    /**
     * User-specified settings for defining what the conditions are for declaring the input unhealthy and failing over
     * to a different input.
     * 
     * @return User-specified settings for defining what the conditions are for declaring the input unhealthy and
     *         failing over to a different input.
     */
    public final AutomaticInputFailoverSettings automaticInputFailoverSettings() {
        return automaticInputFailoverSettings;
    }

    /**
     * User-specified name for the attachment. This is required if the user wants to use this input in an input switch
     * action.
     * 
     * @return User-specified name for the attachment. This is required if the user wants to use this input in an input
     *         switch action.
     */
    public final String inputAttachmentName() {
        return inputAttachmentName;
    }

    /**
     * The ID of the input
     * 
     * @return The ID of the input
     */
    public final String inputId() {
        return inputId;
    }

    /**
     * Settings of an input (caption selector, etc.)
     * 
     * @return Settings of an input (caption selector, etc.)
     */
    public final InputSettings inputSettings() {
        return inputSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticInputFailoverSettings());
        hashCode = 31 * hashCode + Objects.hashCode(inputAttachmentName());
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        hashCode = 31 * hashCode + Objects.hashCode(inputSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputAttachment)) {
            return false;
        }
        InputAttachment other = (InputAttachment) obj;
        return Objects.equals(automaticInputFailoverSettings(), other.automaticInputFailoverSettings())
                && Objects.equals(inputAttachmentName(), other.inputAttachmentName())
                && Objects.equals(inputId(), other.inputId()) && Objects.equals(inputSettings(), other.inputSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputAttachment").add("AutomaticInputFailoverSettings", automaticInputFailoverSettings())
                .add("InputAttachmentName", inputAttachmentName()).add("InputId", inputId())
                .add("InputSettings", inputSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticInputFailoverSettings":
            return Optional.ofNullable(clazz.cast(automaticInputFailoverSettings()));
        case "InputAttachmentName":
            return Optional.ofNullable(clazz.cast(inputAttachmentName()));
        case "InputId":
            return Optional.ofNullable(clazz.cast(inputId()));
        case "InputSettings":
            return Optional.ofNullable(clazz.cast(inputSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputAttachment, T> g) {
        return obj -> g.apply((InputAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputAttachment> {
        /**
         * User-specified settings for defining what the conditions are for declaring the input unhealthy and failing
         * over to a different input.
         * 
         * @param automaticInputFailoverSettings
         *        User-specified settings for defining what the conditions are for declaring the input unhealthy and
         *        failing over to a different input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticInputFailoverSettings(AutomaticInputFailoverSettings automaticInputFailoverSettings);

        /**
         * User-specified settings for defining what the conditions are for declaring the input unhealthy and failing
         * over to a different input. This is a convenience that creates an instance of the
         * {@link AutomaticInputFailoverSettings.Builder} avoiding the need to create one manually via
         * {@link AutomaticInputFailoverSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutomaticInputFailoverSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #automaticInputFailoverSettings(AutomaticInputFailoverSettings)}.
         * 
         * @param automaticInputFailoverSettings
         *        a consumer that will call methods on {@link AutomaticInputFailoverSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automaticInputFailoverSettings(AutomaticInputFailoverSettings)
         */
        default Builder automaticInputFailoverSettings(
                Consumer<AutomaticInputFailoverSettings.Builder> automaticInputFailoverSettings) {
            return automaticInputFailoverSettings(AutomaticInputFailoverSettings.builder()
                    .applyMutation(automaticInputFailoverSettings).build());
        }

        /**
         * User-specified name for the attachment. This is required if the user wants to use this input in an input
         * switch action.
         * 
         * @param inputAttachmentName
         *        User-specified name for the attachment. This is required if the user wants to use this input in an
         *        input switch action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachmentName(String inputAttachmentName);

        /**
         * The ID of the input
         * 
         * @param inputId
         *        The ID of the input
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * Settings of an input (caption selector, etc.)
         * 
         * @param inputSettings
         *        Settings of an input (caption selector, etc.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSettings(InputSettings inputSettings);

        /**
         * Settings of an input (caption selector, etc.) This is a convenience that creates an instance of the
         * {@link InputSettings.Builder} avoiding the need to create one manually via {@link InputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSettings(InputSettings)}.
         * 
         * @param inputSettings
         *        a consumer that will call methods on {@link InputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSettings(InputSettings)
         */
        default Builder inputSettings(Consumer<InputSettings.Builder> inputSettings) {
            return inputSettings(InputSettings.builder().applyMutation(inputSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomaticInputFailoverSettings automaticInputFailoverSettings;

        private String inputAttachmentName;

        private String inputId;

        private InputSettings inputSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(InputAttachment model) {
            automaticInputFailoverSettings(model.automaticInputFailoverSettings);
            inputAttachmentName(model.inputAttachmentName);
            inputId(model.inputId);
            inputSettings(model.inputSettings);
        }

        public final AutomaticInputFailoverSettings.Builder getAutomaticInputFailoverSettings() {
            return automaticInputFailoverSettings != null ? automaticInputFailoverSettings.toBuilder() : null;
        }

        @Override
        public final Builder automaticInputFailoverSettings(AutomaticInputFailoverSettings automaticInputFailoverSettings) {
            this.automaticInputFailoverSettings = automaticInputFailoverSettings;
            return this;
        }

        public final void setAutomaticInputFailoverSettings(
                AutomaticInputFailoverSettings.BuilderImpl automaticInputFailoverSettings) {
            this.automaticInputFailoverSettings = automaticInputFailoverSettings != null ? automaticInputFailoverSettings.build()
                    : null;
        }

        public final String getInputAttachmentName() {
            return inputAttachmentName;
        }

        @Override
        public final Builder inputAttachmentName(String inputAttachmentName) {
            this.inputAttachmentName = inputAttachmentName;
            return this;
        }

        public final void setInputAttachmentName(String inputAttachmentName) {
            this.inputAttachmentName = inputAttachmentName;
        }

        public final String getInputId() {
            return inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final InputSettings.Builder getInputSettings() {
            return inputSettings != null ? inputSettings.toBuilder() : null;
        }

        @Override
        public final Builder inputSettings(InputSettings inputSettings) {
            this.inputSettings = inputSettings;
            return this;
        }

        public final void setInputSettings(InputSettings.BuilderImpl inputSettings) {
            this.inputSettings = inputSettings != null ? inputSettings.build() : null;
        }

        @Override
        public InputAttachment build() {
            return new InputAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
