/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Ebu Tt DDestination Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbuTtDDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<EbuTtDDestinationSettings.Builder, EbuTtDDestinationSettings> {
    private static final SdkField<String> FILL_LINE_GAP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FillLineGap").getter(getter(EbuTtDDestinationSettings::fillLineGapAsString))
            .setter(setter(Builder::fillLineGap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fillLineGap").build()).build();

    private static final SdkField<String> FONT_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontFamily").getter(getter(EbuTtDDestinationSettings::fontFamily)).setter(setter(Builder::fontFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontFamily").build()).build();

    private static final SdkField<String> STYLE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StyleControl").getter(getter(EbuTtDDestinationSettings::styleControlAsString))
            .setter(setter(Builder::styleControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("styleControl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILL_LINE_GAP_FIELD,
            FONT_FAMILY_FIELD, STYLE_CONTROL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fillLineGap;

    private final String fontFamily;

    private final String styleControl;

    private EbuTtDDestinationSettings(BuilderImpl builder) {
        this.fillLineGap = builder.fillLineGap;
        this.fontFamily = builder.fontFamily;
        this.styleControl = builder.styleControl;
    }

    /**
     * Specifies how to handle the gap between the lines (in multi-line captions).
     *
     * - enabled: Fill with the captions background color (as specified in the input captions). - disabled: Leave the
     * gap unfilled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fillLineGap} will
     * return {@link EbuTtDFillLineGapControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fillLineGapAsString}.
     * </p>
     * 
     * @return Specifies how to handle the gap between the lines (in multi-line captions).
     *
     *         - enabled: Fill with the captions background color (as specified in the input captions). - disabled:
     *         Leave the gap unfilled.
     * @see EbuTtDFillLineGapControl
     */
    public final EbuTtDFillLineGapControl fillLineGap() {
        return EbuTtDFillLineGapControl.fromValue(fillLineGap);
    }

    /**
     * Specifies how to handle the gap between the lines (in multi-line captions).
     *
     * - enabled: Fill with the captions background color (as specified in the input captions). - disabled: Leave the
     * gap unfilled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fillLineGap} will
     * return {@link EbuTtDFillLineGapControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fillLineGapAsString}.
     * </p>
     * 
     * @return Specifies how to handle the gap between the lines (in multi-line captions).
     *
     *         - enabled: Fill with the captions background color (as specified in the input captions). - disabled:
     *         Leave the gap unfilled.
     * @see EbuTtDFillLineGapControl
     */
    public final String fillLineGapAsString() {
        return fillLineGap;
    }

    /**
     * Specifies the font family to include in the font data attached to the EBU-TT captions. Valid only if styleControl
     * is set to include. If you leave this field empty, the font family is set to "monospaced". (If styleControl is set
     * to exclude, the font family is always set to "monospaced".)
     *
     * You specify only the font family. All other style information (color, bold, position and so on) is copied from
     * the input captions. The size is always set to 100% to allow the downstream player to choose the size.
     *
     * - Enter a list of font families, as a comma-separated list of font names, in order of preference. The name can be
     * a font family (such as “Arial”), or a generic font family (such as “serif”), or “default” (to let the downstream
     * player choose the font). - Leave blank to set the family to “monospace”.
     * 
     * @return Specifies the font family to include in the font data attached to the EBU-TT captions. Valid only if
     *         styleControl is set to include. If you leave this field empty, the font family is set to "monospaced".
     *         (If styleControl is set to exclude, the font family is always set to "monospaced".)
     *
     *         You specify only the font family. All other style information (color, bold, position and so on) is copied
     *         from the input captions. The size is always set to 100% to allow the downstream player to choose the
     *         size.
     *
     *         - Enter a list of font families, as a comma-separated list of font names, in order of preference. The
     *         name can be a font family (such as “Arial”), or a generic font family (such as “serif”), or “default” (to
     *         let the downstream player choose the font). - Leave blank to set the family to “monospace”.
     */
    public final String fontFamily() {
        return fontFamily;
    }

    /**
     * Specifies the style information (font color, font position, and so on) to include in the font data that is
     * attached to the EBU-TT captions.
     *
     * - include: Take the style information (font color, font position, and so on) from the source captions and include
     * that information in the font data attached to the EBU-TT captions. This option is valid only if the source
     * captions are Embedded or Teletext. - exclude: In the font data attached to the EBU-TT captions, set the font
     * family to "monospaced". Do not include any other style information.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #styleControl} will
     * return {@link EbuTtDDestinationStyleControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #styleControlAsString}.
     * </p>
     * 
     * @return Specifies the style information (font color, font position, and so on) to include in the font data that
     *         is attached to the EBU-TT captions.
     *
     *         - include: Take the style information (font color, font position, and so on) from the source captions and
     *         include that information in the font data attached to the EBU-TT captions. This option is valid only if
     *         the source captions are Embedded or Teletext. - exclude: In the font data attached to the EBU-TT
     *         captions, set the font family to "monospaced". Do not include any other style information.
     * @see EbuTtDDestinationStyleControl
     */
    public final EbuTtDDestinationStyleControl styleControl() {
        return EbuTtDDestinationStyleControl.fromValue(styleControl);
    }

    /**
     * Specifies the style information (font color, font position, and so on) to include in the font data that is
     * attached to the EBU-TT captions.
     *
     * - include: Take the style information (font color, font position, and so on) from the source captions and include
     * that information in the font data attached to the EBU-TT captions. This option is valid only if the source
     * captions are Embedded or Teletext. - exclude: In the font data attached to the EBU-TT captions, set the font
     * family to "monospaced". Do not include any other style information.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #styleControl} will
     * return {@link EbuTtDDestinationStyleControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #styleControlAsString}.
     * </p>
     * 
     * @return Specifies the style information (font color, font position, and so on) to include in the font data that
     *         is attached to the EBU-TT captions.
     *
     *         - include: Take the style information (font color, font position, and so on) from the source captions and
     *         include that information in the font data attached to the EBU-TT captions. This option is valid only if
     *         the source captions are Embedded or Teletext. - exclude: In the font data attached to the EBU-TT
     *         captions, set the font family to "monospaced". Do not include any other style information.
     * @see EbuTtDDestinationStyleControl
     */
    public final String styleControlAsString() {
        return styleControl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fillLineGapAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fontFamily());
        hashCode = 31 * hashCode + Objects.hashCode(styleControlAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbuTtDDestinationSettings)) {
            return false;
        }
        EbuTtDDestinationSettings other = (EbuTtDDestinationSettings) obj;
        return Objects.equals(fillLineGapAsString(), other.fillLineGapAsString())
                && Objects.equals(fontFamily(), other.fontFamily())
                && Objects.equals(styleControlAsString(), other.styleControlAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbuTtDDestinationSettings").add("FillLineGap", fillLineGapAsString())
                .add("FontFamily", fontFamily()).add("StyleControl", styleControlAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FillLineGap":
            return Optional.ofNullable(clazz.cast(fillLineGapAsString()));
        case "FontFamily":
            return Optional.ofNullable(clazz.cast(fontFamily()));
        case "StyleControl":
            return Optional.ofNullable(clazz.cast(styleControlAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbuTtDDestinationSettings, T> g) {
        return obj -> g.apply((EbuTtDDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbuTtDDestinationSettings> {
        /**
         * Specifies how to handle the gap between the lines (in multi-line captions).
         *
         * - enabled: Fill with the captions background color (as specified in the input captions). - disabled: Leave
         * the gap unfilled.
         * 
         * @param fillLineGap
         *        Specifies how to handle the gap between the lines (in multi-line captions).
         *
         *        - enabled: Fill with the captions background color (as specified in the input captions). - disabled:
         *        Leave the gap unfilled.
         * @see EbuTtDFillLineGapControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbuTtDFillLineGapControl
         */
        Builder fillLineGap(String fillLineGap);

        /**
         * Specifies how to handle the gap between the lines (in multi-line captions).
         *
         * - enabled: Fill with the captions background color (as specified in the input captions). - disabled: Leave
         * the gap unfilled.
         * 
         * @param fillLineGap
         *        Specifies how to handle the gap between the lines (in multi-line captions).
         *
         *        - enabled: Fill with the captions background color (as specified in the input captions). - disabled:
         *        Leave the gap unfilled.
         * @see EbuTtDFillLineGapControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbuTtDFillLineGapControl
         */
        Builder fillLineGap(EbuTtDFillLineGapControl fillLineGap);

        /**
         * Specifies the font family to include in the font data attached to the EBU-TT captions. Valid only if
         * styleControl is set to include. If you leave this field empty, the font family is set to "monospaced". (If
         * styleControl is set to exclude, the font family is always set to "monospaced".)
         *
         * You specify only the font family. All other style information (color, bold, position and so on) is copied
         * from the input captions. The size is always set to 100% to allow the downstream player to choose the size.
         *
         * - Enter a list of font families, as a comma-separated list of font names, in order of preference. The name
         * can be a font family (such as “Arial”), or a generic font family (such as “serif”), or “default” (to let the
         * downstream player choose the font). - Leave blank to set the family to “monospace”.
         * 
         * @param fontFamily
         *        Specifies the font family to include in the font data attached to the EBU-TT captions. Valid only if
         *        styleControl is set to include. If you leave this field empty, the font family is set to "monospaced".
         *        (If styleControl is set to exclude, the font family is always set to "monospaced".)
         *
         *        You specify only the font family. All other style information (color, bold, position and so on) is
         *        copied from the input captions. The size is always set to 100% to allow the downstream player to
         *        choose the size.
         *
         *        - Enter a list of font families, as a comma-separated list of font names, in order of preference. The
         *        name can be a font family (such as “Arial”), or a generic font family (such as “serif”), or “default”
         *        (to let the downstream player choose the font). - Leave blank to set the family to “monospace”.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontFamily(String fontFamily);

        /**
         * Specifies the style information (font color, font position, and so on) to include in the font data that is
         * attached to the EBU-TT captions.
         *
         * - include: Take the style information (font color, font position, and so on) from the source captions and
         * include that information in the font data attached to the EBU-TT captions. This option is valid only if the
         * source captions are Embedded or Teletext. - exclude: In the font data attached to the EBU-TT captions, set
         * the font family to "monospaced". Do not include any other style information.
         * 
         * @param styleControl
         *        Specifies the style information (font color, font position, and so on) to include in the font data
         *        that is attached to the EBU-TT captions.
         *
         *        - include: Take the style information (font color, font position, and so on) from the source captions
         *        and include that information in the font data attached to the EBU-TT captions. This option is valid
         *        only if the source captions are Embedded or Teletext. - exclude: In the font data attached to the
         *        EBU-TT captions, set the font family to "monospaced". Do not include any other style information.
         * @see EbuTtDDestinationStyleControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbuTtDDestinationStyleControl
         */
        Builder styleControl(String styleControl);

        /**
         * Specifies the style information (font color, font position, and so on) to include in the font data that is
         * attached to the EBU-TT captions.
         *
         * - include: Take the style information (font color, font position, and so on) from the source captions and
         * include that information in the font data attached to the EBU-TT captions. This option is valid only if the
         * source captions are Embedded or Teletext. - exclude: In the font data attached to the EBU-TT captions, set
         * the font family to "monospaced". Do not include any other style information.
         * 
         * @param styleControl
         *        Specifies the style information (font color, font position, and so on) to include in the font data
         *        that is attached to the EBU-TT captions.
         *
         *        - include: Take the style information (font color, font position, and so on) from the source captions
         *        and include that information in the font data attached to the EBU-TT captions. This option is valid
         *        only if the source captions are Embedded or Teletext. - exclude: In the font data attached to the
         *        EBU-TT captions, set the font family to "monospaced". Do not include any other style information.
         * @see EbuTtDDestinationStyleControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbuTtDDestinationStyleControl
         */
        Builder styleControl(EbuTtDDestinationStyleControl styleControl);
    }

    static final class BuilderImpl implements Builder {
        private String fillLineGap;

        private String fontFamily;

        private String styleControl;

        private BuilderImpl() {
        }

        private BuilderImpl(EbuTtDDestinationSettings model) {
            fillLineGap(model.fillLineGap);
            fontFamily(model.fontFamily);
            styleControl(model.styleControl);
        }

        public final String getFillLineGap() {
            return fillLineGap;
        }

        @Override
        public final Builder fillLineGap(String fillLineGap) {
            this.fillLineGap = fillLineGap;
            return this;
        }

        @Override
        public final Builder fillLineGap(EbuTtDFillLineGapControl fillLineGap) {
            this.fillLineGap(fillLineGap == null ? null : fillLineGap.toString());
            return this;
        }

        public final void setFillLineGap(String fillLineGap) {
            this.fillLineGap = fillLineGap;
        }

        public final String getFontFamily() {
            return fontFamily;
        }

        @Override
        public final Builder fontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
            return this;
        }

        public final void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
        }

        public final String getStyleControl() {
            return styleControl;
        }

        @Override
        public final Builder styleControl(String styleControl) {
            this.styleControl = styleControl;
            return this;
        }

        @Override
        public final Builder styleControl(EbuTtDDestinationStyleControl styleControl) {
            this.styleControl(styleControl == null ? null : styleControl.toString());
            return this;
        }

        public final void setStyleControl(String styleControl) {
            this.styleControl = styleControl;
        }

        @Override
        public EbuTtDDestinationSettings build() {
            return new EbuTtDDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
