/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ChannelSummary
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelSummary implements SdkPojo, Serializable, ToCopyableBuilder<ChannelSummary.Builder, ChannelSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ChannelSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<CdiInputSpecification> CDI_INPUT_SPECIFICATION_FIELD = SdkField
            .<CdiInputSpecification> builder(MarshallingType.SDK_POJO).memberName("CdiInputSpecification")
            .getter(getter(ChannelSummary::cdiInputSpecification)).setter(setter(Builder::cdiInputSpecification))
            .constructor(CdiInputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cdiInputSpecification").build())
            .build();

    private static final SdkField<String> CHANNEL_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelClass").getter(getter(ChannelSummary::channelClassAsString))
            .setter(setter(Builder::channelClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelClass").build()).build();

    private static final SdkField<List<OutputDestination>> DESTINATIONS_FIELD = SdkField
            .<List<OutputDestination>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(ChannelSummary::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ChannelEgressEndpoint>> EGRESS_ENDPOINTS_FIELD = SdkField
            .<List<ChannelEgressEndpoint>> builder(MarshallingType.LIST)
            .memberName("EgressEndpoints")
            .getter(getter(ChannelSummary::egressEndpoints))
            .setter(setter(Builder::egressEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelEgressEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelEgressEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ChannelSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<InputAttachment>> INPUT_ATTACHMENTS_FIELD = SdkField
            .<List<InputAttachment>> builder(MarshallingType.LIST)
            .memberName("InputAttachments")
            .getter(getter(ChannelSummary::inputAttachments))
            .setter(setter(Builder::inputAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InputSpecification> INPUT_SPECIFICATION_FIELD = SdkField
            .<InputSpecification> builder(MarshallingType.SDK_POJO).memberName("InputSpecification")
            .getter(getter(ChannelSummary::inputSpecification)).setter(setter(Builder::inputSpecification))
            .constructor(InputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSpecification").build())
            .build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevel").getter(getter(ChannelSummary::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ChannelSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PIPELINES_RUNNING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PipelinesRunningCount").getter(getter(ChannelSummary::pipelinesRunningCount))
            .setter(setter(Builder::pipelinesRunningCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelinesRunningCount").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(ChannelSummary::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ChannelSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(ChannelSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<VpcOutputSettings> VPC_FIELD = SdkField.<VpcOutputSettings> builder(MarshallingType.SDK_POJO)
            .memberName("Vpc").getter(getter(ChannelSummary::vpc)).setter(setter(Builder::vpc))
            .constructor(VpcOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CDI_INPUT_SPECIFICATION_FIELD, CHANNEL_CLASS_FIELD, DESTINATIONS_FIELD, EGRESS_ENDPOINTS_FIELD, ID_FIELD,
            INPUT_ATTACHMENTS_FIELD, INPUT_SPECIFICATION_FIELD, LOG_LEVEL_FIELD, NAME_FIELD, PIPELINES_RUNNING_COUNT_FIELD,
            ROLE_ARN_FIELD, STATE_FIELD, TAGS_FIELD, VPC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final CdiInputSpecification cdiInputSpecification;

    private final String channelClass;

    private final List<OutputDestination> destinations;

    private final List<ChannelEgressEndpoint> egressEndpoints;

    private final String id;

    private final List<InputAttachment> inputAttachments;

    private final InputSpecification inputSpecification;

    private final String logLevel;

    private final String name;

    private final Integer pipelinesRunningCount;

    private final String roleArn;

    private final String state;

    private final Map<String, String> tags;

    private final VpcOutputSettings vpc;

    private ChannelSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.cdiInputSpecification = builder.cdiInputSpecification;
        this.channelClass = builder.channelClass;
        this.destinations = builder.destinations;
        this.egressEndpoints = builder.egressEndpoints;
        this.id = builder.id;
        this.inputAttachments = builder.inputAttachments;
        this.inputSpecification = builder.inputSpecification;
        this.logLevel = builder.logLevel;
        this.name = builder.name;
        this.pipelinesRunningCount = builder.pipelinesRunningCount;
        this.roleArn = builder.roleArn;
        this.state = builder.state;
        this.tags = builder.tags;
        this.vpc = builder.vpc;
    }

    /**
     * The unique arn of the channel.
     * 
     * @return The unique arn of the channel.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Specification of CDI inputs for this channel
     * 
     * @return Specification of CDI inputs for this channel
     */
    public final CdiInputSpecification cdiInputSpecification() {
        return cdiInputSpecification;
    }

    /**
     * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one
     * pipeline.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelClass} will
     * return {@link ChannelClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelClassAsString}.
     * </p>
     * 
     * @return The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
     *         with one pipeline.
     * @see ChannelClass
     */
    public final ChannelClass channelClass() {
        return ChannelClass.fromValue(channelClass);
    }

    /**
     * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one
     * pipeline.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelClass} will
     * return {@link ChannelClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelClassAsString}.
     * </p>
     * 
     * @return The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
     *         with one pipeline.
     * @see ChannelClass
     */
    public final String channelClassAsString() {
        return channelClass;
    }

    /**
     * Returns true if the Destinations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * A list of destinations of the channel. For UDP outputs, there is one destination per output. For other types
     * (HLS, for example), there is one destination per packager.
     *
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of destinations of the channel. For UDP outputs, there is one destination per output. For other
     *         types (HLS, for example), there is one destination per packager.
     */
    public final List<OutputDestination> destinations() {
        return destinations;
    }

    /**
     * Returns true if the EgressEndpoints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasEgressEndpoints() {
        return egressEndpoints != null && !(egressEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * The endpoints where outgoing connections initiate from
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEgressEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The endpoints where outgoing connections initiate from
     */
    public final List<ChannelEgressEndpoint> egressEndpoints() {
        return egressEndpoints;
    }

    /**
     * The unique id of the channel.
     * 
     * @return The unique id of the channel.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns true if the InputAttachments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInputAttachments() {
        return inputAttachments != null && !(inputAttachments instanceof SdkAutoConstructList);
    }

    /**
     * List of input attachments for channel.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputAttachments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of input attachments for channel.
     */
    public final List<InputAttachment> inputAttachments() {
        return inputAttachments;
    }

    /**
     * Specification of network and file inputs for this channel
     * 
     * @return Specification of network and file inputs for this channel
     */
    public final InputSpecification inputSpecification() {
        return inputSpecification;
    }

    /**
     * The log level being written to CloudWatch Logs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The log level being written to CloudWatch Logs.
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * The log level being written to CloudWatch Logs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The log level being written to CloudWatch Logs.
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * The name of the channel. (user-mutable)
     * 
     * @return The name of the channel. (user-mutable)
     */
    public final String name() {
        return name;
    }

    /**
     * The number of currently healthy pipelines.
     * 
     * @return The number of currently healthy pipelines.
     */
    public final Integer pipelinesRunningCount() {
        return pipelinesRunningCount;
    }

    /**
     * The Amazon Resource Name (ARN) of the role assumed when running the Channel.
     * 
     * @return The Amazon Resource Name (ARN) of the role assumed when running the Channel.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ChannelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see ChannelState
     */
    public final ChannelState state() {
        return ChannelState.fromValue(state);
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ChannelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see ChannelState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * Settings for VPC output
     * 
     * @return Settings for VPC output
     */
    public final VpcOutputSettings vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(cdiInputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(channelClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEgressEndpoints() ? egressEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputAttachments() ? inputAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pipelinesRunningCount());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelSummary)) {
            return false;
        }
        ChannelSummary other = (ChannelSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(cdiInputSpecification(), other.cdiInputSpecification())
                && Objects.equals(channelClassAsString(), other.channelClassAsString())
                && hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations())
                && hasEgressEndpoints() == other.hasEgressEndpoints()
                && Objects.equals(egressEndpoints(), other.egressEndpoints()) && Objects.equals(id(), other.id())
                && hasInputAttachments() == other.hasInputAttachments()
                && Objects.equals(inputAttachments(), other.inputAttachments())
                && Objects.equals(inputSpecification(), other.inputSpecification())
                && Objects.equals(logLevelAsString(), other.logLevelAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(pipelinesRunningCount(), other.pipelinesRunningCount())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(stateAsString(), other.stateAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelSummary").add("Arn", arn()).add("CdiInputSpecification", cdiInputSpecification())
                .add("ChannelClass", channelClassAsString()).add("Destinations", hasDestinations() ? destinations() : null)
                .add("EgressEndpoints", hasEgressEndpoints() ? egressEndpoints() : null).add("Id", id())
                .add("InputAttachments", hasInputAttachments() ? inputAttachments() : null)
                .add("InputSpecification", inputSpecification()).add("LogLevel", logLevelAsString()).add("Name", name())
                .add("PipelinesRunningCount", pipelinesRunningCount()).add("RoleArn", roleArn()).add("State", stateAsString())
                .add("Tags", hasTags() ? tags() : null).add("Vpc", vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CdiInputSpecification":
            return Optional.ofNullable(clazz.cast(cdiInputSpecification()));
        case "ChannelClass":
            return Optional.ofNullable(clazz.cast(channelClassAsString()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "EgressEndpoints":
            return Optional.ofNullable(clazz.cast(egressEndpoints()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InputAttachments":
            return Optional.ofNullable(clazz.cast(inputAttachments()));
        case "InputSpecification":
            return Optional.ofNullable(clazz.cast(inputSpecification()));
        case "LogLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PipelinesRunningCount":
            return Optional.ofNullable(clazz.cast(pipelinesRunningCount()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelSummary, T> g) {
        return obj -> g.apply((ChannelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelSummary> {
        /**
         * The unique arn of the channel.
         * 
         * @param arn
         *        The unique arn of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Specification of CDI inputs for this channel
         * 
         * @param cdiInputSpecification
         *        Specification of CDI inputs for this channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdiInputSpecification(CdiInputSpecification cdiInputSpecification);

        /**
         * Specification of CDI inputs for this channel This is a convenience that creates an instance of the
         * {@link CdiInputSpecification.Builder} avoiding the need to create one manually via
         * {@link CdiInputSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link CdiInputSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #cdiInputSpecification(CdiInputSpecification)}.
         * 
         * @param cdiInputSpecification
         *        a consumer that will call methods on {@link CdiInputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cdiInputSpecification(CdiInputSpecification)
         */
        default Builder cdiInputSpecification(Consumer<CdiInputSpecification.Builder> cdiInputSpecification) {
            return cdiInputSpecification(CdiInputSpecification.builder().applyMutation(cdiInputSpecification).build());
        }

        /**
         * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with
         * one pipeline.
         * 
         * @param channelClass
         *        The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
         *        with one pipeline.
         * @see ChannelClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelClass
         */
        Builder channelClass(String channelClass);

        /**
         * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with
         * one pipeline.
         * 
         * @param channelClass
         *        The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
         *        with one pipeline.
         * @see ChannelClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelClass
         */
        Builder channelClass(ChannelClass channelClass);

        /**
         * A list of destinations of the channel. For UDP outputs, there is one destination per output. For other types
         * (HLS, for example), there is one destination per packager.
         *
         * @param destinations
         *        A list of destinations of the channel. For UDP outputs, there is one destination per output. For other
         *        types (HLS, for example), there is one destination per packager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<OutputDestination> destinations);

        /**
         * A list of destinations of the channel. For UDP outputs, there is one destination per output. For other types
         * (HLS, for example), there is one destination per packager.
         *
         * @param destinations
         *        A list of destinations of the channel. For UDP outputs, there is one destination per output. For other
         *        types (HLS, for example), there is one destination per packager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(OutputDestination... destinations);

        /**
         * A list of destinations of the channel. For UDP outputs, there is one destination per output. For other types
         * (HLS, for example), there is one destination per packager.
         *
         * This is a convenience that creates an instance of the {@link List<OutputDestination>.Builder} avoiding the
         * need to create one manually via {@link List<OutputDestination>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputDestination>.Builder#build()} is called immediately
         * and its result is passed to {@link #destinations(List<OutputDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on {@link List<OutputDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(List<OutputDestination>)
         */
        Builder destinations(Consumer<OutputDestination.Builder>... destinations);

        /**
         * The endpoints where outgoing connections initiate from
         * 
         * @param egressEndpoints
         *        The endpoints where outgoing connections initiate from
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressEndpoints(Collection<ChannelEgressEndpoint> egressEndpoints);

        /**
         * The endpoints where outgoing connections initiate from
         * 
         * @param egressEndpoints
         *        The endpoints where outgoing connections initiate from
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressEndpoints(ChannelEgressEndpoint... egressEndpoints);

        /**
         * The endpoints where outgoing connections initiate from This is a convenience that creates an instance of the
         * {@link List<ChannelEgressEndpoint>.Builder} avoiding the need to create one manually via {@link List
         * <ChannelEgressEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChannelEgressEndpoint>.Builder#build()} is called
         * immediately and its result is passed to {@link #egressEndpoints(List<ChannelEgressEndpoint>)}.
         * 
         * @param egressEndpoints
         *        a consumer that will call methods on {@link List<ChannelEgressEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressEndpoints(List<ChannelEgressEndpoint>)
         */
        Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder>... egressEndpoints);

        /**
         * The unique id of the channel.
         * 
         * @param id
         *        The unique id of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * List of input attachments for channel.
         * 
         * @param inputAttachments
         *        List of input attachments for channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachments(Collection<InputAttachment> inputAttachments);

        /**
         * List of input attachments for channel.
         * 
         * @param inputAttachments
         *        List of input attachments for channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachments(InputAttachment... inputAttachments);

        /**
         * List of input attachments for channel. This is a convenience that creates an instance of the {@link List
         * <InputAttachment>.Builder} avoiding the need to create one manually via {@link List
         * <InputAttachment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputAttachment>.Builder#build()} is called immediately and
         * its result is passed to {@link #inputAttachments(List<InputAttachment>)}.
         * 
         * @param inputAttachments
         *        a consumer that will call methods on {@link List<InputAttachment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputAttachments(List<InputAttachment>)
         */
        Builder inputAttachments(Consumer<InputAttachment.Builder>... inputAttachments);

        /**
         * Specification of network and file inputs for this channel
         * 
         * @param inputSpecification
         *        Specification of network and file inputs for this channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSpecification(InputSpecification inputSpecification);

        /**
         * Specification of network and file inputs for this channel This is a convenience that creates an instance of
         * the {@link InputSpecification.Builder} avoiding the need to create one manually via
         * {@link InputSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputSpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSpecification(InputSpecification)}.
         * 
         * @param inputSpecification
         *        a consumer that will call methods on {@link InputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSpecification(InputSpecification)
         */
        default Builder inputSpecification(Consumer<InputSpecification.Builder> inputSpecification) {
            return inputSpecification(InputSpecification.builder().applyMutation(inputSpecification).build());
        }

        /**
         * The log level being written to CloudWatch Logs.
         * 
         * @param logLevel
         *        The log level being written to CloudWatch Logs.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * The log level being written to CloudWatch Logs.
         * 
         * @param logLevel
         *        The log level being written to CloudWatch Logs.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);

        /**
         * The name of the channel. (user-mutable)
         * 
         * @param name
         *        The name of the channel. (user-mutable)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The number of currently healthy pipelines.
         * 
         * @param pipelinesRunningCount
         *        The number of currently healthy pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelinesRunningCount(Integer pipelinesRunningCount);

        /**
         * The Amazon Resource Name (ARN) of the role assumed when running the Channel.
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role assumed when running the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see ChannelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelState
         */
        Builder state(String state);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see ChannelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelState
         */
        Builder state(ChannelState state);

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Settings for VPC output
         * 
         * @param vpc
         *        Settings for VPC output
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VpcOutputSettings vpc);

        /**
         * Settings for VPC output This is a convenience that creates an instance of the
         * {@link VpcOutputSettings.Builder} avoiding the need to create one manually via
         * {@link VpcOutputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcOutputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #vpc(VpcOutputSettings)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VpcOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VpcOutputSettings)
         */
        default Builder vpc(Consumer<VpcOutputSettings.Builder> vpc) {
            return vpc(VpcOutputSettings.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private CdiInputSpecification cdiInputSpecification;

        private String channelClass;

        private List<OutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private List<ChannelEgressEndpoint> egressEndpoints = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private List<InputAttachment> inputAttachments = DefaultSdkAutoConstructList.getInstance();

        private InputSpecification inputSpecification;

        private String logLevel;

        private String name;

        private Integer pipelinesRunningCount;

        private String roleArn;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private VpcOutputSettings vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelSummary model) {
            arn(model.arn);
            cdiInputSpecification(model.cdiInputSpecification);
            channelClass(model.channelClass);
            destinations(model.destinations);
            egressEndpoints(model.egressEndpoints);
            id(model.id);
            inputAttachments(model.inputAttachments);
            inputSpecification(model.inputSpecification);
            logLevel(model.logLevel);
            name(model.name);
            pipelinesRunningCount(model.pipelinesRunningCount);
            roleArn(model.roleArn);
            state(model.state);
            tags(model.tags);
            vpc(model.vpc);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final CdiInputSpecification.Builder getCdiInputSpecification() {
            return cdiInputSpecification != null ? cdiInputSpecification.toBuilder() : null;
        }

        @Override
        public final Builder cdiInputSpecification(CdiInputSpecification cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification;
            return this;
        }

        public final void setCdiInputSpecification(CdiInputSpecification.BuilderImpl cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification != null ? cdiInputSpecification.build() : null;
        }

        public final String getChannelClass() {
            return channelClass;
        }

        @Override
        public final Builder channelClass(String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        @Override
        public final Builder channelClass(ChannelClass channelClass) {
            this.channelClass(channelClass == null ? null : channelClass.toString());
            return this;
        }

        public final void setChannelClass(String channelClass) {
            this.channelClass = channelClass;
        }

        public final Collection<OutputDestination.Builder> getDestinations() {
            if (destinations instanceof SdkAutoConstructList) {
                return null;
            }
            return destinations != null ? destinations.stream().map(OutputDestination::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(OutputDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> OutputDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        public final Collection<ChannelEgressEndpoint.Builder> getEgressEndpoints() {
            if (egressEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return egressEndpoints != null ? egressEndpoints.stream().map(ChannelEgressEndpoint::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder egressEndpoints(Collection<ChannelEgressEndpoint> egressEndpoints) {
            this.egressEndpoints = ___listOfChannelEgressEndpointCopier.copy(egressEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(ChannelEgressEndpoint... egressEndpoints) {
            egressEndpoints(Arrays.asList(egressEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder>... egressEndpoints) {
            egressEndpoints(Stream.of(egressEndpoints).map(c -> ChannelEgressEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEgressEndpoints(Collection<ChannelEgressEndpoint.BuilderImpl> egressEndpoints) {
            this.egressEndpoints = ___listOfChannelEgressEndpointCopier.copyFromBuilder(egressEndpoints);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<InputAttachment.Builder> getInputAttachments() {
            if (inputAttachments instanceof SdkAutoConstructList) {
                return null;
            }
            return inputAttachments != null ? inputAttachments.stream().map(InputAttachment::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputAttachments(Collection<InputAttachment> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copy(inputAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(InputAttachment... inputAttachments) {
            inputAttachments(Arrays.asList(inputAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(Consumer<InputAttachment.Builder>... inputAttachments) {
            inputAttachments(Stream.of(inputAttachments).map(c -> InputAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputAttachments(Collection<InputAttachment.BuilderImpl> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copyFromBuilder(inputAttachments);
        }

        public final InputSpecification.Builder getInputSpecification() {
            return inputSpecification != null ? inputSpecification.toBuilder() : null;
        }

        @Override
        public final Builder inputSpecification(InputSpecification inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        public final void setInputSpecification(InputSpecification.BuilderImpl inputSpecification) {
            this.inputSpecification = inputSpecification != null ? inputSpecification.build() : null;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPipelinesRunningCount() {
            return pipelinesRunningCount;
        }

        @Override
        public final Builder pipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
            return this;
        }

        public final void setPipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ChannelState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final VpcOutputSettings.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VpcOutputSettings vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(VpcOutputSettings.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public ChannelSummary build() {
            return new ChannelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
