/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Caption Destination Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptionDestinationSettings.Builder, CaptionDestinationSettings> {
    private static final SdkField<AribDestinationSettings> ARIB_DESTINATION_SETTINGS_FIELD = SdkField
            .<AribDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("AribDestinationSettings")
            .getter(getter(CaptionDestinationSettings::aribDestinationSettings)).setter(setter(Builder::aribDestinationSettings))
            .constructor(AribDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aribDestinationSettings").build())
            .build();

    private static final SdkField<BurnInDestinationSettings> BURN_IN_DESTINATION_SETTINGS_FIELD = SdkField
            .<BurnInDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("BurnInDestinationSettings")
            .getter(getter(CaptionDestinationSettings::burnInDestinationSettings))
            .setter(setter(Builder::burnInDestinationSettings)).constructor(BurnInDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("burnInDestinationSettings").build())
            .build();

    private static final SdkField<DvbSubDestinationSettings> DVB_SUB_DESTINATION_SETTINGS_FIELD = SdkField
            .<DvbSubDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("DvbSubDestinationSettings")
            .getter(getter(CaptionDestinationSettings::dvbSubDestinationSettings))
            .setter(setter(Builder::dvbSubDestinationSettings)).constructor(DvbSubDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSubDestinationSettings").build())
            .build();

    private static final SdkField<EbuTtDDestinationSettings> EBU_TT_D_DESTINATION_SETTINGS_FIELD = SdkField
            .<EbuTtDDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("EbuTtDDestinationSettings")
            .getter(getter(CaptionDestinationSettings::ebuTtDDestinationSettings))
            .setter(setter(Builder::ebuTtDDestinationSettings)).constructor(EbuTtDDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebuTtDDestinationSettings").build())
            .build();

    private static final SdkField<EmbeddedDestinationSettings> EMBEDDED_DESTINATION_SETTINGS_FIELD = SdkField
            .<EmbeddedDestinationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("EmbeddedDestinationSettings")
            .getter(getter(CaptionDestinationSettings::embeddedDestinationSettings))
            .setter(setter(Builder::embeddedDestinationSettings))
            .constructor(EmbeddedDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddedDestinationSettings")
                    .build()).build();

    private static final SdkField<EmbeddedPlusScte20DestinationSettings> EMBEDDED_PLUS_SCTE20_DESTINATION_SETTINGS_FIELD = SdkField
            .<EmbeddedPlusScte20DestinationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("EmbeddedPlusScte20DestinationSettings")
            .getter(getter(CaptionDestinationSettings::embeddedPlusScte20DestinationSettings))
            .setter(setter(Builder::embeddedPlusScte20DestinationSettings))
            .constructor(EmbeddedPlusScte20DestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("embeddedPlusScte20DestinationSettings").build()).build();

    private static final SdkField<RtmpCaptionInfoDestinationSettings> RTMP_CAPTION_INFO_DESTINATION_SETTINGS_FIELD = SdkField
            .<RtmpCaptionInfoDestinationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("RtmpCaptionInfoDestinationSettings")
            .getter(getter(CaptionDestinationSettings::rtmpCaptionInfoDestinationSettings))
            .setter(setter(Builder::rtmpCaptionInfoDestinationSettings))
            .constructor(RtmpCaptionInfoDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtmpCaptionInfoDestinationSettings")
                    .build()).build();

    private static final SdkField<Scte20PlusEmbeddedDestinationSettings> SCTE20_PLUS_EMBEDDED_DESTINATION_SETTINGS_FIELD = SdkField
            .<Scte20PlusEmbeddedDestinationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("Scte20PlusEmbeddedDestinationSettings")
            .getter(getter(CaptionDestinationSettings::scte20PlusEmbeddedDestinationSettings))
            .setter(setter(Builder::scte20PlusEmbeddedDestinationSettings))
            .constructor(Scte20PlusEmbeddedDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("scte20PlusEmbeddedDestinationSettings").build()).build();

    private static final SdkField<Scte27DestinationSettings> SCTE27_DESTINATION_SETTINGS_FIELD = SdkField
            .<Scte27DestinationSettings> builder(MarshallingType.SDK_POJO).memberName("Scte27DestinationSettings")
            .getter(getter(CaptionDestinationSettings::scte27DestinationSettings))
            .setter(setter(Builder::scte27DestinationSettings)).constructor(Scte27DestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte27DestinationSettings").build())
            .build();

    private static final SdkField<SmpteTtDestinationSettings> SMPTE_TT_DESTINATION_SETTINGS_FIELD = SdkField
            .<SmpteTtDestinationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("SmpteTtDestinationSettings")
            .getter(getter(CaptionDestinationSettings::smpteTtDestinationSettings))
            .setter(setter(Builder::smpteTtDestinationSettings))
            .constructor(SmpteTtDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smpteTtDestinationSettings").build())
            .build();

    private static final SdkField<TeletextDestinationSettings> TELETEXT_DESTINATION_SETTINGS_FIELD = SdkField
            .<TeletextDestinationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("TeletextDestinationSettings")
            .getter(getter(CaptionDestinationSettings::teletextDestinationSettings))
            .setter(setter(Builder::teletextDestinationSettings))
            .constructor(TeletextDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextDestinationSettings")
                    .build()).build();

    private static final SdkField<TtmlDestinationSettings> TTML_DESTINATION_SETTINGS_FIELD = SdkField
            .<TtmlDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("TtmlDestinationSettings")
            .getter(getter(CaptionDestinationSettings::ttmlDestinationSettings)).setter(setter(Builder::ttmlDestinationSettings))
            .constructor(TtmlDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttmlDestinationSettings").build())
            .build();

    private static final SdkField<WebvttDestinationSettings> WEBVTT_DESTINATION_SETTINGS_FIELD = SdkField
            .<WebvttDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("WebvttDestinationSettings")
            .getter(getter(CaptionDestinationSettings::webvttDestinationSettings))
            .setter(setter(Builder::webvttDestinationSettings)).constructor(WebvttDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webvttDestinationSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ARIB_DESTINATION_SETTINGS_FIELD, BURN_IN_DESTINATION_SETTINGS_FIELD, DVB_SUB_DESTINATION_SETTINGS_FIELD,
            EBU_TT_D_DESTINATION_SETTINGS_FIELD, EMBEDDED_DESTINATION_SETTINGS_FIELD,
            EMBEDDED_PLUS_SCTE20_DESTINATION_SETTINGS_FIELD, RTMP_CAPTION_INFO_DESTINATION_SETTINGS_FIELD,
            SCTE20_PLUS_EMBEDDED_DESTINATION_SETTINGS_FIELD, SCTE27_DESTINATION_SETTINGS_FIELD,
            SMPTE_TT_DESTINATION_SETTINGS_FIELD, TELETEXT_DESTINATION_SETTINGS_FIELD, TTML_DESTINATION_SETTINGS_FIELD,
            WEBVTT_DESTINATION_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AribDestinationSettings aribDestinationSettings;

    private final BurnInDestinationSettings burnInDestinationSettings;

    private final DvbSubDestinationSettings dvbSubDestinationSettings;

    private final EbuTtDDestinationSettings ebuTtDDestinationSettings;

    private final EmbeddedDestinationSettings embeddedDestinationSettings;

    private final EmbeddedPlusScte20DestinationSettings embeddedPlusScte20DestinationSettings;

    private final RtmpCaptionInfoDestinationSettings rtmpCaptionInfoDestinationSettings;

    private final Scte20PlusEmbeddedDestinationSettings scte20PlusEmbeddedDestinationSettings;

    private final Scte27DestinationSettings scte27DestinationSettings;

    private final SmpteTtDestinationSettings smpteTtDestinationSettings;

    private final TeletextDestinationSettings teletextDestinationSettings;

    private final TtmlDestinationSettings ttmlDestinationSettings;

    private final WebvttDestinationSettings webvttDestinationSettings;

    private CaptionDestinationSettings(BuilderImpl builder) {
        this.aribDestinationSettings = builder.aribDestinationSettings;
        this.burnInDestinationSettings = builder.burnInDestinationSettings;
        this.dvbSubDestinationSettings = builder.dvbSubDestinationSettings;
        this.ebuTtDDestinationSettings = builder.ebuTtDDestinationSettings;
        this.embeddedDestinationSettings = builder.embeddedDestinationSettings;
        this.embeddedPlusScte20DestinationSettings = builder.embeddedPlusScte20DestinationSettings;
        this.rtmpCaptionInfoDestinationSettings = builder.rtmpCaptionInfoDestinationSettings;
        this.scte20PlusEmbeddedDestinationSettings = builder.scte20PlusEmbeddedDestinationSettings;
        this.scte27DestinationSettings = builder.scte27DestinationSettings;
        this.smpteTtDestinationSettings = builder.smpteTtDestinationSettings;
        this.teletextDestinationSettings = builder.teletextDestinationSettings;
        this.ttmlDestinationSettings = builder.ttmlDestinationSettings;
        this.webvttDestinationSettings = builder.webvttDestinationSettings;
    }

    /**
     * Returns the value of the AribDestinationSettings property for this object.
     * 
     * @return The value of the AribDestinationSettings property for this object.
     */
    public final AribDestinationSettings aribDestinationSettings() {
        return aribDestinationSettings;
    }

    /**
     * Returns the value of the BurnInDestinationSettings property for this object.
     * 
     * @return The value of the BurnInDestinationSettings property for this object.
     */
    public final BurnInDestinationSettings burnInDestinationSettings() {
        return burnInDestinationSettings;
    }

    /**
     * Returns the value of the DvbSubDestinationSettings property for this object.
     * 
     * @return The value of the DvbSubDestinationSettings property for this object.
     */
    public final DvbSubDestinationSettings dvbSubDestinationSettings() {
        return dvbSubDestinationSettings;
    }

    /**
     * Returns the value of the EbuTtDDestinationSettings property for this object.
     * 
     * @return The value of the EbuTtDDestinationSettings property for this object.
     */
    public final EbuTtDDestinationSettings ebuTtDDestinationSettings() {
        return ebuTtDDestinationSettings;
    }

    /**
     * Returns the value of the EmbeddedDestinationSettings property for this object.
     * 
     * @return The value of the EmbeddedDestinationSettings property for this object.
     */
    public final EmbeddedDestinationSettings embeddedDestinationSettings() {
        return embeddedDestinationSettings;
    }

    /**
     * Returns the value of the EmbeddedPlusScte20DestinationSettings property for this object.
     * 
     * @return The value of the EmbeddedPlusScte20DestinationSettings property for this object.
     */
    public final EmbeddedPlusScte20DestinationSettings embeddedPlusScte20DestinationSettings() {
        return embeddedPlusScte20DestinationSettings;
    }

    /**
     * Returns the value of the RtmpCaptionInfoDestinationSettings property for this object.
     * 
     * @return The value of the RtmpCaptionInfoDestinationSettings property for this object.
     */
    public final RtmpCaptionInfoDestinationSettings rtmpCaptionInfoDestinationSettings() {
        return rtmpCaptionInfoDestinationSettings;
    }

    /**
     * Returns the value of the Scte20PlusEmbeddedDestinationSettings property for this object.
     * 
     * @return The value of the Scte20PlusEmbeddedDestinationSettings property for this object.
     */
    public final Scte20PlusEmbeddedDestinationSettings scte20PlusEmbeddedDestinationSettings() {
        return scte20PlusEmbeddedDestinationSettings;
    }

    /**
     * Returns the value of the Scte27DestinationSettings property for this object.
     * 
     * @return The value of the Scte27DestinationSettings property for this object.
     */
    public final Scte27DestinationSettings scte27DestinationSettings() {
        return scte27DestinationSettings;
    }

    /**
     * Returns the value of the SmpteTtDestinationSettings property for this object.
     * 
     * @return The value of the SmpteTtDestinationSettings property for this object.
     */
    public final SmpteTtDestinationSettings smpteTtDestinationSettings() {
        return smpteTtDestinationSettings;
    }

    /**
     * Returns the value of the TeletextDestinationSettings property for this object.
     * 
     * @return The value of the TeletextDestinationSettings property for this object.
     */
    public final TeletextDestinationSettings teletextDestinationSettings() {
        return teletextDestinationSettings;
    }

    /**
     * Returns the value of the TtmlDestinationSettings property for this object.
     * 
     * @return The value of the TtmlDestinationSettings property for this object.
     */
    public final TtmlDestinationSettings ttmlDestinationSettings() {
        return ttmlDestinationSettings;
    }

    /**
     * Returns the value of the WebvttDestinationSettings property for this object.
     * 
     * @return The value of the WebvttDestinationSettings property for this object.
     */
    public final WebvttDestinationSettings webvttDestinationSettings() {
        return webvttDestinationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aribDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(burnInDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(dvbSubDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(ebuTtDDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(embeddedDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(embeddedPlusScte20DestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(rtmpCaptionInfoDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(scte20PlusEmbeddedDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(scte27DestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(smpteTtDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(teletextDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(ttmlDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(webvttDestinationSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionDestinationSettings)) {
            return false;
        }
        CaptionDestinationSettings other = (CaptionDestinationSettings) obj;
        return Objects.equals(aribDestinationSettings(), other.aribDestinationSettings())
                && Objects.equals(burnInDestinationSettings(), other.burnInDestinationSettings())
                && Objects.equals(dvbSubDestinationSettings(), other.dvbSubDestinationSettings())
                && Objects.equals(ebuTtDDestinationSettings(), other.ebuTtDDestinationSettings())
                && Objects.equals(embeddedDestinationSettings(), other.embeddedDestinationSettings())
                && Objects.equals(embeddedPlusScte20DestinationSettings(), other.embeddedPlusScte20DestinationSettings())
                && Objects.equals(rtmpCaptionInfoDestinationSettings(), other.rtmpCaptionInfoDestinationSettings())
                && Objects.equals(scte20PlusEmbeddedDestinationSettings(), other.scte20PlusEmbeddedDestinationSettings())
                && Objects.equals(scte27DestinationSettings(), other.scte27DestinationSettings())
                && Objects.equals(smpteTtDestinationSettings(), other.smpteTtDestinationSettings())
                && Objects.equals(teletextDestinationSettings(), other.teletextDestinationSettings())
                && Objects.equals(ttmlDestinationSettings(), other.ttmlDestinationSettings())
                && Objects.equals(webvttDestinationSettings(), other.webvttDestinationSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptionDestinationSettings").add("AribDestinationSettings", aribDestinationSettings())
                .add("BurnInDestinationSettings", burnInDestinationSettings())
                .add("DvbSubDestinationSettings", dvbSubDestinationSettings())
                .add("EbuTtDDestinationSettings", ebuTtDDestinationSettings())
                .add("EmbeddedDestinationSettings", embeddedDestinationSettings())
                .add("EmbeddedPlusScte20DestinationSettings", embeddedPlusScte20DestinationSettings())
                .add("RtmpCaptionInfoDestinationSettings", rtmpCaptionInfoDestinationSettings())
                .add("Scte20PlusEmbeddedDestinationSettings", scte20PlusEmbeddedDestinationSettings())
                .add("Scte27DestinationSettings", scte27DestinationSettings())
                .add("SmpteTtDestinationSettings", smpteTtDestinationSettings())
                .add("TeletextDestinationSettings", teletextDestinationSettings())
                .add("TtmlDestinationSettings", ttmlDestinationSettings())
                .add("WebvttDestinationSettings", webvttDestinationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AribDestinationSettings":
            return Optional.ofNullable(clazz.cast(aribDestinationSettings()));
        case "BurnInDestinationSettings":
            return Optional.ofNullable(clazz.cast(burnInDestinationSettings()));
        case "DvbSubDestinationSettings":
            return Optional.ofNullable(clazz.cast(dvbSubDestinationSettings()));
        case "EbuTtDDestinationSettings":
            return Optional.ofNullable(clazz.cast(ebuTtDDestinationSettings()));
        case "EmbeddedDestinationSettings":
            return Optional.ofNullable(clazz.cast(embeddedDestinationSettings()));
        case "EmbeddedPlusScte20DestinationSettings":
            return Optional.ofNullable(clazz.cast(embeddedPlusScte20DestinationSettings()));
        case "RtmpCaptionInfoDestinationSettings":
            return Optional.ofNullable(clazz.cast(rtmpCaptionInfoDestinationSettings()));
        case "Scte20PlusEmbeddedDestinationSettings":
            return Optional.ofNullable(clazz.cast(scte20PlusEmbeddedDestinationSettings()));
        case "Scte27DestinationSettings":
            return Optional.ofNullable(clazz.cast(scte27DestinationSettings()));
        case "SmpteTtDestinationSettings":
            return Optional.ofNullable(clazz.cast(smpteTtDestinationSettings()));
        case "TeletextDestinationSettings":
            return Optional.ofNullable(clazz.cast(teletextDestinationSettings()));
        case "TtmlDestinationSettings":
            return Optional.ofNullable(clazz.cast(ttmlDestinationSettings()));
        case "WebvttDestinationSettings":
            return Optional.ofNullable(clazz.cast(webvttDestinationSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionDestinationSettings, T> g) {
        return obj -> g.apply((CaptionDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionDestinationSettings> {
        /**
         * Sets the value of the AribDestinationSettings property for this object.
         *
         * @param aribDestinationSettings
         *        The new value for the AribDestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aribDestinationSettings(AribDestinationSettings aribDestinationSettings);

        /**
         * Sets the value of the AribDestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link AribDestinationSettings.Builder} avoiding the
         * need to create one manually via {@link AribDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AribDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #aribDestinationSettings(AribDestinationSettings)}.
         * 
         * @param aribDestinationSettings
         *        a consumer that will call methods on {@link AribDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aribDestinationSettings(AribDestinationSettings)
         */
        default Builder aribDestinationSettings(Consumer<AribDestinationSettings.Builder> aribDestinationSettings) {
            return aribDestinationSettings(AribDestinationSettings.builder().applyMutation(aribDestinationSettings).build());
        }

        /**
         * Sets the value of the BurnInDestinationSettings property for this object.
         *
         * @param burnInDestinationSettings
         *        The new value for the BurnInDestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder burnInDestinationSettings(BurnInDestinationSettings burnInDestinationSettings);

        /**
         * Sets the value of the BurnInDestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link BurnInDestinationSettings.Builder} avoiding the
         * need to create one manually via {@link BurnInDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link BurnInDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #burnInDestinationSettings(BurnInDestinationSettings)}.
         * 
         * @param burnInDestinationSettings
         *        a consumer that will call methods on {@link BurnInDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #burnInDestinationSettings(BurnInDestinationSettings)
         */
        default Builder burnInDestinationSettings(Consumer<BurnInDestinationSettings.Builder> burnInDestinationSettings) {
            return burnInDestinationSettings(BurnInDestinationSettings.builder().applyMutation(burnInDestinationSettings).build());
        }

        /**
         * Sets the value of the DvbSubDestinationSettings property for this object.
         *
         * @param dvbSubDestinationSettings
         *        The new value for the DvbSubDestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbSubDestinationSettings(DvbSubDestinationSettings dvbSubDestinationSettings);

        /**
         * Sets the value of the DvbSubDestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link DvbSubDestinationSettings.Builder} avoiding the
         * need to create one manually via {@link DvbSubDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DvbSubDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #dvbSubDestinationSettings(DvbSubDestinationSettings)}.
         * 
         * @param dvbSubDestinationSettings
         *        a consumer that will call methods on {@link DvbSubDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dvbSubDestinationSettings(DvbSubDestinationSettings)
         */
        default Builder dvbSubDestinationSettings(Consumer<DvbSubDestinationSettings.Builder> dvbSubDestinationSettings) {
            return dvbSubDestinationSettings(DvbSubDestinationSettings.builder().applyMutation(dvbSubDestinationSettings).build());
        }

        /**
         * Sets the value of the EbuTtDDestinationSettings property for this object.
         *
         * @param ebuTtDDestinationSettings
         *        The new value for the EbuTtDDestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebuTtDDestinationSettings(EbuTtDDestinationSettings ebuTtDDestinationSettings);

        /**
         * Sets the value of the EbuTtDDestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link EbuTtDDestinationSettings.Builder} avoiding the
         * need to create one manually via {@link EbuTtDDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link EbuTtDDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #ebuTtDDestinationSettings(EbuTtDDestinationSettings)}.
         * 
         * @param ebuTtDDestinationSettings
         *        a consumer that will call methods on {@link EbuTtDDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebuTtDDestinationSettings(EbuTtDDestinationSettings)
         */
        default Builder ebuTtDDestinationSettings(Consumer<EbuTtDDestinationSettings.Builder> ebuTtDDestinationSettings) {
            return ebuTtDDestinationSettings(EbuTtDDestinationSettings.builder().applyMutation(ebuTtDDestinationSettings).build());
        }

        /**
         * Sets the value of the EmbeddedDestinationSettings property for this object.
         *
         * @param embeddedDestinationSettings
         *        The new value for the EmbeddedDestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embeddedDestinationSettings(EmbeddedDestinationSettings embeddedDestinationSettings);

        /**
         * Sets the value of the EmbeddedDestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link EmbeddedDestinationSettings.Builder} avoiding
         * the need to create one manually via {@link EmbeddedDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmbeddedDestinationSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #embeddedDestinationSettings(EmbeddedDestinationSettings)}.
         * 
         * @param embeddedDestinationSettings
         *        a consumer that will call methods on {@link EmbeddedDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #embeddedDestinationSettings(EmbeddedDestinationSettings)
         */
        default Builder embeddedDestinationSettings(Consumer<EmbeddedDestinationSettings.Builder> embeddedDestinationSettings) {
            return embeddedDestinationSettings(EmbeddedDestinationSettings.builder().applyMutation(embeddedDestinationSettings)
                    .build());
        }

        /**
         * Sets the value of the EmbeddedPlusScte20DestinationSettings property for this object.
         *
         * @param embeddedPlusScte20DestinationSettings
         *        The new value for the EmbeddedPlusScte20DestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettings embeddedPlusScte20DestinationSettings);

        /**
         * Sets the value of the EmbeddedPlusScte20DestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link EmbeddedPlusScte20DestinationSettings.Builder}
         * avoiding the need to create one manually via {@link EmbeddedPlusScte20DestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmbeddedPlusScte20DestinationSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettings)}.
         * 
         * @param embeddedPlusScte20DestinationSettings
         *        a consumer that will call methods on {@link EmbeddedPlusScte20DestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettings)
         */
        default Builder embeddedPlusScte20DestinationSettings(
                Consumer<EmbeddedPlusScte20DestinationSettings.Builder> embeddedPlusScte20DestinationSettings) {
            return embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettings.builder()
                    .applyMutation(embeddedPlusScte20DestinationSettings).build());
        }

        /**
         * Sets the value of the RtmpCaptionInfoDestinationSettings property for this object.
         *
         * @param rtmpCaptionInfoDestinationSettings
         *        The new value for the RtmpCaptionInfoDestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettings rtmpCaptionInfoDestinationSettings);

        /**
         * Sets the value of the RtmpCaptionInfoDestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link RtmpCaptionInfoDestinationSettings.Builder}
         * avoiding the need to create one manually via {@link RtmpCaptionInfoDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link RtmpCaptionInfoDestinationSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettings)}.
         * 
         * @param rtmpCaptionInfoDestinationSettings
         *        a consumer that will call methods on {@link RtmpCaptionInfoDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettings)
         */
        default Builder rtmpCaptionInfoDestinationSettings(
                Consumer<RtmpCaptionInfoDestinationSettings.Builder> rtmpCaptionInfoDestinationSettings) {
            return rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettings.builder()
                    .applyMutation(rtmpCaptionInfoDestinationSettings).build());
        }

        /**
         * Sets the value of the Scte20PlusEmbeddedDestinationSettings property for this object.
         *
         * @param scte20PlusEmbeddedDestinationSettings
         *        The new value for the Scte20PlusEmbeddedDestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettings scte20PlusEmbeddedDestinationSettings);

        /**
         * Sets the value of the Scte20PlusEmbeddedDestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Scte20PlusEmbeddedDestinationSettings.Builder}
         * avoiding the need to create one manually via {@link Scte20PlusEmbeddedDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scte20PlusEmbeddedDestinationSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettings)}.
         * 
         * @param scte20PlusEmbeddedDestinationSettings
         *        a consumer that will call methods on {@link Scte20PlusEmbeddedDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettings)
         */
        default Builder scte20PlusEmbeddedDestinationSettings(
                Consumer<Scte20PlusEmbeddedDestinationSettings.Builder> scte20PlusEmbeddedDestinationSettings) {
            return scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettings.builder()
                    .applyMutation(scte20PlusEmbeddedDestinationSettings).build());
        }

        /**
         * Sets the value of the Scte27DestinationSettings property for this object.
         *
         * @param scte27DestinationSettings
         *        The new value for the Scte27DestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte27DestinationSettings(Scte27DestinationSettings scte27DestinationSettings);

        /**
         * Sets the value of the Scte27DestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Scte27DestinationSettings.Builder} avoiding the
         * need to create one manually via {@link Scte27DestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scte27DestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #scte27DestinationSettings(Scte27DestinationSettings)}.
         * 
         * @param scte27DestinationSettings
         *        a consumer that will call methods on {@link Scte27DestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte27DestinationSettings(Scte27DestinationSettings)
         */
        default Builder scte27DestinationSettings(Consumer<Scte27DestinationSettings.Builder> scte27DestinationSettings) {
            return scte27DestinationSettings(Scte27DestinationSettings.builder().applyMutation(scte27DestinationSettings).build());
        }

        /**
         * Sets the value of the SmpteTtDestinationSettings property for this object.
         *
         * @param smpteTtDestinationSettings
         *        The new value for the SmpteTtDestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smpteTtDestinationSettings(SmpteTtDestinationSettings smpteTtDestinationSettings);

        /**
         * Sets the value of the SmpteTtDestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link SmpteTtDestinationSettings.Builder} avoiding the
         * need to create one manually via {@link SmpteTtDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link SmpteTtDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #smpteTtDestinationSettings(SmpteTtDestinationSettings)}.
         * 
         * @param smpteTtDestinationSettings
         *        a consumer that will call methods on {@link SmpteTtDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smpteTtDestinationSettings(SmpteTtDestinationSettings)
         */
        default Builder smpteTtDestinationSettings(Consumer<SmpteTtDestinationSettings.Builder> smpteTtDestinationSettings) {
            return smpteTtDestinationSettings(SmpteTtDestinationSettings.builder().applyMutation(smpteTtDestinationSettings)
                    .build());
        }

        /**
         * Sets the value of the TeletextDestinationSettings property for this object.
         *
         * @param teletextDestinationSettings
         *        The new value for the TeletextDestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teletextDestinationSettings(TeletextDestinationSettings teletextDestinationSettings);

        /**
         * Sets the value of the TeletextDestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link TeletextDestinationSettings.Builder} avoiding
         * the need to create one manually via {@link TeletextDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link TeletextDestinationSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #teletextDestinationSettings(TeletextDestinationSettings)}.
         * 
         * @param teletextDestinationSettings
         *        a consumer that will call methods on {@link TeletextDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #teletextDestinationSettings(TeletextDestinationSettings)
         */
        default Builder teletextDestinationSettings(Consumer<TeletextDestinationSettings.Builder> teletextDestinationSettings) {
            return teletextDestinationSettings(TeletextDestinationSettings.builder().applyMutation(teletextDestinationSettings)
                    .build());
        }

        /**
         * Sets the value of the TtmlDestinationSettings property for this object.
         *
         * @param ttmlDestinationSettings
         *        The new value for the TtmlDestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttmlDestinationSettings(TtmlDestinationSettings ttmlDestinationSettings);

        /**
         * Sets the value of the TtmlDestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link TtmlDestinationSettings.Builder} avoiding the
         * need to create one manually via {@link TtmlDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link TtmlDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #ttmlDestinationSettings(TtmlDestinationSettings)}.
         * 
         * @param ttmlDestinationSettings
         *        a consumer that will call methods on {@link TtmlDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ttmlDestinationSettings(TtmlDestinationSettings)
         */
        default Builder ttmlDestinationSettings(Consumer<TtmlDestinationSettings.Builder> ttmlDestinationSettings) {
            return ttmlDestinationSettings(TtmlDestinationSettings.builder().applyMutation(ttmlDestinationSettings).build());
        }

        /**
         * Sets the value of the WebvttDestinationSettings property for this object.
         *
         * @param webvttDestinationSettings
         *        The new value for the WebvttDestinationSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webvttDestinationSettings(WebvttDestinationSettings webvttDestinationSettings);

        /**
         * Sets the value of the WebvttDestinationSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link WebvttDestinationSettings.Builder} avoiding the
         * need to create one manually via {@link WebvttDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link WebvttDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #webvttDestinationSettings(WebvttDestinationSettings)}.
         * 
         * @param webvttDestinationSettings
         *        a consumer that will call methods on {@link WebvttDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webvttDestinationSettings(WebvttDestinationSettings)
         */
        default Builder webvttDestinationSettings(Consumer<WebvttDestinationSettings.Builder> webvttDestinationSettings) {
            return webvttDestinationSettings(WebvttDestinationSettings.builder().applyMutation(webvttDestinationSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AribDestinationSettings aribDestinationSettings;

        private BurnInDestinationSettings burnInDestinationSettings;

        private DvbSubDestinationSettings dvbSubDestinationSettings;

        private EbuTtDDestinationSettings ebuTtDDestinationSettings;

        private EmbeddedDestinationSettings embeddedDestinationSettings;

        private EmbeddedPlusScte20DestinationSettings embeddedPlusScte20DestinationSettings;

        private RtmpCaptionInfoDestinationSettings rtmpCaptionInfoDestinationSettings;

        private Scte20PlusEmbeddedDestinationSettings scte20PlusEmbeddedDestinationSettings;

        private Scte27DestinationSettings scte27DestinationSettings;

        private SmpteTtDestinationSettings smpteTtDestinationSettings;

        private TeletextDestinationSettings teletextDestinationSettings;

        private TtmlDestinationSettings ttmlDestinationSettings;

        private WebvttDestinationSettings webvttDestinationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionDestinationSettings model) {
            aribDestinationSettings(model.aribDestinationSettings);
            burnInDestinationSettings(model.burnInDestinationSettings);
            dvbSubDestinationSettings(model.dvbSubDestinationSettings);
            ebuTtDDestinationSettings(model.ebuTtDDestinationSettings);
            embeddedDestinationSettings(model.embeddedDestinationSettings);
            embeddedPlusScte20DestinationSettings(model.embeddedPlusScte20DestinationSettings);
            rtmpCaptionInfoDestinationSettings(model.rtmpCaptionInfoDestinationSettings);
            scte20PlusEmbeddedDestinationSettings(model.scte20PlusEmbeddedDestinationSettings);
            scte27DestinationSettings(model.scte27DestinationSettings);
            smpteTtDestinationSettings(model.smpteTtDestinationSettings);
            teletextDestinationSettings(model.teletextDestinationSettings);
            ttmlDestinationSettings(model.ttmlDestinationSettings);
            webvttDestinationSettings(model.webvttDestinationSettings);
        }

        public final AribDestinationSettings.Builder getAribDestinationSettings() {
            return aribDestinationSettings != null ? aribDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder aribDestinationSettings(AribDestinationSettings aribDestinationSettings) {
            this.aribDestinationSettings = aribDestinationSettings;
            return this;
        }

        public final void setAribDestinationSettings(AribDestinationSettings.BuilderImpl aribDestinationSettings) {
            this.aribDestinationSettings = aribDestinationSettings != null ? aribDestinationSettings.build() : null;
        }

        public final BurnInDestinationSettings.Builder getBurnInDestinationSettings() {
            return burnInDestinationSettings != null ? burnInDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder burnInDestinationSettings(BurnInDestinationSettings burnInDestinationSettings) {
            this.burnInDestinationSettings = burnInDestinationSettings;
            return this;
        }

        public final void setBurnInDestinationSettings(BurnInDestinationSettings.BuilderImpl burnInDestinationSettings) {
            this.burnInDestinationSettings = burnInDestinationSettings != null ? burnInDestinationSettings.build() : null;
        }

        public final DvbSubDestinationSettings.Builder getDvbSubDestinationSettings() {
            return dvbSubDestinationSettings != null ? dvbSubDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbSubDestinationSettings(DvbSubDestinationSettings dvbSubDestinationSettings) {
            this.dvbSubDestinationSettings = dvbSubDestinationSettings;
            return this;
        }

        public final void setDvbSubDestinationSettings(DvbSubDestinationSettings.BuilderImpl dvbSubDestinationSettings) {
            this.dvbSubDestinationSettings = dvbSubDestinationSettings != null ? dvbSubDestinationSettings.build() : null;
        }

        public final EbuTtDDestinationSettings.Builder getEbuTtDDestinationSettings() {
            return ebuTtDDestinationSettings != null ? ebuTtDDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder ebuTtDDestinationSettings(EbuTtDDestinationSettings ebuTtDDestinationSettings) {
            this.ebuTtDDestinationSettings = ebuTtDDestinationSettings;
            return this;
        }

        public final void setEbuTtDDestinationSettings(EbuTtDDestinationSettings.BuilderImpl ebuTtDDestinationSettings) {
            this.ebuTtDDestinationSettings = ebuTtDDestinationSettings != null ? ebuTtDDestinationSettings.build() : null;
        }

        public final EmbeddedDestinationSettings.Builder getEmbeddedDestinationSettings() {
            return embeddedDestinationSettings != null ? embeddedDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder embeddedDestinationSettings(EmbeddedDestinationSettings embeddedDestinationSettings) {
            this.embeddedDestinationSettings = embeddedDestinationSettings;
            return this;
        }

        public final void setEmbeddedDestinationSettings(EmbeddedDestinationSettings.BuilderImpl embeddedDestinationSettings) {
            this.embeddedDestinationSettings = embeddedDestinationSettings != null ? embeddedDestinationSettings.build() : null;
        }

        public final EmbeddedPlusScte20DestinationSettings.Builder getEmbeddedPlusScte20DestinationSettings() {
            return embeddedPlusScte20DestinationSettings != null ? embeddedPlusScte20DestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder embeddedPlusScte20DestinationSettings(
                EmbeddedPlusScte20DestinationSettings embeddedPlusScte20DestinationSettings) {
            this.embeddedPlusScte20DestinationSettings = embeddedPlusScte20DestinationSettings;
            return this;
        }

        public final void setEmbeddedPlusScte20DestinationSettings(
                EmbeddedPlusScte20DestinationSettings.BuilderImpl embeddedPlusScte20DestinationSettings) {
            this.embeddedPlusScte20DestinationSettings = embeddedPlusScte20DestinationSettings != null ? embeddedPlusScte20DestinationSettings
                    .build() : null;
        }

        public final RtmpCaptionInfoDestinationSettings.Builder getRtmpCaptionInfoDestinationSettings() {
            return rtmpCaptionInfoDestinationSettings != null ? rtmpCaptionInfoDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder rtmpCaptionInfoDestinationSettings(
                RtmpCaptionInfoDestinationSettings rtmpCaptionInfoDestinationSettings) {
            this.rtmpCaptionInfoDestinationSettings = rtmpCaptionInfoDestinationSettings;
            return this;
        }

        public final void setRtmpCaptionInfoDestinationSettings(
                RtmpCaptionInfoDestinationSettings.BuilderImpl rtmpCaptionInfoDestinationSettings) {
            this.rtmpCaptionInfoDestinationSettings = rtmpCaptionInfoDestinationSettings != null ? rtmpCaptionInfoDestinationSettings
                    .build() : null;
        }

        public final Scte20PlusEmbeddedDestinationSettings.Builder getScte20PlusEmbeddedDestinationSettings() {
            return scte20PlusEmbeddedDestinationSettings != null ? scte20PlusEmbeddedDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder scte20PlusEmbeddedDestinationSettings(
                Scte20PlusEmbeddedDestinationSettings scte20PlusEmbeddedDestinationSettings) {
            this.scte20PlusEmbeddedDestinationSettings = scte20PlusEmbeddedDestinationSettings;
            return this;
        }

        public final void setScte20PlusEmbeddedDestinationSettings(
                Scte20PlusEmbeddedDestinationSettings.BuilderImpl scte20PlusEmbeddedDestinationSettings) {
            this.scte20PlusEmbeddedDestinationSettings = scte20PlusEmbeddedDestinationSettings != null ? scte20PlusEmbeddedDestinationSettings
                    .build() : null;
        }

        public final Scte27DestinationSettings.Builder getScte27DestinationSettings() {
            return scte27DestinationSettings != null ? scte27DestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder scte27DestinationSettings(Scte27DestinationSettings scte27DestinationSettings) {
            this.scte27DestinationSettings = scte27DestinationSettings;
            return this;
        }

        public final void setScte27DestinationSettings(Scte27DestinationSettings.BuilderImpl scte27DestinationSettings) {
            this.scte27DestinationSettings = scte27DestinationSettings != null ? scte27DestinationSettings.build() : null;
        }

        public final SmpteTtDestinationSettings.Builder getSmpteTtDestinationSettings() {
            return smpteTtDestinationSettings != null ? smpteTtDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder smpteTtDestinationSettings(SmpteTtDestinationSettings smpteTtDestinationSettings) {
            this.smpteTtDestinationSettings = smpteTtDestinationSettings;
            return this;
        }

        public final void setSmpteTtDestinationSettings(SmpteTtDestinationSettings.BuilderImpl smpteTtDestinationSettings) {
            this.smpteTtDestinationSettings = smpteTtDestinationSettings != null ? smpteTtDestinationSettings.build() : null;
        }

        public final TeletextDestinationSettings.Builder getTeletextDestinationSettings() {
            return teletextDestinationSettings != null ? teletextDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder teletextDestinationSettings(TeletextDestinationSettings teletextDestinationSettings) {
            this.teletextDestinationSettings = teletextDestinationSettings;
            return this;
        }

        public final void setTeletextDestinationSettings(TeletextDestinationSettings.BuilderImpl teletextDestinationSettings) {
            this.teletextDestinationSettings = teletextDestinationSettings != null ? teletextDestinationSettings.build() : null;
        }

        public final TtmlDestinationSettings.Builder getTtmlDestinationSettings() {
            return ttmlDestinationSettings != null ? ttmlDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder ttmlDestinationSettings(TtmlDestinationSettings ttmlDestinationSettings) {
            this.ttmlDestinationSettings = ttmlDestinationSettings;
            return this;
        }

        public final void setTtmlDestinationSettings(TtmlDestinationSettings.BuilderImpl ttmlDestinationSettings) {
            this.ttmlDestinationSettings = ttmlDestinationSettings != null ? ttmlDestinationSettings.build() : null;
        }

        public final WebvttDestinationSettings.Builder getWebvttDestinationSettings() {
            return webvttDestinationSettings != null ? webvttDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder webvttDestinationSettings(WebvttDestinationSettings webvttDestinationSettings) {
            this.webvttDestinationSettings = webvttDestinationSettings;
            return this;
        }

        public final void setWebvttDestinationSettings(WebvttDestinationSettings.BuilderImpl webvttDestinationSettings) {
            this.webvttDestinationSettings = webvttDestinationSettings != null ? webvttDestinationSettings.build() : null;
        }

        @Override
        public CaptionDestinationSettings build() {
            return new CaptionDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
