/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReservationsRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, ListReservationsRequest> {
    private static final SdkField<String> CHANNEL_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelClass").getter(ListReservationsRequest.getter(ListReservationsRequest::channelClass)).setter(ListReservationsRequest.setter(Builder::channelClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("channelClass").build()}).build();
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Codec").getter(ListReservationsRequest.getter(ListReservationsRequest::codec)).setter(ListReservationsRequest.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("codec").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListReservationsRequest.getter(ListReservationsRequest::maxResults)).setter(ListReservationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> MAXIMUM_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaximumBitrate").getter(ListReservationsRequest.getter(ListReservationsRequest::maximumBitrate)).setter(ListReservationsRequest.setter(Builder::maximumBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maximumBitrate").build()}).build();
    private static final SdkField<String> MAXIMUM_FRAMERATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaximumFramerate").getter(ListReservationsRequest.getter(ListReservationsRequest::maximumFramerate)).setter(ListReservationsRequest.setter(Builder::maximumFramerate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maximumFramerate").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReservationsRequest.getter(ListReservationsRequest::nextToken)).setter(ListReservationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Resolution").getter(ListReservationsRequest.getter(ListReservationsRequest::resolution)).setter(ListReservationsRequest.setter(Builder::resolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolution").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ListReservationsRequest.getter(ListReservationsRequest::resourceType)).setter(ListReservationsRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()}).build();
    private static final SdkField<String> SPECIAL_FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpecialFeature").getter(ListReservationsRequest.getter(ListReservationsRequest::specialFeature)).setter(ListReservationsRequest.setter(Builder::specialFeature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("specialFeature").build()}).build();
    private static final SdkField<String> VIDEO_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VideoQuality").getter(ListReservationsRequest.getter(ListReservationsRequest::videoQuality)).setter(ListReservationsRequest.setter(Builder::videoQuality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("videoQuality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_CLASS_FIELD, CODEC_FIELD, MAX_RESULTS_FIELD, MAXIMUM_BITRATE_FIELD, MAXIMUM_FRAMERATE_FIELD, NEXT_TOKEN_FIELD, RESOLUTION_FIELD, RESOURCE_TYPE_FIELD, SPECIAL_FEATURE_FIELD, VIDEO_QUALITY_FIELD));
    private final String channelClass;
    private final String codec;
    private final Integer maxResults;
    private final String maximumBitrate;
    private final String maximumFramerate;
    private final String nextToken;
    private final String resolution;
    private final String resourceType;
    private final String specialFeature;
    private final String videoQuality;

    private ListReservationsRequest(BuilderImpl builder) {
        super(builder);
        this.channelClass = builder.channelClass;
        this.codec = builder.codec;
        this.maxResults = builder.maxResults;
        this.maximumBitrate = builder.maximumBitrate;
        this.maximumFramerate = builder.maximumFramerate;
        this.nextToken = builder.nextToken;
        this.resolution = builder.resolution;
        this.resourceType = builder.resourceType;
        this.specialFeature = builder.specialFeature;
        this.videoQuality = builder.videoQuality;
    }

    public String channelClass() {
        return this.channelClass;
    }

    public String codec() {
        return this.codec;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String maximumBitrate() {
        return this.maximumBitrate;
    }

    public String maximumFramerate() {
        return this.maximumFramerate;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String resolution() {
        return this.resolution;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String specialFeature() {
        return this.specialFeature;
    }

    public String videoQuality() {
        return this.videoQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.codec());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumFramerate());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.specialFeature());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoQuality());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReservationsRequest)) {
            return false;
        }
        ListReservationsRequest other = (ListReservationsRequest)((Object)obj);
        return Objects.equals(this.channelClass(), other.channelClass()) && Objects.equals(this.codec(), other.codec()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.maximumBitrate(), other.maximumBitrate()) && Objects.equals(this.maximumFramerate(), other.maximumFramerate()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.resolution(), other.resolution()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.specialFeature(), other.specialFeature()) && Objects.equals(this.videoQuality(), other.videoQuality());
    }

    public String toString() {
        return ToString.builder((String)"ListReservationsRequest").add("ChannelClass", (Object)this.channelClass()).add("Codec", (Object)this.codec()).add("MaxResults", (Object)this.maxResults()).add("MaximumBitrate", (Object)this.maximumBitrate()).add("MaximumFramerate", (Object)this.maximumFramerate()).add("NextToken", (Object)this.nextToken()).add("Resolution", (Object)this.resolution()).add("ResourceType", (Object)this.resourceType()).add("SpecialFeature", (Object)this.specialFeature()).add("VideoQuality", (Object)this.videoQuality()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelClass": {
                return Optional.ofNullable(clazz.cast(this.channelClass()));
            }
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codec()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "MaximumBitrate": {
                return Optional.ofNullable(clazz.cast(this.maximumBitrate()));
            }
            case "MaximumFramerate": {
                return Optional.ofNullable(clazz.cast(this.maximumFramerate()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Resolution": {
                return Optional.ofNullable(clazz.cast(this.resolution()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "SpecialFeature": {
                return Optional.ofNullable(clazz.cast(this.specialFeature()));
            }
            case "VideoQuality": {
                return Optional.ofNullable(clazz.cast(this.videoQuality()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReservationsRequest, T> g) {
        return obj -> g.apply((ListReservationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String channelClass;
        private String codec;
        private Integer maxResults;
        private String maximumBitrate;
        private String maximumFramerate;
        private String nextToken;
        private String resolution;
        private String resourceType;
        private String specialFeature;
        private String videoQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReservationsRequest model) {
            super(model);
            this.channelClass(model.channelClass);
            this.codec(model.codec);
            this.maxResults(model.maxResults);
            this.maximumBitrate(model.maximumBitrate);
            this.maximumFramerate(model.maximumFramerate);
            this.nextToken(model.nextToken);
            this.resolution(model.resolution);
            this.resourceType(model.resourceType);
            this.specialFeature(model.specialFeature);
            this.videoQuality(model.videoQuality);
        }

        public final String getChannelClass() {
            return this.channelClass;
        }

        @Override
        public final Builder channelClass(String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        public final void setChannelClass(String channelClass) {
            this.channelClass = channelClass;
        }

        public final String getCodec() {
            return this.codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getMaximumBitrate() {
            return this.maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        public final void setMaximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        public final String getMaximumFramerate() {
            return this.maximumFramerate;
        }

        @Override
        public final Builder maximumFramerate(String maximumFramerate) {
            this.maximumFramerate = maximumFramerate;
            return this;
        }

        public final void setMaximumFramerate(String maximumFramerate) {
            this.maximumFramerate = maximumFramerate;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getResolution() {
            return this.resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getSpecialFeature() {
            return this.specialFeature;
        }

        @Override
        public final Builder specialFeature(String specialFeature) {
            this.specialFeature = specialFeature;
            return this;
        }

        public final void setSpecialFeature(String specialFeature) {
            this.specialFeature = specialFeature;
        }

        public final String getVideoQuality() {
            return this.videoQuality;
        }

        @Override
        public final Builder videoQuality(String videoQuality) {
            this.videoQuality = videoQuality;
            return this;
        }

        public final void setVideoQuality(String videoQuality) {
            this.videoQuality = videoQuality;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReservationsRequest build() {
            return new ListReservationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReservationsRequest> {
        public Builder channelClass(String var1);

        public Builder codec(String var1);

        public Builder maxResults(Integer var1);

        public Builder maximumBitrate(String var1);

        public Builder maximumFramerate(String var1);

        public Builder nextToken(String var1);

        public Builder resolution(String var1);

        public Builder resourceType(String var1);

        public Builder specialFeature(String var1);

        public Builder videoQuality(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

