/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchScheduleActionDeleteRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchScheduleActionDeleteRequest> {
    private static final SdkField<List<String>> ACTION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActionNames").getter(BatchScheduleActionDeleteRequest.getter(BatchScheduleActionDeleteRequest::actionNames)).setter(BatchScheduleActionDeleteRequest.setter(Builder::actionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> actionNames;

    private BatchScheduleActionDeleteRequest(BuilderImpl builder) {
        this.actionNames = builder.actionNames;
    }

    public boolean hasActionNames() {
        return this.actionNames != null && !(this.actionNames instanceof SdkAutoConstructList);
    }

    public List<String> actionNames() {
        return this.actionNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchScheduleActionDeleteRequest)) {
            return false;
        }
        BatchScheduleActionDeleteRequest other = (BatchScheduleActionDeleteRequest)obj;
        return Objects.equals(this.actionNames(), other.actionNames());
    }

    public String toString() {
        return ToString.builder((String)"BatchScheduleActionDeleteRequest").add("ActionNames", this.actionNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionNames": {
                return Optional.ofNullable(clazz.cast(this.actionNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchScheduleActionDeleteRequest, T> g) {
        return obj -> g.apply((BatchScheduleActionDeleteRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> actionNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchScheduleActionDeleteRequest model) {
            this.actionNames(model.actionNames);
        }

        public final Collection<String> getActionNames() {
            return this.actionNames;
        }

        @Override
        public final Builder actionNames(Collection<String> actionNames) {
            this.actionNames = ___listOf__stringCopier.copy(actionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionNames(String ... actionNames) {
            this.actionNames(Arrays.asList(actionNames));
            return this;
        }

        public final void setActionNames(Collection<String> actionNames) {
            this.actionNames = ___listOf__stringCopier.copy(actionNames);
        }

        public BatchScheduleActionDeleteRequest build() {
            return new BatchScheduleActionDeleteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchScheduleActionDeleteRequest> {
        public Builder actionNames(Collection<String> var1);

        public Builder actionNames(String ... var1);
    }
}

