/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ScheduleActionSettings;
import software.amazon.awssdk.services.medialive.model.ScheduleActionStartSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduleAction> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionName").getter(ScheduleAction.getter(ScheduleAction::actionName)).setter(ScheduleAction.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<ScheduleActionSettings> SCHEDULE_ACTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleActionSettings").getter(ScheduleAction.getter(ScheduleAction::scheduleActionSettings)).setter(ScheduleAction.setter(Builder::scheduleActionSettings)).constructor(ScheduleActionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleActionSettings").build()}).build();
    private static final SdkField<ScheduleActionStartSettings> SCHEDULE_ACTION_START_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleActionStartSettings").getter(ScheduleAction.getter(ScheduleAction::scheduleActionStartSettings)).setter(ScheduleAction.setter(Builder::scheduleActionStartSettings)).constructor(ScheduleActionStartSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleActionStartSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD, SCHEDULE_ACTION_SETTINGS_FIELD, SCHEDULE_ACTION_START_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionName;
    private final ScheduleActionSettings scheduleActionSettings;
    private final ScheduleActionStartSettings scheduleActionStartSettings;

    private ScheduleAction(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.scheduleActionSettings = builder.scheduleActionSettings;
        this.scheduleActionStartSettings = builder.scheduleActionStartSettings;
    }

    public String actionName() {
        return this.actionName;
    }

    public ScheduleActionSettings scheduleActionSettings() {
        return this.scheduleActionSettings;
    }

    public ScheduleActionStartSettings scheduleActionStartSettings() {
        return this.scheduleActionStartSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleActionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleActionStartSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleAction)) {
            return false;
        }
        ScheduleAction other = (ScheduleAction)obj;
        return Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.scheduleActionSettings(), other.scheduleActionSettings()) && Objects.equals(this.scheduleActionStartSettings(), other.scheduleActionStartSettings());
    }

    public String toString() {
        return ToString.builder((String)"ScheduleAction").add("ActionName", (Object)this.actionName()).add("ScheduleActionSettings", (Object)this.scheduleActionSettings()).add("ScheduleActionStartSettings", (Object)this.scheduleActionStartSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "ScheduleActionSettings": {
                return Optional.ofNullable(clazz.cast(this.scheduleActionSettings()));
            }
            case "ScheduleActionStartSettings": {
                return Optional.ofNullable(clazz.cast(this.scheduleActionStartSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleAction, T> g) {
        return obj -> g.apply((ScheduleAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionName;
        private ScheduleActionSettings scheduleActionSettings;
        private ScheduleActionStartSettings scheduleActionStartSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleAction model) {
            this.actionName(model.actionName);
            this.scheduleActionSettings(model.scheduleActionSettings);
            this.scheduleActionStartSettings(model.scheduleActionStartSettings);
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final ScheduleActionSettings.Builder getScheduleActionSettings() {
            return this.scheduleActionSettings != null ? this.scheduleActionSettings.toBuilder() : null;
        }

        @Override
        public final Builder scheduleActionSettings(ScheduleActionSettings scheduleActionSettings) {
            this.scheduleActionSettings = scheduleActionSettings;
            return this;
        }

        public final void setScheduleActionSettings(ScheduleActionSettings.BuilderImpl scheduleActionSettings) {
            this.scheduleActionSettings = scheduleActionSettings != null ? scheduleActionSettings.build() : null;
        }

        public final ScheduleActionStartSettings.Builder getScheduleActionStartSettings() {
            return this.scheduleActionStartSettings != null ? this.scheduleActionStartSettings.toBuilder() : null;
        }

        @Override
        public final Builder scheduleActionStartSettings(ScheduleActionStartSettings scheduleActionStartSettings) {
            this.scheduleActionStartSettings = scheduleActionStartSettings;
            return this;
        }

        public final void setScheduleActionStartSettings(ScheduleActionStartSettings.BuilderImpl scheduleActionStartSettings) {
            this.scheduleActionStartSettings = scheduleActionStartSettings != null ? scheduleActionStartSettings.build() : null;
        }

        public ScheduleAction build() {
            return new ScheduleAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduleAction> {
        public Builder actionName(String var1);

        public Builder scheduleActionSettings(ScheduleActionSettings var1);

        default public Builder scheduleActionSettings(Consumer<ScheduleActionSettings.Builder> scheduleActionSettings) {
            return this.scheduleActionSettings((ScheduleActionSettings)((ScheduleActionSettings.Builder)ScheduleActionSettings.builder().applyMutation(scheduleActionSettings)).build());
        }

        public Builder scheduleActionStartSettings(ScheduleActionStartSettings var1);

        default public Builder scheduleActionStartSettings(Consumer<ScheduleActionStartSettings.Builder> scheduleActionStartSettings) {
            return this.scheduleActionStartSettings((ScheduleActionStartSettings)((ScheduleActionStartSettings.Builder)ScheduleActionStartSettings.builder().applyMutation(scheduleActionStartSettings)).build());
        }
    }
}

