/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputDestinationRequest;
import software.amazon.awssdk.services.medialive.model.InputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.InputSourceRequest;
import software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.___listOfInputDestinationRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputDeviceRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputSourceRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOfMediaConnectFlowRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInputRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateInputRequest> {
    private static final SdkField<List<InputDestinationRequest>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(UpdateInputRequest.getter(UpdateInputRequest::destinations)).setter(UpdateInputRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDestinationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InputDeviceRequest>> INPUT_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputDevices").getter(UpdateInputRequest.getter(UpdateInputRequest::inputDevices)).setter(UpdateInputRequest.setter(Builder::inputDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDeviceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputId").getter(UpdateInputRequest.getter(UpdateInputRequest::inputId)).setter(UpdateInputRequest.setter(Builder::inputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputId").build()}).build();
    private static final SdkField<List<String>> INPUT_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputSecurityGroups").getter(UpdateInputRequest.getter(UpdateInputRequest::inputSecurityGroups)).setter(UpdateInputRequest.setter(Builder::inputSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MediaConnectFlowRequest>> MEDIA_CONNECT_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaConnectFlows").getter(UpdateInputRequest.getter(UpdateInputRequest::mediaConnectFlows)).setter(UpdateInputRequest.setter(Builder::mediaConnectFlows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaConnectFlowRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateInputRequest.getter(UpdateInputRequest::name)).setter(UpdateInputRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateInputRequest.getter(UpdateInputRequest::roleArn)).setter(UpdateInputRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<InputSourceRequest>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(UpdateInputRequest.getter(UpdateInputRequest::sources)).setter(UpdateInputRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD, INPUT_DEVICES_FIELD, INPUT_ID_FIELD, INPUT_SECURITY_GROUPS_FIELD, MEDIA_CONNECT_FLOWS_FIELD, NAME_FIELD, ROLE_ARN_FIELD, SOURCES_FIELD));
    private final List<InputDestinationRequest> destinations;
    private final List<InputDeviceRequest> inputDevices;
    private final String inputId;
    private final List<String> inputSecurityGroups;
    private final List<MediaConnectFlowRequest> mediaConnectFlows;
    private final String name;
    private final String roleArn;
    private final List<InputSourceRequest> sources;

    private UpdateInputRequest(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.inputDevices = builder.inputDevices;
        this.inputId = builder.inputId;
        this.inputSecurityGroups = builder.inputSecurityGroups;
        this.mediaConnectFlows = builder.mediaConnectFlows;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.sources = builder.sources;
    }

    public boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public List<InputDestinationRequest> destinations() {
        return this.destinations;
    }

    public boolean hasInputDevices() {
        return this.inputDevices != null && !(this.inputDevices instanceof SdkAutoConstructList);
    }

    public List<InputDeviceRequest> inputDevices() {
        return this.inputDevices;
    }

    public String inputId() {
        return this.inputId;
    }

    public boolean hasInputSecurityGroups() {
        return this.inputSecurityGroups != null && !(this.inputSecurityGroups instanceof SdkAutoConstructList);
    }

    public List<String> inputSecurityGroups() {
        return this.inputSecurityGroups;
    }

    public boolean hasMediaConnectFlows() {
        return this.mediaConnectFlows != null && !(this.mediaConnectFlows instanceof SdkAutoConstructList);
    }

    public List<MediaConnectFlowRequest> mediaConnectFlows() {
        return this.mediaConnectFlows;
    }

    public String name() {
        return this.name;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public List<InputSourceRequest> sources() {
        return this.sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDevices());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaConnectFlows());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInputRequest)) {
            return false;
        }
        UpdateInputRequest other = (UpdateInputRequest)((Object)obj);
        return Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.inputDevices(), other.inputDevices()) && Objects.equals(this.inputId(), other.inputId()) && Objects.equals(this.inputSecurityGroups(), other.inputSecurityGroups()) && Objects.equals(this.mediaConnectFlows(), other.mediaConnectFlows()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.sources(), other.sources());
    }

    public String toString() {
        return ToString.builder((String)"UpdateInputRequest").add("Destinations", this.destinations()).add("InputDevices", this.inputDevices()).add("InputId", (Object)this.inputId()).add("InputSecurityGroups", this.inputSecurityGroups()).add("MediaConnectFlows", this.mediaConnectFlows()).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("Sources", this.sources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "InputDevices": {
                return Optional.ofNullable(clazz.cast(this.inputDevices()));
            }
            case "InputId": {
                return Optional.ofNullable(clazz.cast(this.inputId()));
            }
            case "InputSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.inputSecurityGroups()));
            }
            case "MediaConnectFlows": {
                return Optional.ofNullable(clazz.cast(this.mediaConnectFlows()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInputRequest, T> g) {
        return obj -> g.apply((UpdateInputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<InputDestinationRequest> destinations = DefaultSdkAutoConstructList.getInstance();
        private List<InputDeviceRequest> inputDevices = DefaultSdkAutoConstructList.getInstance();
        private String inputId;
        private List<String> inputSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<MediaConnectFlowRequest> mediaConnectFlows = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String roleArn;
        private List<InputSourceRequest> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInputRequest model) {
            super(model);
            this.destinations(model.destinations);
            this.inputDevices(model.inputDevices);
            this.inputId(model.inputId);
            this.inputSecurityGroups(model.inputSecurityGroups);
            this.mediaConnectFlows(model.mediaConnectFlows);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.sources(model.sources);
        }

        public final Collection<InputDestinationRequest.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(InputDestinationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<InputDestinationRequest> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(InputDestinationRequest ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<InputDestinationRequest.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (InputDestinationRequest)((InputDestinationRequest.Builder)InputDestinationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<InputDestinationRequest.BuilderImpl> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copyFromBuilder(destinations);
        }

        public final Collection<InputDeviceRequest.Builder> getInputDevices() {
            return this.inputDevices != null ? (Collection)this.inputDevices.stream().map(InputDeviceRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDevices(Collection<InputDeviceRequest> inputDevices) {
            this.inputDevices = ___listOfInputDeviceRequestCopier.copy(inputDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(InputDeviceRequest ... inputDevices) {
            this.inputDevices(Arrays.asList(inputDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(Consumer<InputDeviceRequest.Builder> ... inputDevices) {
            this.inputDevices(Stream.of(inputDevices).map(c -> (InputDeviceRequest)((InputDeviceRequest.Builder)InputDeviceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDevices(Collection<InputDeviceRequest.BuilderImpl> inputDevices) {
            this.inputDevices = ___listOfInputDeviceRequestCopier.copyFromBuilder(inputDevices);
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final Collection<String> getInputSecurityGroups() {
            return this.inputSecurityGroups;
        }

        @Override
        public final Builder inputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroups(String ... inputSecurityGroups) {
            this.inputSecurityGroups(Arrays.asList(inputSecurityGroups));
            return this;
        }

        public final void setInputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
        }

        public final Collection<MediaConnectFlowRequest.Builder> getMediaConnectFlows() {
            return this.mediaConnectFlows != null ? (Collection)this.mediaConnectFlows.stream().map(MediaConnectFlowRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mediaConnectFlows(Collection<MediaConnectFlowRequest> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowRequestCopier.copy(mediaConnectFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(MediaConnectFlowRequest ... mediaConnectFlows) {
            this.mediaConnectFlows(Arrays.asList(mediaConnectFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(Consumer<MediaConnectFlowRequest.Builder> ... mediaConnectFlows) {
            this.mediaConnectFlows(Stream.of(mediaConnectFlows).map(c -> (MediaConnectFlowRequest)((MediaConnectFlowRequest.Builder)MediaConnectFlowRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMediaConnectFlows(Collection<MediaConnectFlowRequest.BuilderImpl> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowRequestCopier.copyFromBuilder(mediaConnectFlows);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<InputSourceRequest.Builder> getSources() {
            return this.sources != null ? (Collection)this.sources.stream().map(InputSourceRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<InputSourceRequest> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(InputSourceRequest ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<InputSourceRequest.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (InputSourceRequest)((InputSourceRequest.Builder)InputSourceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<InputSourceRequest.BuilderImpl> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copyFromBuilder(sources);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInputRequest build() {
            return new UpdateInputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInputRequest> {
        public Builder destinations(Collection<InputDestinationRequest> var1);

        public Builder destinations(InputDestinationRequest ... var1);

        public Builder destinations(Consumer<InputDestinationRequest.Builder> ... var1);

        public Builder inputDevices(Collection<InputDeviceRequest> var1);

        public Builder inputDevices(InputDeviceRequest ... var1);

        public Builder inputDevices(Consumer<InputDeviceRequest.Builder> ... var1);

        public Builder inputId(String var1);

        public Builder inputSecurityGroups(Collection<String> var1);

        public Builder inputSecurityGroups(String ... var1);

        public Builder mediaConnectFlows(Collection<MediaConnectFlowRequest> var1);

        public Builder mediaConnectFlows(MediaConnectFlowRequest ... var1);

        public Builder mediaConnectFlows(Consumer<MediaConnectFlowRequest.Builder> ... var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder sources(Collection<InputSourceRequest> var1);

        public Builder sources(InputSourceRequest ... var1);

        public Builder sources(Consumer<InputSourceRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

