/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.MultiplexSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMultiplexRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateMultiplexRequest> {
    private static final SdkField<String> MULTIPLEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiplexId").getter(UpdateMultiplexRequest.getter(UpdateMultiplexRequest::multiplexId)).setter(UpdateMultiplexRequest.setter(Builder::multiplexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("multiplexId").build()}).build();
    private static final SdkField<MultiplexSettings> MULTIPLEX_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiplexSettings").getter(UpdateMultiplexRequest.getter(UpdateMultiplexRequest::multiplexSettings)).setter(UpdateMultiplexRequest.setter(Builder::multiplexSettings)).constructor(MultiplexSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexSettings").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateMultiplexRequest.getter(UpdateMultiplexRequest::name)).setter(UpdateMultiplexRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_ID_FIELD, MULTIPLEX_SETTINGS_FIELD, NAME_FIELD));
    private final String multiplexId;
    private final MultiplexSettings multiplexSettings;
    private final String name;

    private UpdateMultiplexRequest(BuilderImpl builder) {
        super(builder);
        this.multiplexId = builder.multiplexId;
        this.multiplexSettings = builder.multiplexSettings;
        this.name = builder.name;
    }

    public String multiplexId() {
        return this.multiplexId;
    }

    public MultiplexSettings multiplexSettings() {
        return this.multiplexSettings;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMultiplexRequest)) {
            return false;
        }
        UpdateMultiplexRequest other = (UpdateMultiplexRequest)((Object)obj);
        return Objects.equals(this.multiplexId(), other.multiplexId()) && Objects.equals(this.multiplexSettings(), other.multiplexSettings()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMultiplexRequest").add("MultiplexId", (Object)this.multiplexId()).add("MultiplexSettings", (Object)this.multiplexSettings()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiplexId": {
                return Optional.ofNullable(clazz.cast(this.multiplexId()));
            }
            case "MultiplexSettings": {
                return Optional.ofNullable(clazz.cast(this.multiplexSettings()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMultiplexRequest, T> g) {
        return obj -> g.apply((UpdateMultiplexRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String multiplexId;
        private MultiplexSettings multiplexSettings;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMultiplexRequest model) {
            super(model);
            this.multiplexId(model.multiplexId);
            this.multiplexSettings(model.multiplexSettings);
            this.name(model.name);
        }

        public final String getMultiplexId() {
            return this.multiplexId;
        }

        @Override
        public final Builder multiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        public final void setMultiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
        }

        public final MultiplexSettings.Builder getMultiplexSettings() {
            return this.multiplexSettings != null ? this.multiplexSettings.toBuilder() : null;
        }

        @Override
        public final Builder multiplexSettings(MultiplexSettings multiplexSettings) {
            this.multiplexSettings = multiplexSettings;
            return this;
        }

        public final void setMultiplexSettings(MultiplexSettings.BuilderImpl multiplexSettings) {
            this.multiplexSettings = multiplexSettings != null ? multiplexSettings.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMultiplexRequest build() {
            return new UpdateMultiplexRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMultiplexRequest> {
        public Builder multiplexId(String var1);

        public Builder multiplexSettings(MultiplexSettings var1);

        default public Builder multiplexSettings(Consumer<MultiplexSettings.Builder> multiplexSettings) {
            return this.multiplexSettings((MultiplexSettings)((MultiplexSettings.Builder)MultiplexSettings.builder().applyMutation(multiplexSettings)).build());
        }

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

