/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ArchiveOutputSettings;
import software.amazon.awssdk.services.medialive.model.FrameCaptureOutputSettings;
import software.amazon.awssdk.services.medialive.model.HlsOutputSettings;
import software.amazon.awssdk.services.medialive.model.MediaPackageOutputSettings;
import software.amazon.awssdk.services.medialive.model.MsSmoothOutputSettings;
import software.amazon.awssdk.services.medialive.model.MultiplexOutputSettings;
import software.amazon.awssdk.services.medialive.model.RtmpOutputSettings;
import software.amazon.awssdk.services.medialive.model.UdpOutputSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputSettings> {
    private static final SdkField<ArchiveOutputSettings> ARCHIVE_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArchiveOutputSettings").getter(OutputSettings.getter(OutputSettings::archiveOutputSettings)).setter(OutputSettings.setter(Builder::archiveOutputSettings)).constructor(ArchiveOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveOutputSettings").build()}).build();
    private static final SdkField<FrameCaptureOutputSettings> FRAME_CAPTURE_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameCaptureOutputSettings").getter(OutputSettings.getter(OutputSettings::frameCaptureOutputSettings)).setter(OutputSettings.setter(Builder::frameCaptureOutputSettings)).constructor(FrameCaptureOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureOutputSettings").build()}).build();
    private static final SdkField<HlsOutputSettings> HLS_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsOutputSettings").getter(OutputSettings.getter(OutputSettings::hlsOutputSettings)).setter(OutputSettings.setter(Builder::hlsOutputSettings)).constructor(HlsOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsOutputSettings").build()}).build();
    private static final SdkField<MediaPackageOutputSettings> MEDIA_PACKAGE_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaPackageOutputSettings").getter(OutputSettings.getter(OutputSettings::mediaPackageOutputSettings)).setter(OutputSettings.setter(Builder::mediaPackageOutputSettings)).constructor(MediaPackageOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaPackageOutputSettings").build()}).build();
    private static final SdkField<MsSmoothOutputSettings> MS_SMOOTH_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MsSmoothOutputSettings").getter(OutputSettings.getter(OutputSettings::msSmoothOutputSettings)).setter(OutputSettings.setter(Builder::msSmoothOutputSettings)).constructor(MsSmoothOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("msSmoothOutputSettings").build()}).build();
    private static final SdkField<MultiplexOutputSettings> MULTIPLEX_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiplexOutputSettings").getter(OutputSettings.getter(OutputSettings::multiplexOutputSettings)).setter(OutputSettings.setter(Builder::multiplexOutputSettings)).constructor(MultiplexOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexOutputSettings").build()}).build();
    private static final SdkField<RtmpOutputSettings> RTMP_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RtmpOutputSettings").getter(OutputSettings.getter(OutputSettings::rtmpOutputSettings)).setter(OutputSettings.setter(Builder::rtmpOutputSettings)).constructor(RtmpOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtmpOutputSettings").build()}).build();
    private static final SdkField<UdpOutputSettings> UDP_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UdpOutputSettings").getter(OutputSettings.getter(OutputSettings::udpOutputSettings)).setter(OutputSettings.setter(Builder::udpOutputSettings)).constructor(UdpOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("udpOutputSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_OUTPUT_SETTINGS_FIELD, FRAME_CAPTURE_OUTPUT_SETTINGS_FIELD, HLS_OUTPUT_SETTINGS_FIELD, MEDIA_PACKAGE_OUTPUT_SETTINGS_FIELD, MS_SMOOTH_OUTPUT_SETTINGS_FIELD, MULTIPLEX_OUTPUT_SETTINGS_FIELD, RTMP_OUTPUT_SETTINGS_FIELD, UDP_OUTPUT_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ArchiveOutputSettings archiveOutputSettings;
    private final FrameCaptureOutputSettings frameCaptureOutputSettings;
    private final HlsOutputSettings hlsOutputSettings;
    private final MediaPackageOutputSettings mediaPackageOutputSettings;
    private final MsSmoothOutputSettings msSmoothOutputSettings;
    private final MultiplexOutputSettings multiplexOutputSettings;
    private final RtmpOutputSettings rtmpOutputSettings;
    private final UdpOutputSettings udpOutputSettings;

    private OutputSettings(BuilderImpl builder) {
        this.archiveOutputSettings = builder.archiveOutputSettings;
        this.frameCaptureOutputSettings = builder.frameCaptureOutputSettings;
        this.hlsOutputSettings = builder.hlsOutputSettings;
        this.mediaPackageOutputSettings = builder.mediaPackageOutputSettings;
        this.msSmoothOutputSettings = builder.msSmoothOutputSettings;
        this.multiplexOutputSettings = builder.multiplexOutputSettings;
        this.rtmpOutputSettings = builder.rtmpOutputSettings;
        this.udpOutputSettings = builder.udpOutputSettings;
    }

    public ArchiveOutputSettings archiveOutputSettings() {
        return this.archiveOutputSettings;
    }

    public FrameCaptureOutputSettings frameCaptureOutputSettings() {
        return this.frameCaptureOutputSettings;
    }

    public HlsOutputSettings hlsOutputSettings() {
        return this.hlsOutputSettings;
    }

    public MediaPackageOutputSettings mediaPackageOutputSettings() {
        return this.mediaPackageOutputSettings;
    }

    public MsSmoothOutputSettings msSmoothOutputSettings() {
        return this.msSmoothOutputSettings;
    }

    public MultiplexOutputSettings multiplexOutputSettings() {
        return this.multiplexOutputSettings;
    }

    public RtmpOutputSettings rtmpOutputSettings() {
        return this.rtmpOutputSettings;
    }

    public UdpOutputSettings udpOutputSettings() {
        return this.udpOutputSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameCaptureOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPackageOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.msSmoothOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rtmpOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.udpOutputSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSettings)) {
            return false;
        }
        OutputSettings other = (OutputSettings)obj;
        return Objects.equals(this.archiveOutputSettings(), other.archiveOutputSettings()) && Objects.equals(this.frameCaptureOutputSettings(), other.frameCaptureOutputSettings()) && Objects.equals(this.hlsOutputSettings(), other.hlsOutputSettings()) && Objects.equals(this.mediaPackageOutputSettings(), other.mediaPackageOutputSettings()) && Objects.equals(this.msSmoothOutputSettings(), other.msSmoothOutputSettings()) && Objects.equals(this.multiplexOutputSettings(), other.multiplexOutputSettings()) && Objects.equals(this.rtmpOutputSettings(), other.rtmpOutputSettings()) && Objects.equals(this.udpOutputSettings(), other.udpOutputSettings());
    }

    public String toString() {
        return ToString.builder((String)"OutputSettings").add("ArchiveOutputSettings", (Object)this.archiveOutputSettings()).add("FrameCaptureOutputSettings", (Object)this.frameCaptureOutputSettings()).add("HlsOutputSettings", (Object)this.hlsOutputSettings()).add("MediaPackageOutputSettings", (Object)this.mediaPackageOutputSettings()).add("MsSmoothOutputSettings", (Object)this.msSmoothOutputSettings()).add("MultiplexOutputSettings", (Object)this.multiplexOutputSettings()).add("RtmpOutputSettings", (Object)this.rtmpOutputSettings()).add("UdpOutputSettings", (Object)this.udpOutputSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.archiveOutputSettings()));
            }
            case "FrameCaptureOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.frameCaptureOutputSettings()));
            }
            case "HlsOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsOutputSettings()));
            }
            case "MediaPackageOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.mediaPackageOutputSettings()));
            }
            case "MsSmoothOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.msSmoothOutputSettings()));
            }
            case "MultiplexOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.multiplexOutputSettings()));
            }
            case "RtmpOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.rtmpOutputSettings()));
            }
            case "UdpOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.udpOutputSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputSettings, T> g) {
        return obj -> g.apply((OutputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ArchiveOutputSettings archiveOutputSettings;
        private FrameCaptureOutputSettings frameCaptureOutputSettings;
        private HlsOutputSettings hlsOutputSettings;
        private MediaPackageOutputSettings mediaPackageOutputSettings;
        private MsSmoothOutputSettings msSmoothOutputSettings;
        private MultiplexOutputSettings multiplexOutputSettings;
        private RtmpOutputSettings rtmpOutputSettings;
        private UdpOutputSettings udpOutputSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSettings model) {
            this.archiveOutputSettings(model.archiveOutputSettings);
            this.frameCaptureOutputSettings(model.frameCaptureOutputSettings);
            this.hlsOutputSettings(model.hlsOutputSettings);
            this.mediaPackageOutputSettings(model.mediaPackageOutputSettings);
            this.msSmoothOutputSettings(model.msSmoothOutputSettings);
            this.multiplexOutputSettings(model.multiplexOutputSettings);
            this.rtmpOutputSettings(model.rtmpOutputSettings);
            this.udpOutputSettings(model.udpOutputSettings);
        }

        public final ArchiveOutputSettings.Builder getArchiveOutputSettings() {
            return this.archiveOutputSettings != null ? this.archiveOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder archiveOutputSettings(ArchiveOutputSettings archiveOutputSettings) {
            this.archiveOutputSettings = archiveOutputSettings;
            return this;
        }

        public final void setArchiveOutputSettings(ArchiveOutputSettings.BuilderImpl archiveOutputSettings) {
            this.archiveOutputSettings = archiveOutputSettings != null ? archiveOutputSettings.build() : null;
        }

        public final FrameCaptureOutputSettings.Builder getFrameCaptureOutputSettings() {
            return this.frameCaptureOutputSettings != null ? this.frameCaptureOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder frameCaptureOutputSettings(FrameCaptureOutputSettings frameCaptureOutputSettings) {
            this.frameCaptureOutputSettings = frameCaptureOutputSettings;
            return this;
        }

        public final void setFrameCaptureOutputSettings(FrameCaptureOutputSettings.BuilderImpl frameCaptureOutputSettings) {
            this.frameCaptureOutputSettings = frameCaptureOutputSettings != null ? frameCaptureOutputSettings.build() : null;
        }

        public final HlsOutputSettings.Builder getHlsOutputSettings() {
            return this.hlsOutputSettings != null ? this.hlsOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsOutputSettings(HlsOutputSettings hlsOutputSettings) {
            this.hlsOutputSettings = hlsOutputSettings;
            return this;
        }

        public final void setHlsOutputSettings(HlsOutputSettings.BuilderImpl hlsOutputSettings) {
            this.hlsOutputSettings = hlsOutputSettings != null ? hlsOutputSettings.build() : null;
        }

        public final MediaPackageOutputSettings.Builder getMediaPackageOutputSettings() {
            return this.mediaPackageOutputSettings != null ? this.mediaPackageOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder mediaPackageOutputSettings(MediaPackageOutputSettings mediaPackageOutputSettings) {
            this.mediaPackageOutputSettings = mediaPackageOutputSettings;
            return this;
        }

        public final void setMediaPackageOutputSettings(MediaPackageOutputSettings.BuilderImpl mediaPackageOutputSettings) {
            this.mediaPackageOutputSettings = mediaPackageOutputSettings != null ? mediaPackageOutputSettings.build() : null;
        }

        public final MsSmoothOutputSettings.Builder getMsSmoothOutputSettings() {
            return this.msSmoothOutputSettings != null ? this.msSmoothOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder msSmoothOutputSettings(MsSmoothOutputSettings msSmoothOutputSettings) {
            this.msSmoothOutputSettings = msSmoothOutputSettings;
            return this;
        }

        public final void setMsSmoothOutputSettings(MsSmoothOutputSettings.BuilderImpl msSmoothOutputSettings) {
            this.msSmoothOutputSettings = msSmoothOutputSettings != null ? msSmoothOutputSettings.build() : null;
        }

        public final MultiplexOutputSettings.Builder getMultiplexOutputSettings() {
            return this.multiplexOutputSettings != null ? this.multiplexOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder multiplexOutputSettings(MultiplexOutputSettings multiplexOutputSettings) {
            this.multiplexOutputSettings = multiplexOutputSettings;
            return this;
        }

        public final void setMultiplexOutputSettings(MultiplexOutputSettings.BuilderImpl multiplexOutputSettings) {
            this.multiplexOutputSettings = multiplexOutputSettings != null ? multiplexOutputSettings.build() : null;
        }

        public final RtmpOutputSettings.Builder getRtmpOutputSettings() {
            return this.rtmpOutputSettings != null ? this.rtmpOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder rtmpOutputSettings(RtmpOutputSettings rtmpOutputSettings) {
            this.rtmpOutputSettings = rtmpOutputSettings;
            return this;
        }

        public final void setRtmpOutputSettings(RtmpOutputSettings.BuilderImpl rtmpOutputSettings) {
            this.rtmpOutputSettings = rtmpOutputSettings != null ? rtmpOutputSettings.build() : null;
        }

        public final UdpOutputSettings.Builder getUdpOutputSettings() {
            return this.udpOutputSettings != null ? this.udpOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder udpOutputSettings(UdpOutputSettings udpOutputSettings) {
            this.udpOutputSettings = udpOutputSettings;
            return this;
        }

        public final void setUdpOutputSettings(UdpOutputSettings.BuilderImpl udpOutputSettings) {
            this.udpOutputSettings = udpOutputSettings != null ? udpOutputSettings.build() : null;
        }

        public OutputSettings build() {
            return new OutputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputSettings> {
        public Builder archiveOutputSettings(ArchiveOutputSettings var1);

        default public Builder archiveOutputSettings(Consumer<ArchiveOutputSettings.Builder> archiveOutputSettings) {
            return this.archiveOutputSettings((ArchiveOutputSettings)((ArchiveOutputSettings.Builder)ArchiveOutputSettings.builder().applyMutation(archiveOutputSettings)).build());
        }

        public Builder frameCaptureOutputSettings(FrameCaptureOutputSettings var1);

        default public Builder frameCaptureOutputSettings(Consumer<FrameCaptureOutputSettings.Builder> frameCaptureOutputSettings) {
            return this.frameCaptureOutputSettings((FrameCaptureOutputSettings)((FrameCaptureOutputSettings.Builder)FrameCaptureOutputSettings.builder().applyMutation(frameCaptureOutputSettings)).build());
        }

        public Builder hlsOutputSettings(HlsOutputSettings var1);

        default public Builder hlsOutputSettings(Consumer<HlsOutputSettings.Builder> hlsOutputSettings) {
            return this.hlsOutputSettings((HlsOutputSettings)((HlsOutputSettings.Builder)HlsOutputSettings.builder().applyMutation(hlsOutputSettings)).build());
        }

        public Builder mediaPackageOutputSettings(MediaPackageOutputSettings var1);

        default public Builder mediaPackageOutputSettings(Consumer<MediaPackageOutputSettings.Builder> mediaPackageOutputSettings) {
            return this.mediaPackageOutputSettings((MediaPackageOutputSettings)((MediaPackageOutputSettings.Builder)MediaPackageOutputSettings.builder().applyMutation(mediaPackageOutputSettings)).build());
        }

        public Builder msSmoothOutputSettings(MsSmoothOutputSettings var1);

        default public Builder msSmoothOutputSettings(Consumer<MsSmoothOutputSettings.Builder> msSmoothOutputSettings) {
            return this.msSmoothOutputSettings((MsSmoothOutputSettings)((MsSmoothOutputSettings.Builder)MsSmoothOutputSettings.builder().applyMutation(msSmoothOutputSettings)).build());
        }

        public Builder multiplexOutputSettings(MultiplexOutputSettings var1);

        default public Builder multiplexOutputSettings(Consumer<MultiplexOutputSettings.Builder> multiplexOutputSettings) {
            return this.multiplexOutputSettings((MultiplexOutputSettings)((MultiplexOutputSettings.Builder)MultiplexOutputSettings.builder().applyMutation(multiplexOutputSettings)).build());
        }

        public Builder rtmpOutputSettings(RtmpOutputSettings var1);

        default public Builder rtmpOutputSettings(Consumer<RtmpOutputSettings.Builder> rtmpOutputSettings) {
            return this.rtmpOutputSettings((RtmpOutputSettings)((RtmpOutputSettings.Builder)RtmpOutputSettings.builder().applyMutation(rtmpOutputSettings)).build());
        }

        public Builder udpOutputSettings(UdpOutputSettings var1);

        default public Builder udpOutputSettings(Consumer<UdpOutputSettings.Builder> udpOutputSettings) {
            return this.udpOutputSettings((UdpOutputSettings)((UdpOutputSettings.Builder)UdpOutputSettings.builder().applyMutation(udpOutputSettings)).build());
        }
    }
}

