/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.BurnInAlignment;
import software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor;
import software.amazon.awssdk.services.medialive.model.BurnInFontColor;
import software.amazon.awssdk.services.medialive.model.BurnInOutlineColor;
import software.amazon.awssdk.services.medialive.model.BurnInShadowColor;
import software.amazon.awssdk.services.medialive.model.BurnInTeletextGridControl;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BurnInDestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BurnInDestinationSettings> {
    private static final SdkField<String> ALIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alignment").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::alignmentAsString)).setter(BurnInDestinationSettings.setter(Builder::alignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alignment").build()}).build();
    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackgroundColor").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::backgroundColorAsString)).setter(BurnInDestinationSettings.setter(Builder::backgroundColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backgroundColor").build()}).build();
    private static final SdkField<Integer> BACKGROUND_OPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackgroundOpacity").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::backgroundOpacity)).setter(BurnInDestinationSettings.setter(Builder::backgroundOpacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backgroundOpacity").build()}).build();
    private static final SdkField<InputLocation> FONT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Font").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::font)).setter(BurnInDestinationSettings.setter(Builder::font)).constructor(InputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("font").build()}).build();
    private static final SdkField<String> FONT_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontColor").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::fontColorAsString)).setter(BurnInDestinationSettings.setter(Builder::fontColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontColor").build()}).build();
    private static final SdkField<Integer> FONT_OPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FontOpacity").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::fontOpacity)).setter(BurnInDestinationSettings.setter(Builder::fontOpacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontOpacity").build()}).build();
    private static final SdkField<Integer> FONT_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FontResolution").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::fontResolution)).setter(BurnInDestinationSettings.setter(Builder::fontResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontResolution").build()}).build();
    private static final SdkField<String> FONT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontSize").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::fontSize)).setter(BurnInDestinationSettings.setter(Builder::fontSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontSize").build()}).build();
    private static final SdkField<String> OUTLINE_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutlineColor").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::outlineColorAsString)).setter(BurnInDestinationSettings.setter(Builder::outlineColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outlineColor").build()}).build();
    private static final SdkField<Integer> OUTLINE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OutlineSize").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::outlineSize)).setter(BurnInDestinationSettings.setter(Builder::outlineSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outlineSize").build()}).build();
    private static final SdkField<String> SHADOW_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShadowColor").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::shadowColorAsString)).setter(BurnInDestinationSettings.setter(Builder::shadowColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowColor").build()}).build();
    private static final SdkField<Integer> SHADOW_OPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ShadowOpacity").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::shadowOpacity)).setter(BurnInDestinationSettings.setter(Builder::shadowOpacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowOpacity").build()}).build();
    private static final SdkField<Integer> SHADOW_X_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ShadowXOffset").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::shadowXOffset)).setter(BurnInDestinationSettings.setter(Builder::shadowXOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowXOffset").build()}).build();
    private static final SdkField<Integer> SHADOW_Y_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ShadowYOffset").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::shadowYOffset)).setter(BurnInDestinationSettings.setter(Builder::shadowYOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowYOffset").build()}).build();
    private static final SdkField<String> TELETEXT_GRID_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TeletextGridControl").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::teletextGridControlAsString)).setter(BurnInDestinationSettings.setter(Builder::teletextGridControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextGridControl").build()}).build();
    private static final SdkField<Integer> X_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("XPosition").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::xPosition)).setter(BurnInDestinationSettings.setter(Builder::xPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xPosition").build()}).build();
    private static final SdkField<Integer> Y_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("YPosition").getter(BurnInDestinationSettings.getter(BurnInDestinationSettings::yPosition)).setter(BurnInDestinationSettings.setter(Builder::yPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("yPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNMENT_FIELD, BACKGROUND_COLOR_FIELD, BACKGROUND_OPACITY_FIELD, FONT_FIELD, FONT_COLOR_FIELD, FONT_OPACITY_FIELD, FONT_RESOLUTION_FIELD, FONT_SIZE_FIELD, OUTLINE_COLOR_FIELD, OUTLINE_SIZE_FIELD, SHADOW_COLOR_FIELD, SHADOW_OPACITY_FIELD, SHADOW_X_OFFSET_FIELD, SHADOW_Y_OFFSET_FIELD, TELETEXT_GRID_CONTROL_FIELD, X_POSITION_FIELD, Y_POSITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alignment;
    private final String backgroundColor;
    private final Integer backgroundOpacity;
    private final InputLocation font;
    private final String fontColor;
    private final Integer fontOpacity;
    private final Integer fontResolution;
    private final String fontSize;
    private final String outlineColor;
    private final Integer outlineSize;
    private final String shadowColor;
    private final Integer shadowOpacity;
    private final Integer shadowXOffset;
    private final Integer shadowYOffset;
    private final String teletextGridControl;
    private final Integer xPosition;
    private final Integer yPosition;

    private BurnInDestinationSettings(BuilderImpl builder) {
        this.alignment = builder.alignment;
        this.backgroundColor = builder.backgroundColor;
        this.backgroundOpacity = builder.backgroundOpacity;
        this.font = builder.font;
        this.fontColor = builder.fontColor;
        this.fontOpacity = builder.fontOpacity;
        this.fontResolution = builder.fontResolution;
        this.fontSize = builder.fontSize;
        this.outlineColor = builder.outlineColor;
        this.outlineSize = builder.outlineSize;
        this.shadowColor = builder.shadowColor;
        this.shadowOpacity = builder.shadowOpacity;
        this.shadowXOffset = builder.shadowXOffset;
        this.shadowYOffset = builder.shadowYOffset;
        this.teletextGridControl = builder.teletextGridControl;
        this.xPosition = builder.xPosition;
        this.yPosition = builder.yPosition;
    }

    public BurnInAlignment alignment() {
        return BurnInAlignment.fromValue(this.alignment);
    }

    public String alignmentAsString() {
        return this.alignment;
    }

    public BurnInBackgroundColor backgroundColor() {
        return BurnInBackgroundColor.fromValue(this.backgroundColor);
    }

    public String backgroundColorAsString() {
        return this.backgroundColor;
    }

    public Integer backgroundOpacity() {
        return this.backgroundOpacity;
    }

    public InputLocation font() {
        return this.font;
    }

    public BurnInFontColor fontColor() {
        return BurnInFontColor.fromValue(this.fontColor);
    }

    public String fontColorAsString() {
        return this.fontColor;
    }

    public Integer fontOpacity() {
        return this.fontOpacity;
    }

    public Integer fontResolution() {
        return this.fontResolution;
    }

    public String fontSize() {
        return this.fontSize;
    }

    public BurnInOutlineColor outlineColor() {
        return BurnInOutlineColor.fromValue(this.outlineColor);
    }

    public String outlineColorAsString() {
        return this.outlineColor;
    }

    public Integer outlineSize() {
        return this.outlineSize;
    }

    public BurnInShadowColor shadowColor() {
        return BurnInShadowColor.fromValue(this.shadowColor);
    }

    public String shadowColorAsString() {
        return this.shadowColor;
    }

    public Integer shadowOpacity() {
        return this.shadowOpacity;
    }

    public Integer shadowXOffset() {
        return this.shadowXOffset;
    }

    public Integer shadowYOffset() {
        return this.shadowYOffset;
    }

    public BurnInTeletextGridControl teletextGridControl() {
        return BurnInTeletextGridControl.fromValue(this.teletextGridControl);
    }

    public String teletextGridControlAsString() {
        return this.teletextGridControl;
    }

    public Integer xPosition() {
        return this.xPosition;
    }

    public Integer yPosition() {
        return this.yPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.font());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontResolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.outlineColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outlineSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowXOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowYOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.teletextGridControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.yPosition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BurnInDestinationSettings)) {
            return false;
        }
        BurnInDestinationSettings other = (BurnInDestinationSettings)obj;
        return Objects.equals(this.alignmentAsString(), other.alignmentAsString()) && Objects.equals(this.backgroundColorAsString(), other.backgroundColorAsString()) && Objects.equals(this.backgroundOpacity(), other.backgroundOpacity()) && Objects.equals(this.font(), other.font()) && Objects.equals(this.fontColorAsString(), other.fontColorAsString()) && Objects.equals(this.fontOpacity(), other.fontOpacity()) && Objects.equals(this.fontResolution(), other.fontResolution()) && Objects.equals(this.fontSize(), other.fontSize()) && Objects.equals(this.outlineColorAsString(), other.outlineColorAsString()) && Objects.equals(this.outlineSize(), other.outlineSize()) && Objects.equals(this.shadowColorAsString(), other.shadowColorAsString()) && Objects.equals(this.shadowOpacity(), other.shadowOpacity()) && Objects.equals(this.shadowXOffset(), other.shadowXOffset()) && Objects.equals(this.shadowYOffset(), other.shadowYOffset()) && Objects.equals(this.teletextGridControlAsString(), other.teletextGridControlAsString()) && Objects.equals(this.xPosition(), other.xPosition()) && Objects.equals(this.yPosition(), other.yPosition());
    }

    public String toString() {
        return ToString.builder((String)"BurnInDestinationSettings").add("Alignment", (Object)this.alignmentAsString()).add("BackgroundColor", (Object)this.backgroundColorAsString()).add("BackgroundOpacity", (Object)this.backgroundOpacity()).add("Font", (Object)this.font()).add("FontColor", (Object)this.fontColorAsString()).add("FontOpacity", (Object)this.fontOpacity()).add("FontResolution", (Object)this.fontResolution()).add("FontSize", (Object)this.fontSize()).add("OutlineColor", (Object)this.outlineColorAsString()).add("OutlineSize", (Object)this.outlineSize()).add("ShadowColor", (Object)this.shadowColorAsString()).add("ShadowOpacity", (Object)this.shadowOpacity()).add("ShadowXOffset", (Object)this.shadowXOffset()).add("ShadowYOffset", (Object)this.shadowYOffset()).add("TeletextGridControl", (Object)this.teletextGridControlAsString()).add("XPosition", (Object)this.xPosition()).add("YPosition", (Object)this.yPosition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alignment": {
                return Optional.ofNullable(clazz.cast(this.alignmentAsString()));
            }
            case "BackgroundColor": {
                return Optional.ofNullable(clazz.cast(this.backgroundColorAsString()));
            }
            case "BackgroundOpacity": {
                return Optional.ofNullable(clazz.cast(this.backgroundOpacity()));
            }
            case "Font": {
                return Optional.ofNullable(clazz.cast(this.font()));
            }
            case "FontColor": {
                return Optional.ofNullable(clazz.cast(this.fontColorAsString()));
            }
            case "FontOpacity": {
                return Optional.ofNullable(clazz.cast(this.fontOpacity()));
            }
            case "FontResolution": {
                return Optional.ofNullable(clazz.cast(this.fontResolution()));
            }
            case "FontSize": {
                return Optional.ofNullable(clazz.cast(this.fontSize()));
            }
            case "OutlineColor": {
                return Optional.ofNullable(clazz.cast(this.outlineColorAsString()));
            }
            case "OutlineSize": {
                return Optional.ofNullable(clazz.cast(this.outlineSize()));
            }
            case "ShadowColor": {
                return Optional.ofNullable(clazz.cast(this.shadowColorAsString()));
            }
            case "ShadowOpacity": {
                return Optional.ofNullable(clazz.cast(this.shadowOpacity()));
            }
            case "ShadowXOffset": {
                return Optional.ofNullable(clazz.cast(this.shadowXOffset()));
            }
            case "ShadowYOffset": {
                return Optional.ofNullable(clazz.cast(this.shadowYOffset()));
            }
            case "TeletextGridControl": {
                return Optional.ofNullable(clazz.cast(this.teletextGridControlAsString()));
            }
            case "XPosition": {
                return Optional.ofNullable(clazz.cast(this.xPosition()));
            }
            case "YPosition": {
                return Optional.ofNullable(clazz.cast(this.yPosition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BurnInDestinationSettings, T> g) {
        return obj -> g.apply((BurnInDestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alignment;
        private String backgroundColor;
        private Integer backgroundOpacity;
        private InputLocation font;
        private String fontColor;
        private Integer fontOpacity;
        private Integer fontResolution;
        private String fontSize;
        private String outlineColor;
        private Integer outlineSize;
        private String shadowColor;
        private Integer shadowOpacity;
        private Integer shadowXOffset;
        private Integer shadowYOffset;
        private String teletextGridControl;
        private Integer xPosition;
        private Integer yPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(BurnInDestinationSettings model) {
            this.alignment(model.alignment);
            this.backgroundColor(model.backgroundColor);
            this.backgroundOpacity(model.backgroundOpacity);
            this.font(model.font);
            this.fontColor(model.fontColor);
            this.fontOpacity(model.fontOpacity);
            this.fontResolution(model.fontResolution);
            this.fontSize(model.fontSize);
            this.outlineColor(model.outlineColor);
            this.outlineSize(model.outlineSize);
            this.shadowColor(model.shadowColor);
            this.shadowOpacity(model.shadowOpacity);
            this.shadowXOffset(model.shadowXOffset);
            this.shadowYOffset(model.shadowYOffset);
            this.teletextGridControl(model.teletextGridControl);
            this.xPosition(model.xPosition);
            this.yPosition(model.yPosition);
        }

        public final String getAlignment() {
            return this.alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        @Override
        public final Builder alignment(BurnInAlignment alignment) {
            this.alignment(alignment == null ? null : alignment.toString());
            return this;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        public final String getBackgroundColor() {
            return this.backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Override
        public final Builder backgroundColor(BurnInBackgroundColor backgroundColor) {
            this.backgroundColor(backgroundColor == null ? null : backgroundColor.toString());
            return this;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public final Integer getBackgroundOpacity() {
            return this.backgroundOpacity;
        }

        @Override
        public final Builder backgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
            return this;
        }

        public final void setBackgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
        }

        public final InputLocation.Builder getFont() {
            return this.font != null ? this.font.toBuilder() : null;
        }

        @Override
        public final Builder font(InputLocation font) {
            this.font = font;
            return this;
        }

        public final void setFont(InputLocation.BuilderImpl font) {
            this.font = font != null ? font.build() : null;
        }

        public final String getFontColor() {
            return this.fontColor;
        }

        @Override
        public final Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        @Override
        public final Builder fontColor(BurnInFontColor fontColor) {
            this.fontColor(fontColor == null ? null : fontColor.toString());
            return this;
        }

        public final void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        public final Integer getFontOpacity() {
            return this.fontOpacity;
        }

        @Override
        public final Builder fontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
            return this;
        }

        public final void setFontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
        }

        public final Integer getFontResolution() {
            return this.fontResolution;
        }

        @Override
        public final Builder fontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
            return this;
        }

        public final void setFontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
        }

        public final String getFontSize() {
            return this.fontSize;
        }

        @Override
        public final Builder fontSize(String fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public final void setFontSize(String fontSize) {
            this.fontSize = fontSize;
        }

        public final String getOutlineColor() {
            return this.outlineColor;
        }

        @Override
        public final Builder outlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
            return this;
        }

        @Override
        public final Builder outlineColor(BurnInOutlineColor outlineColor) {
            this.outlineColor(outlineColor == null ? null : outlineColor.toString());
            return this;
        }

        public final void setOutlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
        }

        public final Integer getOutlineSize() {
            return this.outlineSize;
        }

        @Override
        public final Builder outlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
            return this;
        }

        public final void setOutlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
        }

        public final String getShadowColor() {
            return this.shadowColor;
        }

        @Override
        public final Builder shadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
            return this;
        }

        @Override
        public final Builder shadowColor(BurnInShadowColor shadowColor) {
            this.shadowColor(shadowColor == null ? null : shadowColor.toString());
            return this;
        }

        public final void setShadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
        }

        public final Integer getShadowOpacity() {
            return this.shadowOpacity;
        }

        @Override
        public final Builder shadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
            return this;
        }

        public final void setShadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
        }

        public final Integer getShadowXOffset() {
            return this.shadowXOffset;
        }

        @Override
        public final Builder shadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
            return this;
        }

        public final void setShadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
        }

        public final Integer getShadowYOffset() {
            return this.shadowYOffset;
        }

        @Override
        public final Builder shadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
            return this;
        }

        public final void setShadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
        }

        public final String getTeletextGridControl() {
            return this.teletextGridControl;
        }

        @Override
        public final Builder teletextGridControl(String teletextGridControl) {
            this.teletextGridControl = teletextGridControl;
            return this;
        }

        @Override
        public final Builder teletextGridControl(BurnInTeletextGridControl teletextGridControl) {
            this.teletextGridControl(teletextGridControl == null ? null : teletextGridControl.toString());
            return this;
        }

        public final void setTeletextGridControl(String teletextGridControl) {
            this.teletextGridControl = teletextGridControl;
        }

        public final Integer getXPosition() {
            return this.xPosition;
        }

        @Override
        public final Builder xPosition(Integer xPosition) {
            this.xPosition = xPosition;
            return this;
        }

        public final void setXPosition(Integer xPosition) {
            this.xPosition = xPosition;
        }

        public final Integer getYPosition() {
            return this.yPosition;
        }

        @Override
        public final Builder yPosition(Integer yPosition) {
            this.yPosition = yPosition;
            return this;
        }

        public final void setYPosition(Integer yPosition) {
            this.yPosition = yPosition;
        }

        public BurnInDestinationSettings build() {
            return new BurnInDestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BurnInDestinationSettings> {
        public Builder alignment(String var1);

        public Builder alignment(BurnInAlignment var1);

        public Builder backgroundColor(String var1);

        public Builder backgroundColor(BurnInBackgroundColor var1);

        public Builder backgroundOpacity(Integer var1);

        public Builder font(InputLocation var1);

        default public Builder font(Consumer<InputLocation.Builder> font) {
            return this.font((InputLocation)((InputLocation.Builder)InputLocation.builder().applyMutation(font)).build());
        }

        public Builder fontColor(String var1);

        public Builder fontColor(BurnInFontColor var1);

        public Builder fontOpacity(Integer var1);

        public Builder fontResolution(Integer var1);

        public Builder fontSize(String var1);

        public Builder outlineColor(String var1);

        public Builder outlineColor(BurnInOutlineColor var1);

        public Builder outlineSize(Integer var1);

        public Builder shadowColor(String var1);

        public Builder shadowColor(BurnInShadowColor var1);

        public Builder shadowOpacity(Integer var1);

        public Builder shadowXOffset(Integer var1);

        public Builder shadowYOffset(Integer var1);

        public Builder teletextGridControl(String var1);

        public Builder teletextGridControl(BurnInTeletextGridControl var1);

        public Builder xPosition(Integer var1);

        public Builder yPosition(Integer var1);
    }
}

