/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputSecurityGroup;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.___listOfInputSecurityGroupCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInputSecurityGroupsResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListInputSecurityGroupsResponse> {
    private static final SdkField<List<InputSecurityGroup>> INPUT_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputSecurityGroups").getter(ListInputSecurityGroupsResponse.getter(ListInputSecurityGroupsResponse::inputSecurityGroups)).setter(ListInputSecurityGroupsResponse.setter(Builder::inputSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInputSecurityGroupsResponse.getter(ListInputSecurityGroupsResponse::nextToken)).setter(ListInputSecurityGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SECURITY_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<InputSecurityGroup> inputSecurityGroups;
    private final String nextToken;

    private ListInputSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.inputSecurityGroups = builder.inputSecurityGroups;
        this.nextToken = builder.nextToken;
    }

    public boolean hasInputSecurityGroups() {
        return this.inputSecurityGroups != null && !(this.inputSecurityGroups instanceof SdkAutoConstructList);
    }

    public List<InputSecurityGroup> inputSecurityGroups() {
        return this.inputSecurityGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputSecurityGroups() ? this.inputSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInputSecurityGroupsResponse)) {
            return false;
        }
        ListInputSecurityGroupsResponse other = (ListInputSecurityGroupsResponse)((Object)obj);
        return this.hasInputSecurityGroups() == other.hasInputSecurityGroups() && Objects.equals(this.inputSecurityGroups(), other.inputSecurityGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListInputSecurityGroupsResponse").add("InputSecurityGroups", this.hasInputSecurityGroups() ? this.inputSecurityGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.inputSecurityGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInputSecurityGroupsResponse, T> g) {
        return obj -> g.apply((ListInputSecurityGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<InputSecurityGroup> inputSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInputSecurityGroupsResponse model) {
            super(model);
            this.inputSecurityGroups(model.inputSecurityGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<InputSecurityGroup.Builder> getInputSecurityGroups() {
            if (this.inputSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputSecurityGroups != null ? (Collection)this.inputSecurityGroups.stream().map(InputSecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputSecurityGroups(Collection<InputSecurityGroup> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOfInputSecurityGroupCopier.copy(inputSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroups(InputSecurityGroup ... inputSecurityGroups) {
            this.inputSecurityGroups(Arrays.asList(inputSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroups(Consumer<InputSecurityGroup.Builder> ... inputSecurityGroups) {
            this.inputSecurityGroups(Stream.of(inputSecurityGroups).map(c -> (InputSecurityGroup)((InputSecurityGroup.Builder)InputSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputSecurityGroups(Collection<InputSecurityGroup.BuilderImpl> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOfInputSecurityGroupCopier.copyFromBuilder(inputSecurityGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInputSecurityGroupsResponse build() {
            return new ListInputSecurityGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInputSecurityGroupsResponse> {
        public Builder inputSecurityGroups(Collection<InputSecurityGroup> var1);

        public Builder inputSecurityGroups(InputSecurityGroup ... var1);

        public Builder inputSecurityGroups(Consumer<InputSecurityGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

