/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.FrameCaptureSettings;
import software.amazon.awssdk.services.medialive.model.H264Settings;
import software.amazon.awssdk.services.medialive.model.H265Settings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoCodecSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoCodecSettings> {
    private static final SdkField<FrameCaptureSettings> FRAME_CAPTURE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameCaptureSettings").getter(VideoCodecSettings.getter(VideoCodecSettings::frameCaptureSettings)).setter(VideoCodecSettings.setter(Builder::frameCaptureSettings)).constructor(FrameCaptureSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureSettings").build()}).build();
    private static final SdkField<H264Settings> H264_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("H264Settings").getter(VideoCodecSettings.getter(VideoCodecSettings::h264Settings)).setter(VideoCodecSettings.setter(Builder::h264Settings)).constructor(H264Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h264Settings").build()}).build();
    private static final SdkField<H265Settings> H265_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("H265Settings").getter(VideoCodecSettings.getter(VideoCodecSettings::h265Settings)).setter(VideoCodecSettings.setter(Builder::h265Settings)).constructor(H265Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h265Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAME_CAPTURE_SETTINGS_FIELD, H264_SETTINGS_FIELD, H265_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final FrameCaptureSettings frameCaptureSettings;
    private final H264Settings h264Settings;
    private final H265Settings h265Settings;

    private VideoCodecSettings(BuilderImpl builder) {
        this.frameCaptureSettings = builder.frameCaptureSettings;
        this.h264Settings = builder.h264Settings;
        this.h265Settings = builder.h265Settings;
    }

    public FrameCaptureSettings frameCaptureSettings() {
        return this.frameCaptureSettings;
    }

    public H264Settings h264Settings() {
        return this.h264Settings;
    }

    public H265Settings h265Settings() {
        return this.h265Settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frameCaptureSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.h264Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.h265Settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoCodecSettings)) {
            return false;
        }
        VideoCodecSettings other = (VideoCodecSettings)obj;
        return Objects.equals(this.frameCaptureSettings(), other.frameCaptureSettings()) && Objects.equals(this.h264Settings(), other.h264Settings()) && Objects.equals(this.h265Settings(), other.h265Settings());
    }

    public String toString() {
        return ToString.builder((String)"VideoCodecSettings").add("FrameCaptureSettings", (Object)this.frameCaptureSettings()).add("H264Settings", (Object)this.h264Settings()).add("H265Settings", (Object)this.h265Settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FrameCaptureSettings": {
                return Optional.ofNullable(clazz.cast(this.frameCaptureSettings()));
            }
            case "H264Settings": {
                return Optional.ofNullable(clazz.cast(this.h264Settings()));
            }
            case "H265Settings": {
                return Optional.ofNullable(clazz.cast(this.h265Settings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoCodecSettings, T> g) {
        return obj -> g.apply((VideoCodecSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FrameCaptureSettings frameCaptureSettings;
        private H264Settings h264Settings;
        private H265Settings h265Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoCodecSettings model) {
            this.frameCaptureSettings(model.frameCaptureSettings);
            this.h264Settings(model.h264Settings);
            this.h265Settings(model.h265Settings);
        }

        public final FrameCaptureSettings.Builder getFrameCaptureSettings() {
            return this.frameCaptureSettings != null ? this.frameCaptureSettings.toBuilder() : null;
        }

        @Override
        public final Builder frameCaptureSettings(FrameCaptureSettings frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings;
            return this;
        }

        public final void setFrameCaptureSettings(FrameCaptureSettings.BuilderImpl frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings != null ? frameCaptureSettings.build() : null;
        }

        public final H264Settings.Builder getH264Settings() {
            return this.h264Settings != null ? this.h264Settings.toBuilder() : null;
        }

        @Override
        public final Builder h264Settings(H264Settings h264Settings) {
            this.h264Settings = h264Settings;
            return this;
        }

        public final void setH264Settings(H264Settings.BuilderImpl h264Settings) {
            this.h264Settings = h264Settings != null ? h264Settings.build() : null;
        }

        public final H265Settings.Builder getH265Settings() {
            return this.h265Settings != null ? this.h265Settings.toBuilder() : null;
        }

        @Override
        public final Builder h265Settings(H265Settings h265Settings) {
            this.h265Settings = h265Settings;
            return this;
        }

        public final void setH265Settings(H265Settings.BuilderImpl h265Settings) {
            this.h265Settings = h265Settings != null ? h265Settings.build() : null;
        }

        public VideoCodecSettings build() {
            return new VideoCodecSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoCodecSettings> {
        public Builder frameCaptureSettings(FrameCaptureSettings var1);

        default public Builder frameCaptureSettings(Consumer<FrameCaptureSettings.Builder> frameCaptureSettings) {
            return this.frameCaptureSettings((FrameCaptureSettings)((FrameCaptureSettings.Builder)FrameCaptureSettings.builder().applyMutation(frameCaptureSettings)).build());
        }

        public Builder h264Settings(H264Settings var1);

        default public Builder h264Settings(Consumer<H264Settings.Builder> h264Settings) {
            return this.h264Settings((H264Settings)((H264Settings.Builder)H264Settings.builder().applyMutation(h264Settings)).build());
        }

        public Builder h265Settings(H265Settings var1);

        default public Builder h265Settings(Consumer<H265Settings.Builder> h265Settings) {
            return this.h265Settings((H265Settings)((H265Settings.Builder)H265Settings.builder().applyMutation(h265Settings)).build());
        }
    }
}

