/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.AudioChannelMapping;
import software.amazon.awssdk.services.medialive.model.___listOfAudioChannelMappingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemixSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemixSettings> {
    private static final SdkField<List<AudioChannelMapping>> CHANNEL_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelMappings").getter(RemixSettings.getter(RemixSettings::channelMappings)).setter(RemixSettings.setter(Builder::channelMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioChannelMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CHANNELS_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ChannelsIn").getter(RemixSettings.getter(RemixSettings::channelsIn)).setter(RemixSettings.setter(Builder::channelsIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelsIn").build()}).build();
    private static final SdkField<Integer> CHANNELS_OUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ChannelsOut").getter(RemixSettings.getter(RemixSettings::channelsOut)).setter(RemixSettings.setter(Builder::channelsOut)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelsOut").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_MAPPINGS_FIELD, CHANNELS_IN_FIELD, CHANNELS_OUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AudioChannelMapping> channelMappings;
    private final Integer channelsIn;
    private final Integer channelsOut;

    private RemixSettings(BuilderImpl builder) {
        this.channelMappings = builder.channelMappings;
        this.channelsIn = builder.channelsIn;
        this.channelsOut = builder.channelsOut;
    }

    public boolean hasChannelMappings() {
        return this.channelMappings != null && !(this.channelMappings instanceof SdkAutoConstructList);
    }

    public List<AudioChannelMapping> channelMappings() {
        return this.channelMappings;
    }

    public Integer channelsIn() {
        return this.channelsIn;
    }

    public Integer channelsOut() {
        return this.channelsOut;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelMappings() ? this.channelMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelsIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelsOut());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemixSettings)) {
            return false;
        }
        RemixSettings other = (RemixSettings)obj;
        return this.hasChannelMappings() == other.hasChannelMappings() && Objects.equals(this.channelMappings(), other.channelMappings()) && Objects.equals(this.channelsIn(), other.channelsIn()) && Objects.equals(this.channelsOut(), other.channelsOut());
    }

    public String toString() {
        return ToString.builder((String)"RemixSettings").add("ChannelMappings", this.hasChannelMappings() ? this.channelMappings() : null).add("ChannelsIn", (Object)this.channelsIn()).add("ChannelsOut", (Object)this.channelsOut()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelMappings": {
                return Optional.ofNullable(clazz.cast(this.channelMappings()));
            }
            case "ChannelsIn": {
                return Optional.ofNullable(clazz.cast(this.channelsIn()));
            }
            case "ChannelsOut": {
                return Optional.ofNullable(clazz.cast(this.channelsOut()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemixSettings, T> g) {
        return obj -> g.apply((RemixSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioChannelMapping> channelMappings = DefaultSdkAutoConstructList.getInstance();
        private Integer channelsIn;
        private Integer channelsOut;

        private BuilderImpl() {
        }

        private BuilderImpl(RemixSettings model) {
            this.channelMappings(model.channelMappings);
            this.channelsIn(model.channelsIn);
            this.channelsOut(model.channelsOut);
        }

        public final Collection<AudioChannelMapping.Builder> getChannelMappings() {
            if (this.channelMappings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channelMappings != null ? (Collection)this.channelMappings.stream().map(AudioChannelMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder channelMappings(Collection<AudioChannelMapping> channelMappings) {
            this.channelMappings = ___listOfAudioChannelMappingCopier.copy(channelMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMappings(AudioChannelMapping ... channelMappings) {
            this.channelMappings(Arrays.asList(channelMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMappings(Consumer<AudioChannelMapping.Builder> ... channelMappings) {
            this.channelMappings(Stream.of(channelMappings).map(c -> (AudioChannelMapping)((AudioChannelMapping.Builder)AudioChannelMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChannelMappings(Collection<AudioChannelMapping.BuilderImpl> channelMappings) {
            this.channelMappings = ___listOfAudioChannelMappingCopier.copyFromBuilder(channelMappings);
        }

        public final Integer getChannelsIn() {
            return this.channelsIn;
        }

        @Override
        public final Builder channelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
            return this;
        }

        public final void setChannelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
        }

        public final Integer getChannelsOut() {
            return this.channelsOut;
        }

        @Override
        public final Builder channelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
            return this;
        }

        public final void setChannelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
        }

        public RemixSettings build() {
            return new RemixSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemixSettings> {
        public Builder channelMappings(Collection<AudioChannelMapping> var1);

        public Builder channelMappings(AudioChannelMapping ... var1);

        public Builder channelMappings(Consumer<AudioChannelMapping.Builder> ... var1);

        public Builder channelsIn(Integer var1);

        public Builder channelsOut(Integer var1);
    }
}

