/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AudioType {
    CLEAN_EFFECTS("CLEAN_EFFECTS"),
    HEARING_IMPAIRED("HEARING_IMPAIRED"),
    UNDEFINED("UNDEFINED"),
    VISUAL_IMPAIRED_COMMENTARY("VISUAL_IMPAIRED_COMMENTARY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AudioType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudioType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AudioType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudioType> knownValues() {
        return Stream.of(AudioType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

