/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState;
import software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState;
import software.amazon.awssdk.services.medialive.model.InputDeviceHdSettings;
import software.amazon.awssdk.services.medialive.model.InputDeviceNetworkSettings;
import software.amazon.awssdk.services.medialive.model.InputDeviceType;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInputDeviceResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, DescribeInputDeviceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeInputDeviceResponse.getter(DescribeInputDeviceResponse::arn)).setter(DescribeInputDeviceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionState").getter(DescribeInputDeviceResponse.getter(DescribeInputDeviceResponse::connectionStateAsString)).setter(DescribeInputDeviceResponse.setter(Builder::connectionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionState").build()}).build();
    private static final SdkField<String> DEVICE_SETTINGS_SYNC_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceSettingsSyncState").getter(DescribeInputDeviceResponse.getter(DescribeInputDeviceResponse::deviceSettingsSyncStateAsString)).setter(DescribeInputDeviceResponse.setter(Builder::deviceSettingsSyncState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceSettingsSyncState").build()}).build();
    private static final SdkField<InputDeviceHdSettings> HD_DEVICE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HdDeviceSettings").getter(DescribeInputDeviceResponse.getter(DescribeInputDeviceResponse::hdDeviceSettings)).setter(DescribeInputDeviceResponse.setter(Builder::hdDeviceSettings)).constructor(InputDeviceHdSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdDeviceSettings").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DescribeInputDeviceResponse.getter(DescribeInputDeviceResponse::id)).setter(DescribeInputDeviceResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAddress").getter(DescribeInputDeviceResponse.getter(DescribeInputDeviceResponse::macAddress)).setter(DescribeInputDeviceResponse.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeInputDeviceResponse.getter(DescribeInputDeviceResponse::name)).setter(DescribeInputDeviceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<InputDeviceNetworkSettings> NETWORK_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkSettings").getter(DescribeInputDeviceResponse.getter(DescribeInputDeviceResponse::networkSettings)).setter(DescribeInputDeviceResponse.setter(Builder::networkSettings)).constructor(InputDeviceNetworkSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettings").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(DescribeInputDeviceResponse.getter(DescribeInputDeviceResponse::serialNumber)).setter(DescribeInputDeviceResponse.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serialNumber").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribeInputDeviceResponse.getter(DescribeInputDeviceResponse::typeAsString)).setter(DescribeInputDeviceResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONNECTION_STATE_FIELD, DEVICE_SETTINGS_SYNC_STATE_FIELD, HD_DEVICE_SETTINGS_FIELD, ID_FIELD, MAC_ADDRESS_FIELD, NAME_FIELD, NETWORK_SETTINGS_FIELD, SERIAL_NUMBER_FIELD, TYPE_FIELD));
    private final String arn;
    private final String connectionState;
    private final String deviceSettingsSyncState;
    private final InputDeviceHdSettings hdDeviceSettings;
    private final String id;
    private final String macAddress;
    private final String name;
    private final InputDeviceNetworkSettings networkSettings;
    private final String serialNumber;
    private final String type;

    private DescribeInputDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.connectionState = builder.connectionState;
        this.deviceSettingsSyncState = builder.deviceSettingsSyncState;
        this.hdDeviceSettings = builder.hdDeviceSettings;
        this.id = builder.id;
        this.macAddress = builder.macAddress;
        this.name = builder.name;
        this.networkSettings = builder.networkSettings;
        this.serialNumber = builder.serialNumber;
        this.type = builder.type;
    }

    public String arn() {
        return this.arn;
    }

    public InputDeviceConnectionState connectionState() {
        return InputDeviceConnectionState.fromValue(this.connectionState);
    }

    public String connectionStateAsString() {
        return this.connectionState;
    }

    public DeviceSettingsSyncState deviceSettingsSyncState() {
        return DeviceSettingsSyncState.fromValue(this.deviceSettingsSyncState);
    }

    public String deviceSettingsSyncStateAsString() {
        return this.deviceSettingsSyncState;
    }

    public InputDeviceHdSettings hdDeviceSettings() {
        return this.hdDeviceSettings;
    }

    public String id() {
        return this.id;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public String name() {
        return this.name;
    }

    public InputDeviceNetworkSettings networkSettings() {
        return this.networkSettings;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public InputDeviceType type() {
        return InputDeviceType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSettingsSyncStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hdDeviceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInputDeviceResponse)) {
            return false;
        }
        DescribeInputDeviceResponse other = (DescribeInputDeviceResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(this.deviceSettingsSyncStateAsString(), other.deviceSettingsSyncStateAsString()) && Objects.equals(this.hdDeviceSettings(), other.hdDeviceSettings()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.networkSettings(), other.networkSettings()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInputDeviceResponse").add("Arn", (Object)this.arn()).add("ConnectionState", (Object)this.connectionStateAsString()).add("DeviceSettingsSyncState", (Object)this.deviceSettingsSyncStateAsString()).add("HdDeviceSettings", (Object)this.hdDeviceSettings()).add("Id", (Object)this.id()).add("MacAddress", (Object)this.macAddress()).add("Name", (Object)this.name()).add("NetworkSettings", (Object)this.networkSettings()).add("SerialNumber", (Object)this.serialNumber()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ConnectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
            case "DeviceSettingsSyncState": {
                return Optional.ofNullable(clazz.cast(this.deviceSettingsSyncStateAsString()));
            }
            case "HdDeviceSettings": {
                return Optional.ofNullable(clazz.cast(this.hdDeviceSettings()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NetworkSettings": {
                return Optional.ofNullable(clazz.cast(this.networkSettings()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInputDeviceResponse, T> g) {
        return obj -> g.apply((DescribeInputDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String connectionState;
        private String deviceSettingsSyncState;
        private InputDeviceHdSettings hdDeviceSettings;
        private String id;
        private String macAddress;
        private String name;
        private InputDeviceNetworkSettings networkSettings;
        private String serialNumber;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInputDeviceResponse model) {
            super(model);
            this.arn(model.arn);
            this.connectionState(model.connectionState);
            this.deviceSettingsSyncState(model.deviceSettingsSyncState);
            this.hdDeviceSettings(model.hdDeviceSettings);
            this.id(model.id);
            this.macAddress(model.macAddress);
            this.name(model.name);
            this.networkSettings(model.networkSettings);
            this.serialNumber(model.serialNumber);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getConnectionState() {
            return this.connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(InputDeviceConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        public final String getDeviceSettingsSyncState() {
            return this.deviceSettingsSyncState;
        }

        @Override
        public final Builder deviceSettingsSyncState(String deviceSettingsSyncState) {
            this.deviceSettingsSyncState = deviceSettingsSyncState;
            return this;
        }

        @Override
        public final Builder deviceSettingsSyncState(DeviceSettingsSyncState deviceSettingsSyncState) {
            this.deviceSettingsSyncState(deviceSettingsSyncState == null ? null : deviceSettingsSyncState.toString());
            return this;
        }

        public final void setDeviceSettingsSyncState(String deviceSettingsSyncState) {
            this.deviceSettingsSyncState = deviceSettingsSyncState;
        }

        public final InputDeviceHdSettings.Builder getHdDeviceSettings() {
            return this.hdDeviceSettings != null ? this.hdDeviceSettings.toBuilder() : null;
        }

        @Override
        public final Builder hdDeviceSettings(InputDeviceHdSettings hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings;
            return this;
        }

        public final void setHdDeviceSettings(InputDeviceHdSettings.BuilderImpl hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings != null ? hdDeviceSettings.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final InputDeviceNetworkSettings.Builder getNetworkSettings() {
            return this.networkSettings != null ? this.networkSettings.toBuilder() : null;
        }

        @Override
        public final Builder networkSettings(InputDeviceNetworkSettings networkSettings) {
            this.networkSettings = networkSettings;
            return this;
        }

        public final void setNetworkSettings(InputDeviceNetworkSettings.BuilderImpl networkSettings) {
            this.networkSettings = networkSettings != null ? networkSettings.build() : null;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputDeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public DescribeInputDeviceResponse build() {
            return new DescribeInputDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInputDeviceResponse> {
        public Builder arn(String var1);

        public Builder connectionState(String var1);

        public Builder connectionState(InputDeviceConnectionState var1);

        public Builder deviceSettingsSyncState(String var1);

        public Builder deviceSettingsSyncState(DeviceSettingsSyncState var1);

        public Builder hdDeviceSettings(InputDeviceHdSettings var1);

        default public Builder hdDeviceSettings(Consumer<InputDeviceHdSettings.Builder> hdDeviceSettings) {
            return this.hdDeviceSettings((InputDeviceHdSettings)((InputDeviceHdSettings.Builder)InputDeviceHdSettings.builder().applyMutation(hdDeviceSettings)).build());
        }

        public Builder id(String var1);

        public Builder macAddress(String var1);

        public Builder name(String var1);

        public Builder networkSettings(InputDeviceNetworkSettings var1);

        default public Builder networkSettings(Consumer<InputDeviceNetworkSettings.Builder> networkSettings) {
            return this.networkSettings((InputDeviceNetworkSettings)((InputDeviceNetworkSettings.Builder)InputDeviceNetworkSettings.builder().applyMutation(networkSettings)).build());
        }

        public Builder serialNumber(String var1);

        public Builder type(String var1);

        public Builder type(InputDeviceType var1);
    }
}

