/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.InputWhitelistRuleCidr;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputWhitelistRuleCidrCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInputSecurityGroupRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateInputSecurityGroupRequest> {
    private static final SdkField<String> INPUT_SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputSecurityGroupId").getter(UpdateInputSecurityGroupRequest.getter(UpdateInputSecurityGroupRequest::inputSecurityGroupId)).setter(UpdateInputSecurityGroupRequest.setter(Builder::inputSecurityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputSecurityGroupId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateInputSecurityGroupRequest.getter(UpdateInputSecurityGroupRequest::tags)).setter(UpdateInputSecurityGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<InputWhitelistRuleCidr>> WHITELIST_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WhitelistRules").getter(UpdateInputSecurityGroupRequest.getter(UpdateInputSecurityGroupRequest::whitelistRules)).setter(UpdateInputSecurityGroupRequest.setter(Builder::whitelistRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputWhitelistRuleCidr::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SECURITY_GROUP_ID_FIELD, TAGS_FIELD, WHITELIST_RULES_FIELD));
    private final String inputSecurityGroupId;
    private final Map<String, String> tags;
    private final List<InputWhitelistRuleCidr> whitelistRules;

    private UpdateInputSecurityGroupRequest(BuilderImpl builder) {
        super(builder);
        this.inputSecurityGroupId = builder.inputSecurityGroupId;
        this.tags = builder.tags;
        this.whitelistRules = builder.whitelistRules;
    }

    public String inputSecurityGroupId() {
        return this.inputSecurityGroupId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public boolean hasWhitelistRules() {
        return this.whitelistRules != null && !(this.whitelistRules instanceof SdkAutoConstructList);
    }

    public List<InputWhitelistRuleCidr> whitelistRules() {
        return this.whitelistRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.whitelistRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInputSecurityGroupRequest)) {
            return false;
        }
        UpdateInputSecurityGroupRequest other = (UpdateInputSecurityGroupRequest)((Object)obj);
        return Objects.equals(this.inputSecurityGroupId(), other.inputSecurityGroupId()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.whitelistRules(), other.whitelistRules());
    }

    public String toString() {
        return ToString.builder((String)"UpdateInputSecurityGroupRequest").add("InputSecurityGroupId", (Object)this.inputSecurityGroupId()).add("Tags", this.tags()).add("WhitelistRules", this.whitelistRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputSecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.inputSecurityGroupId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "WhitelistRules": {
                return Optional.ofNullable(clazz.cast(this.whitelistRules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInputSecurityGroupRequest, T> g) {
        return obj -> g.apply((UpdateInputSecurityGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String inputSecurityGroupId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<InputWhitelistRuleCidr> whitelistRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInputSecurityGroupRequest model) {
            super(model);
            this.inputSecurityGroupId(model.inputSecurityGroupId);
            this.tags(model.tags);
            this.whitelistRules(model.whitelistRules);
        }

        public final String getInputSecurityGroupId() {
            return this.inputSecurityGroupId;
        }

        @Override
        public final Builder inputSecurityGroupId(String inputSecurityGroupId) {
            this.inputSecurityGroupId = inputSecurityGroupId;
            return this;
        }

        public final void setInputSecurityGroupId(String inputSecurityGroupId) {
            this.inputSecurityGroupId = inputSecurityGroupId;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Collection<InputWhitelistRuleCidr.Builder> getWhitelistRules() {
            return this.whitelistRules != null ? (Collection)this.whitelistRules.stream().map(InputWhitelistRuleCidr::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder whitelistRules(Collection<InputWhitelistRuleCidr> whitelistRules) {
            this.whitelistRules = ___listOfInputWhitelistRuleCidrCopier.copy(whitelistRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whitelistRules(InputWhitelistRuleCidr ... whitelistRules) {
            this.whitelistRules(Arrays.asList(whitelistRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whitelistRules(Consumer<InputWhitelistRuleCidr.Builder> ... whitelistRules) {
            this.whitelistRules(Stream.of(whitelistRules).map(c -> (InputWhitelistRuleCidr)((InputWhitelistRuleCidr.Builder)InputWhitelistRuleCidr.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWhitelistRules(Collection<InputWhitelistRuleCidr.BuilderImpl> whitelistRules) {
            this.whitelistRules = ___listOfInputWhitelistRuleCidrCopier.copyFromBuilder(whitelistRules);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInputSecurityGroupRequest build() {
            return new UpdateInputSecurityGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInputSecurityGroupRequest> {
        public Builder inputSecurityGroupId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder whitelistRules(Collection<InputWhitelistRuleCidr> var1);

        public Builder whitelistRules(InputWhitelistRuleCidr ... var1);

        public Builder whitelistRules(Consumer<InputWhitelistRuleCidr.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

