/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchStartRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, BatchStartRequest> {
    private static final SdkField<List<String>> CHANNEL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchStartRequest.getter(BatchStartRequest::channelIds)).setter(BatchStartRequest.setter(Builder::channelIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MULTIPLEX_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchStartRequest.getter(BatchStartRequest::multiplexIds)).setter(BatchStartRequest.setter(Builder::multiplexIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_IDS_FIELD, MULTIPLEX_IDS_FIELD));
    private final List<String> channelIds;
    private final List<String> multiplexIds;

    private BatchStartRequest(BuilderImpl builder) {
        super(builder);
        this.channelIds = builder.channelIds;
        this.multiplexIds = builder.multiplexIds;
    }

    public boolean hasChannelIds() {
        return this.channelIds != null && !(this.channelIds instanceof SdkAutoConstructList);
    }

    public List<String> channelIds() {
        return this.channelIds;
    }

    public boolean hasMultiplexIds() {
        return this.multiplexIds != null && !(this.multiplexIds instanceof SdkAutoConstructList);
    }

    public List<String> multiplexIds() {
        return this.multiplexIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStartRequest)) {
            return false;
        }
        BatchStartRequest other = (BatchStartRequest)((Object)obj);
        return Objects.equals(this.channelIds(), other.channelIds()) && Objects.equals(this.multiplexIds(), other.multiplexIds());
    }

    public String toString() {
        return ToString.builder((String)"BatchStartRequest").add("ChannelIds", this.channelIds()).add("MultiplexIds", this.multiplexIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelIds": {
                return Optional.ofNullable(clazz.cast(this.channelIds()));
            }
            case "MultiplexIds": {
                return Optional.ofNullable(clazz.cast(this.multiplexIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStartRequest, T> g) {
        return obj -> g.apply((BatchStartRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<String> channelIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> multiplexIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStartRequest model) {
            super(model);
            this.channelIds(model.channelIds);
            this.multiplexIds(model.multiplexIds);
        }

        public final Collection<String> getChannelIds() {
            return this.channelIds;
        }

        @Override
        public final Builder channelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelIds(String ... channelIds) {
            this.channelIds(Arrays.asList(channelIds));
            return this;
        }

        public final void setChannelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
        }

        public final Collection<String> getMultiplexIds() {
            return this.multiplexIds;
        }

        @Override
        public final Builder multiplexIds(Collection<String> multiplexIds) {
            this.multiplexIds = ___listOf__stringCopier.copy(multiplexIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexIds(String ... multiplexIds) {
            this.multiplexIds(Arrays.asList(multiplexIds));
            return this;
        }

        public final void setMultiplexIds(Collection<String> multiplexIds) {
            this.multiplexIds = ___listOf__stringCopier.copy(multiplexIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchStartRequest build() {
            return new BatchStartRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchStartRequest> {
        public Builder channelIds(Collection<String> var1);

        public Builder channelIds(String ... var1);

        public Builder multiplexIds(Collection<String> var1);

        public Builder multiplexIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

