/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseOfferingRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, PurchaseOfferingRequest> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PurchaseOfferingRequest.getter(PurchaseOfferingRequest::count)).setter(PurchaseOfferingRequest.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PurchaseOfferingRequest.getter(PurchaseOfferingRequest::name)).setter(PurchaseOfferingRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PurchaseOfferingRequest.getter(PurchaseOfferingRequest::offeringId)).setter(PurchaseOfferingRequest.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("offeringId").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PurchaseOfferingRequest.getter(PurchaseOfferingRequest::requestId)).setter(PurchaseOfferingRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PurchaseOfferingRequest.getter(PurchaseOfferingRequest::start)).setter(PurchaseOfferingRequest.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(PurchaseOfferingRequest.getter(PurchaseOfferingRequest::tags)).setter(PurchaseOfferingRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, NAME_FIELD, OFFERING_ID_FIELD, REQUEST_ID_FIELD, START_FIELD, TAGS_FIELD));
    private final Integer count;
    private final String name;
    private final String offeringId;
    private final String requestId;
    private final String start;
    private final Map<String, String> tags;

    private PurchaseOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.count = builder.count;
        this.name = builder.name;
        this.offeringId = builder.offeringId;
        this.requestId = builder.requestId;
        this.start = builder.start;
        this.tags = builder.tags;
    }

    public Integer count() {
        return this.count;
    }

    public String name() {
        return this.name;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public String requestId() {
        return this.requestId;
    }

    public String start() {
        return this.start;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseOfferingRequest)) {
            return false;
        }
        PurchaseOfferingRequest other = (PurchaseOfferingRequest)((Object)obj);
        return Objects.equals(this.count(), other.count()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"PurchaseOfferingRequest").add("Count", (Object)this.count()).add("Name", (Object)this.name()).add("OfferingId", (Object)this.offeringId()).add("RequestId", (Object)this.requestId()).add("Start", (Object)this.start()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OfferingId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseOfferingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private Integer count;
        private String name;
        private String offeringId;
        private String requestId;
        private String start;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseOfferingRequest model) {
            super(model);
            this.count(model.count);
            this.name(model.name);
            this.offeringId(model.offeringId);
            this.requestId(model.requestId);
            this.start(model.start);
            this.tags(model.tags);
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getStart() {
            return this.start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseOfferingRequest build() {
            return new PurchaseOfferingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseOfferingRequest> {
        public Builder count(Integer var1);

        public Builder name(String var1);

        public Builder offeringId(String var1);

        public Builder requestId(String var1);

        public Builder start(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

