/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.AudioTrack;
import software.amazon.awssdk.services.medialive.model.___listOfAudioTrackCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioTrackSelection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioTrackSelection> {
    private static final SdkField<List<AudioTrack>> TRACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AudioTrackSelection.getter(AudioTrackSelection::tracks)).setter(AudioTrackSelection.setter(Builder::tracks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioTrack::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AudioTrack> tracks;

    private AudioTrackSelection(BuilderImpl builder) {
        this.tracks = builder.tracks;
    }

    public boolean hasTracks() {
        return this.tracks != null && !(this.tracks instanceof SdkAutoConstructList);
    }

    public List<AudioTrack> tracks() {
        return this.tracks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tracks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioTrackSelection)) {
            return false;
        }
        AudioTrackSelection other = (AudioTrackSelection)obj;
        return Objects.equals(this.tracks(), other.tracks());
    }

    public String toString() {
        return ToString.builder((String)"AudioTrackSelection").add("Tracks", this.tracks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tracks": {
                return Optional.ofNullable(clazz.cast(this.tracks()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioTrackSelection, T> g) {
        return obj -> g.apply((AudioTrackSelection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioTrack> tracks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudioTrackSelection model) {
            this.tracks(model.tracks);
        }

        public final Collection<AudioTrack.Builder> getTracks() {
            return this.tracks != null ? (Collection)this.tracks.stream().map(AudioTrack::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tracks(Collection<AudioTrack> tracks) {
            this.tracks = ___listOfAudioTrackCopier.copy(tracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(AudioTrack ... tracks) {
            this.tracks(Arrays.asList(tracks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(Consumer<AudioTrack.Builder> ... tracks) {
            this.tracks(Stream.of(tracks).map(c -> (AudioTrack)((AudioTrack.Builder)AudioTrack.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTracks(Collection<AudioTrack.BuilderImpl> tracks) {
            this.tracks = ___listOfAudioTrackCopier.copyFromBuilder(tracks);
        }

        public AudioTrackSelection build() {
            return new AudioTrackSelection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioTrackSelection> {
        public Builder tracks(Collection<AudioTrack> var1);

        public Builder tracks(AudioTrack ... var1);

        public Builder tracks(Consumer<AudioTrack.Builder> ... var1);
    }
}

