/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.TemporalFilterPostFilterSharpening;
import software.amazon.awssdk.services.medialive.model.TemporalFilterStrength;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemporalFilterSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemporalFilterSettings> {
    private static final SdkField<String> POST_FILTER_SHARPENING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TemporalFilterSettings.getter(TemporalFilterSettings::postFilterSharpeningAsString)).setter(TemporalFilterSettings.setter(Builder::postFilterSharpening)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postFilterSharpening").build()}).build();
    private static final SdkField<String> STRENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TemporalFilterSettings.getter(TemporalFilterSettings::strengthAsString)).setter(TemporalFilterSettings.setter(Builder::strength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POST_FILTER_SHARPENING_FIELD, STRENGTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String postFilterSharpening;
    private final String strength;

    private TemporalFilterSettings(BuilderImpl builder) {
        this.postFilterSharpening = builder.postFilterSharpening;
        this.strength = builder.strength;
    }

    public TemporalFilterPostFilterSharpening postFilterSharpening() {
        return TemporalFilterPostFilterSharpening.fromValue(this.postFilterSharpening);
    }

    public String postFilterSharpeningAsString() {
        return this.postFilterSharpening;
    }

    public TemporalFilterStrength strength() {
        return TemporalFilterStrength.fromValue(this.strength);
    }

    public String strengthAsString() {
        return this.strength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.postFilterSharpeningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.strengthAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemporalFilterSettings)) {
            return false;
        }
        TemporalFilterSettings other = (TemporalFilterSettings)obj;
        return Objects.equals(this.postFilterSharpeningAsString(), other.postFilterSharpeningAsString()) && Objects.equals(this.strengthAsString(), other.strengthAsString());
    }

    public String toString() {
        return ToString.builder((String)"TemporalFilterSettings").add("PostFilterSharpening", (Object)this.postFilterSharpeningAsString()).add("Strength", (Object)this.strengthAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PostFilterSharpening": {
                return Optional.ofNullable(clazz.cast(this.postFilterSharpeningAsString()));
            }
            case "Strength": {
                return Optional.ofNullable(clazz.cast(this.strengthAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemporalFilterSettings, T> g) {
        return obj -> g.apply((TemporalFilterSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String postFilterSharpening;
        private String strength;

        private BuilderImpl() {
        }

        private BuilderImpl(TemporalFilterSettings model) {
            this.postFilterSharpening(model.postFilterSharpening);
            this.strength(model.strength);
        }

        public final String getPostFilterSharpening() {
            return this.postFilterSharpening;
        }

        @Override
        public final Builder postFilterSharpening(String postFilterSharpening) {
            this.postFilterSharpening = postFilterSharpening;
            return this;
        }

        @Override
        public final Builder postFilterSharpening(TemporalFilterPostFilterSharpening postFilterSharpening) {
            this.postFilterSharpening(postFilterSharpening == null ? null : postFilterSharpening.toString());
            return this;
        }

        public final void setPostFilterSharpening(String postFilterSharpening) {
            this.postFilterSharpening = postFilterSharpening;
        }

        public final String getStrength() {
            return this.strength;
        }

        @Override
        public final Builder strength(String strength) {
            this.strength = strength;
            return this;
        }

        @Override
        public final Builder strength(TemporalFilterStrength strength) {
            this.strength(strength == null ? null : strength.toString());
            return this;
        }

        public final void setStrength(String strength) {
            this.strength = strength;
        }

        public TemporalFilterSettings build() {
            return new TemporalFilterSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemporalFilterSettings> {
        public Builder postFilterSharpening(String var1);

        public Builder postFilterSharpening(TemporalFilterPostFilterSharpening var1);

        public Builder strength(String var1);

        public Builder strength(TemporalFilterStrength var1);
    }
}

