/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiplexProgramChannelDestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiplexProgramChannelDestinationSettings> {
    private static final SdkField<String> MULTIPLEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MultiplexProgramChannelDestinationSettings.getter(MultiplexProgramChannelDestinationSettings::multiplexId)).setter(MultiplexProgramChannelDestinationSettings.setter(Builder::multiplexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexId").build()}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MultiplexProgramChannelDestinationSettings.getter(MultiplexProgramChannelDestinationSettings::programName)).setter(MultiplexProgramChannelDestinationSettings.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_ID_FIELD, PROGRAM_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String multiplexId;
    private final String programName;

    private MultiplexProgramChannelDestinationSettings(BuilderImpl builder) {
        this.multiplexId = builder.multiplexId;
        this.programName = builder.programName;
    }

    public String multiplexId() {
        return this.multiplexId;
    }

    public String programName() {
        return this.programName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexProgramChannelDestinationSettings)) {
            return false;
        }
        MultiplexProgramChannelDestinationSettings other = (MultiplexProgramChannelDestinationSettings)obj;
        return Objects.equals(this.multiplexId(), other.multiplexId()) && Objects.equals(this.programName(), other.programName());
    }

    public String toString() {
        return ToString.builder((String)"MultiplexProgramChannelDestinationSettings").add("MultiplexId", (Object)this.multiplexId()).add("ProgramName", (Object)this.programName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiplexId": {
                return Optional.ofNullable(clazz.cast(this.multiplexId()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexProgramChannelDestinationSettings, T> g) {
        return obj -> g.apply((MultiplexProgramChannelDestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String multiplexId;
        private String programName;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexProgramChannelDestinationSettings model) {
            this.multiplexId(model.multiplexId);
            this.programName(model.programName);
        }

        public final String getMultiplexId() {
            return this.multiplexId;
        }

        @Override
        public final Builder multiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        public final void setMultiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
        }

        public final String getProgramName() {
            return this.programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        public MultiplexProgramChannelDestinationSettings build() {
            return new MultiplexProgramChannelDestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiplexProgramChannelDestinationSettings> {
        public Builder multiplexId(String var1);

        public Builder programName(String var1);
    }
}

