/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Ttml Destination Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class TtmlDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TtmlDestinationSettings.Builder, TtmlDestinationSettings> {
    private static final SdkField<String> STYLE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TtmlDestinationSettings::styleControlAsString)).setter(setter(Builder::styleControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("styleControl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_CONTROL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String styleControl;

    private TtmlDestinationSettings(BuilderImpl builder) {
        this.styleControl = builder.styleControl;
    }

    /**
     * When set to passthrough, passes through style and position information from a TTML-like input source (TTML,
     * SMPTE-TT, CFF-TT) to the CFF-TT output or TTML output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #styleControl} will
     * return {@link TtmlDestinationStyleControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #styleControlAsString}.
     * </p>
     * 
     * @return When set to passthrough, passes through style and position information from a TTML-like input source
     *         (TTML, SMPTE-TT, CFF-TT) to the CFF-TT output or TTML output.
     * @see TtmlDestinationStyleControl
     */
    public TtmlDestinationStyleControl styleControl() {
        return TtmlDestinationStyleControl.fromValue(styleControl);
    }

    /**
     * When set to passthrough, passes through style and position information from a TTML-like input source (TTML,
     * SMPTE-TT, CFF-TT) to the CFF-TT output or TTML output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #styleControl} will
     * return {@link TtmlDestinationStyleControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #styleControlAsString}.
     * </p>
     * 
     * @return When set to passthrough, passes through style and position information from a TTML-like input source
     *         (TTML, SMPTE-TT, CFF-TT) to the CFF-TT output or TTML output.
     * @see TtmlDestinationStyleControl
     */
    public String styleControlAsString() {
        return styleControl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(styleControlAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TtmlDestinationSettings)) {
            return false;
        }
        TtmlDestinationSettings other = (TtmlDestinationSettings) obj;
        return Objects.equals(styleControlAsString(), other.styleControlAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TtmlDestinationSettings").add("StyleControl", styleControlAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StyleControl":
            return Optional.ofNullable(clazz.cast(styleControlAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TtmlDestinationSettings, T> g) {
        return obj -> g.apply((TtmlDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TtmlDestinationSettings> {
        /**
         * When set to passthrough, passes through style and position information from a TTML-like input source (TTML,
         * SMPTE-TT, CFF-TT) to the CFF-TT output or TTML output.
         * 
         * @param styleControl
         *        When set to passthrough, passes through style and position information from a TTML-like input source
         *        (TTML, SMPTE-TT, CFF-TT) to the CFF-TT output or TTML output.
         * @see TtmlDestinationStyleControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TtmlDestinationStyleControl
         */
        Builder styleControl(String styleControl);

        /**
         * When set to passthrough, passes through style and position information from a TTML-like input source (TTML,
         * SMPTE-TT, CFF-TT) to the CFF-TT output or TTML output.
         * 
         * @param styleControl
         *        When set to passthrough, passes through style and position information from a TTML-like input source
         *        (TTML, SMPTE-TT, CFF-TT) to the CFF-TT output or TTML output.
         * @see TtmlDestinationStyleControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TtmlDestinationStyleControl
         */
        Builder styleControl(TtmlDestinationStyleControl styleControl);
    }

    static final class BuilderImpl implements Builder {
        private String styleControl;

        private BuilderImpl() {
        }

        private BuilderImpl(TtmlDestinationSettings model) {
            styleControl(model.styleControl);
        }

        public final String getStyleControl() {
            return styleControl;
        }

        @Override
        public final Builder styleControl(String styleControl) {
            this.styleControl = styleControl;
            return this;
        }

        @Override
        public final Builder styleControl(TtmlDestinationStyleControl styleControl) {
            this.styleControl(styleControl == null ? null : styleControl.toString());
            return this;
        }

        public final void setStyleControl(String styleControl) {
            this.styleControl = styleControl;
        }

        @Override
        public TtmlDestinationSettings build() {
            return new TtmlDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
