/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for a SCTE-35 splice_insert message.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scte35SpliceInsertScheduleActionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<Scte35SpliceInsertScheduleActionSettings.Builder, Scte35SpliceInsertScheduleActionSettings> {
    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Scte35SpliceInsertScheduleActionSettings::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<Long> SPLICE_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Scte35SpliceInsertScheduleActionSettings::spliceEventId)).setter(setter(Builder::spliceEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spliceEventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD,
            SPLICE_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long duration;

    private final Long spliceEventId;

    private Scte35SpliceInsertScheduleActionSettings(BuilderImpl builder) {
        this.duration = builder.duration;
        this.spliceEventId = builder.spliceEventId;
    }

    /**
     * Optional, the duration for the splice_insert, in 90 KHz ticks. To convert seconds to ticks, multiple the seconds
     * by 90,000. If you enter a duration, there is an expectation that the downstream system can read the duration and
     * cue in at that time. If you do not enter a duration, the splice_insert will continue indefinitely and there is an
     * expectation that you will enter a return_to_network to end the splice_insert at the appropriate time.
     * 
     * @return Optional, the duration for the splice_insert, in 90 KHz ticks. To convert seconds to ticks, multiple the
     *         seconds by 90,000. If you enter a duration, there is an expectation that the downstream system can read
     *         the duration and cue in at that time. If you do not enter a duration, the splice_insert will continue
     *         indefinitely and there is an expectation that you will enter a return_to_network to end the splice_insert
     *         at the appropriate time.
     */
    public Long duration() {
        return duration;
    }

    /**
     * The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
     * 
     * @return The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
     */
    public Long spliceEventId() {
        return spliceEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(spliceEventId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte35SpliceInsertScheduleActionSettings)) {
            return false;
        }
        Scte35SpliceInsertScheduleActionSettings other = (Scte35SpliceInsertScheduleActionSettings) obj;
        return Objects.equals(duration(), other.duration()) && Objects.equals(spliceEventId(), other.spliceEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Scte35SpliceInsertScheduleActionSettings").add("Duration", duration())
                .add("SpliceEventId", spliceEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "SpliceEventId":
            return Optional.ofNullable(clazz.cast(spliceEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scte35SpliceInsertScheduleActionSettings, T> g) {
        return obj -> g.apply((Scte35SpliceInsertScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scte35SpliceInsertScheduleActionSettings> {
        /**
         * Optional, the duration for the splice_insert, in 90 KHz ticks. To convert seconds to ticks, multiple the
         * seconds by 90,000. If you enter a duration, there is an expectation that the downstream system can read the
         * duration and cue in at that time. If you do not enter a duration, the splice_insert will continue
         * indefinitely and there is an expectation that you will enter a return_to_network to end the splice_insert at
         * the appropriate time.
         * 
         * @param duration
         *        Optional, the duration for the splice_insert, in 90 KHz ticks. To convert seconds to ticks, multiple
         *        the seconds by 90,000. If you enter a duration, there is an expectation that the downstream system can
         *        read the duration and cue in at that time. If you do not enter a duration, the splice_insert will
         *        continue indefinitely and there is an expectation that you will enter a return_to_network to end the
         *        splice_insert at the appropriate time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
         * 
         * @param spliceEventId
         *        The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spliceEventId(Long spliceEventId);
    }

    static final class BuilderImpl implements Builder {
        private Long duration;

        private Long spliceEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(Scte35SpliceInsertScheduleActionSettings model) {
            duration(model.duration);
            spliceEventId(model.spliceEventId);
        }

        public final Long getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Long getSpliceEventId() {
            return spliceEventId;
        }

        @Override
        public final Builder spliceEventId(Long spliceEventId) {
            this.spliceEventId = spliceEventId;
            return this;
        }

        public final void setSpliceEventId(Long spliceEventId) {
            this.spliceEventId = spliceEventId;
        }

        @Override
        public Scte35SpliceInsertScheduleActionSettings build() {
            return new Scte35SpliceInsertScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
