/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Corresponds to SCTE-35 segmentation_descriptor.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scte35SegmentationDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<Scte35SegmentationDescriptor.Builder, Scte35SegmentationDescriptor> {
    private static final SdkField<Scte35DeliveryRestrictions> DELIVERY_RESTRICTIONS_FIELD = SdkField
            .<Scte35DeliveryRestrictions> builder(MarshallingType.SDK_POJO)
            .getter(getter(Scte35SegmentationDescriptor::deliveryRestrictions)).setter(setter(Builder::deliveryRestrictions))
            .constructor(Scte35DeliveryRestrictions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryRestrictions").build())
            .build();

    private static final SdkField<Integer> SEGMENT_NUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Scte35SegmentationDescriptor::segmentNum)).setter(setter(Builder::segmentNum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentNum").build()).build();

    private static final SdkField<String> SEGMENTATION_CANCEL_INDICATOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Scte35SegmentationDescriptor::segmentationCancelIndicatorAsString))
            .setter(setter(Builder::segmentationCancelIndicator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationCancelIndicator")
                    .build()).build();

    private static final SdkField<Long> SEGMENTATION_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Scte35SegmentationDescriptor::segmentationDuration)).setter(setter(Builder::segmentationDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationDuration").build())
            .build();

    private static final SdkField<Long> SEGMENTATION_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Scte35SegmentationDescriptor::segmentationEventId)).setter(setter(Builder::segmentationEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationEventId").build())
            .build();

    private static final SdkField<Integer> SEGMENTATION_TYPE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Scte35SegmentationDescriptor::segmentationTypeId)).setter(setter(Builder::segmentationTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationTypeId").build())
            .build();

    private static final SdkField<String> SEGMENTATION_UPID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Scte35SegmentationDescriptor::segmentationUpid)).setter(setter(Builder::segmentationUpid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationUpid").build()).build();

    private static final SdkField<Integer> SEGMENTATION_UPID_TYPE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Scte35SegmentationDescriptor::segmentationUpidType)).setter(setter(Builder::segmentationUpidType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationUpidType").build())
            .build();

    private static final SdkField<Integer> SEGMENTS_EXPECTED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Scte35SegmentationDescriptor::segmentsExpected)).setter(setter(Builder::segmentsExpected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentsExpected").build()).build();

    private static final SdkField<Integer> SUB_SEGMENT_NUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Scte35SegmentationDescriptor::subSegmentNum)).setter(setter(Builder::subSegmentNum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subSegmentNum").build()).build();

    private static final SdkField<Integer> SUB_SEGMENTS_EXPECTED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Scte35SegmentationDescriptor::subSegmentsExpected)).setter(setter(Builder::subSegmentsExpected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subSegmentsExpected").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_RESTRICTIONS_FIELD,
            SEGMENT_NUM_FIELD, SEGMENTATION_CANCEL_INDICATOR_FIELD, SEGMENTATION_DURATION_FIELD, SEGMENTATION_EVENT_ID_FIELD,
            SEGMENTATION_TYPE_ID_FIELD, SEGMENTATION_UPID_FIELD, SEGMENTATION_UPID_TYPE_FIELD, SEGMENTS_EXPECTED_FIELD,
            SUB_SEGMENT_NUM_FIELD, SUB_SEGMENTS_EXPECTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Scte35DeliveryRestrictions deliveryRestrictions;

    private final Integer segmentNum;

    private final String segmentationCancelIndicator;

    private final Long segmentationDuration;

    private final Long segmentationEventId;

    private final Integer segmentationTypeId;

    private final String segmentationUpid;

    private final Integer segmentationUpidType;

    private final Integer segmentsExpected;

    private final Integer subSegmentNum;

    private final Integer subSegmentsExpected;

    private Scte35SegmentationDescriptor(BuilderImpl builder) {
        this.deliveryRestrictions = builder.deliveryRestrictions;
        this.segmentNum = builder.segmentNum;
        this.segmentationCancelIndicator = builder.segmentationCancelIndicator;
        this.segmentationDuration = builder.segmentationDuration;
        this.segmentationEventId = builder.segmentationEventId;
        this.segmentationTypeId = builder.segmentationTypeId;
        this.segmentationUpid = builder.segmentationUpid;
        this.segmentationUpidType = builder.segmentationUpidType;
        this.segmentsExpected = builder.segmentsExpected;
        this.subSegmentNum = builder.subSegmentNum;
        this.subSegmentsExpected = builder.subSegmentsExpected;
    }

    /**
     * Holds the four SCTE-35 delivery restriction parameters.
     * 
     * @return Holds the four SCTE-35 delivery restriction parameters.
     */
    public Scte35DeliveryRestrictions deliveryRestrictions() {
        return deliveryRestrictions;
    }

    /**
     * Corresponds to SCTE-35 segment_num. A value that is valid for the specified segmentation_type_id.
     * 
     * @return Corresponds to SCTE-35 segment_num. A value that is valid for the specified segmentation_type_id.
     */
    public Integer segmentNum() {
        return segmentNum;
    }

    /**
     * Corresponds to SCTE-35 segmentation_event_cancel_indicator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentationCancelIndicator} will return {@link Scte35SegmentationCancelIndicator#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #segmentationCancelIndicatorAsString}.
     * </p>
     * 
     * @return Corresponds to SCTE-35 segmentation_event_cancel_indicator.
     * @see Scte35SegmentationCancelIndicator
     */
    public Scte35SegmentationCancelIndicator segmentationCancelIndicator() {
        return Scte35SegmentationCancelIndicator.fromValue(segmentationCancelIndicator);
    }

    /**
     * Corresponds to SCTE-35 segmentation_event_cancel_indicator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentationCancelIndicator} will return {@link Scte35SegmentationCancelIndicator#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #segmentationCancelIndicatorAsString}.
     * </p>
     * 
     * @return Corresponds to SCTE-35 segmentation_event_cancel_indicator.
     * @see Scte35SegmentationCancelIndicator
     */
    public String segmentationCancelIndicatorAsString() {
        return segmentationCancelIndicator;
    }

    /**
     * Corresponds to SCTE-35 segmentation_duration. Optional. The duration for the time_signal, in 90 KHz ticks. To
     * convert seconds to ticks, multiple the seconds by 90,000. Enter time in 90 KHz clock ticks. If you do not enter a
     * duration, the time_signal will continue until you insert a cancellation message.
     * 
     * @return Corresponds to SCTE-35 segmentation_duration. Optional. The duration for the time_signal, in 90 KHz
     *         ticks. To convert seconds to ticks, multiple the seconds by 90,000. Enter time in 90 KHz clock ticks. If
     *         you do not enter a duration, the time_signal will continue until you insert a cancellation message.
     */
    public Long segmentationDuration() {
        return segmentationDuration;
    }

    /**
     * Corresponds to SCTE-35 segmentation_event_id.
     * 
     * @return Corresponds to SCTE-35 segmentation_event_id.
     */
    public Long segmentationEventId() {
        return segmentationEventId;
    }

    /**
     * Corresponds to SCTE-35 segmentation_type_id. One of the segmentation_type_id values listed in the SCTE-35
     * specification. On the console, enter the ID in decimal (for example, "52"). In the CLI, API, or an SDK, enter the
     * ID in hex (for example, "0x34") or decimal (for example, "52").
     * 
     * @return Corresponds to SCTE-35 segmentation_type_id. One of the segmentation_type_id values listed in the SCTE-35
     *         specification. On the console, enter the ID in decimal (for example, "52"). In the CLI, API, or an SDK,
     *         enter the ID in hex (for example, "0x34") or decimal (for example, "52").
     */
    public Integer segmentationTypeId() {
        return segmentationTypeId;
    }

    /**
     * Corresponds to SCTE-35 segmentation_upid. Enter a string containing the hexadecimal representation of the
     * characters that make up the SCTE-35 segmentation_upid value. Must contain an even number of hex characters. Do
     * not include spaces between each hex pair. For example, the ASCII "ADS Information" becomes hex
     * "41445320496e666f726d6174696f6e.
     * 
     * @return Corresponds to SCTE-35 segmentation_upid. Enter a string containing the hexadecimal representation of the
     *         characters that make up the SCTE-35 segmentation_upid value. Must contain an even number of hex
     *         characters. Do not include spaces between each hex pair. For example, the ASCII "ADS Information" becomes
     *         hex "41445320496e666f726d6174696f6e.
     */
    public String segmentationUpid() {
        return segmentationUpid;
    }

    /**
     * Corresponds to SCTE-35 segmentation_upid_type. On the console, enter one of the types listed in the SCTE-35
     * specification, converted to a decimal. For example, "0x0C" hex from the specification is "12" in decimal. In the
     * CLI, API, or an SDK, enter one of the types listed in the SCTE-35 specification, in either hex (for example,
     * "0x0C" ) or in decimal (for example, "12").
     * 
     * @return Corresponds to SCTE-35 segmentation_upid_type. On the console, enter one of the types listed in the
     *         SCTE-35 specification, converted to a decimal. For example, "0x0C" hex from the specification is "12" in
     *         decimal. In the CLI, API, or an SDK, enter one of the types listed in the SCTE-35 specification, in
     *         either hex (for example, "0x0C" ) or in decimal (for example, "12").
     */
    public Integer segmentationUpidType() {
        return segmentationUpidType;
    }

    /**
     * Corresponds to SCTE-35 segments_expected. A value that is valid for the specified segmentation_type_id.
     * 
     * @return Corresponds to SCTE-35 segments_expected. A value that is valid for the specified segmentation_type_id.
     */
    public Integer segmentsExpected() {
        return segmentsExpected;
    }

    /**
     * Corresponds to SCTE-35 sub_segment_num. A value that is valid for the specified segmentation_type_id.
     * 
     * @return Corresponds to SCTE-35 sub_segment_num. A value that is valid for the specified segmentation_type_id.
     */
    public Integer subSegmentNum() {
        return subSegmentNum;
    }

    /**
     * Corresponds to SCTE-35 sub_segments_expected. A value that is valid for the specified segmentation_type_id.
     * 
     * @return Corresponds to SCTE-35 sub_segments_expected. A value that is valid for the specified
     *         segmentation_type_id.
     */
    public Integer subSegmentsExpected() {
        return subSegmentsExpected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryRestrictions());
        hashCode = 31 * hashCode + Objects.hashCode(segmentNum());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationCancelIndicatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationDuration());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationEventId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationUpid());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationUpidType());
        hashCode = 31 * hashCode + Objects.hashCode(segmentsExpected());
        hashCode = 31 * hashCode + Objects.hashCode(subSegmentNum());
        hashCode = 31 * hashCode + Objects.hashCode(subSegmentsExpected());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte35SegmentationDescriptor)) {
            return false;
        }
        Scte35SegmentationDescriptor other = (Scte35SegmentationDescriptor) obj;
        return Objects.equals(deliveryRestrictions(), other.deliveryRestrictions())
                && Objects.equals(segmentNum(), other.segmentNum())
                && Objects.equals(segmentationCancelIndicatorAsString(), other.segmentationCancelIndicatorAsString())
                && Objects.equals(segmentationDuration(), other.segmentationDuration())
                && Objects.equals(segmentationEventId(), other.segmentationEventId())
                && Objects.equals(segmentationTypeId(), other.segmentationTypeId())
                && Objects.equals(segmentationUpid(), other.segmentationUpid())
                && Objects.equals(segmentationUpidType(), other.segmentationUpidType())
                && Objects.equals(segmentsExpected(), other.segmentsExpected())
                && Objects.equals(subSegmentNum(), other.subSegmentNum())
                && Objects.equals(subSegmentsExpected(), other.subSegmentsExpected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Scte35SegmentationDescriptor").add("DeliveryRestrictions", deliveryRestrictions())
                .add("SegmentNum", segmentNum()).add("SegmentationCancelIndicator", segmentationCancelIndicatorAsString())
                .add("SegmentationDuration", segmentationDuration()).add("SegmentationEventId", segmentationEventId())
                .add("SegmentationTypeId", segmentationTypeId()).add("SegmentationUpid", segmentationUpid())
                .add("SegmentationUpidType", segmentationUpidType()).add("SegmentsExpected", segmentsExpected())
                .add("SubSegmentNum", subSegmentNum()).add("SubSegmentsExpected", subSegmentsExpected()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryRestrictions":
            return Optional.ofNullable(clazz.cast(deliveryRestrictions()));
        case "SegmentNum":
            return Optional.ofNullable(clazz.cast(segmentNum()));
        case "SegmentationCancelIndicator":
            return Optional.ofNullable(clazz.cast(segmentationCancelIndicatorAsString()));
        case "SegmentationDuration":
            return Optional.ofNullable(clazz.cast(segmentationDuration()));
        case "SegmentationEventId":
            return Optional.ofNullable(clazz.cast(segmentationEventId()));
        case "SegmentationTypeId":
            return Optional.ofNullable(clazz.cast(segmentationTypeId()));
        case "SegmentationUpid":
            return Optional.ofNullable(clazz.cast(segmentationUpid()));
        case "SegmentationUpidType":
            return Optional.ofNullable(clazz.cast(segmentationUpidType()));
        case "SegmentsExpected":
            return Optional.ofNullable(clazz.cast(segmentsExpected()));
        case "SubSegmentNum":
            return Optional.ofNullable(clazz.cast(subSegmentNum()));
        case "SubSegmentsExpected":
            return Optional.ofNullable(clazz.cast(subSegmentsExpected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scte35SegmentationDescriptor, T> g) {
        return obj -> g.apply((Scte35SegmentationDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scte35SegmentationDescriptor> {
        /**
         * Holds the four SCTE-35 delivery restriction parameters.
         * 
         * @param deliveryRestrictions
         *        Holds the four SCTE-35 delivery restriction parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryRestrictions(Scte35DeliveryRestrictions deliveryRestrictions);

        /**
         * Holds the four SCTE-35 delivery restriction parameters. This is a convenience that creates an instance of the
         * {@link Scte35DeliveryRestrictions.Builder} avoiding the need to create one manually via
         * {@link Scte35DeliveryRestrictions#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scte35DeliveryRestrictions.Builder#build()} is called immediately
         * and its result is passed to {@link #deliveryRestrictions(Scte35DeliveryRestrictions)}.
         * 
         * @param deliveryRestrictions
         *        a consumer that will call methods on {@link Scte35DeliveryRestrictions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryRestrictions(Scte35DeliveryRestrictions)
         */
        default Builder deliveryRestrictions(Consumer<Scte35DeliveryRestrictions.Builder> deliveryRestrictions) {
            return deliveryRestrictions(Scte35DeliveryRestrictions.builder().applyMutation(deliveryRestrictions).build());
        }

        /**
         * Corresponds to SCTE-35 segment_num. A value that is valid for the specified segmentation_type_id.
         * 
         * @param segmentNum
         *        Corresponds to SCTE-35 segment_num. A value that is valid for the specified segmentation_type_id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentNum(Integer segmentNum);

        /**
         * Corresponds to SCTE-35 segmentation_event_cancel_indicator.
         * 
         * @param segmentationCancelIndicator
         *        Corresponds to SCTE-35 segmentation_event_cancel_indicator.
         * @see Scte35SegmentationCancelIndicator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35SegmentationCancelIndicator
         */
        Builder segmentationCancelIndicator(String segmentationCancelIndicator);

        /**
         * Corresponds to SCTE-35 segmentation_event_cancel_indicator.
         * 
         * @param segmentationCancelIndicator
         *        Corresponds to SCTE-35 segmentation_event_cancel_indicator.
         * @see Scte35SegmentationCancelIndicator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35SegmentationCancelIndicator
         */
        Builder segmentationCancelIndicator(Scte35SegmentationCancelIndicator segmentationCancelIndicator);

        /**
         * Corresponds to SCTE-35 segmentation_duration. Optional. The duration for the time_signal, in 90 KHz ticks. To
         * convert seconds to ticks, multiple the seconds by 90,000. Enter time in 90 KHz clock ticks. If you do not
         * enter a duration, the time_signal will continue until you insert a cancellation message.
         * 
         * @param segmentationDuration
         *        Corresponds to SCTE-35 segmentation_duration. Optional. The duration for the time_signal, in 90 KHz
         *        ticks. To convert seconds to ticks, multiple the seconds by 90,000. Enter time in 90 KHz clock ticks.
         *        If you do not enter a duration, the time_signal will continue until you insert a cancellation message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationDuration(Long segmentationDuration);

        /**
         * Corresponds to SCTE-35 segmentation_event_id.
         * 
         * @param segmentationEventId
         *        Corresponds to SCTE-35 segmentation_event_id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationEventId(Long segmentationEventId);

        /**
         * Corresponds to SCTE-35 segmentation_type_id. One of the segmentation_type_id values listed in the SCTE-35
         * specification. On the console, enter the ID in decimal (for example, "52"). In the CLI, API, or an SDK, enter
         * the ID in hex (for example, "0x34") or decimal (for example, "52").
         * 
         * @param segmentationTypeId
         *        Corresponds to SCTE-35 segmentation_type_id. One of the segmentation_type_id values listed in the
         *        SCTE-35 specification. On the console, enter the ID in decimal (for example, "52"). In the CLI, API,
         *        or an SDK, enter the ID in hex (for example, "0x34") or decimal (for example, "52").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationTypeId(Integer segmentationTypeId);

        /**
         * Corresponds to SCTE-35 segmentation_upid. Enter a string containing the hexadecimal representation of the
         * characters that make up the SCTE-35 segmentation_upid value. Must contain an even number of hex characters.
         * Do not include spaces between each hex pair. For example, the ASCII "ADS Information" becomes hex
         * "41445320496e666f726d6174696f6e.
         * 
         * @param segmentationUpid
         *        Corresponds to SCTE-35 segmentation_upid. Enter a string containing the hexadecimal representation of
         *        the characters that make up the SCTE-35 segmentation_upid value. Must contain an even number of hex
         *        characters. Do not include spaces between each hex pair. For example, the ASCII "ADS Information"
         *        becomes hex "41445320496e666f726d6174696f6e.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationUpid(String segmentationUpid);

        /**
         * Corresponds to SCTE-35 segmentation_upid_type. On the console, enter one of the types listed in the SCTE-35
         * specification, converted to a decimal. For example, "0x0C" hex from the specification is "12" in decimal. In
         * the CLI, API, or an SDK, enter one of the types listed in the SCTE-35 specification, in either hex (for
         * example, "0x0C" ) or in decimal (for example, "12").
         * 
         * @param segmentationUpidType
         *        Corresponds to SCTE-35 segmentation_upid_type. On the console, enter one of the types listed in the
         *        SCTE-35 specification, converted to a decimal. For example, "0x0C" hex from the specification is "12"
         *        in decimal. In the CLI, API, or an SDK, enter one of the types listed in the SCTE-35 specification, in
         *        either hex (for example, "0x0C" ) or in decimal (for example, "12").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationUpidType(Integer segmentationUpidType);

        /**
         * Corresponds to SCTE-35 segments_expected. A value that is valid for the specified segmentation_type_id.
         * 
         * @param segmentsExpected
         *        Corresponds to SCTE-35 segments_expected. A value that is valid for the specified
         *        segmentation_type_id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentsExpected(Integer segmentsExpected);

        /**
         * Corresponds to SCTE-35 sub_segment_num. A value that is valid for the specified segmentation_type_id.
         * 
         * @param subSegmentNum
         *        Corresponds to SCTE-35 sub_segment_num. A value that is valid for the specified segmentation_type_id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subSegmentNum(Integer subSegmentNum);

        /**
         * Corresponds to SCTE-35 sub_segments_expected. A value that is valid for the specified segmentation_type_id.
         * 
         * @param subSegmentsExpected
         *        Corresponds to SCTE-35 sub_segments_expected. A value that is valid for the specified
         *        segmentation_type_id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subSegmentsExpected(Integer subSegmentsExpected);
    }

    static final class BuilderImpl implements Builder {
        private Scte35DeliveryRestrictions deliveryRestrictions;

        private Integer segmentNum;

        private String segmentationCancelIndicator;

        private Long segmentationDuration;

        private Long segmentationEventId;

        private Integer segmentationTypeId;

        private String segmentationUpid;

        private Integer segmentationUpidType;

        private Integer segmentsExpected;

        private Integer subSegmentNum;

        private Integer subSegmentsExpected;

        private BuilderImpl() {
        }

        private BuilderImpl(Scte35SegmentationDescriptor model) {
            deliveryRestrictions(model.deliveryRestrictions);
            segmentNum(model.segmentNum);
            segmentationCancelIndicator(model.segmentationCancelIndicator);
            segmentationDuration(model.segmentationDuration);
            segmentationEventId(model.segmentationEventId);
            segmentationTypeId(model.segmentationTypeId);
            segmentationUpid(model.segmentationUpid);
            segmentationUpidType(model.segmentationUpidType);
            segmentsExpected(model.segmentsExpected);
            subSegmentNum(model.subSegmentNum);
            subSegmentsExpected(model.subSegmentsExpected);
        }

        public final Scte35DeliveryRestrictions.Builder getDeliveryRestrictions() {
            return deliveryRestrictions != null ? deliveryRestrictions.toBuilder() : null;
        }

        @Override
        public final Builder deliveryRestrictions(Scte35DeliveryRestrictions deliveryRestrictions) {
            this.deliveryRestrictions = deliveryRestrictions;
            return this;
        }

        public final void setDeliveryRestrictions(Scte35DeliveryRestrictions.BuilderImpl deliveryRestrictions) {
            this.deliveryRestrictions = deliveryRestrictions != null ? deliveryRestrictions.build() : null;
        }

        public final Integer getSegmentNum() {
            return segmentNum;
        }

        @Override
        public final Builder segmentNum(Integer segmentNum) {
            this.segmentNum = segmentNum;
            return this;
        }

        public final void setSegmentNum(Integer segmentNum) {
            this.segmentNum = segmentNum;
        }

        public final String getSegmentationCancelIndicator() {
            return segmentationCancelIndicator;
        }

        @Override
        public final Builder segmentationCancelIndicator(String segmentationCancelIndicator) {
            this.segmentationCancelIndicator = segmentationCancelIndicator;
            return this;
        }

        @Override
        public final Builder segmentationCancelIndicator(Scte35SegmentationCancelIndicator segmentationCancelIndicator) {
            this.segmentationCancelIndicator(segmentationCancelIndicator == null ? null : segmentationCancelIndicator.toString());
            return this;
        }

        public final void setSegmentationCancelIndicator(String segmentationCancelIndicator) {
            this.segmentationCancelIndicator = segmentationCancelIndicator;
        }

        public final Long getSegmentationDuration() {
            return segmentationDuration;
        }

        @Override
        public final Builder segmentationDuration(Long segmentationDuration) {
            this.segmentationDuration = segmentationDuration;
            return this;
        }

        public final void setSegmentationDuration(Long segmentationDuration) {
            this.segmentationDuration = segmentationDuration;
        }

        public final Long getSegmentationEventId() {
            return segmentationEventId;
        }

        @Override
        public final Builder segmentationEventId(Long segmentationEventId) {
            this.segmentationEventId = segmentationEventId;
            return this;
        }

        public final void setSegmentationEventId(Long segmentationEventId) {
            this.segmentationEventId = segmentationEventId;
        }

        public final Integer getSegmentationTypeId() {
            return segmentationTypeId;
        }

        @Override
        public final Builder segmentationTypeId(Integer segmentationTypeId) {
            this.segmentationTypeId = segmentationTypeId;
            return this;
        }

        public final void setSegmentationTypeId(Integer segmentationTypeId) {
            this.segmentationTypeId = segmentationTypeId;
        }

        public final String getSegmentationUpid() {
            return segmentationUpid;
        }

        @Override
        public final Builder segmentationUpid(String segmentationUpid) {
            this.segmentationUpid = segmentationUpid;
            return this;
        }

        public final void setSegmentationUpid(String segmentationUpid) {
            this.segmentationUpid = segmentationUpid;
        }

        public final Integer getSegmentationUpidType() {
            return segmentationUpidType;
        }

        @Override
        public final Builder segmentationUpidType(Integer segmentationUpidType) {
            this.segmentationUpidType = segmentationUpidType;
            return this;
        }

        public final void setSegmentationUpidType(Integer segmentationUpidType) {
            this.segmentationUpidType = segmentationUpidType;
        }

        public final Integer getSegmentsExpected() {
            return segmentsExpected;
        }

        @Override
        public final Builder segmentsExpected(Integer segmentsExpected) {
            this.segmentsExpected = segmentsExpected;
            return this;
        }

        public final void setSegmentsExpected(Integer segmentsExpected) {
            this.segmentsExpected = segmentsExpected;
        }

        public final Integer getSubSegmentNum() {
            return subSegmentNum;
        }

        @Override
        public final Builder subSegmentNum(Integer subSegmentNum) {
            this.subSegmentNum = subSegmentNum;
            return this;
        }

        public final void setSubSegmentNum(Integer subSegmentNum) {
            this.subSegmentNum = subSegmentNum;
        }

        public final Integer getSubSegmentsExpected() {
            return subSegmentsExpected;
        }

        @Override
        public final Builder subSegmentsExpected(Integer subSegmentsExpected) {
            this.subSegmentsExpected = subSegmentsExpected;
            return this;
        }

        public final void setSubSegmentsExpected(Integer subSegmentsExpected) {
            this.subSegmentsExpected = subSegmentsExpected;
        }

        @Override
        public Scte35SegmentationDescriptor build() {
            return new Scte35SegmentationDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
