/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Scte20 Source Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scte20SourceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<Scte20SourceSettings.Builder, Scte20SourceSettings> {
    private static final SdkField<String> CONVERT608_TO708_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Scte20SourceSettings::convert608To708AsString)).setter(setter(Builder::convert608To708))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convert608To708").build()).build();

    private static final SdkField<Integer> SOURCE608_CHANNEL_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Scte20SourceSettings::source608ChannelNumber)).setter(setter(Builder::source608ChannelNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source608ChannelNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERT608_TO708_FIELD,
            SOURCE608_CHANNEL_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String convert608To708;

    private final Integer source608ChannelNumber;

    private Scte20SourceSettings(BuilderImpl builder) {
        this.convert608To708 = builder.convert608To708;
        this.source608ChannelNumber = builder.source608ChannelNumber;
    }

    /**
     * If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well
     * as translated into 708. 708 data present in the source content will be discarded.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link Scte20Convert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper
     *         as well as translated into 708. 708 data present in the source content will be discarded.
     * @see Scte20Convert608To708
     */
    public Scte20Convert608To708 convert608To708() {
        return Scte20Convert608To708.fromValue(convert608To708);
    }

    /**
     * If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well
     * as translated into 708. 708 data present in the source content will be discarded.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link Scte20Convert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper
     *         as well as translated into 708. 708 data present in the source content will be discarded.
     * @see Scte20Convert608To708
     */
    public String convert608To708AsString() {
        return convert608To708;
    }

    /**
     * Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
     * passthrough.
     * 
     * @return Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
     *         passthrough.
     */
    public Integer source608ChannelNumber() {
        return source608ChannelNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(convert608To708AsString());
        hashCode = 31 * hashCode + Objects.hashCode(source608ChannelNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte20SourceSettings)) {
            return false;
        }
        Scte20SourceSettings other = (Scte20SourceSettings) obj;
        return Objects.equals(convert608To708AsString(), other.convert608To708AsString())
                && Objects.equals(source608ChannelNumber(), other.source608ChannelNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Scte20SourceSettings").add("Convert608To708", convert608To708AsString())
                .add("Source608ChannelNumber", source608ChannelNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Convert608To708":
            return Optional.ofNullable(clazz.cast(convert608To708AsString()));
        case "Source608ChannelNumber":
            return Optional.ofNullable(clazz.cast(source608ChannelNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scte20SourceSettings, T> g) {
        return obj -> g.apply((Scte20SourceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scte20SourceSettings> {
        /**
         * If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as
         * well as translated into 708. 708 data present in the source content will be discarded.
         * 
         * @param convert608To708
         *        If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708
         *        wrapper as well as translated into 708. 708 data present in the source content will be discarded.
         * @see Scte20Convert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte20Convert608To708
         */
        Builder convert608To708(String convert608To708);

        /**
         * If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as
         * well as translated into 708. 708 data present in the source content will be discarded.
         * 
         * @param convert608To708
         *        If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708
         *        wrapper as well as translated into 708. 708 data present in the source content will be discarded.
         * @see Scte20Convert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte20Convert608To708
         */
        Builder convert608To708(Scte20Convert608To708 convert608To708);

        /**
         * Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
         * passthrough.
         * 
         * @param source608ChannelNumber
         *        Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
         *        passthrough.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source608ChannelNumber(Integer source608ChannelNumber);
    }

    static final class BuilderImpl implements Builder {
        private String convert608To708;

        private Integer source608ChannelNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Scte20SourceSettings model) {
            convert608To708(model.convert608To708);
            source608ChannelNumber(model.source608ChannelNumber);
        }

        public final String getConvert608To708() {
            return convert608To708;
        }

        @Override
        public final Builder convert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
            return this;
        }

        @Override
        public final Builder convert608To708(Scte20Convert608To708 convert608To708) {
            this.convert608To708(convert608To708 == null ? null : convert608To708.toString());
            return this;
        }

        public final void setConvert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
        }

        public final Integer getSource608ChannelNumber() {
            return source608ChannelNumber;
        }

        @Override
        public final Builder source608ChannelNumber(Integer source608ChannelNumber) {
            this.source608ChannelNumber = source608ChannelNumber;
            return this;
        }

        public final void setSource608ChannelNumber(Integer source608ChannelNumber) {
            this.source608ChannelNumber = source608ChannelNumber;
        }

        @Override
        public Scte20SourceSettings build() {
            return new Scte20SourceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
