/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for pausing a pipeline.
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelinePauseStateSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelinePauseStateSettings.Builder, PipelinePauseStateSettings> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PipelinePauseStateSettings::pipelineIdAsString)).setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineId;

    private PipelinePauseStateSettings(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
    }

    /**
     * Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipelineId} will
     * return {@link PipelineId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pipelineIdAsString}.
     * </p>
     * 
     * @return Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").
     * @see PipelineId
     */
    public PipelineId pipelineId() {
        return PipelineId.fromValue(pipelineId);
    }

    /**
     * Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipelineId} will
     * return {@link PipelineId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pipelineIdAsString}.
     * </p>
     * 
     * @return Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").
     * @see PipelineId
     */
    public String pipelineIdAsString() {
        return pipelineId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineIdAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelinePauseStateSettings)) {
            return false;
        }
        PipelinePauseStateSettings other = (PipelinePauseStateSettings) obj;
        return Objects.equals(pipelineIdAsString(), other.pipelineIdAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PipelinePauseStateSettings").add("PipelineId", pipelineIdAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineId":
            return Optional.ofNullable(clazz.cast(pipelineIdAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelinePauseStateSettings, T> g) {
        return obj -> g.apply((PipelinePauseStateSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelinePauseStateSettings> {
        /**
         * Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").
         * 
         * @param pipelineId
         *        Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").
         * @see PipelineId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineId
         */
        Builder pipelineId(String pipelineId);

        /**
         * Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").
         * 
         * @param pipelineId
         *        Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").
         * @see PipelineId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineId
         */
        Builder pipelineId(PipelineId pipelineId);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineId;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelinePauseStateSettings model) {
            pipelineId(model.pipelineId);
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        @Override
        public final Builder pipelineId(PipelineId pipelineId) {
            this.pipelineId(pipelineId == null ? null : pipelineId.toString());
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        public PipelinePauseStateSettings build() {
            return new PipelinePauseStateSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
