/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Output Group Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputGroupSettings.Builder, OutputGroupSettings> {
    private static final SdkField<ArchiveGroupSettings> ARCHIVE_GROUP_SETTINGS_FIELD = SdkField
            .<ArchiveGroupSettings> builder(MarshallingType.SDK_POJO).getter(getter(OutputGroupSettings::archiveGroupSettings))
            .setter(setter(Builder::archiveGroupSettings)).constructor(ArchiveGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveGroupSettings").build())
            .build();

    private static final SdkField<FrameCaptureGroupSettings> FRAME_CAPTURE_GROUP_SETTINGS_FIELD = SdkField
            .<FrameCaptureGroupSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(OutputGroupSettings::frameCaptureGroupSettings)).setter(setter(Builder::frameCaptureGroupSettings))
            .constructor(FrameCaptureGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureGroupSettings").build())
            .build();

    private static final SdkField<HlsGroupSettings> HLS_GROUP_SETTINGS_FIELD = SdkField
            .<HlsGroupSettings> builder(MarshallingType.SDK_POJO).getter(getter(OutputGroupSettings::hlsGroupSettings))
            .setter(setter(Builder::hlsGroupSettings)).constructor(HlsGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsGroupSettings").build()).build();

    private static final SdkField<MediaPackageGroupSettings> MEDIA_PACKAGE_GROUP_SETTINGS_FIELD = SdkField
            .<MediaPackageGroupSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(OutputGroupSettings::mediaPackageGroupSettings)).setter(setter(Builder::mediaPackageGroupSettings))
            .constructor(MediaPackageGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaPackageGroupSettings").build())
            .build();

    private static final SdkField<MsSmoothGroupSettings> MS_SMOOTH_GROUP_SETTINGS_FIELD = SdkField
            .<MsSmoothGroupSettings> builder(MarshallingType.SDK_POJO).getter(getter(OutputGroupSettings::msSmoothGroupSettings))
            .setter(setter(Builder::msSmoothGroupSettings)).constructor(MsSmoothGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("msSmoothGroupSettings").build())
            .build();

    private static final SdkField<MultiplexGroupSettings> MULTIPLEX_GROUP_SETTINGS_FIELD = SdkField
            .<MultiplexGroupSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(OutputGroupSettings::multiplexGroupSettings)).setter(setter(Builder::multiplexGroupSettings))
            .constructor(MultiplexGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexGroupSettings").build())
            .build();

    private static final SdkField<RtmpGroupSettings> RTMP_GROUP_SETTINGS_FIELD = SdkField
            .<RtmpGroupSettings> builder(MarshallingType.SDK_POJO).getter(getter(OutputGroupSettings::rtmpGroupSettings))
            .setter(setter(Builder::rtmpGroupSettings)).constructor(RtmpGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtmpGroupSettings").build()).build();

    private static final SdkField<UdpGroupSettings> UDP_GROUP_SETTINGS_FIELD = SdkField
            .<UdpGroupSettings> builder(MarshallingType.SDK_POJO).getter(getter(OutputGroupSettings::udpGroupSettings))
            .setter(setter(Builder::udpGroupSettings)).constructor(UdpGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("udpGroupSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_GROUP_SETTINGS_FIELD,
            FRAME_CAPTURE_GROUP_SETTINGS_FIELD, HLS_GROUP_SETTINGS_FIELD, MEDIA_PACKAGE_GROUP_SETTINGS_FIELD,
            MS_SMOOTH_GROUP_SETTINGS_FIELD, MULTIPLEX_GROUP_SETTINGS_FIELD, RTMP_GROUP_SETTINGS_FIELD, UDP_GROUP_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ArchiveGroupSettings archiveGroupSettings;

    private final FrameCaptureGroupSettings frameCaptureGroupSettings;

    private final HlsGroupSettings hlsGroupSettings;

    private final MediaPackageGroupSettings mediaPackageGroupSettings;

    private final MsSmoothGroupSettings msSmoothGroupSettings;

    private final MultiplexGroupSettings multiplexGroupSettings;

    private final RtmpGroupSettings rtmpGroupSettings;

    private final UdpGroupSettings udpGroupSettings;

    private OutputGroupSettings(BuilderImpl builder) {
        this.archiveGroupSettings = builder.archiveGroupSettings;
        this.frameCaptureGroupSettings = builder.frameCaptureGroupSettings;
        this.hlsGroupSettings = builder.hlsGroupSettings;
        this.mediaPackageGroupSettings = builder.mediaPackageGroupSettings;
        this.msSmoothGroupSettings = builder.msSmoothGroupSettings;
        this.multiplexGroupSettings = builder.multiplexGroupSettings;
        this.rtmpGroupSettings = builder.rtmpGroupSettings;
        this.udpGroupSettings = builder.udpGroupSettings;
    }

    /**
     * Returns the value of the ArchiveGroupSettings property for this object.
     * 
     * @return The value of the ArchiveGroupSettings property for this object.
     */
    public ArchiveGroupSettings archiveGroupSettings() {
        return archiveGroupSettings;
    }

    /**
     * Returns the value of the FrameCaptureGroupSettings property for this object.
     * 
     * @return The value of the FrameCaptureGroupSettings property for this object.
     */
    public FrameCaptureGroupSettings frameCaptureGroupSettings() {
        return frameCaptureGroupSettings;
    }

    /**
     * Returns the value of the HlsGroupSettings property for this object.
     * 
     * @return The value of the HlsGroupSettings property for this object.
     */
    public HlsGroupSettings hlsGroupSettings() {
        return hlsGroupSettings;
    }

    /**
     * Returns the value of the MediaPackageGroupSettings property for this object.
     * 
     * @return The value of the MediaPackageGroupSettings property for this object.
     */
    public MediaPackageGroupSettings mediaPackageGroupSettings() {
        return mediaPackageGroupSettings;
    }

    /**
     * Returns the value of the MsSmoothGroupSettings property for this object.
     * 
     * @return The value of the MsSmoothGroupSettings property for this object.
     */
    public MsSmoothGroupSettings msSmoothGroupSettings() {
        return msSmoothGroupSettings;
    }

    /**
     * Returns the value of the MultiplexGroupSettings property for this object.
     * 
     * @return The value of the MultiplexGroupSettings property for this object.
     */
    public MultiplexGroupSettings multiplexGroupSettings() {
        return multiplexGroupSettings;
    }

    /**
     * Returns the value of the RtmpGroupSettings property for this object.
     * 
     * @return The value of the RtmpGroupSettings property for this object.
     */
    public RtmpGroupSettings rtmpGroupSettings() {
        return rtmpGroupSettings;
    }

    /**
     * Returns the value of the UdpGroupSettings property for this object.
     * 
     * @return The value of the UdpGroupSettings property for this object.
     */
    public UdpGroupSettings udpGroupSettings() {
        return udpGroupSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(archiveGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(frameCaptureGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hlsGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(mediaPackageGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(msSmoothGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(multiplexGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(rtmpGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(udpGroupSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroupSettings)) {
            return false;
        }
        OutputGroupSettings other = (OutputGroupSettings) obj;
        return Objects.equals(archiveGroupSettings(), other.archiveGroupSettings())
                && Objects.equals(frameCaptureGroupSettings(), other.frameCaptureGroupSettings())
                && Objects.equals(hlsGroupSettings(), other.hlsGroupSettings())
                && Objects.equals(mediaPackageGroupSettings(), other.mediaPackageGroupSettings())
                && Objects.equals(msSmoothGroupSettings(), other.msSmoothGroupSettings())
                && Objects.equals(multiplexGroupSettings(), other.multiplexGroupSettings())
                && Objects.equals(rtmpGroupSettings(), other.rtmpGroupSettings())
                && Objects.equals(udpGroupSettings(), other.udpGroupSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OutputGroupSettings").add("ArchiveGroupSettings", archiveGroupSettings())
                .add("FrameCaptureGroupSettings", frameCaptureGroupSettings()).add("HlsGroupSettings", hlsGroupSettings())
                .add("MediaPackageGroupSettings", mediaPackageGroupSettings())
                .add("MsSmoothGroupSettings", msSmoothGroupSettings()).add("MultiplexGroupSettings", multiplexGroupSettings())
                .add("RtmpGroupSettings", rtmpGroupSettings()).add("UdpGroupSettings", udpGroupSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveGroupSettings":
            return Optional.ofNullable(clazz.cast(archiveGroupSettings()));
        case "FrameCaptureGroupSettings":
            return Optional.ofNullable(clazz.cast(frameCaptureGroupSettings()));
        case "HlsGroupSettings":
            return Optional.ofNullable(clazz.cast(hlsGroupSettings()));
        case "MediaPackageGroupSettings":
            return Optional.ofNullable(clazz.cast(mediaPackageGroupSettings()));
        case "MsSmoothGroupSettings":
            return Optional.ofNullable(clazz.cast(msSmoothGroupSettings()));
        case "MultiplexGroupSettings":
            return Optional.ofNullable(clazz.cast(multiplexGroupSettings()));
        case "RtmpGroupSettings":
            return Optional.ofNullable(clazz.cast(rtmpGroupSettings()));
        case "UdpGroupSettings":
            return Optional.ofNullable(clazz.cast(udpGroupSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputGroupSettings, T> g) {
        return obj -> g.apply((OutputGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputGroupSettings> {
        /**
         * Sets the value of the ArchiveGroupSettings property for this object.
         *
         * @param archiveGroupSettings
         *        The new value for the ArchiveGroupSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveGroupSettings(ArchiveGroupSettings archiveGroupSettings);

        /**
         * Sets the value of the ArchiveGroupSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link ArchiveGroupSettings.Builder} avoiding the need
         * to create one manually via {@link ArchiveGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArchiveGroupSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #archiveGroupSettings(ArchiveGroupSettings)}.
         * 
         * @param archiveGroupSettings
         *        a consumer that will call methods on {@link ArchiveGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archiveGroupSettings(ArchiveGroupSettings)
         */
        default Builder archiveGroupSettings(Consumer<ArchiveGroupSettings.Builder> archiveGroupSettings) {
            return archiveGroupSettings(ArchiveGroupSettings.builder().applyMutation(archiveGroupSettings).build());
        }

        /**
         * Sets the value of the FrameCaptureGroupSettings property for this object.
         *
         * @param frameCaptureGroupSettings
         *        The new value for the FrameCaptureGroupSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameCaptureGroupSettings(FrameCaptureGroupSettings frameCaptureGroupSettings);

        /**
         * Sets the value of the FrameCaptureGroupSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link FrameCaptureGroupSettings.Builder} avoiding the
         * need to create one manually via {@link FrameCaptureGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FrameCaptureGroupSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #frameCaptureGroupSettings(FrameCaptureGroupSettings)}.
         * 
         * @param frameCaptureGroupSettings
         *        a consumer that will call methods on {@link FrameCaptureGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameCaptureGroupSettings(FrameCaptureGroupSettings)
         */
        default Builder frameCaptureGroupSettings(Consumer<FrameCaptureGroupSettings.Builder> frameCaptureGroupSettings) {
            return frameCaptureGroupSettings(FrameCaptureGroupSettings.builder().applyMutation(frameCaptureGroupSettings).build());
        }

        /**
         * Sets the value of the HlsGroupSettings property for this object.
         *
         * @param hlsGroupSettings
         *        The new value for the HlsGroupSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsGroupSettings(HlsGroupSettings hlsGroupSettings);

        /**
         * Sets the value of the HlsGroupSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link HlsGroupSettings.Builder} avoiding the need to
         * create one manually via {@link HlsGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsGroupSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #hlsGroupSettings(HlsGroupSettings)}.
         * 
         * @param hlsGroupSettings
         *        a consumer that will call methods on {@link HlsGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsGroupSettings(HlsGroupSettings)
         */
        default Builder hlsGroupSettings(Consumer<HlsGroupSettings.Builder> hlsGroupSettings) {
            return hlsGroupSettings(HlsGroupSettings.builder().applyMutation(hlsGroupSettings).build());
        }

        /**
         * Sets the value of the MediaPackageGroupSettings property for this object.
         *
         * @param mediaPackageGroupSettings
         *        The new value for the MediaPackageGroupSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPackageGroupSettings(MediaPackageGroupSettings mediaPackageGroupSettings);

        /**
         * Sets the value of the MediaPackageGroupSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link MediaPackageGroupSettings.Builder} avoiding the
         * need to create one manually via {@link MediaPackageGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MediaPackageGroupSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaPackageGroupSettings(MediaPackageGroupSettings)}.
         * 
         * @param mediaPackageGroupSettings
         *        a consumer that will call methods on {@link MediaPackageGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaPackageGroupSettings(MediaPackageGroupSettings)
         */
        default Builder mediaPackageGroupSettings(Consumer<MediaPackageGroupSettings.Builder> mediaPackageGroupSettings) {
            return mediaPackageGroupSettings(MediaPackageGroupSettings.builder().applyMutation(mediaPackageGroupSettings).build());
        }

        /**
         * Sets the value of the MsSmoothGroupSettings property for this object.
         *
         * @param msSmoothGroupSettings
         *        The new value for the MsSmoothGroupSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder msSmoothGroupSettings(MsSmoothGroupSettings msSmoothGroupSettings);

        /**
         * Sets the value of the MsSmoothGroupSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link MsSmoothGroupSettings.Builder} avoiding the need
         * to create one manually via {@link MsSmoothGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MsSmoothGroupSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #msSmoothGroupSettings(MsSmoothGroupSettings)}.
         * 
         * @param msSmoothGroupSettings
         *        a consumer that will call methods on {@link MsSmoothGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #msSmoothGroupSettings(MsSmoothGroupSettings)
         */
        default Builder msSmoothGroupSettings(Consumer<MsSmoothGroupSettings.Builder> msSmoothGroupSettings) {
            return msSmoothGroupSettings(MsSmoothGroupSettings.builder().applyMutation(msSmoothGroupSettings).build());
        }

        /**
         * Sets the value of the MultiplexGroupSettings property for this object.
         *
         * @param multiplexGroupSettings
         *        The new value for the MultiplexGroupSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexGroupSettings(MultiplexGroupSettings multiplexGroupSettings);

        /**
         * Sets the value of the MultiplexGroupSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link MultiplexGroupSettings.Builder} avoiding the
         * need to create one manually via {@link MultiplexGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexGroupSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #multiplexGroupSettings(MultiplexGroupSettings)}.
         * 
         * @param multiplexGroupSettings
         *        a consumer that will call methods on {@link MultiplexGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexGroupSettings(MultiplexGroupSettings)
         */
        default Builder multiplexGroupSettings(Consumer<MultiplexGroupSettings.Builder> multiplexGroupSettings) {
            return multiplexGroupSettings(MultiplexGroupSettings.builder().applyMutation(multiplexGroupSettings).build());
        }

        /**
         * Sets the value of the RtmpGroupSettings property for this object.
         *
         * @param rtmpGroupSettings
         *        The new value for the RtmpGroupSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rtmpGroupSettings(RtmpGroupSettings rtmpGroupSettings);

        /**
         * Sets the value of the RtmpGroupSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link RtmpGroupSettings.Builder} avoiding the need to
         * create one manually via {@link RtmpGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link RtmpGroupSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #rtmpGroupSettings(RtmpGroupSettings)}.
         * 
         * @param rtmpGroupSettings
         *        a consumer that will call methods on {@link RtmpGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rtmpGroupSettings(RtmpGroupSettings)
         */
        default Builder rtmpGroupSettings(Consumer<RtmpGroupSettings.Builder> rtmpGroupSettings) {
            return rtmpGroupSettings(RtmpGroupSettings.builder().applyMutation(rtmpGroupSettings).build());
        }

        /**
         * Sets the value of the UdpGroupSettings property for this object.
         *
         * @param udpGroupSettings
         *        The new value for the UdpGroupSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder udpGroupSettings(UdpGroupSettings udpGroupSettings);

        /**
         * Sets the value of the UdpGroupSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link UdpGroupSettings.Builder} avoiding the need to
         * create one manually via {@link UdpGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link UdpGroupSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #udpGroupSettings(UdpGroupSettings)}.
         * 
         * @param udpGroupSettings
         *        a consumer that will call methods on {@link UdpGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #udpGroupSettings(UdpGroupSettings)
         */
        default Builder udpGroupSettings(Consumer<UdpGroupSettings.Builder> udpGroupSettings) {
            return udpGroupSettings(UdpGroupSettings.builder().applyMutation(udpGroupSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ArchiveGroupSettings archiveGroupSettings;

        private FrameCaptureGroupSettings frameCaptureGroupSettings;

        private HlsGroupSettings hlsGroupSettings;

        private MediaPackageGroupSettings mediaPackageGroupSettings;

        private MsSmoothGroupSettings msSmoothGroupSettings;

        private MultiplexGroupSettings multiplexGroupSettings;

        private RtmpGroupSettings rtmpGroupSettings;

        private UdpGroupSettings udpGroupSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputGroupSettings model) {
            archiveGroupSettings(model.archiveGroupSettings);
            frameCaptureGroupSettings(model.frameCaptureGroupSettings);
            hlsGroupSettings(model.hlsGroupSettings);
            mediaPackageGroupSettings(model.mediaPackageGroupSettings);
            msSmoothGroupSettings(model.msSmoothGroupSettings);
            multiplexGroupSettings(model.multiplexGroupSettings);
            rtmpGroupSettings(model.rtmpGroupSettings);
            udpGroupSettings(model.udpGroupSettings);
        }

        public final ArchiveGroupSettings.Builder getArchiveGroupSettings() {
            return archiveGroupSettings != null ? archiveGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder archiveGroupSettings(ArchiveGroupSettings archiveGroupSettings) {
            this.archiveGroupSettings = archiveGroupSettings;
            return this;
        }

        public final void setArchiveGroupSettings(ArchiveGroupSettings.BuilderImpl archiveGroupSettings) {
            this.archiveGroupSettings = archiveGroupSettings != null ? archiveGroupSettings.build() : null;
        }

        public final FrameCaptureGroupSettings.Builder getFrameCaptureGroupSettings() {
            return frameCaptureGroupSettings != null ? frameCaptureGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder frameCaptureGroupSettings(FrameCaptureGroupSettings frameCaptureGroupSettings) {
            this.frameCaptureGroupSettings = frameCaptureGroupSettings;
            return this;
        }

        public final void setFrameCaptureGroupSettings(FrameCaptureGroupSettings.BuilderImpl frameCaptureGroupSettings) {
            this.frameCaptureGroupSettings = frameCaptureGroupSettings != null ? frameCaptureGroupSettings.build() : null;
        }

        public final HlsGroupSettings.Builder getHlsGroupSettings() {
            return hlsGroupSettings != null ? hlsGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsGroupSettings(HlsGroupSettings hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings;
            return this;
        }

        public final void setHlsGroupSettings(HlsGroupSettings.BuilderImpl hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings != null ? hlsGroupSettings.build() : null;
        }

        public final MediaPackageGroupSettings.Builder getMediaPackageGroupSettings() {
            return mediaPackageGroupSettings != null ? mediaPackageGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder mediaPackageGroupSettings(MediaPackageGroupSettings mediaPackageGroupSettings) {
            this.mediaPackageGroupSettings = mediaPackageGroupSettings;
            return this;
        }

        public final void setMediaPackageGroupSettings(MediaPackageGroupSettings.BuilderImpl mediaPackageGroupSettings) {
            this.mediaPackageGroupSettings = mediaPackageGroupSettings != null ? mediaPackageGroupSettings.build() : null;
        }

        public final MsSmoothGroupSettings.Builder getMsSmoothGroupSettings() {
            return msSmoothGroupSettings != null ? msSmoothGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder msSmoothGroupSettings(MsSmoothGroupSettings msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings;
            return this;
        }

        public final void setMsSmoothGroupSettings(MsSmoothGroupSettings.BuilderImpl msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings != null ? msSmoothGroupSettings.build() : null;
        }

        public final MultiplexGroupSettings.Builder getMultiplexGroupSettings() {
            return multiplexGroupSettings != null ? multiplexGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder multiplexGroupSettings(MultiplexGroupSettings multiplexGroupSettings) {
            this.multiplexGroupSettings = multiplexGroupSettings;
            return this;
        }

        public final void setMultiplexGroupSettings(MultiplexGroupSettings.BuilderImpl multiplexGroupSettings) {
            this.multiplexGroupSettings = multiplexGroupSettings != null ? multiplexGroupSettings.build() : null;
        }

        public final RtmpGroupSettings.Builder getRtmpGroupSettings() {
            return rtmpGroupSettings != null ? rtmpGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder rtmpGroupSettings(RtmpGroupSettings rtmpGroupSettings) {
            this.rtmpGroupSettings = rtmpGroupSettings;
            return this;
        }

        public final void setRtmpGroupSettings(RtmpGroupSettings.BuilderImpl rtmpGroupSettings) {
            this.rtmpGroupSettings = rtmpGroupSettings != null ? rtmpGroupSettings.build() : null;
        }

        public final UdpGroupSettings.Builder getUdpGroupSettings() {
            return udpGroupSettings != null ? udpGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder udpGroupSettings(UdpGroupSettings udpGroupSettings) {
            this.udpGroupSettings = udpGroupSettings;
            return this;
        }

        public final void setUdpGroupSettings(UdpGroupSettings.BuilderImpl udpGroupSettings) {
            this.udpGroupSettings = udpGroupSettings != null ? udpGroupSettings.build() : null;
        }

        @Override
        public OutputGroupSettings build() {
            return new OutputGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
