/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The multiplex program object.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexProgram implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexProgram.Builder, MultiplexProgram> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MultiplexProgram::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()).build();

    private static final SdkField<MultiplexProgramSettings> MULTIPLEX_PROGRAM_SETTINGS_FIELD = SdkField
            .<MultiplexProgramSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(MultiplexProgram::multiplexProgramSettings)).setter(setter(Builder::multiplexProgramSettings))
            .constructor(MultiplexProgramSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexProgramSettings").build())
            .build();

    private static final SdkField<MultiplexProgramPacketIdentifiersMap> PACKET_IDENTIFIERS_MAP_FIELD = SdkField
            .<MultiplexProgramPacketIdentifiersMap> builder(MarshallingType.SDK_POJO)
            .getter(getter(MultiplexProgram::packetIdentifiersMap)).setter(setter(Builder::packetIdentifiersMap))
            .constructor(MultiplexProgramPacketIdentifiersMap::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetIdentifiersMap").build())
            .build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MultiplexProgram::programName)).setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD,
            MULTIPLEX_PROGRAM_SETTINGS_FIELD, PACKET_IDENTIFIERS_MAP_FIELD, PROGRAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelId;

    private final MultiplexProgramSettings multiplexProgramSettings;

    private final MultiplexProgramPacketIdentifiersMap packetIdentifiersMap;

    private final String programName;

    private MultiplexProgram(BuilderImpl builder) {
        this.channelId = builder.channelId;
        this.multiplexProgramSettings = builder.multiplexProgramSettings;
        this.packetIdentifiersMap = builder.packetIdentifiersMap;
        this.programName = builder.programName;
    }

    /**
     * The MediaLive channel associated with the program.
     * 
     * @return The MediaLive channel associated with the program.
     */
    public String channelId() {
        return channelId;
    }

    /**
     * The settings for this multiplex program.
     * 
     * @return The settings for this multiplex program.
     */
    public MultiplexProgramSettings multiplexProgramSettings() {
        return multiplexProgramSettings;
    }

    /**
     * The packet identifier map for this multiplex program.
     * 
     * @return The packet identifier map for this multiplex program.
     */
    public MultiplexProgramPacketIdentifiersMap packetIdentifiersMap() {
        return packetIdentifiersMap;
    }

    /**
     * The name of the multiplex program.
     * 
     * @return The name of the multiplex program.
     */
    public String programName() {
        return programName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(multiplexProgramSettings());
        hashCode = 31 * hashCode + Objects.hashCode(packetIdentifiersMap());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexProgram)) {
            return false;
        }
        MultiplexProgram other = (MultiplexProgram) obj;
        return Objects.equals(channelId(), other.channelId())
                && Objects.equals(multiplexProgramSettings(), other.multiplexProgramSettings())
                && Objects.equals(packetIdentifiersMap(), other.packetIdentifiersMap())
                && Objects.equals(programName(), other.programName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MultiplexProgram").add("ChannelId", channelId())
                .add("MultiplexProgramSettings", multiplexProgramSettings()).add("PacketIdentifiersMap", packetIdentifiersMap())
                .add("ProgramName", programName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "MultiplexProgramSettings":
            return Optional.ofNullable(clazz.cast(multiplexProgramSettings()));
        case "PacketIdentifiersMap":
            return Optional.ofNullable(clazz.cast(packetIdentifiersMap()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexProgram, T> g) {
        return obj -> g.apply((MultiplexProgram) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexProgram> {
        /**
         * The MediaLive channel associated with the program.
         * 
         * @param channelId
         *        The MediaLive channel associated with the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * The settings for this multiplex program.
         * 
         * @param multiplexProgramSettings
         *        The settings for this multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexProgramSettings(MultiplexProgramSettings multiplexProgramSettings);

        /**
         * The settings for this multiplex program. This is a convenience that creates an instance of the
         * {@link MultiplexProgramSettings.Builder} avoiding the need to create one manually via
         * {@link MultiplexProgramSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexProgramSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #multiplexProgramSettings(MultiplexProgramSettings)}.
         * 
         * @param multiplexProgramSettings
         *        a consumer that will call methods on {@link MultiplexProgramSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexProgramSettings(MultiplexProgramSettings)
         */
        default Builder multiplexProgramSettings(Consumer<MultiplexProgramSettings.Builder> multiplexProgramSettings) {
            return multiplexProgramSettings(MultiplexProgramSettings.builder().applyMutation(multiplexProgramSettings).build());
        }

        /**
         * The packet identifier map for this multiplex program.
         * 
         * @param packetIdentifiersMap
         *        The packet identifier map for this multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap packetIdentifiersMap);

        /**
         * The packet identifier map for this multiplex program. This is a convenience that creates an instance of the
         * {@link MultiplexProgramPacketIdentifiersMap.Builder} avoiding the need to create one manually via
         * {@link MultiplexProgramPacketIdentifiersMap#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexProgramPacketIdentifiersMap.Builder#build()} is called
         * immediately and its result is passed to {@link #packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap)}.
         * 
         * @param packetIdentifiersMap
         *        a consumer that will call methods on {@link MultiplexProgramPacketIdentifiersMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap)
         */
        default Builder packetIdentifiersMap(Consumer<MultiplexProgramPacketIdentifiersMap.Builder> packetIdentifiersMap) {
            return packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap.builder().applyMutation(packetIdentifiersMap)
                    .build());
        }

        /**
         * The name of the multiplex program.
         * 
         * @param programName
         *        The name of the multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);
    }

    static final class BuilderImpl implements Builder {
        private String channelId;

        private MultiplexProgramSettings multiplexProgramSettings;

        private MultiplexProgramPacketIdentifiersMap packetIdentifiersMap;

        private String programName;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexProgram model) {
            channelId(model.channelId);
            multiplexProgramSettings(model.multiplexProgramSettings);
            packetIdentifiersMap(model.packetIdentifiersMap);
            programName(model.programName);
        }

        public final String getChannelId() {
            return channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public final MultiplexProgramSettings.Builder getMultiplexProgramSettings() {
            return multiplexProgramSettings != null ? multiplexProgramSettings.toBuilder() : null;
        }

        @Override
        public final Builder multiplexProgramSettings(MultiplexProgramSettings multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings;
            return this;
        }

        public final void setMultiplexProgramSettings(MultiplexProgramSettings.BuilderImpl multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings != null ? multiplexProgramSettings.build() : null;
        }

        public final MultiplexProgramPacketIdentifiersMap.Builder getPacketIdentifiersMap() {
            return packetIdentifiersMap != null ? packetIdentifiersMap.toBuilder() : null;
        }

        @Override
        public final Builder packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap packetIdentifiersMap) {
            this.packetIdentifiersMap = packetIdentifiersMap;
            return this;
        }

        public final void setPacketIdentifiersMap(MultiplexProgramPacketIdentifiersMap.BuilderImpl packetIdentifiersMap) {
            this.packetIdentifiersMap = packetIdentifiersMap != null ? packetIdentifiersMap.build() : null;
        }

        public final String getProgramName() {
            return programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public MultiplexProgram build() {
            return new MultiplexProgram(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
