/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for a MediaConnect Flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaConnectFlow implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaConnectFlow.Builder, MediaConnectFlow> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MediaConnectFlow::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String flowArn;

    private MediaConnectFlow(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
    }

    /**
     * The unique ARN of the MediaConnect Flow being used as a source.
     * 
     * @return The unique ARN of the MediaConnect Flow being used as a source.
     */
    public String flowArn() {
        return flowArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaConnectFlow)) {
            return false;
        }
        MediaConnectFlow other = (MediaConnectFlow) obj;
        return Objects.equals(flowArn(), other.flowArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MediaConnectFlow").add("FlowArn", flowArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaConnectFlow, T> g) {
        return obj -> g.apply((MediaConnectFlow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaConnectFlow> {
        /**
         * The unique ARN of the MediaConnect Flow being used as a source.
         * 
         * @param flowArn
         *        The unique ARN of the MediaConnect Flow being used as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);
    }

    static final class BuilderImpl implements Builder {
        private String flowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaConnectFlow model) {
            flowArn(model.flowArn);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public MediaConnectFlow build() {
            return new MediaConnectFlow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
