/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * M2ts Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class M2tsSettings implements SdkPojo, Serializable, ToCopyableBuilder<M2tsSettings.Builder, M2tsSettings> {
    private static final SdkField<String> ABSENT_INPUT_AUDIO_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::absentInputAudioBehaviorAsString)).setter(setter(Builder::absentInputAudioBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("absentInputAudioBehavior").build())
            .build();

    private static final SdkField<String> ARIB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::aribAsString)).setter(setter(Builder::arib))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arib").build()).build();

    private static final SdkField<String> ARIB_CAPTIONS_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::aribCaptionsPid)).setter(setter(Builder::aribCaptionsPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aribCaptionsPid").build()).build();

    private static final SdkField<String> ARIB_CAPTIONS_PID_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::aribCaptionsPidControlAsString)).setter(setter(Builder::aribCaptionsPidControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aribCaptionsPidControl").build())
            .build();

    private static final SdkField<String> AUDIO_BUFFER_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::audioBufferModelAsString)).setter(setter(Builder::audioBufferModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioBufferModel").build()).build();

    private static final SdkField<Integer> AUDIO_FRAMES_PER_PES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(M2tsSettings::audioFramesPerPes)).setter(setter(Builder::audioFramesPerPes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioFramesPerPes").build()).build();

    private static final SdkField<String> AUDIO_PIDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::audioPids)).setter(setter(Builder::audioPids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioPids").build()).build();

    private static final SdkField<String> AUDIO_STREAM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::audioStreamTypeAsString)).setter(setter(Builder::audioStreamType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioStreamType").build()).build();

    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(M2tsSettings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> BUFFER_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::bufferModelAsString)).setter(setter(Builder::bufferModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufferModel").build()).build();

    private static final SdkField<String> CC_DESCRIPTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::ccDescriptorAsString)).setter(setter(Builder::ccDescriptor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ccDescriptor").build()).build();

    private static final SdkField<DvbNitSettings> DVB_NIT_SETTINGS_FIELD = SdkField
            .<DvbNitSettings> builder(MarshallingType.SDK_POJO).getter(getter(M2tsSettings::dvbNitSettings))
            .setter(setter(Builder::dvbNitSettings)).constructor(DvbNitSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbNitSettings").build()).build();

    private static final SdkField<DvbSdtSettings> DVB_SDT_SETTINGS_FIELD = SdkField
            .<DvbSdtSettings> builder(MarshallingType.SDK_POJO).getter(getter(M2tsSettings::dvbSdtSettings))
            .setter(setter(Builder::dvbSdtSettings)).constructor(DvbSdtSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSdtSettings").build()).build();

    private static final SdkField<String> DVB_SUB_PIDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::dvbSubPids)).setter(setter(Builder::dvbSubPids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSubPids").build()).build();

    private static final SdkField<DvbTdtSettings> DVB_TDT_SETTINGS_FIELD = SdkField
            .<DvbTdtSettings> builder(MarshallingType.SDK_POJO).getter(getter(M2tsSettings::dvbTdtSettings))
            .setter(setter(Builder::dvbTdtSettings)).constructor(DvbTdtSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbTdtSettings").build()).build();

    private static final SdkField<String> DVB_TELETEXT_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::dvbTeletextPid)).setter(setter(Builder::dvbTeletextPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbTeletextPid").build()).build();

    private static final SdkField<String> EBIF_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::ebifAsString)).setter(setter(Builder::ebif))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebif").build()).build();

    private static final SdkField<String> EBP_AUDIO_INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::ebpAudioIntervalAsString)).setter(setter(Builder::ebpAudioInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebpAudioInterval").build()).build();

    private static final SdkField<Integer> EBP_LOOKAHEAD_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(M2tsSettings::ebpLookaheadMs)).setter(setter(Builder::ebpLookaheadMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebpLookaheadMs").build()).build();

    private static final SdkField<String> EBP_PLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::ebpPlacementAsString)).setter(setter(Builder::ebpPlacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebpPlacement").build()).build();

    private static final SdkField<String> ECM_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::ecmPid)).setter(setter(Builder::ecmPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecmPid").build()).build();

    private static final SdkField<String> ES_RATE_IN_PES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::esRateInPesAsString)).setter(setter(Builder::esRateInPes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("esRateInPes").build()).build();

    private static final SdkField<String> ETV_PLATFORM_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::etvPlatformPid)).setter(setter(Builder::etvPlatformPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etvPlatformPid").build()).build();

    private static final SdkField<String> ETV_SIGNAL_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::etvSignalPid)).setter(setter(Builder::etvSignalPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etvSignalPid").build()).build();

    private static final SdkField<Double> FRAGMENT_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(M2tsSettings::fragmentTime)).setter(setter(Builder::fragmentTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentTime").build()).build();

    private static final SdkField<String> KLV_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::klvAsString)).setter(setter(Builder::klv))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("klv").build()).build();

    private static final SdkField<String> KLV_DATA_PIDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::klvDataPids)).setter(setter(Builder::klvDataPids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("klvDataPids").build()).build();

    private static final SdkField<String> NIELSEN_ID3_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::nielsenId3BehaviorAsString)).setter(setter(Builder::nielsenId3Behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenId3Behavior").build())
            .build();

    private static final SdkField<Double> NULL_PACKET_BITRATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(M2tsSettings::nullPacketBitrate)).setter(setter(Builder::nullPacketBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nullPacketBitrate").build()).build();

    private static final SdkField<Integer> PAT_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(M2tsSettings::patInterval)).setter(setter(Builder::patInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patInterval").build()).build();

    private static final SdkField<String> PCR_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::pcrControlAsString)).setter(setter(Builder::pcrControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrControl").build()).build();

    private static final SdkField<Integer> PCR_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(M2tsSettings::pcrPeriod)).setter(setter(Builder::pcrPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrPeriod").build()).build();

    private static final SdkField<String> PCR_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::pcrPid)).setter(setter(Builder::pcrPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrPid").build()).build();

    private static final SdkField<Integer> PMT_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(M2tsSettings::pmtInterval)).setter(setter(Builder::pmtInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pmtInterval").build()).build();

    private static final SdkField<String> PMT_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::pmtPid)).setter(setter(Builder::pmtPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pmtPid").build()).build();

    private static final SdkField<Integer> PROGRAM_NUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(M2tsSettings::programNum)).setter(setter(Builder::programNum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNum").build()).build();

    private static final SdkField<String> RATE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::rateModeAsString)).setter(setter(Builder::rateMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateMode").build()).build();

    private static final SdkField<String> SCTE27_PIDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::scte27Pids)).setter(setter(Builder::scte27Pids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte27Pids").build()).build();

    private static final SdkField<String> SCTE35_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::scte35ControlAsString)).setter(setter(Builder::scte35Control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Control").build()).build();

    private static final SdkField<String> SCTE35_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::scte35Pid)).setter(setter(Builder::scte35Pid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Pid").build()).build();

    private static final SdkField<String> SEGMENTATION_MARKERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::segmentationMarkersAsString)).setter(setter(Builder::segmentationMarkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationMarkers").build())
            .build();

    private static final SdkField<String> SEGMENTATION_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::segmentationStyleAsString)).setter(setter(Builder::segmentationStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationStyle").build()).build();

    private static final SdkField<Double> SEGMENTATION_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(M2tsSettings::segmentationTime)).setter(setter(Builder::segmentationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationTime").build()).build();

    private static final SdkField<String> TIMED_METADATA_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::timedMetadataBehaviorAsString)).setter(setter(Builder::timedMetadataBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataBehavior").build())
            .build();

    private static final SdkField<String> TIMED_METADATA_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::timedMetadataPid)).setter(setter(Builder::timedMetadataPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataPid").build()).build();

    private static final SdkField<Integer> TRANSPORT_STREAM_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(M2tsSettings::transportStreamId)).setter(setter(Builder::transportStreamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamId").build()).build();

    private static final SdkField<String> VIDEO_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(M2tsSettings::videoPid)).setter(setter(Builder::videoPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoPid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ABSENT_INPUT_AUDIO_BEHAVIOR_FIELD, ARIB_FIELD, ARIB_CAPTIONS_PID_FIELD, ARIB_CAPTIONS_PID_CONTROL_FIELD,
            AUDIO_BUFFER_MODEL_FIELD, AUDIO_FRAMES_PER_PES_FIELD, AUDIO_PIDS_FIELD, AUDIO_STREAM_TYPE_FIELD, BITRATE_FIELD,
            BUFFER_MODEL_FIELD, CC_DESCRIPTOR_FIELD, DVB_NIT_SETTINGS_FIELD, DVB_SDT_SETTINGS_FIELD, DVB_SUB_PIDS_FIELD,
            DVB_TDT_SETTINGS_FIELD, DVB_TELETEXT_PID_FIELD, EBIF_FIELD, EBP_AUDIO_INTERVAL_FIELD, EBP_LOOKAHEAD_MS_FIELD,
            EBP_PLACEMENT_FIELD, ECM_PID_FIELD, ES_RATE_IN_PES_FIELD, ETV_PLATFORM_PID_FIELD, ETV_SIGNAL_PID_FIELD,
            FRAGMENT_TIME_FIELD, KLV_FIELD, KLV_DATA_PIDS_FIELD, NIELSEN_ID3_BEHAVIOR_FIELD, NULL_PACKET_BITRATE_FIELD,
            PAT_INTERVAL_FIELD, PCR_CONTROL_FIELD, PCR_PERIOD_FIELD, PCR_PID_FIELD, PMT_INTERVAL_FIELD, PMT_PID_FIELD,
            PROGRAM_NUM_FIELD, RATE_MODE_FIELD, SCTE27_PIDS_FIELD, SCTE35_CONTROL_FIELD, SCTE35_PID_FIELD,
            SEGMENTATION_MARKERS_FIELD, SEGMENTATION_STYLE_FIELD, SEGMENTATION_TIME_FIELD, TIMED_METADATA_BEHAVIOR_FIELD,
            TIMED_METADATA_PID_FIELD, TRANSPORT_STREAM_ID_FIELD, VIDEO_PID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String absentInputAudioBehavior;

    private final String arib;

    private final String aribCaptionsPid;

    private final String aribCaptionsPidControl;

    private final String audioBufferModel;

    private final Integer audioFramesPerPes;

    private final String audioPids;

    private final String audioStreamType;

    private final Integer bitrate;

    private final String bufferModel;

    private final String ccDescriptor;

    private final DvbNitSettings dvbNitSettings;

    private final DvbSdtSettings dvbSdtSettings;

    private final String dvbSubPids;

    private final DvbTdtSettings dvbTdtSettings;

    private final String dvbTeletextPid;

    private final String ebif;

    private final String ebpAudioInterval;

    private final Integer ebpLookaheadMs;

    private final String ebpPlacement;

    private final String ecmPid;

    private final String esRateInPes;

    private final String etvPlatformPid;

    private final String etvSignalPid;

    private final Double fragmentTime;

    private final String klv;

    private final String klvDataPids;

    private final String nielsenId3Behavior;

    private final Double nullPacketBitrate;

    private final Integer patInterval;

    private final String pcrControl;

    private final Integer pcrPeriod;

    private final String pcrPid;

    private final Integer pmtInterval;

    private final String pmtPid;

    private final Integer programNum;

    private final String rateMode;

    private final String scte27Pids;

    private final String scte35Control;

    private final String scte35Pid;

    private final String segmentationMarkers;

    private final String segmentationStyle;

    private final Double segmentationTime;

    private final String timedMetadataBehavior;

    private final String timedMetadataPid;

    private final Integer transportStreamId;

    private final String videoPid;

    private M2tsSettings(BuilderImpl builder) {
        this.absentInputAudioBehavior = builder.absentInputAudioBehavior;
        this.arib = builder.arib;
        this.aribCaptionsPid = builder.aribCaptionsPid;
        this.aribCaptionsPidControl = builder.aribCaptionsPidControl;
        this.audioBufferModel = builder.audioBufferModel;
        this.audioFramesPerPes = builder.audioFramesPerPes;
        this.audioPids = builder.audioPids;
        this.audioStreamType = builder.audioStreamType;
        this.bitrate = builder.bitrate;
        this.bufferModel = builder.bufferModel;
        this.ccDescriptor = builder.ccDescriptor;
        this.dvbNitSettings = builder.dvbNitSettings;
        this.dvbSdtSettings = builder.dvbSdtSettings;
        this.dvbSubPids = builder.dvbSubPids;
        this.dvbTdtSettings = builder.dvbTdtSettings;
        this.dvbTeletextPid = builder.dvbTeletextPid;
        this.ebif = builder.ebif;
        this.ebpAudioInterval = builder.ebpAudioInterval;
        this.ebpLookaheadMs = builder.ebpLookaheadMs;
        this.ebpPlacement = builder.ebpPlacement;
        this.ecmPid = builder.ecmPid;
        this.esRateInPes = builder.esRateInPes;
        this.etvPlatformPid = builder.etvPlatformPid;
        this.etvSignalPid = builder.etvSignalPid;
        this.fragmentTime = builder.fragmentTime;
        this.klv = builder.klv;
        this.klvDataPids = builder.klvDataPids;
        this.nielsenId3Behavior = builder.nielsenId3Behavior;
        this.nullPacketBitrate = builder.nullPacketBitrate;
        this.patInterval = builder.patInterval;
        this.pcrControl = builder.pcrControl;
        this.pcrPeriod = builder.pcrPeriod;
        this.pcrPid = builder.pcrPid;
        this.pmtInterval = builder.pmtInterval;
        this.pmtPid = builder.pmtPid;
        this.programNum = builder.programNum;
        this.rateMode = builder.rateMode;
        this.scte27Pids = builder.scte27Pids;
        this.scte35Control = builder.scte35Control;
        this.scte35Pid = builder.scte35Pid;
        this.segmentationMarkers = builder.segmentationMarkers;
        this.segmentationStyle = builder.segmentationStyle;
        this.segmentationTime = builder.segmentationTime;
        this.timedMetadataBehavior = builder.timedMetadataBehavior;
        this.timedMetadataPid = builder.timedMetadataPid;
        this.transportStreamId = builder.transportStreamId;
        this.videoPid = builder.videoPid;
    }

    /**
     * When set to drop, output audio streams will be removed from the program if the selected input audio stream is
     * removed from the input. This allows the output audio configuration to dynamically change based on input
     * configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not
     * connected to an active input stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #absentInputAudioBehavior} will return {@link M2tsAbsentInputAudioBehavior#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #absentInputAudioBehaviorAsString}.
     * </p>
     * 
     * @return When set to drop, output audio streams will be removed from the program if the selected input audio
     *         stream is removed from the input. This allows the output audio configuration to dynamically change based
     *         on input configuration. If this is set to encodeSilence, all output audio streams will output encoded
     *         silence when not connected to an active input stream.
     * @see M2tsAbsentInputAudioBehavior
     */
    public M2tsAbsentInputAudioBehavior absentInputAudioBehavior() {
        return M2tsAbsentInputAudioBehavior.fromValue(absentInputAudioBehavior);
    }

    /**
     * When set to drop, output audio streams will be removed from the program if the selected input audio stream is
     * removed from the input. This allows the output audio configuration to dynamically change based on input
     * configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not
     * connected to an active input stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #absentInputAudioBehavior} will return {@link M2tsAbsentInputAudioBehavior#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #absentInputAudioBehaviorAsString}.
     * </p>
     * 
     * @return When set to drop, output audio streams will be removed from the program if the selected input audio
     *         stream is removed from the input. This allows the output audio configuration to dynamically change based
     *         on input configuration. If this is set to encodeSilence, all output audio streams will output encoded
     *         silence when not connected to an active input stream.
     * @see M2tsAbsentInputAudioBehavior
     */
    public String absentInputAudioBehaviorAsString() {
        return absentInputAudioBehavior;
    }

    /**
     * When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #arib} will return
     * {@link M2tsArib#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aribAsString}.
     * </p>
     * 
     * @return When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
     * @see M2tsArib
     */
    public M2tsArib arib() {
        return M2tsArib.fromValue(arib);
    }

    /**
     * When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #arib} will return
     * {@link M2tsArib#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aribAsString}.
     * </p>
     * 
     * @return When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
     * @see M2tsArib
     */
    public String aribAsString() {
        return arib;
    }

    /**
     * Packet Identifier (PID) for ARIB Captions in the transport stream. Can be entered as a decimal or hexadecimal
     * value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) for ARIB Captions in the transport stream. Can be entered as a decimal or
     *         hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String aribCaptionsPid() {
        return aribCaptionsPid;
    }

    /**
     * If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids. If set to
     * useConfigured, ARIB Captions will be on the configured pid number.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aribCaptionsPidControl} will return {@link M2tsAribCaptionsPidControl#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #aribCaptionsPidControlAsString}.
     * </p>
     * 
     * @return If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids. If set to
     *         useConfigured, ARIB Captions will be on the configured pid number.
     * @see M2tsAribCaptionsPidControl
     */
    public M2tsAribCaptionsPidControl aribCaptionsPidControl() {
        return M2tsAribCaptionsPidControl.fromValue(aribCaptionsPidControl);
    }

    /**
     * If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids. If set to
     * useConfigured, ARIB Captions will be on the configured pid number.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aribCaptionsPidControl} will return {@link M2tsAribCaptionsPidControl#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #aribCaptionsPidControlAsString}.
     * </p>
     * 
     * @return If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids. If set to
     *         useConfigured, ARIB Captions will be on the configured pid number.
     * @see M2tsAribCaptionsPidControl
     */
    public String aribCaptionsPidControlAsString() {
        return aribCaptionsPidControl;
    }

    /**
     * When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioBufferModel}
     * will return {@link M2tsAudioBufferModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioBufferModelAsString}.
     * </p>
     * 
     * @return When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
     * @see M2tsAudioBufferModel
     */
    public M2tsAudioBufferModel audioBufferModel() {
        return M2tsAudioBufferModel.fromValue(audioBufferModel);
    }

    /**
     * When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioBufferModel}
     * will return {@link M2tsAudioBufferModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioBufferModelAsString}.
     * </p>
     * 
     * @return When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
     * @see M2tsAudioBufferModel
     */
    public String audioBufferModelAsString() {
        return audioBufferModel;
    }

    /**
     * The number of audio frames to insert for each PES packet.
     * 
     * @return The number of audio frames to insert for each PES packet.
     */
    public Integer audioFramesPerPes() {
        return audioFramesPerPes;
    }

    /**
     * Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted,
     * and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each
     * PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are
     *         accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or
     *         hexadecimal values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String audioPids() {
        return audioPids;
    }

    /**
     * When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses stream
     * type = 0x06.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioStreamType}
     * will return {@link M2tsAudioStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioStreamTypeAsString}.
     * </p>
     * 
     * @return When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses
     *         stream type = 0x06.
     * @see M2tsAudioStreamType
     */
    public M2tsAudioStreamType audioStreamType() {
        return M2tsAudioStreamType.fromValue(audioStreamType);
    }

    /**
     * When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses stream
     * type = 0x06.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioStreamType}
     * will return {@link M2tsAudioStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioStreamTypeAsString}.
     * </p>
     * 
     * @return When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses
     *         stream type = 0x06.
     * @see M2tsAudioStreamType
     */
    public String audioStreamTypeAsString() {
        return audioStreamType;
    }

    /**
     * The output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer automatically
     * determine the appropriate bitrate.
     * 
     * @return The output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer automatically
     *         determine the appropriate bitrate.
     */
    public Integer bitrate() {
        return bitrate;
    }

    /**
     * If set to multiplex, use multiplex buffer model for accurate interleaving. Setting to bufferModel to none can
     * lead to lower latency, but low-memory devices may not be able to play back the stream without interruptions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bufferModel} will
     * return {@link M2tsBufferModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bufferModelAsString}.
     * </p>
     * 
     * @return If set to multiplex, use multiplex buffer model for accurate interleaving. Setting to bufferModel to none
     *         can lead to lower latency, but low-memory devices may not be able to play back the stream without
     *         interruptions.
     * @see M2tsBufferModel
     */
    public M2tsBufferModel bufferModel() {
        return M2tsBufferModel.fromValue(bufferModel);
    }

    /**
     * If set to multiplex, use multiplex buffer model for accurate interleaving. Setting to bufferModel to none can
     * lead to lower latency, but low-memory devices may not be able to play back the stream without interruptions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bufferModel} will
     * return {@link M2tsBufferModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bufferModelAsString}.
     * </p>
     * 
     * @return If set to multiplex, use multiplex buffer model for accurate interleaving. Setting to bufferModel to none
     *         can lead to lower latency, but low-memory devices may not be able to play back the stream without
     *         interruptions.
     * @see M2tsBufferModel
     */
    public String bufferModelAsString() {
        return bufferModel;
    }

    /**
     * When set to enabled, generates captionServiceDescriptor in PMT.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ccDescriptor} will
     * return {@link M2tsCcDescriptor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ccDescriptorAsString}.
     * </p>
     * 
     * @return When set to enabled, generates captionServiceDescriptor in PMT.
     * @see M2tsCcDescriptor
     */
    public M2tsCcDescriptor ccDescriptor() {
        return M2tsCcDescriptor.fromValue(ccDescriptor);
    }

    /**
     * When set to enabled, generates captionServiceDescriptor in PMT.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ccDescriptor} will
     * return {@link M2tsCcDescriptor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ccDescriptorAsString}.
     * </p>
     * 
     * @return When set to enabled, generates captionServiceDescriptor in PMT.
     * @see M2tsCcDescriptor
     */
    public String ccDescriptorAsString() {
        return ccDescriptor;
    }

    /**
     * Inserts DVB Network Information Table (NIT) at the specified table repetition interval.
     * 
     * @return Inserts DVB Network Information Table (NIT) at the specified table repetition interval.
     */
    public DvbNitSettings dvbNitSettings() {
        return dvbNitSettings;
    }

    /**
     * Inserts DVB Service Description Table (SDT) at the specified table repetition interval.
     * 
     * @return Inserts DVB Service Description Table (SDT) at the specified table repetition interval.
     */
    public DvbSdtSettings dvbSdtSettings() {
        return dvbSdtSettings;
    }

    /**
     * Packet Identifier (PID) for input source DVB Subtitle data to this output. Multiple values are accepted, and can
     * be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID
     * specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) for input source DVB Subtitle data to this output. Multiple values are accepted,
     *         and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.
     *         Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String dvbSubPids() {
        return dvbSubPids;
    }

    /**
     * Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.
     * 
     * @return Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.
     */
    public DvbTdtSettings dvbTdtSettings() {
        return dvbTdtSettings;
    }

    /**
     * Packet Identifier (PID) for input source DVB Teletext data to this output. Can be entered as a decimal or
     * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) for input source DVB Teletext data to this output. Can be entered as a decimal or
     *         hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String dvbTeletextPid() {
        return dvbTeletextPid;
    }

    /**
     * If set to passthrough, passes any EBIF data from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebif} will return
     * {@link M2tsEbifControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ebifAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any EBIF data from the input source to this output.
     * @see M2tsEbifControl
     */
    public M2tsEbifControl ebif() {
        return M2tsEbifControl.fromValue(ebif);
    }

    /**
     * If set to passthrough, passes any EBIF data from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebif} will return
     * {@link M2tsEbifControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ebifAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any EBIF data from the input source to this output.
     * @see M2tsEbifControl
     */
    public String ebifAsString() {
        return ebif;
    }

    /**
     * When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The interval
     * between these additional markers will be fixed, and will be slightly shorter than the video EBP marker interval.
     * Only available when EBP Cablelabs segmentation markers are selected. Partitions 1 and 2 will always follow the
     * video interval.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebpAudioInterval}
     * will return {@link M2tsAudioInterval#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ebpAudioIntervalAsString}.
     * </p>
     * 
     * @return When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The
     *         interval between these additional markers will be fixed, and will be slightly shorter than the video EBP
     *         marker interval. Only available when EBP Cablelabs segmentation markers are selected. Partitions 1 and 2
     *         will always follow the video interval.
     * @see M2tsAudioInterval
     */
    public M2tsAudioInterval ebpAudioInterval() {
        return M2tsAudioInterval.fromValue(ebpAudioInterval);
    }

    /**
     * When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The interval
     * between these additional markers will be fixed, and will be slightly shorter than the video EBP marker interval.
     * Only available when EBP Cablelabs segmentation markers are selected. Partitions 1 and 2 will always follow the
     * video interval.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebpAudioInterval}
     * will return {@link M2tsAudioInterval#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ebpAudioIntervalAsString}.
     * </p>
     * 
     * @return When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The
     *         interval between these additional markers will be fixed, and will be slightly shorter than the video EBP
     *         marker interval. Only available when EBP Cablelabs segmentation markers are selected. Partitions 1 and 2
     *         will always follow the video interval.
     * @see M2tsAudioInterval
     */
    public String ebpAudioIntervalAsString() {
        return ebpAudioInterval;
    }

    /**
     * When set, enforces that Encoder Boundary Points do not come within the specified time interval of each other by
     * looking ahead at input video. If another EBP is going to come in within the specified time interval, the current
     * EBP is not emitted, and the segment is "stretched" to the next marker. The lookahead value does not add latency
     * to the system. The Live Event must be configured elsewhere to create sufficient latency to make the lookahead
     * accurate.
     * 
     * @return When set, enforces that Encoder Boundary Points do not come within the specified time interval of each
     *         other by looking ahead at input video. If another EBP is going to come in within the specified time
     *         interval, the current EBP is not emitted, and the segment is "stretched" to the next marker. The
     *         lookahead value does not add latency to the system. The Live Event must be configured elsewhere to create
     *         sufficient latency to make the lookahead accurate.
     */
    public Integer ebpLookaheadMs() {
        return ebpLookaheadMs;
    }

    /**
     * Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on the video PID
     * and all audio PIDs. If set to videoPid, EBP markers will be placed on only the video PID.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebpPlacement} will
     * return {@link M2tsEbpPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ebpPlacementAsString}.
     * </p>
     * 
     * @return Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on the
     *         video PID and all audio PIDs. If set to videoPid, EBP markers will be placed on only the video PID.
     * @see M2tsEbpPlacement
     */
    public M2tsEbpPlacement ebpPlacement() {
        return M2tsEbpPlacement.fromValue(ebpPlacement);
    }

    /**
     * Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on the video PID
     * and all audio PIDs. If set to videoPid, EBP markers will be placed on only the video PID.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebpPlacement} will
     * return {@link M2tsEbpPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ebpPlacementAsString}.
     * </p>
     * 
     * @return Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on the
     *         video PID and all audio PIDs. If set to videoPid, EBP markers will be placed on only the video PID.
     * @see M2tsEbpPlacement
     */
    public String ebpPlacementAsString() {
        return ebpPlacement;
    }

    /**
     * This field is unused and deprecated.
     * 
     * @return This field is unused and deprecated.
     */
    public String ecmPid() {
        return ecmPid;
    }

    /**
     * Include or exclude the ES Rate field in the PES header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #esRateInPes} will
     * return {@link M2tsEsRateInPes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #esRateInPesAsString}.
     * </p>
     * 
     * @return Include or exclude the ES Rate field in the PES header.
     * @see M2tsEsRateInPes
     */
    public M2tsEsRateInPes esRateInPes() {
        return M2tsEsRateInPes.fromValue(esRateInPes);
    }

    /**
     * Include or exclude the ES Rate field in the PES header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #esRateInPes} will
     * return {@link M2tsEsRateInPes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #esRateInPesAsString}.
     * </p>
     * 
     * @return Include or exclude the ES Rate field in the PES header.
     * @see M2tsEsRateInPes
     */
    public String esRateInPesAsString() {
        return esRateInPes;
    }

    /**
     * Packet Identifier (PID) for input source ETV Platform data to this output. Can be entered as a decimal or
     * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) for input source ETV Platform data to this output. Can be entered as a decimal or
     *         hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String etvPlatformPid() {
        return etvPlatformPid;
    }

    /**
     * Packet Identifier (PID) for input source ETV Signal data to this output. Can be entered as a decimal or
     * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) for input source ETV Signal data to this output. Can be entered as a decimal or
     *         hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String etvSignalPid() {
        return etvSignalPid;
    }

    /**
     * The length in seconds of each fragment. Only used with EBP markers.
     * 
     * @return The length in seconds of each fragment. Only used with EBP markers.
     */
    public Double fragmentTime() {
        return fragmentTime;
    }

    /**
     * If set to passthrough, passes any KLV data from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #klv} will return
     * {@link M2tsKlv#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #klvAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any KLV data from the input source to this output.
     * @see M2tsKlv
     */
    public M2tsKlv klv() {
        return M2tsKlv.fromValue(klv);
    }

    /**
     * If set to passthrough, passes any KLV data from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #klv} will return
     * {@link M2tsKlv#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #klvAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any KLV data from the input source to this output.
     * @see M2tsKlv
     */
    public String klvAsString() {
        return klv;
    }

    /**
     * Packet Identifier (PID) for input source KLV data to this output. Multiple values are accepted, and can be
     * entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID specified
     * must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) for input source KLV data to this output. Multiple values are accepted, and can
     *         be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each
     *         PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String klvDataPids() {
        return klvDataPids;
    }

    /**
     * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
     * equivalent ID3 tag will be inserted in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenId3Behavior} will return {@link M2tsNielsenId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nielsenId3BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and
     *         an equivalent ID3 tag will be inserted in the output.
     * @see M2tsNielsenId3Behavior
     */
    public M2tsNielsenId3Behavior nielsenId3Behavior() {
        return M2tsNielsenId3Behavior.fromValue(nielsenId3Behavior);
    }

    /**
     * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
     * equivalent ID3 tag will be inserted in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenId3Behavior} will return {@link M2tsNielsenId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nielsenId3BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and
     *         an equivalent ID3 tag will be inserted in the output.
     * @see M2tsNielsenId3Behavior
     */
    public String nielsenId3BehaviorAsString() {
        return nielsenId3Behavior;
    }

    /**
     * Value in bits per second of extra null packets to insert into the transport stream. This can be used if a
     * downstream encryption system requires periodic null packets.
     * 
     * @return Value in bits per second of extra null packets to insert into the transport stream. This can be used if a
     *         downstream encryption system requires periodic null packets.
     */
    public Double nullPacketBitrate() {
        return nullPacketBitrate;
    }

    /**
     * The number of milliseconds between instances of this table in the output transport stream. Valid values are 0,
     * 10..1000.
     * 
     * @return The number of milliseconds between instances of this table in the output transport stream. Valid values
     *         are 0, 10..1000.
     */
    public Integer patInterval() {
        return patInterval;
    }

    /**
     * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream
     * (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary
     * stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pcrControl} will
     * return {@link M2tsPcrControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pcrControlAsString}.
     * </p>
     * 
     * @return When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
     *         Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
     *         video or audio elementary stream.
     * @see M2tsPcrControl
     */
    public M2tsPcrControl pcrControl() {
        return M2tsPcrControl.fromValue(pcrControl);
    }

    /**
     * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream
     * (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary
     * stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pcrControl} will
     * return {@link M2tsPcrControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pcrControlAsString}.
     * </p>
     * 
     * @return When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
     *         Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
     *         video or audio elementary stream.
     * @see M2tsPcrControl
     */
    public String pcrControlAsString() {
        return pcrControl;
    }

    /**
     * Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport stream.
     * 
     * @return Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport stream.
     */
    public Integer pcrPeriod() {
        return pcrPeriod;
    }

    /**
     * Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the
     * encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value. Valid
     * values are 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is
     *         given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or
     *         hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String pcrPid() {
        return pcrPid;
    }

    /**
     * The number of milliseconds between instances of this table in the output transport stream. Valid values are 0,
     * 10..1000.
     * 
     * @return The number of milliseconds between instances of this table in the output transport stream. Valid values
     *         are 0, 10..1000.
     */
    public Integer pmtInterval() {
        return pmtInterval;
    }

    /**
     * Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal or
     * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a
     *         decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String pmtPid() {
        return pmtPid;
    }

    /**
     * The value of the program number field in the Program Map Table.
     * 
     * @return The value of the program number field in the Program Map Table.
     */
    public Integer programNum() {
        return programNum;
    }

    /**
     * When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate setting acts
     * as the maximum bitrate when vbr is set.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateMode} will
     * return {@link M2tsRateMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rateModeAsString}.
     * </p>
     * 
     * @return When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate
     *         setting acts as the maximum bitrate when vbr is set.
     * @see M2tsRateMode
     */
    public M2tsRateMode rateMode() {
        return M2tsRateMode.fromValue(rateMode);
    }

    /**
     * When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate setting acts
     * as the maximum bitrate when vbr is set.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateMode} will
     * return {@link M2tsRateMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rateModeAsString}.
     * </p>
     * 
     * @return When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate
     *         setting acts as the maximum bitrate when vbr is set.
     * @see M2tsRateMode
     */
    public String rateModeAsString() {
        return rateMode;
    }

    /**
     * Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple values are accepted, and can be
     * entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID specified
     * must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple values are accepted, and
     *         can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.
     *         Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String scte27Pids() {
        return scte27Pids;
    }

    /**
     * Optionally pass SCTE-35 signals from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Control}
     * will return {@link M2tsScte35Control#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scte35ControlAsString}.
     * </p>
     * 
     * @return Optionally pass SCTE-35 signals from the input source to this output.
     * @see M2tsScte35Control
     */
    public M2tsScte35Control scte35Control() {
        return M2tsScte35Control.fromValue(scte35Control);
    }

    /**
     * Optionally pass SCTE-35 signals from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Control}
     * will return {@link M2tsScte35Control#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scte35ControlAsString}.
     * </p>
     * 
     * @return Optionally pass SCTE-35 signals from the input source to this output.
     * @see M2tsScte35Control
     */
    public String scte35ControlAsString() {
        return scte35Control;
    }

    /**
     * Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or hexadecimal
     * value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or
     *         hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String scte35Pid() {
        return scte35Pid;
    }

    /**
     * Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access Indicator bit in
     * the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the private data bytes.
     * psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to
     * the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point
     * information to the adaptation field using a legacy proprietary format.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentationMarkers} will return {@link M2tsSegmentationMarkers#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #segmentationMarkersAsString}.
     * </p>
     * 
     * @return Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access
     *         Indicator bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the
     *         private data bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder
     *         Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118.
     *         ebpLegacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary
     *         format.
     * @see M2tsSegmentationMarkers
     */
    public M2tsSegmentationMarkers segmentationMarkers() {
        return M2tsSegmentationMarkers.fromValue(segmentationMarkers);
    }

    /**
     * Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access Indicator bit in
     * the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the private data bytes.
     * psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to
     * the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point
     * information to the adaptation field using a legacy proprietary format.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentationMarkers} will return {@link M2tsSegmentationMarkers#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #segmentationMarkersAsString}.
     * </p>
     * 
     * @return Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access
     *         Indicator bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the
     *         private data bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder
     *         Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118.
     *         ebpLegacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary
     *         format.
     * @see M2tsSegmentationMarkers
     */
    public String segmentationMarkersAsString() {
        return segmentationMarkers;
    }

    /**
     * The segmentation style parameter controls how segmentation markers are inserted into the transport stream. With
     * avails, it is possible that segments may be truncated, which can influence where future segmentation markers are
     * inserted.
     *
     * When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we will reset
     * the segmentation cadence. This means the subsequent segment will have a duration of $segmentationTime seconds.
     *
     * When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail, we will
     * not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However,
     * all segments after that will have a duration of $segmentationTime seconds. Note that EBP lookahead is a slight
     * exception to this rule.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentationStyle}
     * will return {@link M2tsSegmentationStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #segmentationStyleAsString}.
     * </p>
     * 
     * @return The segmentation style parameter controls how segmentation markers are inserted into the transport
     *         stream. With avails, it is possible that segments may be truncated, which can influence where future
     *         segmentation markers are inserted.
     *
     *         When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we
     *         will reset the segmentation cadence. This means the subsequent segment will have a duration of
     *         $segmentationTime seconds.
     *
     *         When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail, we
     *         will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as
     *         well. However, all segments after that will have a duration of $segmentationTime seconds. Note that EBP
     *         lookahead is a slight exception to this rule.
     * @see M2tsSegmentationStyle
     */
    public M2tsSegmentationStyle segmentationStyle() {
        return M2tsSegmentationStyle.fromValue(segmentationStyle);
    }

    /**
     * The segmentation style parameter controls how segmentation markers are inserted into the transport stream. With
     * avails, it is possible that segments may be truncated, which can influence where future segmentation markers are
     * inserted.
     *
     * When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we will reset
     * the segmentation cadence. This means the subsequent segment will have a duration of $segmentationTime seconds.
     *
     * When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail, we will
     * not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However,
     * all segments after that will have a duration of $segmentationTime seconds. Note that EBP lookahead is a slight
     * exception to this rule.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentationStyle}
     * will return {@link M2tsSegmentationStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #segmentationStyleAsString}.
     * </p>
     * 
     * @return The segmentation style parameter controls how segmentation markers are inserted into the transport
     *         stream. With avails, it is possible that segments may be truncated, which can influence where future
     *         segmentation markers are inserted.
     *
     *         When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we
     *         will reset the segmentation cadence. This means the subsequent segment will have a duration of
     *         $segmentationTime seconds.
     *
     *         When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail, we
     *         will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as
     *         well. However, all segments after that will have a duration of $segmentationTime seconds. Note that EBP
     *         lookahead is a slight exception to this rule.
     * @see M2tsSegmentationStyle
     */
    public String segmentationStyleAsString() {
        return segmentationStyle;
    }

    /**
     * The length in seconds of each segment. Required unless markers is set to _none_.
     * 
     * @return The length in seconds of each segment. Required unless markers is set to _none_.
     */
    public Double segmentationTime() {
        return segmentationTime;
    }

    /**
     * When set to passthrough, timed metadata will be passed through from input to output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataBehavior} will return {@link M2tsTimedMetadataBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #timedMetadataBehaviorAsString}.
     * </p>
     * 
     * @return When set to passthrough, timed metadata will be passed through from input to output.
     * @see M2tsTimedMetadataBehavior
     */
    public M2tsTimedMetadataBehavior timedMetadataBehavior() {
        return M2tsTimedMetadataBehavior.fromValue(timedMetadataBehavior);
    }

    /**
     * When set to passthrough, timed metadata will be passed through from input to output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataBehavior} will return {@link M2tsTimedMetadataBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #timedMetadataBehaviorAsString}.
     * </p>
     * 
     * @return When set to passthrough, timed metadata will be passed through from input to output.
     * @see M2tsTimedMetadataBehavior
     */
    public String timedMetadataBehaviorAsString() {
        return timedMetadataBehavior;
    }

    /**
     * Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or
     * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal
     *         or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String timedMetadataPid() {
        return timedMetadataPid;
    }

    /**
     * The value of the transport stream ID field in the Program Map Table.
     * 
     * @return The value of the transport stream ID field in the Program Map Table.
     */
    public Integer transportStreamId() {
        return transportStreamId;
    }

    /**
     * Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal or
     * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a
     *         decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public String videoPid() {
        return videoPid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(absentInputAudioBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aribAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aribCaptionsPid());
        hashCode = 31 * hashCode + Objects.hashCode(aribCaptionsPidControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(audioBufferModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(audioFramesPerPes());
        hashCode = 31 * hashCode + Objects.hashCode(audioPids());
        hashCode = 31 * hashCode + Objects.hashCode(audioStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(bufferModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ccDescriptorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dvbNitSettings());
        hashCode = 31 * hashCode + Objects.hashCode(dvbSdtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(dvbSubPids());
        hashCode = 31 * hashCode + Objects.hashCode(dvbTdtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(dvbTeletextPid());
        hashCode = 31 * hashCode + Objects.hashCode(ebifAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ebpAudioIntervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ebpLookaheadMs());
        hashCode = 31 * hashCode + Objects.hashCode(ebpPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ecmPid());
        hashCode = 31 * hashCode + Objects.hashCode(esRateInPesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(etvPlatformPid());
        hashCode = 31 * hashCode + Objects.hashCode(etvSignalPid());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentTime());
        hashCode = 31 * hashCode + Objects.hashCode(klvAsString());
        hashCode = 31 * hashCode + Objects.hashCode(klvDataPids());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenId3BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nullPacketBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(patInterval());
        hashCode = 31 * hashCode + Objects.hashCode(pcrControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pcrPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(pcrPid());
        hashCode = 31 * hashCode + Objects.hashCode(pmtInterval());
        hashCode = 31 * hashCode + Objects.hashCode(pmtPid());
        hashCode = 31 * hashCode + Objects.hashCode(programNum());
        hashCode = 31 * hashCode + Objects.hashCode(rateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte27Pids());
        hashCode = 31 * hashCode + Objects.hashCode(scte35ControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte35Pid());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationTime());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataPid());
        hashCode = 31 * hashCode + Objects.hashCode(transportStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(videoPid());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2tsSettings)) {
            return false;
        }
        M2tsSettings other = (M2tsSettings) obj;
        return Objects.equals(absentInputAudioBehaviorAsString(), other.absentInputAudioBehaviorAsString())
                && Objects.equals(aribAsString(), other.aribAsString())
                && Objects.equals(aribCaptionsPid(), other.aribCaptionsPid())
                && Objects.equals(aribCaptionsPidControlAsString(), other.aribCaptionsPidControlAsString())
                && Objects.equals(audioBufferModelAsString(), other.audioBufferModelAsString())
                && Objects.equals(audioFramesPerPes(), other.audioFramesPerPes())
                && Objects.equals(audioPids(), other.audioPids())
                && Objects.equals(audioStreamTypeAsString(), other.audioStreamTypeAsString())
                && Objects.equals(bitrate(), other.bitrate())
                && Objects.equals(bufferModelAsString(), other.bufferModelAsString())
                && Objects.equals(ccDescriptorAsString(), other.ccDescriptorAsString())
                && Objects.equals(dvbNitSettings(), other.dvbNitSettings())
                && Objects.equals(dvbSdtSettings(), other.dvbSdtSettings()) && Objects.equals(dvbSubPids(), other.dvbSubPids())
                && Objects.equals(dvbTdtSettings(), other.dvbTdtSettings())
                && Objects.equals(dvbTeletextPid(), other.dvbTeletextPid())
                && Objects.equals(ebifAsString(), other.ebifAsString())
                && Objects.equals(ebpAudioIntervalAsString(), other.ebpAudioIntervalAsString())
                && Objects.equals(ebpLookaheadMs(), other.ebpLookaheadMs())
                && Objects.equals(ebpPlacementAsString(), other.ebpPlacementAsString())
                && Objects.equals(ecmPid(), other.ecmPid()) && Objects.equals(esRateInPesAsString(), other.esRateInPesAsString())
                && Objects.equals(etvPlatformPid(), other.etvPlatformPid())
                && Objects.equals(etvSignalPid(), other.etvSignalPid()) && Objects.equals(fragmentTime(), other.fragmentTime())
                && Objects.equals(klvAsString(), other.klvAsString()) && Objects.equals(klvDataPids(), other.klvDataPids())
                && Objects.equals(nielsenId3BehaviorAsString(), other.nielsenId3BehaviorAsString())
                && Objects.equals(nullPacketBitrate(), other.nullPacketBitrate())
                && Objects.equals(patInterval(), other.patInterval())
                && Objects.equals(pcrControlAsString(), other.pcrControlAsString())
                && Objects.equals(pcrPeriod(), other.pcrPeriod()) && Objects.equals(pcrPid(), other.pcrPid())
                && Objects.equals(pmtInterval(), other.pmtInterval()) && Objects.equals(pmtPid(), other.pmtPid())
                && Objects.equals(programNum(), other.programNum())
                && Objects.equals(rateModeAsString(), other.rateModeAsString())
                && Objects.equals(scte27Pids(), other.scte27Pids())
                && Objects.equals(scte35ControlAsString(), other.scte35ControlAsString())
                && Objects.equals(scte35Pid(), other.scte35Pid())
                && Objects.equals(segmentationMarkersAsString(), other.segmentationMarkersAsString())
                && Objects.equals(segmentationStyleAsString(), other.segmentationStyleAsString())
                && Objects.equals(segmentationTime(), other.segmentationTime())
                && Objects.equals(timedMetadataBehaviorAsString(), other.timedMetadataBehaviorAsString())
                && Objects.equals(timedMetadataPid(), other.timedMetadataPid())
                && Objects.equals(transportStreamId(), other.transportStreamId()) && Objects.equals(videoPid(), other.videoPid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("M2tsSettings").add("AbsentInputAudioBehavior", absentInputAudioBehaviorAsString())
                .add("Arib", aribAsString()).add("AribCaptionsPid", aribCaptionsPid())
                .add("AribCaptionsPidControl", aribCaptionsPidControlAsString())
                .add("AudioBufferModel", audioBufferModelAsString()).add("AudioFramesPerPes", audioFramesPerPes())
                .add("AudioPids", audioPids()).add("AudioStreamType", audioStreamTypeAsString()).add("Bitrate", bitrate())
                .add("BufferModel", bufferModelAsString()).add("CcDescriptor", ccDescriptorAsString())
                .add("DvbNitSettings", dvbNitSettings()).add("DvbSdtSettings", dvbSdtSettings()).add("DvbSubPids", dvbSubPids())
                .add("DvbTdtSettings", dvbTdtSettings()).add("DvbTeletextPid", dvbTeletextPid()).add("Ebif", ebifAsString())
                .add("EbpAudioInterval", ebpAudioIntervalAsString()).add("EbpLookaheadMs", ebpLookaheadMs())
                .add("EbpPlacement", ebpPlacementAsString()).add("EcmPid", ecmPid()).add("EsRateInPes", esRateInPesAsString())
                .add("EtvPlatformPid", etvPlatformPid()).add("EtvSignalPid", etvSignalPid()).add("FragmentTime", fragmentTime())
                .add("Klv", klvAsString()).add("KlvDataPids", klvDataPids())
                .add("NielsenId3Behavior", nielsenId3BehaviorAsString()).add("NullPacketBitrate", nullPacketBitrate())
                .add("PatInterval", patInterval()).add("PcrControl", pcrControlAsString()).add("PcrPeriod", pcrPeriod())
                .add("PcrPid", pcrPid()).add("PmtInterval", pmtInterval()).add("PmtPid", pmtPid())
                .add("ProgramNum", programNum()).add("RateMode", rateModeAsString()).add("Scte27Pids", scte27Pids())
                .add("Scte35Control", scte35ControlAsString()).add("Scte35Pid", scte35Pid())
                .add("SegmentationMarkers", segmentationMarkersAsString()).add("SegmentationStyle", segmentationStyleAsString())
                .add("SegmentationTime", segmentationTime()).add("TimedMetadataBehavior", timedMetadataBehaviorAsString())
                .add("TimedMetadataPid", timedMetadataPid()).add("TransportStreamId", transportStreamId())
                .add("VideoPid", videoPid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AbsentInputAudioBehavior":
            return Optional.ofNullable(clazz.cast(absentInputAudioBehaviorAsString()));
        case "Arib":
            return Optional.ofNullable(clazz.cast(aribAsString()));
        case "AribCaptionsPid":
            return Optional.ofNullable(clazz.cast(aribCaptionsPid()));
        case "AribCaptionsPidControl":
            return Optional.ofNullable(clazz.cast(aribCaptionsPidControlAsString()));
        case "AudioBufferModel":
            return Optional.ofNullable(clazz.cast(audioBufferModelAsString()));
        case "AudioFramesPerPes":
            return Optional.ofNullable(clazz.cast(audioFramesPerPes()));
        case "AudioPids":
            return Optional.ofNullable(clazz.cast(audioPids()));
        case "AudioStreamType":
            return Optional.ofNullable(clazz.cast(audioStreamTypeAsString()));
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "BufferModel":
            return Optional.ofNullable(clazz.cast(bufferModelAsString()));
        case "CcDescriptor":
            return Optional.ofNullable(clazz.cast(ccDescriptorAsString()));
        case "DvbNitSettings":
            return Optional.ofNullable(clazz.cast(dvbNitSettings()));
        case "DvbSdtSettings":
            return Optional.ofNullable(clazz.cast(dvbSdtSettings()));
        case "DvbSubPids":
            return Optional.ofNullable(clazz.cast(dvbSubPids()));
        case "DvbTdtSettings":
            return Optional.ofNullable(clazz.cast(dvbTdtSettings()));
        case "DvbTeletextPid":
            return Optional.ofNullable(clazz.cast(dvbTeletextPid()));
        case "Ebif":
            return Optional.ofNullable(clazz.cast(ebifAsString()));
        case "EbpAudioInterval":
            return Optional.ofNullable(clazz.cast(ebpAudioIntervalAsString()));
        case "EbpLookaheadMs":
            return Optional.ofNullable(clazz.cast(ebpLookaheadMs()));
        case "EbpPlacement":
            return Optional.ofNullable(clazz.cast(ebpPlacementAsString()));
        case "EcmPid":
            return Optional.ofNullable(clazz.cast(ecmPid()));
        case "EsRateInPes":
            return Optional.ofNullable(clazz.cast(esRateInPesAsString()));
        case "EtvPlatformPid":
            return Optional.ofNullable(clazz.cast(etvPlatformPid()));
        case "EtvSignalPid":
            return Optional.ofNullable(clazz.cast(etvSignalPid()));
        case "FragmentTime":
            return Optional.ofNullable(clazz.cast(fragmentTime()));
        case "Klv":
            return Optional.ofNullable(clazz.cast(klvAsString()));
        case "KlvDataPids":
            return Optional.ofNullable(clazz.cast(klvDataPids()));
        case "NielsenId3Behavior":
            return Optional.ofNullable(clazz.cast(nielsenId3BehaviorAsString()));
        case "NullPacketBitrate":
            return Optional.ofNullable(clazz.cast(nullPacketBitrate()));
        case "PatInterval":
            return Optional.ofNullable(clazz.cast(patInterval()));
        case "PcrControl":
            return Optional.ofNullable(clazz.cast(pcrControlAsString()));
        case "PcrPeriod":
            return Optional.ofNullable(clazz.cast(pcrPeriod()));
        case "PcrPid":
            return Optional.ofNullable(clazz.cast(pcrPid()));
        case "PmtInterval":
            return Optional.ofNullable(clazz.cast(pmtInterval()));
        case "PmtPid":
            return Optional.ofNullable(clazz.cast(pmtPid()));
        case "ProgramNum":
            return Optional.ofNullable(clazz.cast(programNum()));
        case "RateMode":
            return Optional.ofNullable(clazz.cast(rateModeAsString()));
        case "Scte27Pids":
            return Optional.ofNullable(clazz.cast(scte27Pids()));
        case "Scte35Control":
            return Optional.ofNullable(clazz.cast(scte35ControlAsString()));
        case "Scte35Pid":
            return Optional.ofNullable(clazz.cast(scte35Pid()));
        case "SegmentationMarkers":
            return Optional.ofNullable(clazz.cast(segmentationMarkersAsString()));
        case "SegmentationStyle":
            return Optional.ofNullable(clazz.cast(segmentationStyleAsString()));
        case "SegmentationTime":
            return Optional.ofNullable(clazz.cast(segmentationTime()));
        case "TimedMetadataBehavior":
            return Optional.ofNullable(clazz.cast(timedMetadataBehaviorAsString()));
        case "TimedMetadataPid":
            return Optional.ofNullable(clazz.cast(timedMetadataPid()));
        case "TransportStreamId":
            return Optional.ofNullable(clazz.cast(transportStreamId()));
        case "VideoPid":
            return Optional.ofNullable(clazz.cast(videoPid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<M2tsSettings, T> g) {
        return obj -> g.apply((M2tsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, M2tsSettings> {
        /**
         * When set to drop, output audio streams will be removed from the program if the selected input audio stream is
         * removed from the input. This allows the output audio configuration to dynamically change based on input
         * configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not
         * connected to an active input stream.
         * 
         * @param absentInputAudioBehavior
         *        When set to drop, output audio streams will be removed from the program if the selected input audio
         *        stream is removed from the input. This allows the output audio configuration to dynamically change
         *        based on input configuration. If this is set to encodeSilence, all output audio streams will output
         *        encoded silence when not connected to an active input stream.
         * @see M2tsAbsentInputAudioBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAbsentInputAudioBehavior
         */
        Builder absentInputAudioBehavior(String absentInputAudioBehavior);

        /**
         * When set to drop, output audio streams will be removed from the program if the selected input audio stream is
         * removed from the input. This allows the output audio configuration to dynamically change based on input
         * configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not
         * connected to an active input stream.
         * 
         * @param absentInputAudioBehavior
         *        When set to drop, output audio streams will be removed from the program if the selected input audio
         *        stream is removed from the input. This allows the output audio configuration to dynamically change
         *        based on input configuration. If this is set to encodeSilence, all output audio streams will output
         *        encoded silence when not connected to an active input stream.
         * @see M2tsAbsentInputAudioBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAbsentInputAudioBehavior
         */
        Builder absentInputAudioBehavior(M2tsAbsentInputAudioBehavior absentInputAudioBehavior);

        /**
         * When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
         * 
         * @param arib
         *        When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
         * @see M2tsArib
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsArib
         */
        Builder arib(String arib);

        /**
         * When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
         * 
         * @param arib
         *        When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
         * @see M2tsArib
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsArib
         */
        Builder arib(M2tsArib arib);

        /**
         * Packet Identifier (PID) for ARIB Captions in the transport stream. Can be entered as a decimal or hexadecimal
         * value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param aribCaptionsPid
         *        Packet Identifier (PID) for ARIB Captions in the transport stream. Can be entered as a decimal or
         *        hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aribCaptionsPid(String aribCaptionsPid);

        /**
         * If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids. If set to
         * useConfigured, ARIB Captions will be on the configured pid number.
         * 
         * @param aribCaptionsPidControl
         *        If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids. If set to
         *        useConfigured, ARIB Captions will be on the configured pid number.
         * @see M2tsAribCaptionsPidControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAribCaptionsPidControl
         */
        Builder aribCaptionsPidControl(String aribCaptionsPidControl);

        /**
         * If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids. If set to
         * useConfigured, ARIB Captions will be on the configured pid number.
         * 
         * @param aribCaptionsPidControl
         *        If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids. If set to
         *        useConfigured, ARIB Captions will be on the configured pid number.
         * @see M2tsAribCaptionsPidControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAribCaptionsPidControl
         */
        Builder aribCaptionsPidControl(M2tsAribCaptionsPidControl aribCaptionsPidControl);

        /**
         * When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
         * 
         * @param audioBufferModel
         *        When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is
         *        used.
         * @see M2tsAudioBufferModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAudioBufferModel
         */
        Builder audioBufferModel(String audioBufferModel);

        /**
         * When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
         * 
         * @param audioBufferModel
         *        When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is
         *        used.
         * @see M2tsAudioBufferModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAudioBufferModel
         */
        Builder audioBufferModel(M2tsAudioBufferModel audioBufferModel);

        /**
         * The number of audio frames to insert for each PES packet.
         * 
         * @param audioFramesPerPes
         *        The number of audio frames to insert for each PES packet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioFramesPerPes(Integer audioFramesPerPes);

        /**
         * Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are
         * accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal
         * values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param audioPids
         *        Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are
         *        accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or
         *        hexadecimal values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioPids(String audioPids);

        /**
         * When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses
         * stream type = 0x06.
         * 
         * @param audioStreamType
         *        When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb,
         *        uses stream type = 0x06.
         * @see M2tsAudioStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAudioStreamType
         */
        Builder audioStreamType(String audioStreamType);

        /**
         * When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses
         * stream type = 0x06.
         * 
         * @param audioStreamType
         *        When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb,
         *        uses stream type = 0x06.
         * @see M2tsAudioStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAudioStreamType
         */
        Builder audioStreamType(M2tsAudioStreamType audioStreamType);

        /**
         * The output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer automatically
         * determine the appropriate bitrate.
         * 
         * @param bitrate
         *        The output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer
         *        automatically determine the appropriate bitrate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * If set to multiplex, use multiplex buffer model for accurate interleaving. Setting to bufferModel to none can
         * lead to lower latency, but low-memory devices may not be able to play back the stream without interruptions.
         * 
         * @param bufferModel
         *        If set to multiplex, use multiplex buffer model for accurate interleaving. Setting to bufferModel to
         *        none can lead to lower latency, but low-memory devices may not be able to play back the stream without
         *        interruptions.
         * @see M2tsBufferModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsBufferModel
         */
        Builder bufferModel(String bufferModel);

        /**
         * If set to multiplex, use multiplex buffer model for accurate interleaving. Setting to bufferModel to none can
         * lead to lower latency, but low-memory devices may not be able to play back the stream without interruptions.
         * 
         * @param bufferModel
         *        If set to multiplex, use multiplex buffer model for accurate interleaving. Setting to bufferModel to
         *        none can lead to lower latency, but low-memory devices may not be able to play back the stream without
         *        interruptions.
         * @see M2tsBufferModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsBufferModel
         */
        Builder bufferModel(M2tsBufferModel bufferModel);

        /**
         * When set to enabled, generates captionServiceDescriptor in PMT.
         * 
         * @param ccDescriptor
         *        When set to enabled, generates captionServiceDescriptor in PMT.
         * @see M2tsCcDescriptor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsCcDescriptor
         */
        Builder ccDescriptor(String ccDescriptor);

        /**
         * When set to enabled, generates captionServiceDescriptor in PMT.
         * 
         * @param ccDescriptor
         *        When set to enabled, generates captionServiceDescriptor in PMT.
         * @see M2tsCcDescriptor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsCcDescriptor
         */
        Builder ccDescriptor(M2tsCcDescriptor ccDescriptor);

        /**
         * Inserts DVB Network Information Table (NIT) at the specified table repetition interval.
         * 
         * @param dvbNitSettings
         *        Inserts DVB Network Information Table (NIT) at the specified table repetition interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbNitSettings(DvbNitSettings dvbNitSettings);

        /**
         * Inserts DVB Network Information Table (NIT) at the specified table repetition interval. This is a convenience
         * that creates an instance of the {@link DvbNitSettings.Builder} avoiding the need to create one manually via
         * {@link DvbNitSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DvbNitSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #dvbNitSettings(DvbNitSettings)}.
         * 
         * @param dvbNitSettings
         *        a consumer that will call methods on {@link DvbNitSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dvbNitSettings(DvbNitSettings)
         */
        default Builder dvbNitSettings(Consumer<DvbNitSettings.Builder> dvbNitSettings) {
            return dvbNitSettings(DvbNitSettings.builder().applyMutation(dvbNitSettings).build());
        }

        /**
         * Inserts DVB Service Description Table (SDT) at the specified table repetition interval.
         * 
         * @param dvbSdtSettings
         *        Inserts DVB Service Description Table (SDT) at the specified table repetition interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbSdtSettings(DvbSdtSettings dvbSdtSettings);

        /**
         * Inserts DVB Service Description Table (SDT) at the specified table repetition interval. This is a convenience
         * that creates an instance of the {@link DvbSdtSettings.Builder} avoiding the need to create one manually via
         * {@link DvbSdtSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DvbSdtSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #dvbSdtSettings(DvbSdtSettings)}.
         * 
         * @param dvbSdtSettings
         *        a consumer that will call methods on {@link DvbSdtSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dvbSdtSettings(DvbSdtSettings)
         */
        default Builder dvbSdtSettings(Consumer<DvbSdtSettings.Builder> dvbSdtSettings) {
            return dvbSdtSettings(DvbSdtSettings.builder().applyMutation(dvbSdtSettings).build());
        }

        /**
         * Packet Identifier (PID) for input source DVB Subtitle data to this output. Multiple values are accepted, and
         * can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each
         * PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param dvbSubPids
         *        Packet Identifier (PID) for input source DVB Subtitle data to this output. Multiple values are
         *        accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or
         *        hexadecimal values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbSubPids(String dvbSubPids);

        /**
         * Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.
         * 
         * @param dvbTdtSettings
         *        Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbTdtSettings(DvbTdtSettings dvbTdtSettings);

        /**
         * Inserts DVB Time and Date Table (TDT) at the specified table repetition interval. This is a convenience that
         * creates an instance of the {@link DvbTdtSettings.Builder} avoiding the need to create one manually via
         * {@link DvbTdtSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DvbTdtSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #dvbTdtSettings(DvbTdtSettings)}.
         * 
         * @param dvbTdtSettings
         *        a consumer that will call methods on {@link DvbTdtSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dvbTdtSettings(DvbTdtSettings)
         */
        default Builder dvbTdtSettings(Consumer<DvbTdtSettings.Builder> dvbTdtSettings) {
            return dvbTdtSettings(DvbTdtSettings.builder().applyMutation(dvbTdtSettings).build());
        }

        /**
         * Packet Identifier (PID) for input source DVB Teletext data to this output. Can be entered as a decimal or
         * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param dvbTeletextPid
         *        Packet Identifier (PID) for input source DVB Teletext data to this output. Can be entered as a decimal
         *        or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbTeletextPid(String dvbTeletextPid);

        /**
         * If set to passthrough, passes any EBIF data from the input source to this output.
         * 
         * @param ebif
         *        If set to passthrough, passes any EBIF data from the input source to this output.
         * @see M2tsEbifControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsEbifControl
         */
        Builder ebif(String ebif);

        /**
         * If set to passthrough, passes any EBIF data from the input source to this output.
         * 
         * @param ebif
         *        If set to passthrough, passes any EBIF data from the input source to this output.
         * @see M2tsEbifControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsEbifControl
         */
        Builder ebif(M2tsEbifControl ebif);

        /**
         * When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The interval
         * between these additional markers will be fixed, and will be slightly shorter than the video EBP marker
         * interval. Only available when EBP Cablelabs segmentation markers are selected. Partitions 1 and 2 will always
         * follow the video interval.
         * 
         * @param ebpAudioInterval
         *        When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The
         *        interval between these additional markers will be fixed, and will be slightly shorter than the video
         *        EBP marker interval. Only available when EBP Cablelabs segmentation markers are selected. Partitions 1
         *        and 2 will always follow the video interval.
         * @see M2tsAudioInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAudioInterval
         */
        Builder ebpAudioInterval(String ebpAudioInterval);

        /**
         * When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The interval
         * between these additional markers will be fixed, and will be slightly shorter than the video EBP marker
         * interval. Only available when EBP Cablelabs segmentation markers are selected. Partitions 1 and 2 will always
         * follow the video interval.
         * 
         * @param ebpAudioInterval
         *        When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The
         *        interval between these additional markers will be fixed, and will be slightly shorter than the video
         *        EBP marker interval. Only available when EBP Cablelabs segmentation markers are selected. Partitions 1
         *        and 2 will always follow the video interval.
         * @see M2tsAudioInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAudioInterval
         */
        Builder ebpAudioInterval(M2tsAudioInterval ebpAudioInterval);

        /**
         * When set, enforces that Encoder Boundary Points do not come within the specified time interval of each other
         * by looking ahead at input video. If another EBP is going to come in within the specified time interval, the
         * current EBP is not emitted, and the segment is "stretched" to the next marker. The lookahead value does not
         * add latency to the system. The Live Event must be configured elsewhere to create sufficient latency to make
         * the lookahead accurate.
         * 
         * @param ebpLookaheadMs
         *        When set, enforces that Encoder Boundary Points do not come within the specified time interval of each
         *        other by looking ahead at input video. If another EBP is going to come in within the specified time
         *        interval, the current EBP is not emitted, and the segment is "stretched" to the next marker. The
         *        lookahead value does not add latency to the system. The Live Event must be configured elsewhere to
         *        create sufficient latency to make the lookahead accurate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebpLookaheadMs(Integer ebpLookaheadMs);

        /**
         * Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on the video
         * PID and all audio PIDs. If set to videoPid, EBP markers will be placed on only the video PID.
         * 
         * @param ebpPlacement
         *        Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on
         *        the video PID and all audio PIDs. If set to videoPid, EBP markers will be placed on only the video
         *        PID.
         * @see M2tsEbpPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsEbpPlacement
         */
        Builder ebpPlacement(String ebpPlacement);

        /**
         * Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on the video
         * PID and all audio PIDs. If set to videoPid, EBP markers will be placed on only the video PID.
         * 
         * @param ebpPlacement
         *        Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on
         *        the video PID and all audio PIDs. If set to videoPid, EBP markers will be placed on only the video
         *        PID.
         * @see M2tsEbpPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsEbpPlacement
         */
        Builder ebpPlacement(M2tsEbpPlacement ebpPlacement);

        /**
         * This field is unused and deprecated.
         * 
         * @param ecmPid
         *        This field is unused and deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecmPid(String ecmPid);

        /**
         * Include or exclude the ES Rate field in the PES header.
         * 
         * @param esRateInPes
         *        Include or exclude the ES Rate field in the PES header.
         * @see M2tsEsRateInPes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsEsRateInPes
         */
        Builder esRateInPes(String esRateInPes);

        /**
         * Include or exclude the ES Rate field in the PES header.
         * 
         * @param esRateInPes
         *        Include or exclude the ES Rate field in the PES header.
         * @see M2tsEsRateInPes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsEsRateInPes
         */
        Builder esRateInPes(M2tsEsRateInPes esRateInPes);

        /**
         * Packet Identifier (PID) for input source ETV Platform data to this output. Can be entered as a decimal or
         * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param etvPlatformPid
         *        Packet Identifier (PID) for input source ETV Platform data to this output. Can be entered as a decimal
         *        or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder etvPlatformPid(String etvPlatformPid);

        /**
         * Packet Identifier (PID) for input source ETV Signal data to this output. Can be entered as a decimal or
         * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param etvSignalPid
         *        Packet Identifier (PID) for input source ETV Signal data to this output. Can be entered as a decimal
         *        or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder etvSignalPid(String etvSignalPid);

        /**
         * The length in seconds of each fragment. Only used with EBP markers.
         * 
         * @param fragmentTime
         *        The length in seconds of each fragment. Only used with EBP markers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentTime(Double fragmentTime);

        /**
         * If set to passthrough, passes any KLV data from the input source to this output.
         * 
         * @param klv
         *        If set to passthrough, passes any KLV data from the input source to this output.
         * @see M2tsKlv
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsKlv
         */
        Builder klv(String klv);

        /**
         * If set to passthrough, passes any KLV data from the input source to this output.
         * 
         * @param klv
         *        If set to passthrough, passes any KLV data from the input source to this output.
         * @see M2tsKlv
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsKlv
         */
        Builder klv(M2tsKlv klv);

        /**
         * Packet Identifier (PID) for input source KLV data to this output. Multiple values are accepted, and can be
         * entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID
         * specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param klvDataPids
         *        Packet Identifier (PID) for input source KLV data to this output. Multiple values are accepted, and
         *        can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.
         *        Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder klvDataPids(String klvDataPids);

        /**
         * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
         * equivalent ID3 tag will be inserted in the output.
         * 
         * @param nielsenId3Behavior
         *        If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio
         *        and an equivalent ID3 tag will be inserted in the output.
         * @see M2tsNielsenId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsNielsenId3Behavior
         */
        Builder nielsenId3Behavior(String nielsenId3Behavior);

        /**
         * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
         * equivalent ID3 tag will be inserted in the output.
         * 
         * @param nielsenId3Behavior
         *        If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio
         *        and an equivalent ID3 tag will be inserted in the output.
         * @see M2tsNielsenId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsNielsenId3Behavior
         */
        Builder nielsenId3Behavior(M2tsNielsenId3Behavior nielsenId3Behavior);

        /**
         * Value in bits per second of extra null packets to insert into the transport stream. This can be used if a
         * downstream encryption system requires periodic null packets.
         * 
         * @param nullPacketBitrate
         *        Value in bits per second of extra null packets to insert into the transport stream. This can be used
         *        if a downstream encryption system requires periodic null packets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullPacketBitrate(Double nullPacketBitrate);

        /**
         * The number of milliseconds between instances of this table in the output transport stream. Valid values are
         * 0, 10..1000.
         * 
         * @param patInterval
         *        The number of milliseconds between instances of this table in the output transport stream. Valid
         *        values are 0, 10..1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patInterval(Integer patInterval);

        /**
         * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary
         * Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio
         * elementary stream.
         * 
         * @param pcrControl
         *        When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
         *        Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
         *        video or audio elementary stream.
         * @see M2tsPcrControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsPcrControl
         */
        Builder pcrControl(String pcrControl);

        /**
         * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary
         * Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio
         * elementary stream.
         * 
         * @param pcrControl
         *        When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
         *        Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
         *        video or audio elementary stream.
         * @see M2tsPcrControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsPcrControl
         */
        Builder pcrControl(M2tsPcrControl pcrControl);

        /**
         * Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport stream.
         * 
         * @param pcrPeriod
         *        Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pcrPeriod(Integer pcrPeriod);

        /**
         * Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given,
         * the encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value.
         * Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param pcrPid
         *        Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is
         *        given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or
         *        hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pcrPid(String pcrPid);

        /**
         * The number of milliseconds between instances of this table in the output transport stream. Valid values are
         * 0, 10..1000.
         * 
         * @param pmtInterval
         *        The number of milliseconds between instances of this table in the output transport stream. Valid
         *        values are 0, 10..1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pmtInterval(Integer pmtInterval);

        /**
         * Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal
         * or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param pmtPid
         *        Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a
         *        decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pmtPid(String pmtPid);

        /**
         * The value of the program number field in the Program Map Table.
         * 
         * @param programNum
         *        The value of the program number field in the Program Map Table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programNum(Integer programNum);

        /**
         * When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate setting
         * acts as the maximum bitrate when vbr is set.
         * 
         * @param rateMode
         *        When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate
         *        setting acts as the maximum bitrate when vbr is set.
         * @see M2tsRateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsRateMode
         */
        Builder rateMode(String rateMode);

        /**
         * When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate setting
         * acts as the maximum bitrate when vbr is set.
         * 
         * @param rateMode
         *        When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate
         *        setting acts as the maximum bitrate when vbr is set.
         * @see M2tsRateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsRateMode
         */
        Builder rateMode(M2tsRateMode rateMode);

        /**
         * Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple values are accepted, and can
         * be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID
         * specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param scte27Pids
         *        Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple values are accepted,
         *        and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal
         *        values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte27Pids(String scte27Pids);

        /**
         * Optionally pass SCTE-35 signals from the input source to this output.
         * 
         * @param scte35Control
         *        Optionally pass SCTE-35 signals from the input source to this output.
         * @see M2tsScte35Control
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsScte35Control
         */
        Builder scte35Control(String scte35Control);

        /**
         * Optionally pass SCTE-35 signals from the input source to this output.
         * 
         * @param scte35Control
         *        Optionally pass SCTE-35 signals from the input source to this output.
         * @see M2tsScte35Control
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsScte35Control
         */
        Builder scte35Control(M2tsScte35Control scte35Control);

        /**
         * Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or
         * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param scte35Pid
         *        Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or
         *        hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35Pid(String scte35Pid);

        /**
         * Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access Indicator
         * bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the private data
         * bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point
         * information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebpLegacy adds
         * Encoder Boundary Point information to the adaptation field using a legacy proprietary format.
         * 
         * @param segmentationMarkers
         *        Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access
         *        Indicator bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the
         *        private data bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder
         *        Boundary Point information to the adaptation field as per OpenCable specification
         *        OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to the adaptation field using
         *        a legacy proprietary format.
         * @see M2tsSegmentationMarkers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsSegmentationMarkers
         */
        Builder segmentationMarkers(String segmentationMarkers);

        /**
         * Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access Indicator
         * bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the private data
         * bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point
         * information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebpLegacy adds
         * Encoder Boundary Point information to the adaptation field using a legacy proprietary format.
         * 
         * @param segmentationMarkers
         *        Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access
         *        Indicator bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the
         *        private data bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder
         *        Boundary Point information to the adaptation field as per OpenCable specification
         *        OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to the adaptation field using
         *        a legacy proprietary format.
         * @see M2tsSegmentationMarkers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsSegmentationMarkers
         */
        Builder segmentationMarkers(M2tsSegmentationMarkers segmentationMarkers);

        /**
         * The segmentation style parameter controls how segmentation markers are inserted into the transport stream.
         * With avails, it is possible that segments may be truncated, which can influence where future segmentation
         * markers are inserted.
         *
         * When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we will
         * reset the segmentation cadence. This means the subsequent segment will have a duration of $segmentationTime
         * seconds.
         *
         * When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail, we
         * will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well.
         * However, all segments after that will have a duration of $segmentationTime seconds. Note that EBP lookahead
         * is a slight exception to this rule.
         * 
         * @param segmentationStyle
         *        The segmentation style parameter controls how segmentation markers are inserted into the transport
         *        stream. With avails, it is possible that segments may be truncated, which can influence where future
         *        segmentation markers are inserted.
         *
         *        When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we
         *        will reset the segmentation cadence. This means the subsequent segment will have a duration of
         *        $segmentationTime seconds.
         *
         *        When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail,
         *        we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated
         *        as well. However, all segments after that will have a duration of $segmentationTime seconds. Note that
         *        EBP lookahead is a slight exception to this rule.
         * @see M2tsSegmentationStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsSegmentationStyle
         */
        Builder segmentationStyle(String segmentationStyle);

        /**
         * The segmentation style parameter controls how segmentation markers are inserted into the transport stream.
         * With avails, it is possible that segments may be truncated, which can influence where future segmentation
         * markers are inserted.
         *
         * When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we will
         * reset the segmentation cadence. This means the subsequent segment will have a duration of $segmentationTime
         * seconds.
         *
         * When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail, we
         * will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well.
         * However, all segments after that will have a duration of $segmentationTime seconds. Note that EBP lookahead
         * is a slight exception to this rule.
         * 
         * @param segmentationStyle
         *        The segmentation style parameter controls how segmentation markers are inserted into the transport
         *        stream. With avails, it is possible that segments may be truncated, which can influence where future
         *        segmentation markers are inserted.
         *
         *        When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we
         *        will reset the segmentation cadence. This means the subsequent segment will have a duration of
         *        $segmentationTime seconds.
         *
         *        When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail,
         *        we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated
         *        as well. However, all segments after that will have a duration of $segmentationTime seconds. Note that
         *        EBP lookahead is a slight exception to this rule.
         * @see M2tsSegmentationStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsSegmentationStyle
         */
        Builder segmentationStyle(M2tsSegmentationStyle segmentationStyle);

        /**
         * The length in seconds of each segment. Required unless markers is set to _none_.
         * 
         * @param segmentationTime
         *        The length in seconds of each segment. Required unless markers is set to _none_.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationTime(Double segmentationTime);

        /**
         * When set to passthrough, timed metadata will be passed through from input to output.
         * 
         * @param timedMetadataBehavior
         *        When set to passthrough, timed metadata will be passed through from input to output.
         * @see M2tsTimedMetadataBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsTimedMetadataBehavior
         */
        Builder timedMetadataBehavior(String timedMetadataBehavior);

        /**
         * When set to passthrough, timed metadata will be passed through from input to output.
         * 
         * @param timedMetadataBehavior
         *        When set to passthrough, timed metadata will be passed through from input to output.
         * @see M2tsTimedMetadataBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsTimedMetadataBehavior
         */
        Builder timedMetadataBehavior(M2tsTimedMetadataBehavior timedMetadataBehavior);

        /**
         * Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or
         * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param timedMetadataPid
         *        Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a
         *        decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timedMetadataPid(String timedMetadataPid);

        /**
         * The value of the transport stream ID field in the Program Map Table.
         * 
         * @param transportStreamId
         *        The value of the transport stream ID field in the Program Map Table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportStreamId(Integer transportStreamId);

        /**
         * Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal
         * or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param videoPid
         *        Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a
         *        decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoPid(String videoPid);
    }

    static final class BuilderImpl implements Builder {
        private String absentInputAudioBehavior;

        private String arib;

        private String aribCaptionsPid;

        private String aribCaptionsPidControl;

        private String audioBufferModel;

        private Integer audioFramesPerPes;

        private String audioPids;

        private String audioStreamType;

        private Integer bitrate;

        private String bufferModel;

        private String ccDescriptor;

        private DvbNitSettings dvbNitSettings;

        private DvbSdtSettings dvbSdtSettings;

        private String dvbSubPids;

        private DvbTdtSettings dvbTdtSettings;

        private String dvbTeletextPid;

        private String ebif;

        private String ebpAudioInterval;

        private Integer ebpLookaheadMs;

        private String ebpPlacement;

        private String ecmPid;

        private String esRateInPes;

        private String etvPlatformPid;

        private String etvSignalPid;

        private Double fragmentTime;

        private String klv;

        private String klvDataPids;

        private String nielsenId3Behavior;

        private Double nullPacketBitrate;

        private Integer patInterval;

        private String pcrControl;

        private Integer pcrPeriod;

        private String pcrPid;

        private Integer pmtInterval;

        private String pmtPid;

        private Integer programNum;

        private String rateMode;

        private String scte27Pids;

        private String scte35Control;

        private String scte35Pid;

        private String segmentationMarkers;

        private String segmentationStyle;

        private Double segmentationTime;

        private String timedMetadataBehavior;

        private String timedMetadataPid;

        private Integer transportStreamId;

        private String videoPid;

        private BuilderImpl() {
        }

        private BuilderImpl(M2tsSettings model) {
            absentInputAudioBehavior(model.absentInputAudioBehavior);
            arib(model.arib);
            aribCaptionsPid(model.aribCaptionsPid);
            aribCaptionsPidControl(model.aribCaptionsPidControl);
            audioBufferModel(model.audioBufferModel);
            audioFramesPerPes(model.audioFramesPerPes);
            audioPids(model.audioPids);
            audioStreamType(model.audioStreamType);
            bitrate(model.bitrate);
            bufferModel(model.bufferModel);
            ccDescriptor(model.ccDescriptor);
            dvbNitSettings(model.dvbNitSettings);
            dvbSdtSettings(model.dvbSdtSettings);
            dvbSubPids(model.dvbSubPids);
            dvbTdtSettings(model.dvbTdtSettings);
            dvbTeletextPid(model.dvbTeletextPid);
            ebif(model.ebif);
            ebpAudioInterval(model.ebpAudioInterval);
            ebpLookaheadMs(model.ebpLookaheadMs);
            ebpPlacement(model.ebpPlacement);
            ecmPid(model.ecmPid);
            esRateInPes(model.esRateInPes);
            etvPlatformPid(model.etvPlatformPid);
            etvSignalPid(model.etvSignalPid);
            fragmentTime(model.fragmentTime);
            klv(model.klv);
            klvDataPids(model.klvDataPids);
            nielsenId3Behavior(model.nielsenId3Behavior);
            nullPacketBitrate(model.nullPacketBitrate);
            patInterval(model.patInterval);
            pcrControl(model.pcrControl);
            pcrPeriod(model.pcrPeriod);
            pcrPid(model.pcrPid);
            pmtInterval(model.pmtInterval);
            pmtPid(model.pmtPid);
            programNum(model.programNum);
            rateMode(model.rateMode);
            scte27Pids(model.scte27Pids);
            scte35Control(model.scte35Control);
            scte35Pid(model.scte35Pid);
            segmentationMarkers(model.segmentationMarkers);
            segmentationStyle(model.segmentationStyle);
            segmentationTime(model.segmentationTime);
            timedMetadataBehavior(model.timedMetadataBehavior);
            timedMetadataPid(model.timedMetadataPid);
            transportStreamId(model.transportStreamId);
            videoPid(model.videoPid);
        }

        public final String getAbsentInputAudioBehavior() {
            return absentInputAudioBehavior;
        }

        @Override
        public final Builder absentInputAudioBehavior(String absentInputAudioBehavior) {
            this.absentInputAudioBehavior = absentInputAudioBehavior;
            return this;
        }

        @Override
        public final Builder absentInputAudioBehavior(M2tsAbsentInputAudioBehavior absentInputAudioBehavior) {
            this.absentInputAudioBehavior(absentInputAudioBehavior == null ? null : absentInputAudioBehavior.toString());
            return this;
        }

        public final void setAbsentInputAudioBehavior(String absentInputAudioBehavior) {
            this.absentInputAudioBehavior = absentInputAudioBehavior;
        }

        public final String getArib() {
            return arib;
        }

        @Override
        public final Builder arib(String arib) {
            this.arib = arib;
            return this;
        }

        @Override
        public final Builder arib(M2tsArib arib) {
            this.arib(arib == null ? null : arib.toString());
            return this;
        }

        public final void setArib(String arib) {
            this.arib = arib;
        }

        public final String getAribCaptionsPid() {
            return aribCaptionsPid;
        }

        @Override
        public final Builder aribCaptionsPid(String aribCaptionsPid) {
            this.aribCaptionsPid = aribCaptionsPid;
            return this;
        }

        public final void setAribCaptionsPid(String aribCaptionsPid) {
            this.aribCaptionsPid = aribCaptionsPid;
        }

        public final String getAribCaptionsPidControl() {
            return aribCaptionsPidControl;
        }

        @Override
        public final Builder aribCaptionsPidControl(String aribCaptionsPidControl) {
            this.aribCaptionsPidControl = aribCaptionsPidControl;
            return this;
        }

        @Override
        public final Builder aribCaptionsPidControl(M2tsAribCaptionsPidControl aribCaptionsPidControl) {
            this.aribCaptionsPidControl(aribCaptionsPidControl == null ? null : aribCaptionsPidControl.toString());
            return this;
        }

        public final void setAribCaptionsPidControl(String aribCaptionsPidControl) {
            this.aribCaptionsPidControl = aribCaptionsPidControl;
        }

        public final String getAudioBufferModel() {
            return audioBufferModel;
        }

        @Override
        public final Builder audioBufferModel(String audioBufferModel) {
            this.audioBufferModel = audioBufferModel;
            return this;
        }

        @Override
        public final Builder audioBufferModel(M2tsAudioBufferModel audioBufferModel) {
            this.audioBufferModel(audioBufferModel == null ? null : audioBufferModel.toString());
            return this;
        }

        public final void setAudioBufferModel(String audioBufferModel) {
            this.audioBufferModel = audioBufferModel;
        }

        public final Integer getAudioFramesPerPes() {
            return audioFramesPerPes;
        }

        @Override
        public final Builder audioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
            return this;
        }

        public final void setAudioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
        }

        public final String getAudioPids() {
            return audioPids;
        }

        @Override
        public final Builder audioPids(String audioPids) {
            this.audioPids = audioPids;
            return this;
        }

        public final void setAudioPids(String audioPids) {
            this.audioPids = audioPids;
        }

        public final String getAudioStreamType() {
            return audioStreamType;
        }

        @Override
        public final Builder audioStreamType(String audioStreamType) {
            this.audioStreamType = audioStreamType;
            return this;
        }

        @Override
        public final Builder audioStreamType(M2tsAudioStreamType audioStreamType) {
            this.audioStreamType(audioStreamType == null ? null : audioStreamType.toString());
            return this;
        }

        public final void setAudioStreamType(String audioStreamType) {
            this.audioStreamType = audioStreamType;
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getBufferModel() {
            return bufferModel;
        }

        @Override
        public final Builder bufferModel(String bufferModel) {
            this.bufferModel = bufferModel;
            return this;
        }

        @Override
        public final Builder bufferModel(M2tsBufferModel bufferModel) {
            this.bufferModel(bufferModel == null ? null : bufferModel.toString());
            return this;
        }

        public final void setBufferModel(String bufferModel) {
            this.bufferModel = bufferModel;
        }

        public final String getCcDescriptor() {
            return ccDescriptor;
        }

        @Override
        public final Builder ccDescriptor(String ccDescriptor) {
            this.ccDescriptor = ccDescriptor;
            return this;
        }

        @Override
        public final Builder ccDescriptor(M2tsCcDescriptor ccDescriptor) {
            this.ccDescriptor(ccDescriptor == null ? null : ccDescriptor.toString());
            return this;
        }

        public final void setCcDescriptor(String ccDescriptor) {
            this.ccDescriptor = ccDescriptor;
        }

        public final DvbNitSettings.Builder getDvbNitSettings() {
            return dvbNitSettings != null ? dvbNitSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbNitSettings(DvbNitSettings dvbNitSettings) {
            this.dvbNitSettings = dvbNitSettings;
            return this;
        }

        public final void setDvbNitSettings(DvbNitSettings.BuilderImpl dvbNitSettings) {
            this.dvbNitSettings = dvbNitSettings != null ? dvbNitSettings.build() : null;
        }

        public final DvbSdtSettings.Builder getDvbSdtSettings() {
            return dvbSdtSettings != null ? dvbSdtSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbSdtSettings(DvbSdtSettings dvbSdtSettings) {
            this.dvbSdtSettings = dvbSdtSettings;
            return this;
        }

        public final void setDvbSdtSettings(DvbSdtSettings.BuilderImpl dvbSdtSettings) {
            this.dvbSdtSettings = dvbSdtSettings != null ? dvbSdtSettings.build() : null;
        }

        public final String getDvbSubPids() {
            return dvbSubPids;
        }

        @Override
        public final Builder dvbSubPids(String dvbSubPids) {
            this.dvbSubPids = dvbSubPids;
            return this;
        }

        public final void setDvbSubPids(String dvbSubPids) {
            this.dvbSubPids = dvbSubPids;
        }

        public final DvbTdtSettings.Builder getDvbTdtSettings() {
            return dvbTdtSettings != null ? dvbTdtSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbTdtSettings(DvbTdtSettings dvbTdtSettings) {
            this.dvbTdtSettings = dvbTdtSettings;
            return this;
        }

        public final void setDvbTdtSettings(DvbTdtSettings.BuilderImpl dvbTdtSettings) {
            this.dvbTdtSettings = dvbTdtSettings != null ? dvbTdtSettings.build() : null;
        }

        public final String getDvbTeletextPid() {
            return dvbTeletextPid;
        }

        @Override
        public final Builder dvbTeletextPid(String dvbTeletextPid) {
            this.dvbTeletextPid = dvbTeletextPid;
            return this;
        }

        public final void setDvbTeletextPid(String dvbTeletextPid) {
            this.dvbTeletextPid = dvbTeletextPid;
        }

        public final String getEbif() {
            return ebif;
        }

        @Override
        public final Builder ebif(String ebif) {
            this.ebif = ebif;
            return this;
        }

        @Override
        public final Builder ebif(M2tsEbifControl ebif) {
            this.ebif(ebif == null ? null : ebif.toString());
            return this;
        }

        public final void setEbif(String ebif) {
            this.ebif = ebif;
        }

        public final String getEbpAudioInterval() {
            return ebpAudioInterval;
        }

        @Override
        public final Builder ebpAudioInterval(String ebpAudioInterval) {
            this.ebpAudioInterval = ebpAudioInterval;
            return this;
        }

        @Override
        public final Builder ebpAudioInterval(M2tsAudioInterval ebpAudioInterval) {
            this.ebpAudioInterval(ebpAudioInterval == null ? null : ebpAudioInterval.toString());
            return this;
        }

        public final void setEbpAudioInterval(String ebpAudioInterval) {
            this.ebpAudioInterval = ebpAudioInterval;
        }

        public final Integer getEbpLookaheadMs() {
            return ebpLookaheadMs;
        }

        @Override
        public final Builder ebpLookaheadMs(Integer ebpLookaheadMs) {
            this.ebpLookaheadMs = ebpLookaheadMs;
            return this;
        }

        public final void setEbpLookaheadMs(Integer ebpLookaheadMs) {
            this.ebpLookaheadMs = ebpLookaheadMs;
        }

        public final String getEbpPlacement() {
            return ebpPlacement;
        }

        @Override
        public final Builder ebpPlacement(String ebpPlacement) {
            this.ebpPlacement = ebpPlacement;
            return this;
        }

        @Override
        public final Builder ebpPlacement(M2tsEbpPlacement ebpPlacement) {
            this.ebpPlacement(ebpPlacement == null ? null : ebpPlacement.toString());
            return this;
        }

        public final void setEbpPlacement(String ebpPlacement) {
            this.ebpPlacement = ebpPlacement;
        }

        public final String getEcmPid() {
            return ecmPid;
        }

        @Override
        public final Builder ecmPid(String ecmPid) {
            this.ecmPid = ecmPid;
            return this;
        }

        public final void setEcmPid(String ecmPid) {
            this.ecmPid = ecmPid;
        }

        public final String getEsRateInPes() {
            return esRateInPes;
        }

        @Override
        public final Builder esRateInPes(String esRateInPes) {
            this.esRateInPes = esRateInPes;
            return this;
        }

        @Override
        public final Builder esRateInPes(M2tsEsRateInPes esRateInPes) {
            this.esRateInPes(esRateInPes == null ? null : esRateInPes.toString());
            return this;
        }

        public final void setEsRateInPes(String esRateInPes) {
            this.esRateInPes = esRateInPes;
        }

        public final String getEtvPlatformPid() {
            return etvPlatformPid;
        }

        @Override
        public final Builder etvPlatformPid(String etvPlatformPid) {
            this.etvPlatformPid = etvPlatformPid;
            return this;
        }

        public final void setEtvPlatformPid(String etvPlatformPid) {
            this.etvPlatformPid = etvPlatformPid;
        }

        public final String getEtvSignalPid() {
            return etvSignalPid;
        }

        @Override
        public final Builder etvSignalPid(String etvSignalPid) {
            this.etvSignalPid = etvSignalPid;
            return this;
        }

        public final void setEtvSignalPid(String etvSignalPid) {
            this.etvSignalPid = etvSignalPid;
        }

        public final Double getFragmentTime() {
            return fragmentTime;
        }

        @Override
        public final Builder fragmentTime(Double fragmentTime) {
            this.fragmentTime = fragmentTime;
            return this;
        }

        public final void setFragmentTime(Double fragmentTime) {
            this.fragmentTime = fragmentTime;
        }

        public final String getKlv() {
            return klv;
        }

        @Override
        public final Builder klv(String klv) {
            this.klv = klv;
            return this;
        }

        @Override
        public final Builder klv(M2tsKlv klv) {
            this.klv(klv == null ? null : klv.toString());
            return this;
        }

        public final void setKlv(String klv) {
            this.klv = klv;
        }

        public final String getKlvDataPids() {
            return klvDataPids;
        }

        @Override
        public final Builder klvDataPids(String klvDataPids) {
            this.klvDataPids = klvDataPids;
            return this;
        }

        public final void setKlvDataPids(String klvDataPids) {
            this.klvDataPids = klvDataPids;
        }

        public final String getNielsenId3Behavior() {
            return nielsenId3Behavior;
        }

        @Override
        public final Builder nielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
            return this;
        }

        @Override
        public final Builder nielsenId3Behavior(M2tsNielsenId3Behavior nielsenId3Behavior) {
            this.nielsenId3Behavior(nielsenId3Behavior == null ? null : nielsenId3Behavior.toString());
            return this;
        }

        public final void setNielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
        }

        public final Double getNullPacketBitrate() {
            return nullPacketBitrate;
        }

        @Override
        public final Builder nullPacketBitrate(Double nullPacketBitrate) {
            this.nullPacketBitrate = nullPacketBitrate;
            return this;
        }

        public final void setNullPacketBitrate(Double nullPacketBitrate) {
            this.nullPacketBitrate = nullPacketBitrate;
        }

        public final Integer getPatInterval() {
            return patInterval;
        }

        @Override
        public final Builder patInterval(Integer patInterval) {
            this.patInterval = patInterval;
            return this;
        }

        public final void setPatInterval(Integer patInterval) {
            this.patInterval = patInterval;
        }

        public final String getPcrControl() {
            return pcrControl;
        }

        @Override
        public final Builder pcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
            return this;
        }

        @Override
        public final Builder pcrControl(M2tsPcrControl pcrControl) {
            this.pcrControl(pcrControl == null ? null : pcrControl.toString());
            return this;
        }

        public final void setPcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
        }

        public final Integer getPcrPeriod() {
            return pcrPeriod;
        }

        @Override
        public final Builder pcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
            return this;
        }

        public final void setPcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
        }

        public final String getPcrPid() {
            return pcrPid;
        }

        @Override
        public final Builder pcrPid(String pcrPid) {
            this.pcrPid = pcrPid;
            return this;
        }

        public final void setPcrPid(String pcrPid) {
            this.pcrPid = pcrPid;
        }

        public final Integer getPmtInterval() {
            return pmtInterval;
        }

        @Override
        public final Builder pmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
            return this;
        }

        public final void setPmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
        }

        public final String getPmtPid() {
            return pmtPid;
        }

        @Override
        public final Builder pmtPid(String pmtPid) {
            this.pmtPid = pmtPid;
            return this;
        }

        public final void setPmtPid(String pmtPid) {
            this.pmtPid = pmtPid;
        }

        public final Integer getProgramNum() {
            return programNum;
        }

        @Override
        public final Builder programNum(Integer programNum) {
            this.programNum = programNum;
            return this;
        }

        public final void setProgramNum(Integer programNum) {
            this.programNum = programNum;
        }

        public final String getRateMode() {
            return rateMode;
        }

        @Override
        public final Builder rateMode(String rateMode) {
            this.rateMode = rateMode;
            return this;
        }

        @Override
        public final Builder rateMode(M2tsRateMode rateMode) {
            this.rateMode(rateMode == null ? null : rateMode.toString());
            return this;
        }

        public final void setRateMode(String rateMode) {
            this.rateMode = rateMode;
        }

        public final String getScte27Pids() {
            return scte27Pids;
        }

        @Override
        public final Builder scte27Pids(String scte27Pids) {
            this.scte27Pids = scte27Pids;
            return this;
        }

        public final void setScte27Pids(String scte27Pids) {
            this.scte27Pids = scte27Pids;
        }

        public final String getScte35Control() {
            return scte35Control;
        }

        @Override
        public final Builder scte35Control(String scte35Control) {
            this.scte35Control = scte35Control;
            return this;
        }

        @Override
        public final Builder scte35Control(M2tsScte35Control scte35Control) {
            this.scte35Control(scte35Control == null ? null : scte35Control.toString());
            return this;
        }

        public final void setScte35Control(String scte35Control) {
            this.scte35Control = scte35Control;
        }

        public final String getScte35Pid() {
            return scte35Pid;
        }

        @Override
        public final Builder scte35Pid(String scte35Pid) {
            this.scte35Pid = scte35Pid;
            return this;
        }

        public final void setScte35Pid(String scte35Pid) {
            this.scte35Pid = scte35Pid;
        }

        public final String getSegmentationMarkers() {
            return segmentationMarkers;
        }

        @Override
        public final Builder segmentationMarkers(String segmentationMarkers) {
            this.segmentationMarkers = segmentationMarkers;
            return this;
        }

        @Override
        public final Builder segmentationMarkers(M2tsSegmentationMarkers segmentationMarkers) {
            this.segmentationMarkers(segmentationMarkers == null ? null : segmentationMarkers.toString());
            return this;
        }

        public final void setSegmentationMarkers(String segmentationMarkers) {
            this.segmentationMarkers = segmentationMarkers;
        }

        public final String getSegmentationStyle() {
            return segmentationStyle;
        }

        @Override
        public final Builder segmentationStyle(String segmentationStyle) {
            this.segmentationStyle = segmentationStyle;
            return this;
        }

        @Override
        public final Builder segmentationStyle(M2tsSegmentationStyle segmentationStyle) {
            this.segmentationStyle(segmentationStyle == null ? null : segmentationStyle.toString());
            return this;
        }

        public final void setSegmentationStyle(String segmentationStyle) {
            this.segmentationStyle = segmentationStyle;
        }

        public final Double getSegmentationTime() {
            return segmentationTime;
        }

        @Override
        public final Builder segmentationTime(Double segmentationTime) {
            this.segmentationTime = segmentationTime;
            return this;
        }

        public final void setSegmentationTime(Double segmentationTime) {
            this.segmentationTime = segmentationTime;
        }

        public final String getTimedMetadataBehavior() {
            return timedMetadataBehavior;
        }

        @Override
        public final Builder timedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
            return this;
        }

        @Override
        public final Builder timedMetadataBehavior(M2tsTimedMetadataBehavior timedMetadataBehavior) {
            this.timedMetadataBehavior(timedMetadataBehavior == null ? null : timedMetadataBehavior.toString());
            return this;
        }

        public final void setTimedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
        }

        public final String getTimedMetadataPid() {
            return timedMetadataPid;
        }

        @Override
        public final Builder timedMetadataPid(String timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
            return this;
        }

        public final void setTimedMetadataPid(String timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
        }

        public final Integer getTransportStreamId() {
            return transportStreamId;
        }

        @Override
        public final Builder transportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
            return this;
        }

        public final void setTransportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
        }

        public final String getVideoPid() {
            return videoPid;
        }

        @Override
        public final Builder videoPid(String videoPid) {
            this.videoPid = videoPid;
            return this;
        }

        public final void setVideoPid(String videoPid) {
            this.videoPid = videoPid;
        }

        @Override
        public M2tsSettings build() {
            return new M2tsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
