/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListOfferingsResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOfferingsResponse extends MediaLiveResponse implements
        ToCopyableBuilder<ListOfferingsResponse.Builder, ListOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Offering>> OFFERINGS_FIELD = SdkField
            .<List<Offering>> builder(MarshallingType.LIST)
            .getter(getter(ListOfferingsResponse::offerings))
            .setter(setter(Builder::offerings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offerings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Offering> builder(MarshallingType.SDK_POJO)
                                            .constructor(Offering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            OFFERINGS_FIELD));

    private final String nextToken;

    private final List<Offering> offerings;

    private ListOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.offerings = builder.offerings;
    }

    /**
     * Token to retrieve the next page of results
     * 
     * @return Token to retrieve the next page of results
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Offerings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOfferings() {
        return offerings != null && !(offerings instanceof SdkAutoConstructList);
    }

    /**
     * List of offerings
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOfferings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of offerings
     */
    public List<Offering> offerings() {
        return offerings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(offerings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingsResponse)) {
            return false;
        }
        ListOfferingsResponse other = (ListOfferingsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(offerings(), other.offerings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListOfferingsResponse").add("NextToken", nextToken()).add("Offerings", offerings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Offerings":
            return Optional.ofNullable(clazz.cast(offerings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOfferingsResponse, T> g) {
        return obj -> g.apply((ListOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOfferingsResponse> {
        /**
         * Token to retrieve the next page of results
         * 
         * @param nextToken
         *        Token to retrieve the next page of results
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * List of offerings
         * 
         * @param offerings
         *        List of offerings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerings(Collection<Offering> offerings);

        /**
         * List of offerings
         * 
         * @param offerings
         *        List of offerings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerings(Offering... offerings);

        /**
         * List of offerings This is a convenience that creates an instance of the {@link List<Offering>.Builder}
         * avoiding the need to create one manually via {@link List<Offering>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Offering>.Builder#build()} is called immediately and its
         * result is passed to {@link #offerings(List<Offering>)}.
         * 
         * @param offerings
         *        a consumer that will call methods on {@link List<Offering>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offerings(List<Offering>)
         */
        Builder offerings(Consumer<Offering.Builder>... offerings);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Offering> offerings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingsResponse model) {
            super(model);
            nextToken(model.nextToken);
            offerings(model.offerings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Offering.Builder> getOfferings() {
            return offerings != null ? offerings.stream().map(Offering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder offerings(Collection<Offering> offerings) {
            this.offerings = ___listOfOfferingCopier.copy(offerings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offerings(Offering... offerings) {
            offerings(Arrays.asList(offerings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offerings(Consumer<Offering.Builder>... offerings) {
            offerings(Stream.of(offerings).map(c -> Offering.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOfferings(Collection<Offering.BuilderImpl> offerings) {
            this.offerings = ___listOfOfferingCopier.copyFromBuilder(offerings);
        }

        @Override
        public ListOfferingsResponse build() {
            return new ListOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
