/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListOfferingsRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOfferingsRequest extends MediaLiveRequest implements
        ToCopyableBuilder<ListOfferingsRequest.Builder, ListOfferingsRequest> {
    private static final SdkField<String> CHANNEL_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsRequest::channelClass)).setter(setter(Builder::channelClass))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("channelClass").build()).build();

    private static final SdkField<String> CHANNEL_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsRequest::channelConfiguration)).setter(setter(Builder::channelConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("channelConfiguration").build())
            .build();

    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsRequest::codec)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("codec").build()).build();

    private static final SdkField<String> DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsRequest::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("duration").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListOfferingsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> MAXIMUM_BITRATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsRequest::maximumBitrate)).setter(setter(Builder::maximumBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maximumBitrate").build())
            .build();

    private static final SdkField<String> MAXIMUM_FRAMERATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsRequest::maximumFramerate)).setter(setter(Builder::maximumFramerate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maximumFramerate").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsRequest::resolution)).setter(setter(Builder::resolution))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolution").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsRequest::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()).build();

    private static final SdkField<String> SPECIAL_FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsRequest::specialFeature)).setter(setter(Builder::specialFeature))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("specialFeature").build())
            .build();

    private static final SdkField<String> VIDEO_QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingsRequest::videoQuality)).setter(setter(Builder::videoQuality))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("videoQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_CLASS_FIELD,
            CHANNEL_CONFIGURATION_FIELD, CODEC_FIELD, DURATION_FIELD, MAX_RESULTS_FIELD, MAXIMUM_BITRATE_FIELD,
            MAXIMUM_FRAMERATE_FIELD, NEXT_TOKEN_FIELD, RESOLUTION_FIELD, RESOURCE_TYPE_FIELD, SPECIAL_FEATURE_FIELD,
            VIDEO_QUALITY_FIELD));

    private final String channelClass;

    private final String channelConfiguration;

    private final String codec;

    private final String duration;

    private final Integer maxResults;

    private final String maximumBitrate;

    private final String maximumFramerate;

    private final String nextToken;

    private final String resolution;

    private final String resourceType;

    private final String specialFeature;

    private final String videoQuality;

    private ListOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.channelClass = builder.channelClass;
        this.channelConfiguration = builder.channelConfiguration;
        this.codec = builder.codec;
        this.duration = builder.duration;
        this.maxResults = builder.maxResults;
        this.maximumBitrate = builder.maximumBitrate;
        this.maximumFramerate = builder.maximumFramerate;
        this.nextToken = builder.nextToken;
        this.resolution = builder.resolution;
        this.resourceType = builder.resourceType;
        this.specialFeature = builder.specialFeature;
        this.videoQuality = builder.videoQuality;
    }

    /**
     * Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
     *
     * @return Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
     */
    public String channelClass() {
        return channelClass;
    }

    /**
     * Filter to offerings that match the configuration of an existing channel, e.g. '2345678' (a channel ID)
     *
     * @return Filter to offerings that match the configuration of an existing channel, e.g. '2345678' (a channel ID)
     */
    public String channelConfiguration() {
        return channelConfiguration;
    }

    /**
     * Filter by codec, 'AVC', 'HEVC', 'MPEG2', or 'AUDIO'
     * 
     * @return Filter by codec, 'AVC', 'HEVC', 'MPEG2', or 'AUDIO'
     */
    public String codec() {
        return codec;
    }

    /**
     * Filter by offering duration, e.g. '12'
     * 
     * @return Filter by offering duration, e.g. '12'
     */
    public String duration() {
        return duration;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
     *
     * @return Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
     */
    public String maximumBitrate() {
        return maximumBitrate;
    }

    /**
     * Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
     * 
     * @return Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
     */
    public String maximumFramerate() {
        return maximumFramerate;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
     * 
     * @return Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
     */
    public String resolution() {
        return resolution;
    }

    /**
     * Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
     * 
     * @return Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
     *
     * @return Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
     */
    public String specialFeature() {
        return specialFeature;
    }

    /**
     * Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
     *
     * @return Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
     */
    public String videoQuality() {
        return videoQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelClass());
        hashCode = 31 * hashCode + Objects.hashCode(channelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(codec());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(maximumFramerate());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(resolution());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(specialFeature());
        hashCode = 31 * hashCode + Objects.hashCode(videoQuality());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingsRequest)) {
            return false;
        }
        ListOfferingsRequest other = (ListOfferingsRequest) obj;
        return Objects.equals(channelClass(), other.channelClass())
                && Objects.equals(channelConfiguration(), other.channelConfiguration()) && Objects.equals(codec(), other.codec())
                && Objects.equals(duration(), other.duration()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(maximumBitrate(), other.maximumBitrate())
                && Objects.equals(maximumFramerate(), other.maximumFramerate()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(resolution(), other.resolution()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(specialFeature(), other.specialFeature())
                && Objects.equals(videoQuality(), other.videoQuality());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListOfferingsRequest").add("ChannelClass", channelClass())
                .add("ChannelConfiguration", channelConfiguration()).add("Codec", codec()).add("Duration", duration())
                .add("MaxResults", maxResults()).add("MaximumBitrate", maximumBitrate())
                .add("MaximumFramerate", maximumFramerate()).add("NextToken", nextToken()).add("Resolution", resolution())
                .add("ResourceType", resourceType()).add("SpecialFeature", specialFeature()).add("VideoQuality", videoQuality())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelClass":
            return Optional.ofNullable(clazz.cast(channelClass()));
        case "ChannelConfiguration":
            return Optional.ofNullable(clazz.cast(channelConfiguration()));
        case "Codec":
            return Optional.ofNullable(clazz.cast(codec()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "MaximumBitrate":
            return Optional.ofNullable(clazz.cast(maximumBitrate()));
        case "MaximumFramerate":
            return Optional.ofNullable(clazz.cast(maximumFramerate()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Resolution":
            return Optional.ofNullable(clazz.cast(resolution()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "SpecialFeature":
            return Optional.ofNullable(clazz.cast(specialFeature()));
        case "VideoQuality":
            return Optional.ofNullable(clazz.cast(videoQuality()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOfferingsRequest, T> g) {
        return obj -> g.apply((ListOfferingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListOfferingsRequest> {
        /**
         * Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
         *
         * @param channelClass
         *        Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelClass(String channelClass);

        /**
         * Filter to offerings that match the configuration of an existing channel, e.g. '2345678' (a channel ID)
         *
         * @param channelConfiguration
         *        Filter to offerings that match the configuration of an existing channel, e.g. '2345678' (a channel ID)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelConfiguration(String channelConfiguration);

        /**
         * Filter by codec, 'AVC', 'HEVC', 'MPEG2', or 'AUDIO'
         * 
         * @param codec
         *        Filter by codec, 'AVC', 'HEVC', 'MPEG2', or 'AUDIO'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codec(String codec);

        /**
         * Filter by offering duration, e.g. '12'
         * 
         * @param duration
         *        Filter by offering duration, e.g. '12'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(String duration);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
         *
         * @param maximumBitrate
         *        Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBitrate(String maximumBitrate);

        /**
         * Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
         * 
         * @param maximumFramerate
         *        Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumFramerate(String maximumFramerate);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
         * 
         * @param resolution
         *        Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolution(String resolution);

        /**
         * Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
         * 
         * @param resourceType
         *        Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
         *
         * @param specialFeature
         *        Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specialFeature(String specialFeature);

        /**
         * Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
         *
         * @param videoQuality
         *        Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoQuality(String videoQuality);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String channelClass;

        private String channelConfiguration;

        private String codec;

        private String duration;

        private Integer maxResults;

        private String maximumBitrate;

        private String maximumFramerate;

        private String nextToken;

        private String resolution;

        private String resourceType;

        private String specialFeature;

        private String videoQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingsRequest model) {
            super(model);
            channelClass(model.channelClass);
            channelConfiguration(model.channelConfiguration);
            codec(model.codec);
            duration(model.duration);
            maxResults(model.maxResults);
            maximumBitrate(model.maximumBitrate);
            maximumFramerate(model.maximumFramerate);
            nextToken(model.nextToken);
            resolution(model.resolution);
            resourceType(model.resourceType);
            specialFeature(model.specialFeature);
            videoQuality(model.videoQuality);
        }

        public final String getChannelClass() {
            return channelClass;
        }

        @Override
        public final Builder channelClass(String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        public final void setChannelClass(String channelClass) {
            this.channelClass = channelClass;
        }

        public final String getChannelConfiguration() {
            return channelConfiguration;
        }

        @Override
        public final Builder channelConfiguration(String channelConfiguration) {
            this.channelConfiguration = channelConfiguration;
            return this;
        }

        public final void setChannelConfiguration(String channelConfiguration) {
            this.channelConfiguration = channelConfiguration;
        }

        public final String getCodec() {
            return codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final String getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getMaximumBitrate() {
            return maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        public final void setMaximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        public final String getMaximumFramerate() {
            return maximumFramerate;
        }

        @Override
        public final Builder maximumFramerate(String maximumFramerate) {
            this.maximumFramerate = maximumFramerate;
            return this;
        }

        public final void setMaximumFramerate(String maximumFramerate) {
            this.maximumFramerate = maximumFramerate;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getResolution() {
            return resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getSpecialFeature() {
            return specialFeature;
        }

        @Override
        public final Builder specialFeature(String specialFeature) {
            this.specialFeature = specialFeature;
            return this;
        }

        public final void setSpecialFeature(String specialFeature) {
            this.specialFeature = specialFeature;
        }

        public final String getVideoQuality() {
            return videoQuality;
        }

        @Override
        public final Builder videoQuality(String videoQuality) {
            this.videoQuality = videoQuality;
            return this;
        }

        public final void setVideoQuality(String videoQuality) {
            this.videoQuality = videoQuality;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOfferingsRequest build() {
            return new ListOfferingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
