/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListMultiplexesResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMultiplexesResponse extends MediaLiveResponse implements
        ToCopyableBuilder<ListMultiplexesResponse.Builder, ListMultiplexesResponse> {
    private static final SdkField<List<MultiplexSummary>> MULTIPLEXES_FIELD = SdkField
            .<List<MultiplexSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListMultiplexesResponse::multiplexes))
            .setter(setter(Builder::multiplexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MultiplexSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MultiplexSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMultiplexesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEXES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MultiplexSummary> multiplexes;

    private final String nextToken;

    private ListMultiplexesResponse(BuilderImpl builder) {
        super(builder);
        this.multiplexes = builder.multiplexes;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Multiplexes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMultiplexes() {
        return multiplexes != null && !(multiplexes instanceof SdkAutoConstructList);
    }

    /**
     * List of multiplexes.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMultiplexes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of multiplexes.
     */
    public List<MultiplexSummary> multiplexes() {
        return multiplexes;
    }

    /**
     * Token for the next ListMultiplexes request.
     * 
     * @return Token for the next ListMultiplexes request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multiplexes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultiplexesResponse)) {
            return false;
        }
        ListMultiplexesResponse other = (ListMultiplexesResponse) obj;
        return Objects.equals(multiplexes(), other.multiplexes()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListMultiplexesResponse").add("Multiplexes", multiplexes()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Multiplexes":
            return Optional.ofNullable(clazz.cast(multiplexes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMultiplexesResponse, T> g) {
        return obj -> g.apply((ListMultiplexesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMultiplexesResponse> {
        /**
         * List of multiplexes.
         * 
         * @param multiplexes
         *        List of multiplexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexes(Collection<MultiplexSummary> multiplexes);

        /**
         * List of multiplexes.
         * 
         * @param multiplexes
         *        List of multiplexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexes(MultiplexSummary... multiplexes);

        /**
         * List of multiplexes. This is a convenience that creates an instance of the {@link List
         * <MultiplexSummary>.Builder} avoiding the need to create one manually via {@link List
         * <MultiplexSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MultiplexSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #multiplexes(List<MultiplexSummary>)}.
         * 
         * @param multiplexes
         *        a consumer that will call methods on {@link List<MultiplexSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexes(List<MultiplexSummary>)
         */
        Builder multiplexes(Consumer<MultiplexSummary.Builder>... multiplexes);

        /**
         * Token for the next ListMultiplexes request.
         * 
         * @param nextToken
         *        Token for the next ListMultiplexes request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private List<MultiplexSummary> multiplexes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultiplexesResponse model) {
            super(model);
            multiplexes(model.multiplexes);
            nextToken(model.nextToken);
        }

        public final Collection<MultiplexSummary.Builder> getMultiplexes() {
            return multiplexes != null ? multiplexes.stream().map(MultiplexSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder multiplexes(Collection<MultiplexSummary> multiplexes) {
            this.multiplexes = ___listOfMultiplexSummaryCopier.copy(multiplexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexes(MultiplexSummary... multiplexes) {
            multiplexes(Arrays.asList(multiplexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexes(Consumer<MultiplexSummary.Builder>... multiplexes) {
            multiplexes(Stream.of(multiplexes).map(c -> MultiplexSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMultiplexes(Collection<MultiplexSummary.BuilderImpl> multiplexes) {
            this.multiplexes = ___listOfMultiplexSummaryCopier.copyFromBuilder(multiplexes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMultiplexesResponse build() {
            return new ListMultiplexesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
