/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListMultiplexProgramsResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMultiplexProgramsResponse extends MediaLiveResponse implements
        ToCopyableBuilder<ListMultiplexProgramsResponse.Builder, ListMultiplexProgramsResponse> {
    private static final SdkField<List<MultiplexProgramSummary>> MULTIPLEX_PROGRAMS_FIELD = SdkField
            .<List<MultiplexProgramSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListMultiplexProgramsResponse::multiplexPrograms))
            .setter(setter(Builder::multiplexPrograms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexPrograms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MultiplexProgramSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MultiplexProgramSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMultiplexProgramsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_PROGRAMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MultiplexProgramSummary> multiplexPrograms;

    private final String nextToken;

    private ListMultiplexProgramsResponse(BuilderImpl builder) {
        super(builder);
        this.multiplexPrograms = builder.multiplexPrograms;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the MultiplexPrograms property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasMultiplexPrograms() {
        return multiplexPrograms != null && !(multiplexPrograms instanceof SdkAutoConstructList);
    }

    /**
     * List of multiplex programs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMultiplexPrograms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of multiplex programs.
     */
    public List<MultiplexProgramSummary> multiplexPrograms() {
        return multiplexPrograms;
    }

    /**
     * Token for the next ListMultiplexProgram request.
     * 
     * @return Token for the next ListMultiplexProgram request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multiplexPrograms());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultiplexProgramsResponse)) {
            return false;
        }
        ListMultiplexProgramsResponse other = (ListMultiplexProgramsResponse) obj;
        return Objects.equals(multiplexPrograms(), other.multiplexPrograms()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListMultiplexProgramsResponse").add("MultiplexPrograms", multiplexPrograms())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiplexPrograms":
            return Optional.ofNullable(clazz.cast(multiplexPrograms()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMultiplexProgramsResponse, T> g) {
        return obj -> g.apply((ListMultiplexProgramsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMultiplexProgramsResponse> {
        /**
         * List of multiplex programs.
         * 
         * @param multiplexPrograms
         *        List of multiplex programs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexPrograms(Collection<MultiplexProgramSummary> multiplexPrograms);

        /**
         * List of multiplex programs.
         * 
         * @param multiplexPrograms
         *        List of multiplex programs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexPrograms(MultiplexProgramSummary... multiplexPrograms);

        /**
         * List of multiplex programs. This is a convenience that creates an instance of the {@link List
         * <MultiplexProgramSummary>.Builder} avoiding the need to create one manually via {@link List
         * <MultiplexProgramSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MultiplexProgramSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #multiplexPrograms(List<MultiplexProgramSummary>)}.
         * 
         * @param multiplexPrograms
         *        a consumer that will call methods on {@link List<MultiplexProgramSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexPrograms(List<MultiplexProgramSummary>)
         */
        Builder multiplexPrograms(Consumer<MultiplexProgramSummary.Builder>... multiplexPrograms);

        /**
         * Token for the next ListMultiplexProgram request.
         * 
         * @param nextToken
         *        Token for the next ListMultiplexProgram request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private List<MultiplexProgramSummary> multiplexPrograms = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultiplexProgramsResponse model) {
            super(model);
            multiplexPrograms(model.multiplexPrograms);
            nextToken(model.nextToken);
        }

        public final Collection<MultiplexProgramSummary.Builder> getMultiplexPrograms() {
            return multiplexPrograms != null ? multiplexPrograms.stream().map(MultiplexProgramSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder multiplexPrograms(Collection<MultiplexProgramSummary> multiplexPrograms) {
            this.multiplexPrograms = ___listOfMultiplexProgramSummaryCopier.copy(multiplexPrograms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexPrograms(MultiplexProgramSummary... multiplexPrograms) {
            multiplexPrograms(Arrays.asList(multiplexPrograms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexPrograms(Consumer<MultiplexProgramSummary.Builder>... multiplexPrograms) {
            multiplexPrograms(Stream.of(multiplexPrograms).map(c -> MultiplexProgramSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMultiplexPrograms(Collection<MultiplexProgramSummary.BuilderImpl> multiplexPrograms) {
            this.multiplexPrograms = ___listOfMultiplexProgramSummaryCopier.copyFromBuilder(multiplexPrograms);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMultiplexProgramsResponse build() {
            return new ListMultiplexProgramsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
