/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListMultiplexProgramsRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMultiplexProgramsRequest extends MediaLiveRequest implements
        ToCopyableBuilder<ListMultiplexProgramsRequest.Builder, ListMultiplexProgramsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListMultiplexProgramsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> MULTIPLEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMultiplexProgramsRequest::multiplexId)).setter(setter(Builder::multiplexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("multiplexId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMultiplexProgramsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            MULTIPLEX_ID_FIELD, NEXT_TOKEN_FIELD));

    private final Integer maxResults;

    private final String multiplexId;

    private final String nextToken;

    private ListMultiplexProgramsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.multiplexId = builder.multiplexId;
        this.nextToken = builder.nextToken;
    }

    /**
     * The maximum number of items to return.
     * 
     * @return The maximum number of items to return.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * The ID of the multiplex that the programs belong to.
     * 
     * @return The ID of the multiplex that the programs belong to.
     */
    public String multiplexId() {
        return multiplexId;
    }

    /**
     * The token to retrieve the next page of results.
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(multiplexId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultiplexProgramsRequest)) {
            return false;
        }
        ListMultiplexProgramsRequest other = (ListMultiplexProgramsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(multiplexId(), other.multiplexId())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListMultiplexProgramsRequest").add("MaxResults", maxResults()).add("MultiplexId", multiplexId())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "MultiplexId":
            return Optional.ofNullable(clazz.cast(multiplexId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMultiplexProgramsRequest, T> g) {
        return obj -> g.apply((ListMultiplexProgramsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMultiplexProgramsRequest> {
        /**
         * The maximum number of items to return.
         * 
         * @param maxResults
         *        The maximum number of items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * The ID of the multiplex that the programs belong to.
         * 
         * @param multiplexId
         *        The ID of the multiplex that the programs belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexId(String multiplexId);

        /**
         * The token to retrieve the next page of results.
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String multiplexId;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultiplexProgramsRequest model) {
            super(model);
            maxResults(model.maxResults);
            multiplexId(model.multiplexId);
            nextToken(model.nextToken);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getMultiplexId() {
            return multiplexId;
        }

        @Override
        public final Builder multiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        public final void setMultiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMultiplexProgramsRequest build() {
            return new ListMultiplexProgramsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
