/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for the "switch input" action: to switch from ingesting one input to ingesting another input.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputSwitchScheduleActionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<InputSwitchScheduleActionSettings.Builder, InputSwitchScheduleActionSettings> {
    private static final SdkField<String> INPUT_ATTACHMENT_NAME_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InputSwitchScheduleActionSettings::inputAttachmentNameReference))
            .setter(setter(Builder::inputAttachmentNameReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachmentNameReference")
                    .build()).build();

    private static final SdkField<InputClippingSettings> INPUT_CLIPPING_SETTINGS_FIELD = SdkField
            .<InputClippingSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(InputSwitchScheduleActionSettings::inputClippingSettings))
            .setter(setter(Builder::inputClippingSettings)).constructor(InputClippingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputClippingSettings").build())
            .build();

    private static final SdkField<List<String>> URL_PATH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(InputSwitchScheduleActionSettings::urlPath))
            .setter(setter(Builder::urlPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlPath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INPUT_ATTACHMENT_NAME_REFERENCE_FIELD, INPUT_CLIPPING_SETTINGS_FIELD, URL_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputAttachmentNameReference;

    private final InputClippingSettings inputClippingSettings;

    private final List<String> urlPath;

    private InputSwitchScheduleActionSettings(BuilderImpl builder) {
        this.inputAttachmentNameReference = builder.inputAttachmentNameReference;
        this.inputClippingSettings = builder.inputClippingSettings;
        this.urlPath = builder.urlPath;
    }

    /**
     * The name of the input attachment (not the name of the input!) to switch to. The name is specified in the channel
     * configuration.
     * 
     * @return The name of the input attachment (not the name of the input!) to switch to. The name is specified in the
     *         channel configuration.
     */
    public String inputAttachmentNameReference() {
        return inputAttachmentNameReference;
    }

    /**
     * Settings to let you create a clip of the file input, in order to set up the input to ingest only a portion of the
     * file.
     * 
     * @return Settings to let you create a clip of the file input, in order to set up the input to ingest only a
     *         portion of the file.
     */
    public InputClippingSettings inputClippingSettings() {
        return inputClippingSettings;
    }

    /**
     * Returns true if the UrlPath property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUrlPath() {
        return urlPath != null && !(urlPath instanceof SdkAutoConstructList);
    }

    /**
     * The value for the variable portion of the URL for the dynamic input, for this instance of the input. Each time
     * you use the same dynamic input in an input switch action, you can provide a different value, in order to connect
     * the input to a different content source.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUrlPath()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value for the variable portion of the URL for the dynamic input, for this instance of the input. Each
     *         time you use the same dynamic input in an input switch action, you can provide a different value, in
     *         order to connect the input to a different content source.
     */
    public List<String> urlPath() {
        return urlPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputAttachmentNameReference());
        hashCode = 31 * hashCode + Objects.hashCode(inputClippingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(urlPath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSwitchScheduleActionSettings)) {
            return false;
        }
        InputSwitchScheduleActionSettings other = (InputSwitchScheduleActionSettings) obj;
        return Objects.equals(inputAttachmentNameReference(), other.inputAttachmentNameReference())
                && Objects.equals(inputClippingSettings(), other.inputClippingSettings())
                && Objects.equals(urlPath(), other.urlPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InputSwitchScheduleActionSettings")
                .add("InputAttachmentNameReference", inputAttachmentNameReference())
                .add("InputClippingSettings", inputClippingSettings()).add("UrlPath", urlPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputAttachmentNameReference":
            return Optional.ofNullable(clazz.cast(inputAttachmentNameReference()));
        case "InputClippingSettings":
            return Optional.ofNullable(clazz.cast(inputClippingSettings()));
        case "UrlPath":
            return Optional.ofNullable(clazz.cast(urlPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputSwitchScheduleActionSettings, T> g) {
        return obj -> g.apply((InputSwitchScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputSwitchScheduleActionSettings> {
        /**
         * The name of the input attachment (not the name of the input!) to switch to. The name is specified in the
         * channel configuration.
         * 
         * @param inputAttachmentNameReference
         *        The name of the input attachment (not the name of the input!) to switch to. The name is specified in
         *        the channel configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachmentNameReference(String inputAttachmentNameReference);

        /**
         * Settings to let you create a clip of the file input, in order to set up the input to ingest only a portion of
         * the file.
         * 
         * @param inputClippingSettings
         *        Settings to let you create a clip of the file input, in order to set up the input to ingest only a
         *        portion of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputClippingSettings(InputClippingSettings inputClippingSettings);

        /**
         * Settings to let you create a clip of the file input, in order to set up the input to ingest only a portion of
         * the file. This is a convenience that creates an instance of the {@link InputClippingSettings.Builder}
         * avoiding the need to create one manually via {@link InputClippingSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputClippingSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #inputClippingSettings(InputClippingSettings)}.
         * 
         * @param inputClippingSettings
         *        a consumer that will call methods on {@link InputClippingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputClippingSettings(InputClippingSettings)
         */
        default Builder inputClippingSettings(Consumer<InputClippingSettings.Builder> inputClippingSettings) {
            return inputClippingSettings(InputClippingSettings.builder().applyMutation(inputClippingSettings).build());
        }

        /**
         * The value for the variable portion of the URL for the dynamic input, for this instance of the input. Each
         * time you use the same dynamic input in an input switch action, you can provide a different value, in order to
         * connect the input to a different content source.
         * 
         * @param urlPath
         *        The value for the variable portion of the URL for the dynamic input, for this instance of the input.
         *        Each time you use the same dynamic input in an input switch action, you can provide a different value,
         *        in order to connect the input to a different content source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlPath(Collection<String> urlPath);

        /**
         * The value for the variable portion of the URL for the dynamic input, for this instance of the input. Each
         * time you use the same dynamic input in an input switch action, you can provide a different value, in order to
         * connect the input to a different content source.
         * 
         * @param urlPath
         *        The value for the variable portion of the URL for the dynamic input, for this instance of the input.
         *        Each time you use the same dynamic input in an input switch action, you can provide a different value,
         *        in order to connect the input to a different content source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlPath(String... urlPath);
    }

    static final class BuilderImpl implements Builder {
        private String inputAttachmentNameReference;

        private InputClippingSettings inputClippingSettings;

        private List<String> urlPath = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputSwitchScheduleActionSettings model) {
            inputAttachmentNameReference(model.inputAttachmentNameReference);
            inputClippingSettings(model.inputClippingSettings);
            urlPath(model.urlPath);
        }

        public final String getInputAttachmentNameReference() {
            return inputAttachmentNameReference;
        }

        @Override
        public final Builder inputAttachmentNameReference(String inputAttachmentNameReference) {
            this.inputAttachmentNameReference = inputAttachmentNameReference;
            return this;
        }

        public final void setInputAttachmentNameReference(String inputAttachmentNameReference) {
            this.inputAttachmentNameReference = inputAttachmentNameReference;
        }

        public final InputClippingSettings.Builder getInputClippingSettings() {
            return inputClippingSettings != null ? inputClippingSettings.toBuilder() : null;
        }

        @Override
        public final Builder inputClippingSettings(InputClippingSettings inputClippingSettings) {
            this.inputClippingSettings = inputClippingSettings;
            return this;
        }

        public final void setInputClippingSettings(InputClippingSettings.BuilderImpl inputClippingSettings) {
            this.inputClippingSettings = inputClippingSettings != null ? inputClippingSettings.build() : null;
        }

        public final Collection<String> getUrlPath() {
            return urlPath;
        }

        @Override
        public final Builder urlPath(Collection<String> urlPath) {
            this.urlPath = ___listOf__stringCopier.copy(urlPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urlPath(String... urlPath) {
            urlPath(Arrays.asList(urlPath));
            return this;
        }

        public final void setUrlPath(Collection<String> urlPath) {
            this.urlPath = ___listOf__stringCopier.copy(urlPath);
        }

        @Override
        public InputSwitchScheduleActionSettings build() {
            return new InputSwitchScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
