/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for a PULL type input.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputSource implements SdkPojo, Serializable, ToCopyableBuilder<InputSource.Builder, InputSource> {
    private static final SdkField<String> PASSWORD_PARAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputSource::passwordParam)).setter(setter(Builder::passwordParam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordParam").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputSource::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputSource::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSWORD_PARAM_FIELD,
            URL_FIELD, USERNAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String passwordParam;

    private final String url;

    private final String username;

    private InputSource(BuilderImpl builder) {
        this.passwordParam = builder.passwordParam;
        this.url = builder.url;
        this.username = builder.username;
    }

    /**
     * The key used to extract the password from EC2 Parameter store.
     * 
     * @return The key used to extract the password from EC2 Parameter store.
     */
    public String passwordParam() {
        return passwordParam;
    }

    /**
     * This represents the customer's source URL where stream is pulled from.
     *
     * @return This represents the customer's source URL where stream is pulled from.
     */
    public String url() {
        return url;
    }

    /**
     * The username for the input source.
     * 
     * @return The username for the input source.
     */
    public String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(passwordParam());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSource)) {
            return false;
        }
        InputSource other = (InputSource) obj;
        return Objects.equals(passwordParam(), other.passwordParam()) && Objects.equals(url(), other.url())
                && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InputSource").add("PasswordParam", passwordParam()).add("Url", url())
                .add("Username", username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PasswordParam":
            return Optional.ofNullable(clazz.cast(passwordParam()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputSource, T> g) {
        return obj -> g.apply((InputSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputSource> {
        /**
         * The key used to extract the password from EC2 Parameter store.
         * 
         * @param passwordParam
         *        The key used to extract the password from EC2 Parameter store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordParam(String passwordParam);

        /**
         * This represents the customer's source URL where stream is pulled from.
         *
         * @param url
         *        This represents the customer's source URL where stream is pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * The username for the input source.
         * 
         * @param username
         *        The username for the input source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private String passwordParam;

        private String url;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSource model) {
            passwordParam(model.passwordParam);
            url(model.url);
            username(model.username);
        }

        public final String getPasswordParam() {
            return passwordParam;
        }

        @Override
        public final Builder passwordParam(String passwordParam) {
            this.passwordParam = passwordParam;
            return this;
        }

        public final void setPasswordParam(String passwordParam) {
            this.passwordParam = passwordParam;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public InputSource build() {
            return new InputSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
