/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for Input
 */
@Generated("software.amazon.awssdk:codegen")
public final class Input implements SdkPojo, Serializable, ToCopyableBuilder<Input.Builder, Input> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<String>> ATTACHED_CHANNELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Input::attachedChannels))
            .setter(setter(Builder::attachedChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedChannels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InputDestination>> DESTINATIONS_FIELD = SdkField
            .<List<InputDestination>> builder(MarshallingType.LIST)
            .getter(getter(Input::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Input::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> INPUT_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::inputClassAsString)).setter(setter(Builder::inputClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputClass").build()).build();

    private static final SdkField<List<InputDeviceSettings>> INPUT_DEVICES_FIELD = SdkField
            .<List<InputDeviceSettings>> builder(MarshallingType.LIST)
            .getter(getter(Input::inputDevices))
            .setter(setter(Builder::inputDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputDeviceSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputDeviceSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INPUT_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::inputSourceTypeAsString)).setter(setter(Builder::inputSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceType").build()).build();

    private static final SdkField<List<MediaConnectFlow>> MEDIA_CONNECT_FLOWS_FIELD = SdkField
            .<List<MediaConnectFlow>> builder(MarshallingType.LIST)
            .getter(getter(Input::mediaConnectFlows))
            .setter(setter(Builder::mediaConnectFlows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaConnectFlow> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaConnectFlow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Input::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InputSource>> SOURCES_FIELD = SdkField
            .<List<InputSource>> builder(MarshallingType.LIST)
            .getter(getter(Input::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Input::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ATTACHED_CHANNELS_FIELD, DESTINATIONS_FIELD, ID_FIELD, INPUT_CLASS_FIELD, INPUT_DEVICES_FIELD,
            INPUT_SOURCE_TYPE_FIELD, MEDIA_CONNECT_FLOWS_FIELD, NAME_FIELD, ROLE_ARN_FIELD, SECURITY_GROUPS_FIELD, SOURCES_FIELD,
            STATE_FIELD, TAGS_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<String> attachedChannels;

    private final List<InputDestination> destinations;

    private final String id;

    private final String inputClass;

    private final List<InputDeviceSettings> inputDevices;

    private final String inputSourceType;

    private final List<MediaConnectFlow> mediaConnectFlows;

    private final String name;

    private final String roleArn;

    private final List<String> securityGroups;

    private final List<InputSource> sources;

    private final String state;

    private final Map<String, String> tags;

    private final String type;

    private Input(BuilderImpl builder) {
        this.arn = builder.arn;
        this.attachedChannels = builder.attachedChannels;
        this.destinations = builder.destinations;
        this.id = builder.id;
        this.inputClass = builder.inputClass;
        this.inputDevices = builder.inputDevices;
        this.inputSourceType = builder.inputSourceType;
        this.mediaConnectFlows = builder.mediaConnectFlows;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.securityGroups = builder.securityGroups;
        this.sources = builder.sources;
        this.state = builder.state;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * The Unique ARN of the input (generated, immutable).
     * 
     * @return The Unique ARN of the input (generated, immutable).
     */
    public String arn() {
        return arn;
    }

    /**
     * Returns true if the AttachedChannels property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAttachedChannels() {
        return attachedChannels != null && !(attachedChannels instanceof SdkAutoConstructList);
    }

    /**
     * A list of channel IDs that that input is attached to (currently an input can only be attached to one channel).
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachedChannels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of channel IDs that that input is attached to (currently an input can only be attached to one
     *         channel).
     */
    public List<String> attachedChannels() {
        return attachedChannels;
    }

    /**
     * Returns true if the Destinations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * A list of the destinations of the input (PUSH-type).
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the destinations of the input (PUSH-type).
     */
    public List<InputDestination> destinations() {
        return destinations;
    }

    /**
     * The generated ID of the input (unique for user account, immutable).
     * 
     * @return The generated ID of the input (unique for user account, immutable).
     */
    public String id() {
        return id;
    }

    /**
     * STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both
     * sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second
     * source will always be ignored, even if the first source fails. SINGLE_PIPELINE - You can connect only one source
     * to this input. If the ChannelClass is also SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD,
     * this value is not valid because the channel requires two sources in the input.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputClass} will
     * return {@link InputClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputClassAsString}.
     * </p>
     * 
     * @return STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD,
     *         both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested;
     *         the second source will always be ignored, even if the first source fails. SINGLE_PIPELINE - You can
     *         connect only one source to this input. If the ChannelClass is also SINGLE_PIPELINE, this value is valid.
     *         If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the
     *         input.
     * @see InputClass
     */
    public InputClass inputClass() {
        return InputClass.fromValue(inputClass);
    }

    /**
     * STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both
     * sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second
     * source will always be ignored, even if the first source fails. SINGLE_PIPELINE - You can connect only one source
     * to this input. If the ChannelClass is also SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD,
     * this value is not valid because the channel requires two sources in the input.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputClass} will
     * return {@link InputClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputClassAsString}.
     * </p>
     * 
     * @return STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD,
     *         both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested;
     *         the second source will always be ignored, even if the first source fails. SINGLE_PIPELINE - You can
     *         connect only one source to this input. If the ChannelClass is also SINGLE_PIPELINE, this value is valid.
     *         If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the
     *         input.
     * @see InputClass
     */
    public String inputClassAsString() {
        return inputClass;
    }

    /**
     * Returns true if the InputDevices property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInputDevices() {
        return inputDevices != null && !(inputDevices instanceof SdkAutoConstructList);
    }

    /**
     * Settings for the input devices.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Settings for the input devices.
     */
    public List<InputDeviceSettings> inputDevices() {
        return inputDevices;
    }

    /**
     * Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes during
     * input switch actions. Presently, this functionality only works with MP4_FILE inputs.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputSourceType}
     * will return {@link InputSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inputSourceTypeAsString}.
     * </p>
     * 
     * @return Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes
     *         during input switch actions. Presently, this functionality only works with MP4_FILE inputs.
     * @see InputSourceType
     */
    public InputSourceType inputSourceType() {
        return InputSourceType.fromValue(inputSourceType);
    }

    /**
     * Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes during
     * input switch actions. Presently, this functionality only works with MP4_FILE inputs.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputSourceType}
     * will return {@link InputSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inputSourceTypeAsString}.
     * </p>
     * 
     * @return Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes
     *         during input switch actions. Presently, this functionality only works with MP4_FILE inputs.
     * @see InputSourceType
     */
    public String inputSourceTypeAsString() {
        return inputSourceType;
    }

    /**
     * Returns true if the MediaConnectFlows property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasMediaConnectFlows() {
        return mediaConnectFlows != null && !(mediaConnectFlows instanceof SdkAutoConstructList);
    }

    /**
     * A list of MediaConnect Flows for this input.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMediaConnectFlows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of MediaConnect Flows for this input.
     */
    public List<MediaConnectFlow> mediaConnectFlows() {
        return mediaConnectFlows;
    }

    /**
     * The user-assigned name (This is a mutable value).
     * 
     * @return The user-assigned name (This is a mutable value).
     */
    public String name() {
        return name;
    }

    /**
     * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
     * 
     * @return The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * A list of IDs for all the Input Security Groups attached to the input.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of IDs for all the Input Security Groups attached to the input.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * Returns true if the Sources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * A list of the sources of the input (PULL-type).
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the sources of the input (PULL-type).
     */
    public List<InputSource> sources() {
        return sources;
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InputState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see InputState
     */
    public InputState state() {
        return InputState.fromValue(state);
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InputState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see InputState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see InputType
     */
    public InputType type() {
        return InputType.fromValue(type);
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see InputType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(attachedChannels());
        hashCode = 31 * hashCode + Objects.hashCode(destinations());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(inputClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputDevices());
        hashCode = 31 * hashCode + Objects.hashCode(inputSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaConnectFlows());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(sources());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(attachedChannels(), other.attachedChannels())
                && Objects.equals(destinations(), other.destinations()) && Objects.equals(id(), other.id())
                && Objects.equals(inputClassAsString(), other.inputClassAsString())
                && Objects.equals(inputDevices(), other.inputDevices())
                && Objects.equals(inputSourceTypeAsString(), other.inputSourceTypeAsString())
                && Objects.equals(mediaConnectFlows(), other.mediaConnectFlows()) && Objects.equals(name(), other.name())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(sources(), other.sources()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Input").add("Arn", arn()).add("AttachedChannels", attachedChannels())
                .add("Destinations", destinations()).add("Id", id()).add("InputClass", inputClassAsString())
                .add("InputDevices", inputDevices()).add("InputSourceType", inputSourceTypeAsString())
                .add("MediaConnectFlows", mediaConnectFlows()).add("Name", name()).add("RoleArn", roleArn())
                .add("SecurityGroups", securityGroups()).add("Sources", sources()).add("State", stateAsString())
                .add("Tags", tags()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AttachedChannels":
            return Optional.ofNullable(clazz.cast(attachedChannels()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InputClass":
            return Optional.ofNullable(clazz.cast(inputClassAsString()));
        case "InputDevices":
            return Optional.ofNullable(clazz.cast(inputDevices()));
        case "InputSourceType":
            return Optional.ofNullable(clazz.cast(inputSourceTypeAsString()));
        case "MediaConnectFlows":
            return Optional.ofNullable(clazz.cast(mediaConnectFlows()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Input, T> g) {
        return obj -> g.apply((Input) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Input> {
        /**
         * The Unique ARN of the input (generated, immutable).
         * 
         * @param arn
         *        The Unique ARN of the input (generated, immutable).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * A list of channel IDs that that input is attached to (currently an input can only be attached to one
         * channel).
         * 
         * @param attachedChannels
         *        A list of channel IDs that that input is attached to (currently an input can only be attached to one
         *        channel).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedChannels(Collection<String> attachedChannels);

        /**
         * A list of channel IDs that that input is attached to (currently an input can only be attached to one
         * channel).
         * 
         * @param attachedChannels
         *        A list of channel IDs that that input is attached to (currently an input can only be attached to one
         *        channel).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedChannels(String... attachedChannels);

        /**
         * A list of the destinations of the input (PUSH-type).
         * 
         * @param destinations
         *        A list of the destinations of the input (PUSH-type).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<InputDestination> destinations);

        /**
         * A list of the destinations of the input (PUSH-type).
         * 
         * @param destinations
         *        A list of the destinations of the input (PUSH-type).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(InputDestination... destinations);

        /**
         * A list of the destinations of the input (PUSH-type). This is a convenience that creates an instance of the
         * {@link List<InputDestination>.Builder} avoiding the need to create one manually via {@link List
         * <InputDestination>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputDestination>.Builder#build()} is called immediately and
         * its result is passed to {@link #destinations(List<InputDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on {@link List<InputDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(List<InputDestination>)
         */
        Builder destinations(Consumer<InputDestination.Builder>... destinations);

        /**
         * The generated ID of the input (unique for user account, immutable).
         * 
         * @param id
         *        The generated ID of the input (unique for user account, immutable).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both
         * sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the
         * second source will always be ignored, even if the first source fails. SINGLE_PIPELINE - You can connect only
         * one source to this input. If the ChannelClass is also SINGLE_PIPELINE, this value is valid. If the
         * ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.
         *
         * @param inputClass
         *        STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also
         *        STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will
         *        be ingested; the second source will always be ignored, even if the first source fails. SINGLE_PIPELINE
         *        - You can connect only one source to this input. If the ChannelClass is also SINGLE_PIPELINE, this
         *        value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires
         *        two sources in the input.
         * @see InputClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputClass
         */
        Builder inputClass(String inputClass);

        /**
         * STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both
         * sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the
         * second source will always be ignored, even if the first source fails. SINGLE_PIPELINE - You can connect only
         * one source to this input. If the ChannelClass is also SINGLE_PIPELINE, this value is valid. If the
         * ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.
         *
         * @param inputClass
         *        STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also
         *        STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will
         *        be ingested; the second source will always be ignored, even if the first source fails. SINGLE_PIPELINE
         *        - You can connect only one source to this input. If the ChannelClass is also SINGLE_PIPELINE, this
         *        value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires
         *        two sources in the input.
         * @see InputClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputClass
         */
        Builder inputClass(InputClass inputClass);

        /**
         * Settings for the input devices.
         * 
         * @param inputDevices
         *        Settings for the input devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDevices(Collection<InputDeviceSettings> inputDevices);

        /**
         * Settings for the input devices.
         * 
         * @param inputDevices
         *        Settings for the input devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDevices(InputDeviceSettings... inputDevices);

        /**
         * Settings for the input devices. This is a convenience that creates an instance of the {@link List
         * <InputDeviceSettings>.Builder} avoiding the need to create one manually via {@link List
         * <InputDeviceSettings>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputDeviceSettings>.Builder#build()} is called immediately
         * and its result is passed to {@link #inputDevices(List<InputDeviceSettings>)}.
         * 
         * @param inputDevices
         *        a consumer that will call methods on {@link List<InputDeviceSettings>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDevices(List<InputDeviceSettings>)
         */
        Builder inputDevices(Consumer<InputDeviceSettings.Builder>... inputDevices);

        /**
         * Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes during
         * input switch actions. Presently, this functionality only works with MP4_FILE inputs.
         *
         * @param inputSourceType
         *        Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes
         *        during input switch actions. Presently, this functionality only works with MP4_FILE inputs.
         * @see InputSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputSourceType
         */
        Builder inputSourceType(String inputSourceType);

        /**
         * Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes during
         * input switch actions. Presently, this functionality only works with MP4_FILE inputs.
         *
         * @param inputSourceType
         *        Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes
         *        during input switch actions. Presently, this functionality only works with MP4_FILE inputs.
         * @see InputSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputSourceType
         */
        Builder inputSourceType(InputSourceType inputSourceType);

        /**
         * A list of MediaConnect Flows for this input.
         * 
         * @param mediaConnectFlows
         *        A list of MediaConnect Flows for this input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConnectFlows(Collection<MediaConnectFlow> mediaConnectFlows);

        /**
         * A list of MediaConnect Flows for this input.
         * 
         * @param mediaConnectFlows
         *        A list of MediaConnect Flows for this input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConnectFlows(MediaConnectFlow... mediaConnectFlows);

        /**
         * A list of MediaConnect Flows for this input. This is a convenience that creates an instance of the
         * {@link List<MediaConnectFlow>.Builder} avoiding the need to create one manually via {@link List
         * <MediaConnectFlow>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MediaConnectFlow>.Builder#build()} is called immediately and
         * its result is passed to {@link #mediaConnectFlows(List<MediaConnectFlow>)}.
         * 
         * @param mediaConnectFlows
         *        a consumer that will call methods on {@link List<MediaConnectFlow>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConnectFlows(List<MediaConnectFlow>)
         */
        Builder mediaConnectFlows(Consumer<MediaConnectFlow.Builder>... mediaConnectFlows);

        /**
         * The user-assigned name (This is a mutable value).
         * 
         * @param name
         *        The user-assigned name (This is a mutable value).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * A list of IDs for all the Input Security Groups attached to the input.
         * 
         * @param securityGroups
         *        A list of IDs for all the Input Security Groups attached to the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * A list of IDs for all the Input Security Groups attached to the input.
         * 
         * @param securityGroups
         *        A list of IDs for all the Input Security Groups attached to the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * A list of the sources of the input (PULL-type).
         * 
         * @param sources
         *        A list of the sources of the input (PULL-type).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<InputSource> sources);

        /**
         * A list of the sources of the input (PULL-type).
         * 
         * @param sources
         *        A list of the sources of the input (PULL-type).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(InputSource... sources);

        /**
         * A list of the sources of the input (PULL-type). This is a convenience that creates an instance of the
         * {@link List<InputSource>.Builder} avoiding the need to create one manually via {@link List
         * <InputSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputSource>.Builder#build()} is called immediately and its
         * result is passed to {@link #sources(List<InputSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<InputSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<InputSource>)
         */
        Builder sources(Consumer<InputSource.Builder>... sources);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see InputState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputState
         */
        Builder state(String state);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see InputState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputState
         */
        Builder state(InputState state);

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see InputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputType
         */
        Builder type(String type);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see InputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputType
         */
        Builder type(InputType type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<String> attachedChannels = DefaultSdkAutoConstructList.getInstance();

        private List<InputDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private String inputClass;

        private List<InputDeviceSettings> inputDevices = DefaultSdkAutoConstructList.getInstance();

        private String inputSourceType;

        private List<MediaConnectFlow> mediaConnectFlows = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String roleArn;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<InputSource> sources = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            arn(model.arn);
            attachedChannels(model.attachedChannels);
            destinations(model.destinations);
            id(model.id);
            inputClass(model.inputClass);
            inputDevices(model.inputDevices);
            inputSourceType(model.inputSourceType);
            mediaConnectFlows(model.mediaConnectFlows);
            name(model.name);
            roleArn(model.roleArn);
            securityGroups(model.securityGroups);
            sources(model.sources);
            state(model.state);
            tags(model.tags);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<String> getAttachedChannels() {
            return attachedChannels;
        }

        @Override
        public final Builder attachedChannels(Collection<String> attachedChannels) {
            this.attachedChannels = ___listOf__stringCopier.copy(attachedChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedChannels(String... attachedChannels) {
            attachedChannels(Arrays.asList(attachedChannels));
            return this;
        }

        public final void setAttachedChannels(Collection<String> attachedChannels) {
            this.attachedChannels = ___listOf__stringCopier.copy(attachedChannels);
        }

        public final Collection<InputDestination.Builder> getDestinations() {
            return destinations != null ? destinations.stream().map(InputDestination::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder destinations(Collection<InputDestination> destinations) {
            this.destinations = ___listOfInputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(InputDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<InputDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> InputDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<InputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfInputDestinationCopier.copyFromBuilder(destinations);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getInputClass() {
            return inputClass;
        }

        @Override
        public final Builder inputClass(String inputClass) {
            this.inputClass = inputClass;
            return this;
        }

        @Override
        public final Builder inputClass(InputClass inputClass) {
            this.inputClass(inputClass == null ? null : inputClass.toString());
            return this;
        }

        public final void setInputClass(String inputClass) {
            this.inputClass = inputClass;
        }

        public final Collection<InputDeviceSettings.Builder> getInputDevices() {
            return inputDevices != null ? inputDevices.stream().map(InputDeviceSettings::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder inputDevices(Collection<InputDeviceSettings> inputDevices) {
            this.inputDevices = ___listOfInputDeviceSettingsCopier.copy(inputDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(InputDeviceSettings... inputDevices) {
            inputDevices(Arrays.asList(inputDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(Consumer<InputDeviceSettings.Builder>... inputDevices) {
            inputDevices(Stream.of(inputDevices).map(c -> InputDeviceSettings.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputDevices(Collection<InputDeviceSettings.BuilderImpl> inputDevices) {
            this.inputDevices = ___listOfInputDeviceSettingsCopier.copyFromBuilder(inputDevices);
        }

        public final String getInputSourceType() {
            return inputSourceType;
        }

        @Override
        public final Builder inputSourceType(String inputSourceType) {
            this.inputSourceType = inputSourceType;
            return this;
        }

        @Override
        public final Builder inputSourceType(InputSourceType inputSourceType) {
            this.inputSourceType(inputSourceType == null ? null : inputSourceType.toString());
            return this;
        }

        public final void setInputSourceType(String inputSourceType) {
            this.inputSourceType = inputSourceType;
        }

        public final Collection<MediaConnectFlow.Builder> getMediaConnectFlows() {
            return mediaConnectFlows != null ? mediaConnectFlows.stream().map(MediaConnectFlow::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mediaConnectFlows(Collection<MediaConnectFlow> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowCopier.copy(mediaConnectFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(MediaConnectFlow... mediaConnectFlows) {
            mediaConnectFlows(Arrays.asList(mediaConnectFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(Consumer<MediaConnectFlow.Builder>... mediaConnectFlows) {
            mediaConnectFlows(Stream.of(mediaConnectFlows).map(c -> MediaConnectFlow.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMediaConnectFlows(Collection<MediaConnectFlow.BuilderImpl> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowCopier.copyFromBuilder(mediaConnectFlows);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        public final Collection<InputSource.Builder> getSources() {
            return sources != null ? sources.stream().map(InputSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<InputSource> sources) {
            this.sources = ___listOfInputSourceCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(InputSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<InputSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> InputSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<InputSource.BuilderImpl> sources) {
            this.sources = ___listOfInputSourceCopier.copyFromBuilder(sources);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InputState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Input build() {
            return new Input(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
