/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Hdr10 Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class Hdr10Settings implements SdkPojo, Serializable, ToCopyableBuilder<Hdr10Settings.Builder, Hdr10Settings> {
    private static final SdkField<Integer> MAX_CLL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Settings::maxCll)).setter(setter(Builder::maxCll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCll").build()).build();

    private static final SdkField<Integer> MAX_FALL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Settings::maxFall)).setter(setter(Builder::maxFall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFall").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MAX_CLL_FIELD, MAX_FALL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxCll;

    private final Integer maxFall;

    private Hdr10Settings(BuilderImpl builder) {
        this.maxCll = builder.maxCll;
        this.maxFall = builder.maxFall;
    }

    /**
     * Maximum Content Light Level An integer metadata value defining the maximum light level, in nits, of any single
     * pixel within an encoded HDR video stream or file.
     * 
     * @return Maximum Content Light Level An integer metadata value defining the maximum light level, in nits, of any
     *         single pixel within an encoded HDR video stream or file.
     */
    public Integer maxCll() {
        return maxCll;
    }

    /**
     * Maximum Frame Average Light Level An integer metadata value defining the maximum average light level, in nits,
     * for any single frame within an encoded HDR video stream or file.
     * 
     * @return Maximum Frame Average Light Level An integer metadata value defining the maximum average light level, in
     *         nits, for any single frame within an encoded HDR video stream or file.
     */
    public Integer maxFall() {
        return maxFall;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxCll());
        hashCode = 31 * hashCode + Objects.hashCode(maxFall());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hdr10Settings)) {
            return false;
        }
        Hdr10Settings other = (Hdr10Settings) obj;
        return Objects.equals(maxCll(), other.maxCll()) && Objects.equals(maxFall(), other.maxFall());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Hdr10Settings").add("MaxCll", maxCll()).add("MaxFall", maxFall()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxCll":
            return Optional.ofNullable(clazz.cast(maxCll()));
        case "MaxFall":
            return Optional.ofNullable(clazz.cast(maxFall()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Hdr10Settings, T> g) {
        return obj -> g.apply((Hdr10Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Hdr10Settings> {
        /**
         * Maximum Content Light Level An integer metadata value defining the maximum light level, in nits, of any
         * single pixel within an encoded HDR video stream or file.
         * 
         * @param maxCll
         *        Maximum Content Light Level An integer metadata value defining the maximum light level, in nits, of
         *        any single pixel within an encoded HDR video stream or file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCll(Integer maxCll);

        /**
         * Maximum Frame Average Light Level An integer metadata value defining the maximum average light level, in
         * nits, for any single frame within an encoded HDR video stream or file.
         * 
         * @param maxFall
         *        Maximum Frame Average Light Level An integer metadata value defining the maximum average light level,
         *        in nits, for any single frame within an encoded HDR video stream or file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFall(Integer maxFall);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxCll;

        private Integer maxFall;

        private BuilderImpl() {
        }

        private BuilderImpl(Hdr10Settings model) {
            maxCll(model.maxCll);
            maxFall(model.maxFall);
        }

        public final Integer getMaxCll() {
            return maxCll;
        }

        @Override
        public final Builder maxCll(Integer maxCll) {
            this.maxCll = maxCll;
            return this;
        }

        public final void setMaxCll(Integer maxCll) {
            this.maxCll = maxCll;
        }

        public final Integer getMaxFall() {
            return maxFall;
        }

        @Override
        public final Builder maxFall(Integer maxFall) {
            this.maxFall = maxFall;
            return this;
        }

        public final void setMaxFall(Integer maxFall) {
            this.maxFall = maxFall;
        }

        @Override
        public Hdr10Settings build() {
            return new Hdr10Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
