/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * H265 Color Space Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class H265ColorSpaceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<H265ColorSpaceSettings.Builder, H265ColorSpaceSettings> {
    private static final SdkField<ColorSpacePassthroughSettings> COLOR_SPACE_PASSTHROUGH_SETTINGS_FIELD = SdkField
            .<ColorSpacePassthroughSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(H265ColorSpaceSettings::colorSpacePassthroughSettings))
            .setter(setter(Builder::colorSpacePassthroughSettings))
            .constructor(ColorSpacePassthroughSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpacePassthroughSettings")
                    .build()).build();

    private static final SdkField<Hdr10Settings> HDR10_SETTINGS_FIELD = SdkField
            .<Hdr10Settings> builder(MarshallingType.SDK_POJO).getter(getter(H265ColorSpaceSettings::hdr10Settings))
            .setter(setter(Builder::hdr10Settings)).constructor(Hdr10Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdr10Settings").build()).build();

    private static final SdkField<Rec601Settings> REC601_SETTINGS_FIELD = SdkField
            .<Rec601Settings> builder(MarshallingType.SDK_POJO).getter(getter(H265ColorSpaceSettings::rec601Settings))
            .setter(setter(Builder::rec601Settings)).constructor(Rec601Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rec601Settings").build()).build();

    private static final SdkField<Rec709Settings> REC709_SETTINGS_FIELD = SdkField
            .<Rec709Settings> builder(MarshallingType.SDK_POJO).getter(getter(H265ColorSpaceSettings::rec709Settings))
            .setter(setter(Builder::rec709Settings)).constructor(Rec709Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rec709Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLOR_SPACE_PASSTHROUGH_SETTINGS_FIELD, HDR10_SETTINGS_FIELD, REC601_SETTINGS_FIELD, REC709_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ColorSpacePassthroughSettings colorSpacePassthroughSettings;

    private final Hdr10Settings hdr10Settings;

    private final Rec601Settings rec601Settings;

    private final Rec709Settings rec709Settings;

    private H265ColorSpaceSettings(BuilderImpl builder) {
        this.colorSpacePassthroughSettings = builder.colorSpacePassthroughSettings;
        this.hdr10Settings = builder.hdr10Settings;
        this.rec601Settings = builder.rec601Settings;
        this.rec709Settings = builder.rec709Settings;
    }

    /**
     * Returns the value of the ColorSpacePassthroughSettings property for this object.
     * 
     * @return The value of the ColorSpacePassthroughSettings property for this object.
     */
    public ColorSpacePassthroughSettings colorSpacePassthroughSettings() {
        return colorSpacePassthroughSettings;
    }

    /**
     * Returns the value of the Hdr10Settings property for this object.
     * 
     * @return The value of the Hdr10Settings property for this object.
     */
    public Hdr10Settings hdr10Settings() {
        return hdr10Settings;
    }

    /**
     * Returns the value of the Rec601Settings property for this object.
     * 
     * @return The value of the Rec601Settings property for this object.
     */
    public Rec601Settings rec601Settings() {
        return rec601Settings;
    }

    /**
     * Returns the value of the Rec709Settings property for this object.
     * 
     * @return The value of the Rec709Settings property for this object.
     */
    public Rec709Settings rec709Settings() {
        return rec709Settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(colorSpacePassthroughSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hdr10Settings());
        hashCode = 31 * hashCode + Objects.hashCode(rec601Settings());
        hashCode = 31 * hashCode + Objects.hashCode(rec709Settings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H265ColorSpaceSettings)) {
            return false;
        }
        H265ColorSpaceSettings other = (H265ColorSpaceSettings) obj;
        return Objects.equals(colorSpacePassthroughSettings(), other.colorSpacePassthroughSettings())
                && Objects.equals(hdr10Settings(), other.hdr10Settings())
                && Objects.equals(rec601Settings(), other.rec601Settings())
                && Objects.equals(rec709Settings(), other.rec709Settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("H265ColorSpaceSettings").add("ColorSpacePassthroughSettings", colorSpacePassthroughSettings())
                .add("Hdr10Settings", hdr10Settings()).add("Rec601Settings", rec601Settings())
                .add("Rec709Settings", rec709Settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColorSpacePassthroughSettings":
            return Optional.ofNullable(clazz.cast(colorSpacePassthroughSettings()));
        case "Hdr10Settings":
            return Optional.ofNullable(clazz.cast(hdr10Settings()));
        case "Rec601Settings":
            return Optional.ofNullable(clazz.cast(rec601Settings()));
        case "Rec709Settings":
            return Optional.ofNullable(clazz.cast(rec709Settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H265ColorSpaceSettings, T> g) {
        return obj -> g.apply((H265ColorSpaceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, H265ColorSpaceSettings> {
        /**
         * Sets the value of the ColorSpacePassthroughSettings property for this object.
         *
         * @param colorSpacePassthroughSettings
         *        The new value for the ColorSpacePassthroughSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorSpacePassthroughSettings(ColorSpacePassthroughSettings colorSpacePassthroughSettings);

        /**
         * Sets the value of the ColorSpacePassthroughSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link ColorSpacePassthroughSettings.Builder} avoiding
         * the need to create one manually via {@link ColorSpacePassthroughSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ColorSpacePassthroughSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #colorSpacePassthroughSettings(ColorSpacePassthroughSettings)}
         * .
         * 
         * @param colorSpacePassthroughSettings
         *        a consumer that will call methods on {@link ColorSpacePassthroughSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorSpacePassthroughSettings(ColorSpacePassthroughSettings)
         */
        default Builder colorSpacePassthroughSettings(
                Consumer<ColorSpacePassthroughSettings.Builder> colorSpacePassthroughSettings) {
            return colorSpacePassthroughSettings(ColorSpacePassthroughSettings.builder()
                    .applyMutation(colorSpacePassthroughSettings).build());
        }

        /**
         * Sets the value of the Hdr10Settings property for this object.
         *
         * @param hdr10Settings
         *        The new value for the Hdr10Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hdr10Settings(Hdr10Settings hdr10Settings);

        /**
         * Sets the value of the Hdr10Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Hdr10Settings.Builder} avoiding the need to
         * create one manually via {@link Hdr10Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Hdr10Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #hdr10Settings(Hdr10Settings)}.
         * 
         * @param hdr10Settings
         *        a consumer that will call methods on {@link Hdr10Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hdr10Settings(Hdr10Settings)
         */
        default Builder hdr10Settings(Consumer<Hdr10Settings.Builder> hdr10Settings) {
            return hdr10Settings(Hdr10Settings.builder().applyMutation(hdr10Settings).build());
        }

        /**
         * Sets the value of the Rec601Settings property for this object.
         *
         * @param rec601Settings
         *        The new value for the Rec601Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rec601Settings(Rec601Settings rec601Settings);

        /**
         * Sets the value of the Rec601Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Rec601Settings.Builder} avoiding the need to
         * create one manually via {@link Rec601Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Rec601Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #rec601Settings(Rec601Settings)}.
         * 
         * @param rec601Settings
         *        a consumer that will call methods on {@link Rec601Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rec601Settings(Rec601Settings)
         */
        default Builder rec601Settings(Consumer<Rec601Settings.Builder> rec601Settings) {
            return rec601Settings(Rec601Settings.builder().applyMutation(rec601Settings).build());
        }

        /**
         * Sets the value of the Rec709Settings property for this object.
         *
         * @param rec709Settings
         *        The new value for the Rec709Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rec709Settings(Rec709Settings rec709Settings);

        /**
         * Sets the value of the Rec709Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Rec709Settings.Builder} avoiding the need to
         * create one manually via {@link Rec709Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Rec709Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #rec709Settings(Rec709Settings)}.
         * 
         * @param rec709Settings
         *        a consumer that will call methods on {@link Rec709Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rec709Settings(Rec709Settings)
         */
        default Builder rec709Settings(Consumer<Rec709Settings.Builder> rec709Settings) {
            return rec709Settings(Rec709Settings.builder().applyMutation(rec709Settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ColorSpacePassthroughSettings colorSpacePassthroughSettings;

        private Hdr10Settings hdr10Settings;

        private Rec601Settings rec601Settings;

        private Rec709Settings rec709Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(H265ColorSpaceSettings model) {
            colorSpacePassthroughSettings(model.colorSpacePassthroughSettings);
            hdr10Settings(model.hdr10Settings);
            rec601Settings(model.rec601Settings);
            rec709Settings(model.rec709Settings);
        }

        public final ColorSpacePassthroughSettings.Builder getColorSpacePassthroughSettings() {
            return colorSpacePassthroughSettings != null ? colorSpacePassthroughSettings.toBuilder() : null;
        }

        @Override
        public final Builder colorSpacePassthroughSettings(ColorSpacePassthroughSettings colorSpacePassthroughSettings) {
            this.colorSpacePassthroughSettings = colorSpacePassthroughSettings;
            return this;
        }

        public final void setColorSpacePassthroughSettings(ColorSpacePassthroughSettings.BuilderImpl colorSpacePassthroughSettings) {
            this.colorSpacePassthroughSettings = colorSpacePassthroughSettings != null ? colorSpacePassthroughSettings.build()
                    : null;
        }

        public final Hdr10Settings.Builder getHdr10Settings() {
            return hdr10Settings != null ? hdr10Settings.toBuilder() : null;
        }

        @Override
        public final Builder hdr10Settings(Hdr10Settings hdr10Settings) {
            this.hdr10Settings = hdr10Settings;
            return this;
        }

        public final void setHdr10Settings(Hdr10Settings.BuilderImpl hdr10Settings) {
            this.hdr10Settings = hdr10Settings != null ? hdr10Settings.build() : null;
        }

        public final Rec601Settings.Builder getRec601Settings() {
            return rec601Settings != null ? rec601Settings.toBuilder() : null;
        }

        @Override
        public final Builder rec601Settings(Rec601Settings rec601Settings) {
            this.rec601Settings = rec601Settings;
            return this;
        }

        public final void setRec601Settings(Rec601Settings.BuilderImpl rec601Settings) {
            this.rec601Settings = rec601Settings != null ? rec601Settings.build() : null;
        }

        public final Rec709Settings.Builder getRec709Settings() {
            return rec709Settings != null ? rec709Settings.toBuilder() : null;
        }

        @Override
        public final Builder rec709Settings(Rec709Settings rec709Settings) {
            this.rec709Settings = rec709Settings;
            return this;
        }

        public final void setRec709Settings(Rec709Settings.BuilderImpl rec709Settings) {
            this.rec709Settings = rec709Settings != null ? rec709Settings.build() : null;
        }

        @Override
        public H265ColorSpaceSettings build() {
            return new H265ColorSpaceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
