/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Frame Capture Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrameCaptureSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FrameCaptureSettings.Builder, FrameCaptureSettings> {
    private static final SdkField<Integer> CAPTURE_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(FrameCaptureSettings::captureInterval)).setter(setter(Builder::captureInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureInterval").build()).build();

    private static final SdkField<String> CAPTURE_INTERVAL_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FrameCaptureSettings::captureIntervalUnitsAsString)).setter(setter(Builder::captureIntervalUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureIntervalUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTURE_INTERVAL_FIELD,
            CAPTURE_INTERVAL_UNITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer captureInterval;

    private final String captureIntervalUnits;

    private FrameCaptureSettings(BuilderImpl builder) {
        this.captureInterval = builder.captureInterval;
        this.captureIntervalUnits = builder.captureIntervalUnits;
    }

    /**
     * The frequency at which to capture frames for inclusion in the output. May be specified in either seconds or
     * milliseconds, as specified by captureIntervalUnits.
     * 
     * @return The frequency at which to capture frames for inclusion in the output. May be specified in either seconds
     *         or milliseconds, as specified by captureIntervalUnits.
     */
    public Integer captureInterval() {
        return captureInterval;
    }

    /**
     * Unit for the frame capture interval.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captureIntervalUnits} will return {@link FrameCaptureIntervalUnit#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #captureIntervalUnitsAsString}.
     * </p>
     * 
     * @return Unit for the frame capture interval.
     * @see FrameCaptureIntervalUnit
     */
    public FrameCaptureIntervalUnit captureIntervalUnits() {
        return FrameCaptureIntervalUnit.fromValue(captureIntervalUnits);
    }

    /**
     * Unit for the frame capture interval.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captureIntervalUnits} will return {@link FrameCaptureIntervalUnit#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #captureIntervalUnitsAsString}.
     * </p>
     * 
     * @return Unit for the frame capture interval.
     * @see FrameCaptureIntervalUnit
     */
    public String captureIntervalUnitsAsString() {
        return captureIntervalUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(captureInterval());
        hashCode = 31 * hashCode + Objects.hashCode(captureIntervalUnitsAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameCaptureSettings)) {
            return false;
        }
        FrameCaptureSettings other = (FrameCaptureSettings) obj;
        return Objects.equals(captureInterval(), other.captureInterval())
                && Objects.equals(captureIntervalUnitsAsString(), other.captureIntervalUnitsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FrameCaptureSettings").add("CaptureInterval", captureInterval())
                .add("CaptureIntervalUnits", captureIntervalUnitsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaptureInterval":
            return Optional.ofNullable(clazz.cast(captureInterval()));
        case "CaptureIntervalUnits":
            return Optional.ofNullable(clazz.cast(captureIntervalUnitsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameCaptureSettings, T> g) {
        return obj -> g.apply((FrameCaptureSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrameCaptureSettings> {
        /**
         * The frequency at which to capture frames for inclusion in the output. May be specified in either seconds or
         * milliseconds, as specified by captureIntervalUnits.
         * 
         * @param captureInterval
         *        The frequency at which to capture frames for inclusion in the output. May be specified in either
         *        seconds or milliseconds, as specified by captureIntervalUnits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captureInterval(Integer captureInterval);

        /**
         * Unit for the frame capture interval.
         * 
         * @param captureIntervalUnits
         *        Unit for the frame capture interval.
         * @see FrameCaptureIntervalUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrameCaptureIntervalUnit
         */
        Builder captureIntervalUnits(String captureIntervalUnits);

        /**
         * Unit for the frame capture interval.
         * 
         * @param captureIntervalUnits
         *        Unit for the frame capture interval.
         * @see FrameCaptureIntervalUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrameCaptureIntervalUnit
         */
        Builder captureIntervalUnits(FrameCaptureIntervalUnit captureIntervalUnits);
    }

    static final class BuilderImpl implements Builder {
        private Integer captureInterval;

        private String captureIntervalUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameCaptureSettings model) {
            captureInterval(model.captureInterval);
            captureIntervalUnits(model.captureIntervalUnits);
        }

        public final Integer getCaptureInterval() {
            return captureInterval;
        }

        @Override
        public final Builder captureInterval(Integer captureInterval) {
            this.captureInterval = captureInterval;
            return this;
        }

        public final void setCaptureInterval(Integer captureInterval) {
            this.captureInterval = captureInterval;
        }

        public final String getCaptureIntervalUnits() {
            return captureIntervalUnits;
        }

        @Override
        public final Builder captureIntervalUnits(String captureIntervalUnits) {
            this.captureIntervalUnits = captureIntervalUnits;
            return this;
        }

        @Override
        public final Builder captureIntervalUnits(FrameCaptureIntervalUnit captureIntervalUnits) {
            this.captureIntervalUnits(captureIntervalUnits == null ? null : captureIntervalUnits.toString());
            return this;
        }

        public final void setCaptureIntervalUnits(String captureIntervalUnits) {
            this.captureIntervalUnits = captureIntervalUnits;
        }

        @Override
        public FrameCaptureSettings build() {
            return new FrameCaptureSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
