/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeScheduleResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScheduleResponse extends MediaLiveResponse implements
        ToCopyableBuilder<DescribeScheduleResponse.Builder, DescribeScheduleResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeScheduleResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ScheduleAction>> SCHEDULE_ACTIONS_FIELD = SdkField
            .<List<ScheduleAction>> builder(MarshallingType.LIST)
            .getter(getter(DescribeScheduleResponse::scheduleActions))
            .setter(setter(Builder::scheduleActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduleAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduleAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SCHEDULE_ACTIONS_FIELD));

    private final String nextToken;

    private final List<ScheduleAction> scheduleActions;

    private DescribeScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scheduleActions = builder.scheduleActions;
    }

    /**
     * The next token; for use in pagination.
     * 
     * @return The next token; for use in pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the ScheduleActions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasScheduleActions() {
        return scheduleActions != null && !(scheduleActions instanceof SdkAutoConstructList);
    }

    /**
     * The list of actions in the schedule.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScheduleActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of actions in the schedule.
     */
    public List<ScheduleAction> scheduleActions() {
        return scheduleActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleActions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduleResponse)) {
            return false;
        }
        DescribeScheduleResponse other = (DescribeScheduleResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(scheduleActions(), other.scheduleActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeScheduleResponse").add("NextToken", nextToken())
                .add("ScheduleActions", scheduleActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ScheduleActions":
            return Optional.ofNullable(clazz.cast(scheduleActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduleResponse, T> g) {
        return obj -> g.apply((DescribeScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeScheduleResponse> {
        /**
         * The next token; for use in pagination.
         * 
         * @param nextToken
         *        The next token; for use in pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * The list of actions in the schedule.
         * 
         * @param scheduleActions
         *        The list of actions in the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleActions(Collection<ScheduleAction> scheduleActions);

        /**
         * The list of actions in the schedule.
         * 
         * @param scheduleActions
         *        The list of actions in the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleActions(ScheduleAction... scheduleActions);

        /**
         * The list of actions in the schedule. This is a convenience that creates an instance of the {@link List
         * <ScheduleAction>.Builder} avoiding the need to create one manually via {@link List<ScheduleAction>#builder()}
         * .
         *
         * When the {@link Consumer} completes, {@link List<ScheduleAction>.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleActions(List<ScheduleAction>)}.
         * 
         * @param scheduleActions
         *        a consumer that will call methods on {@link List<ScheduleAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleActions(List<ScheduleAction>)
         */
        Builder scheduleActions(Consumer<ScheduleAction.Builder>... scheduleActions);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ScheduleAction> scheduleActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduleResponse model) {
            super(model);
            nextToken(model.nextToken);
            scheduleActions(model.scheduleActions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ScheduleAction.Builder> getScheduleActions() {
            return scheduleActions != null ? scheduleActions.stream().map(ScheduleAction::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder scheduleActions(Collection<ScheduleAction> scheduleActions) {
            this.scheduleActions = ___listOfScheduleActionCopier.copy(scheduleActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleActions(ScheduleAction... scheduleActions) {
            scheduleActions(Arrays.asList(scheduleActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleActions(Consumer<ScheduleAction.Builder>... scheduleActions) {
            scheduleActions(Stream.of(scheduleActions).map(c -> ScheduleAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setScheduleActions(Collection<ScheduleAction.BuilderImpl> scheduleActions) {
            this.scheduleActions = ___listOfScheduleActionCopier.copyFromBuilder(scheduleActions);
        }

        @Override
        public DescribeScheduleResponse build() {
            return new DescribeScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
