/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeReservationResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservationResponse extends MediaLiveResponse implements
        ToCopyableBuilder<DescribeReservationResponse.Builder, DescribeReservationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeReservationResponse::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeReservationResponse::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<String> DURATION_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::durationUnitsAsString)).setter(setter(Builder::durationUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationUnits").build()).build();

    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DescribeReservationResponse::fixedPrice)).setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedPrice").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OFFERING_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::offeringDescription)).setter(setter(Builder::offeringDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringDescription").build())
            .build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()).build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::offeringTypeAsString)).setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringType").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::reservationId)).setter(setter(Builder::reservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationId").build()).build();

    private static final SdkField<ReservationResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField
            .<ReservationResourceSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeReservationResponse::resourceSpecification)).setter(setter(Builder::resourceSpecification))
            .constructor(ReservationResourceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build())
            .build();

    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservationResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DescribeReservationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DescribeReservationResponse::usagePrice)).setter(setter(Builder::usagePrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usagePrice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COUNT_FIELD,
            CURRENCY_CODE_FIELD, DURATION_FIELD, DURATION_UNITS_FIELD, END_FIELD, FIXED_PRICE_FIELD, NAME_FIELD,
            OFFERING_DESCRIPTION_FIELD, OFFERING_ID_FIELD, OFFERING_TYPE_FIELD, REGION_FIELD, RESERVATION_ID_FIELD,
            RESOURCE_SPECIFICATION_FIELD, START_FIELD, STATE_FIELD, TAGS_FIELD, USAGE_PRICE_FIELD));

    private final String arn;

    private final Integer count;

    private final String currencyCode;

    private final Integer duration;

    private final String durationUnits;

    private final String end;

    private final Double fixedPrice;

    private final String name;

    private final String offeringDescription;

    private final String offeringId;

    private final String offeringType;

    private final String region;

    private final String reservationId;

    private final ReservationResourceSpecification resourceSpecification;

    private final String start;

    private final String state;

    private final Map<String, String> tags;

    private final Double usagePrice;

    private DescribeReservationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.count = builder.count;
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.durationUnits = builder.durationUnits;
        this.end = builder.end;
        this.fixedPrice = builder.fixedPrice;
        this.name = builder.name;
        this.offeringDescription = builder.offeringDescription;
        this.offeringId = builder.offeringId;
        this.offeringType = builder.offeringType;
        this.region = builder.region;
        this.reservationId = builder.reservationId;
        this.resourceSpecification = builder.resourceSpecification;
        this.start = builder.start;
        this.state = builder.state;
        this.tags = builder.tags;
        this.usagePrice = builder.usagePrice;
    }

    /**
     * Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
     * 
     * @return Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
     */
    public String arn() {
        return arn;
    }

    /**
     * Number of reserved resources
     * 
     * @return Number of reserved resources
     */
    public Integer count() {
        return count;
    }

    /**
     * Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
     * 
     * @return Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
     */
    public String currencyCode() {
        return currencyCode;
    }

    /**
     * Lease duration, e.g. '12'
     * 
     * @return Lease duration, e.g. '12'
     */
    public Integer duration() {
        return duration;
    }

    /**
     * Units for duration, e.g. 'MONTHS'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationUnits}
     * will return {@link OfferingDurationUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #durationUnitsAsString}.
     * </p>
     * 
     * @return Units for duration, e.g. 'MONTHS'
     * @see OfferingDurationUnits
     */
    public OfferingDurationUnits durationUnits() {
        return OfferingDurationUnits.fromValue(durationUnits);
    }

    /**
     * Units for duration, e.g. 'MONTHS'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationUnits}
     * will return {@link OfferingDurationUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #durationUnitsAsString}.
     * </p>
     * 
     * @return Units for duration, e.g. 'MONTHS'
     * @see OfferingDurationUnits
     */
    public String durationUnitsAsString() {
        return durationUnits;
    }

    /**
     * Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
     * 
     * @return Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
     */
    public String end() {
        return end;
    }

    /**
     * One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
     * 
     * @return One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
     */
    public Double fixedPrice() {
        return fixedPrice;
    }

    /**
     * User specified reservation name
     * 
     * @return User specified reservation name
     */
    public String name() {
        return name;
    }

    /**
     * Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
     * 
     * @return Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
     */
    public String offeringDescription() {
        return offeringDescription;
    }

    /**
     * Unique offering ID, e.g. '87654321'
     * 
     * @return Unique offering ID, e.g. '87654321'
     */
    public String offeringId() {
        return offeringId;
    }

    /**
     * Offering type, e.g. 'NO_UPFRONT'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return Offering type, e.g. 'NO_UPFRONT'
     * @see OfferingType
     */
    public OfferingType offeringType() {
        return OfferingType.fromValue(offeringType);
    }

    /**
     * Offering type, e.g. 'NO_UPFRONT'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return Offering type, e.g. 'NO_UPFRONT'
     * @see OfferingType
     */
    public String offeringTypeAsString() {
        return offeringType;
    }

    /**
     * AWS region, e.g. 'us-west-2'
     * 
     * @return AWS region, e.g. 'us-west-2'
     */
    public String region() {
        return region;
    }

    /**
     * Unique reservation ID, e.g. '1234567'
     * 
     * @return Unique reservation ID, e.g. '1234567'
     */
    public String reservationId() {
        return reservationId;
    }

    /**
     * Resource configuration details
     * 
     * @return Resource configuration details
     */
    public ReservationResourceSpecification resourceSpecification() {
        return resourceSpecification;
    }

    /**
     * Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
     * 
     * @return Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
     */
    public String start() {
        return start;
    }

    /**
     * Current state of reservation, e.g. 'ACTIVE'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Current state of reservation, e.g. 'ACTIVE'
     * @see ReservationState
     */
    public ReservationState state() {
        return ReservationState.fromValue(state);
    }

    /**
     * Current state of reservation, e.g. 'ACTIVE'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Current state of reservation, e.g. 'ACTIVE'
     * @see ReservationState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of key-value pairs
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * Recurring usage charge for each reserved resource, e.g. '157.0'
     * 
     * @return Recurring usage charge for each reserved resource, e.g. '157.0'
     */
    public Double usagePrice() {
        return usagePrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(durationUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(offeringDescription());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(reservationId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservationResponse)) {
            return false;
        }
        DescribeReservationResponse other = (DescribeReservationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(count(), other.count())
                && Objects.equals(currencyCode(), other.currencyCode()) && Objects.equals(duration(), other.duration())
                && Objects.equals(durationUnitsAsString(), other.durationUnitsAsString()) && Objects.equals(end(), other.end())
                && Objects.equals(fixedPrice(), other.fixedPrice()) && Objects.equals(name(), other.name())
                && Objects.equals(offeringDescription(), other.offeringDescription())
                && Objects.equals(offeringId(), other.offeringId())
                && Objects.equals(offeringTypeAsString(), other.offeringTypeAsString())
                && Objects.equals(region(), other.region()) && Objects.equals(reservationId(), other.reservationId())
                && Objects.equals(resourceSpecification(), other.resourceSpecification())
                && Objects.equals(start(), other.start()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(tags(), other.tags()) && Objects.equals(usagePrice(), other.usagePrice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeReservationResponse").add("Arn", arn()).add("Count", count())
                .add("CurrencyCode", currencyCode()).add("Duration", duration()).add("DurationUnits", durationUnitsAsString())
                .add("End", end()).add("FixedPrice", fixedPrice()).add("Name", name())
                .add("OfferingDescription", offeringDescription()).add("OfferingId", offeringId())
                .add("OfferingType", offeringTypeAsString()).add("Region", region()).add("ReservationId", reservationId())
                .add("ResourceSpecification", resourceSpecification()).add("Start", start()).add("State", stateAsString())
                .add("Tags", tags()).add("UsagePrice", usagePrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "DurationUnits":
            return Optional.ofNullable(clazz.cast(durationUnitsAsString()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OfferingDescription":
            return Optional.ofNullable(clazz.cast(offeringDescription()));
        case "OfferingId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringTypeAsString()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "ReservationId":
            return Optional.ofNullable(clazz.cast(reservationId()));
        case "ResourceSpecification":
            return Optional.ofNullable(clazz.cast(resourceSpecification()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UsagePrice":
            return Optional.ofNullable(clazz.cast(usagePrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservationResponse, T> g) {
        return obj -> g.apply((DescribeReservationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReservationResponse> {
        /**
         * Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
         * 
         * @param arn
         *        Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Number of reserved resources
         * 
         * @param count
         *        Number of reserved resources
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
         * 
         * @param currencyCode
         *        Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * Lease duration, e.g. '12'
         * 
         * @param duration
         *        Lease duration, e.g. '12'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * Units for duration, e.g. 'MONTHS'
         * 
         * @param durationUnits
         *        Units for duration, e.g. 'MONTHS'
         * @see OfferingDurationUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingDurationUnits
         */
        Builder durationUnits(String durationUnits);

        /**
         * Units for duration, e.g. 'MONTHS'
         * 
         * @param durationUnits
         *        Units for duration, e.g. 'MONTHS'
         * @see OfferingDurationUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingDurationUnits
         */
        Builder durationUnits(OfferingDurationUnits durationUnits);

        /**
         * Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
         * 
         * @param end
         *        Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);

        /**
         * One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
         * 
         * @param fixedPrice
         *        One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Double fixedPrice);

        /**
         * User specified reservation name
         * 
         * @param name
         *        User specified reservation name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
         * 
         * @param offeringDescription
         *        Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringDescription(String offeringDescription);

        /**
         * Unique offering ID, e.g. '87654321'
         * 
         * @param offeringId
         *        Unique offering ID, e.g. '87654321'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * Offering type, e.g. 'NO_UPFRONT'
         * 
         * @param offeringType
         *        Offering type, e.g. 'NO_UPFRONT'
         * @see OfferingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingType
         */
        Builder offeringType(String offeringType);

        /**
         * Offering type, e.g. 'NO_UPFRONT'
         * 
         * @param offeringType
         *        Offering type, e.g. 'NO_UPFRONT'
         * @see OfferingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingType
         */
        Builder offeringType(OfferingType offeringType);

        /**
         * AWS region, e.g. 'us-west-2'
         * 
         * @param region
         *        AWS region, e.g. 'us-west-2'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * Unique reservation ID, e.g. '1234567'
         * 
         * @param reservationId
         *        Unique reservation ID, e.g. '1234567'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationId(String reservationId);

        /**
         * Resource configuration details
         * 
         * @param resourceSpecification
         *        Resource configuration details
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpecification(ReservationResourceSpecification resourceSpecification);

        /**
         * Resource configuration details This is a convenience that creates an instance of the
         * {@link ReservationResourceSpecification.Builder} avoiding the need to create one manually via
         * {@link ReservationResourceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationResourceSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceSpecification(ReservationResourceSpecification)}.
         * 
         * @param resourceSpecification
         *        a consumer that will call methods on {@link ReservationResourceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpecification(ReservationResourceSpecification)
         */
        default Builder resourceSpecification(Consumer<ReservationResourceSpecification.Builder> resourceSpecification) {
            return resourceSpecification(ReservationResourceSpecification.builder().applyMutation(resourceSpecification).build());
        }

        /**
         * Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
         * 
         * @param start
         *        Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        /**
         * Current state of reservation, e.g. 'ACTIVE'
         * 
         * @param state
         *        Current state of reservation, e.g. 'ACTIVE'
         * @see ReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationState
         */
        Builder state(String state);

        /**
         * Current state of reservation, e.g. 'ACTIVE'
         * 
         * @param state
         *        Current state of reservation, e.g. 'ACTIVE'
         * @see ReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationState
         */
        Builder state(ReservationState state);

        /**
         * A collection of key-value pairs
         * 
         * @param tags
         *        A collection of key-value pairs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Recurring usage charge for each reserved resource, e.g. '157.0'
         * 
         * @param usagePrice
         *        Recurring usage charge for each reserved resource, e.g. '157.0'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Double usagePrice);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private Integer count;

        private String currencyCode;

        private Integer duration;

        private String durationUnits;

        private String end;

        private Double fixedPrice;

        private String name;

        private String offeringDescription;

        private String offeringId;

        private String offeringType;

        private String region;

        private String reservationId;

        private ReservationResourceSpecification resourceSpecification;

        private String start;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Double usagePrice;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservationResponse model) {
            super(model);
            arn(model.arn);
            count(model.count);
            currencyCode(model.currencyCode);
            duration(model.duration);
            durationUnits(model.durationUnits);
            end(model.end);
            fixedPrice(model.fixedPrice);
            name(model.name);
            offeringDescription(model.offeringDescription);
            offeringId(model.offeringId);
            offeringType(model.offeringType);
            region(model.region);
            reservationId(model.reservationId);
            resourceSpecification(model.resourceSpecification);
            start(model.start);
            state(model.state);
            tags(model.tags);
            usagePrice(model.usagePrice);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getDurationUnits() {
            return durationUnits;
        }

        @Override
        public final Builder durationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
            return this;
        }

        @Override
        public final Builder durationUnits(OfferingDurationUnits durationUnits) {
            this.durationUnits(durationUnits == null ? null : durationUnits.toString());
            return this;
        }

        public final void setDurationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
        }

        public final String getEnd() {
            return end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        public final Double getFixedPrice() {
            return fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOfferingDescription() {
            return offeringDescription;
        }

        @Override
        public final Builder offeringDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
            return this;
        }

        public final void setOfferingDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingType offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getReservationId() {
            return reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        public final ReservationResourceSpecification.Builder getResourceSpecification() {
            return resourceSpecification != null ? resourceSpecification.toBuilder() : null;
        }

        @Override
        public final Builder resourceSpecification(ReservationResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final void setResourceSpecification(ReservationResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        public final String getStart() {
            return start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Double getUsagePrice() {
            return usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        public DescribeReservationResponse build() {
            return new DescribeReservationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
