/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Caption Selector Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionSelectorSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptionSelectorSettings.Builder, CaptionSelectorSettings> {
    private static final SdkField<AribSourceSettings> ARIB_SOURCE_SETTINGS_FIELD = SdkField
            .<AribSourceSettings> builder(MarshallingType.SDK_POJO).getter(getter(CaptionSelectorSettings::aribSourceSettings))
            .setter(setter(Builder::aribSourceSettings)).constructor(AribSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aribSourceSettings").build())
            .build();

    private static final SdkField<DvbSubSourceSettings> DVB_SUB_SOURCE_SETTINGS_FIELD = SdkField
            .<DvbSubSourceSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(CaptionSelectorSettings::dvbSubSourceSettings)).setter(setter(Builder::dvbSubSourceSettings))
            .constructor(DvbSubSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSubSourceSettings").build())
            .build();

    private static final SdkField<EmbeddedSourceSettings> EMBEDDED_SOURCE_SETTINGS_FIELD = SdkField
            .<EmbeddedSourceSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(CaptionSelectorSettings::embeddedSourceSettings)).setter(setter(Builder::embeddedSourceSettings))
            .constructor(EmbeddedSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddedSourceSettings").build())
            .build();

    private static final SdkField<Scte20SourceSettings> SCTE20_SOURCE_SETTINGS_FIELD = SdkField
            .<Scte20SourceSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(CaptionSelectorSettings::scte20SourceSettings)).setter(setter(Builder::scte20SourceSettings))
            .constructor(Scte20SourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte20SourceSettings").build())
            .build();

    private static final SdkField<Scte27SourceSettings> SCTE27_SOURCE_SETTINGS_FIELD = SdkField
            .<Scte27SourceSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(CaptionSelectorSettings::scte27SourceSettings)).setter(setter(Builder::scte27SourceSettings))
            .constructor(Scte27SourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte27SourceSettings").build())
            .build();

    private static final SdkField<TeletextSourceSettings> TELETEXT_SOURCE_SETTINGS_FIELD = SdkField
            .<TeletextSourceSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(CaptionSelectorSettings::teletextSourceSettings)).setter(setter(Builder::teletextSourceSettings))
            .constructor(TeletextSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextSourceSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARIB_SOURCE_SETTINGS_FIELD,
            DVB_SUB_SOURCE_SETTINGS_FIELD, EMBEDDED_SOURCE_SETTINGS_FIELD, SCTE20_SOURCE_SETTINGS_FIELD,
            SCTE27_SOURCE_SETTINGS_FIELD, TELETEXT_SOURCE_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AribSourceSettings aribSourceSettings;

    private final DvbSubSourceSettings dvbSubSourceSettings;

    private final EmbeddedSourceSettings embeddedSourceSettings;

    private final Scte20SourceSettings scte20SourceSettings;

    private final Scte27SourceSettings scte27SourceSettings;

    private final TeletextSourceSettings teletextSourceSettings;

    private CaptionSelectorSettings(BuilderImpl builder) {
        this.aribSourceSettings = builder.aribSourceSettings;
        this.dvbSubSourceSettings = builder.dvbSubSourceSettings;
        this.embeddedSourceSettings = builder.embeddedSourceSettings;
        this.scte20SourceSettings = builder.scte20SourceSettings;
        this.scte27SourceSettings = builder.scte27SourceSettings;
        this.teletextSourceSettings = builder.teletextSourceSettings;
    }

    /**
     * Returns the value of the AribSourceSettings property for this object.
     * 
     * @return The value of the AribSourceSettings property for this object.
     */
    public AribSourceSettings aribSourceSettings() {
        return aribSourceSettings;
    }

    /**
     * Returns the value of the DvbSubSourceSettings property for this object.
     * 
     * @return The value of the DvbSubSourceSettings property for this object.
     */
    public DvbSubSourceSettings dvbSubSourceSettings() {
        return dvbSubSourceSettings;
    }

    /**
     * Returns the value of the EmbeddedSourceSettings property for this object.
     * 
     * @return The value of the EmbeddedSourceSettings property for this object.
     */
    public EmbeddedSourceSettings embeddedSourceSettings() {
        return embeddedSourceSettings;
    }

    /**
     * Returns the value of the Scte20SourceSettings property for this object.
     * 
     * @return The value of the Scte20SourceSettings property for this object.
     */
    public Scte20SourceSettings scte20SourceSettings() {
        return scte20SourceSettings;
    }

    /**
     * Returns the value of the Scte27SourceSettings property for this object.
     * 
     * @return The value of the Scte27SourceSettings property for this object.
     */
    public Scte27SourceSettings scte27SourceSettings() {
        return scte27SourceSettings;
    }

    /**
     * Returns the value of the TeletextSourceSettings property for this object.
     * 
     * @return The value of the TeletextSourceSettings property for this object.
     */
    public TeletextSourceSettings teletextSourceSettings() {
        return teletextSourceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aribSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(dvbSubSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(embeddedSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(scte20SourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(scte27SourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(teletextSourceSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSelectorSettings)) {
            return false;
        }
        CaptionSelectorSettings other = (CaptionSelectorSettings) obj;
        return Objects.equals(aribSourceSettings(), other.aribSourceSettings())
                && Objects.equals(dvbSubSourceSettings(), other.dvbSubSourceSettings())
                && Objects.equals(embeddedSourceSettings(), other.embeddedSourceSettings())
                && Objects.equals(scte20SourceSettings(), other.scte20SourceSettings())
                && Objects.equals(scte27SourceSettings(), other.scte27SourceSettings())
                && Objects.equals(teletextSourceSettings(), other.teletextSourceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CaptionSelectorSettings").add("AribSourceSettings", aribSourceSettings())
                .add("DvbSubSourceSettings", dvbSubSourceSettings()).add("EmbeddedSourceSettings", embeddedSourceSettings())
                .add("Scte20SourceSettings", scte20SourceSettings()).add("Scte27SourceSettings", scte27SourceSettings())
                .add("TeletextSourceSettings", teletextSourceSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AribSourceSettings":
            return Optional.ofNullable(clazz.cast(aribSourceSettings()));
        case "DvbSubSourceSettings":
            return Optional.ofNullable(clazz.cast(dvbSubSourceSettings()));
        case "EmbeddedSourceSettings":
            return Optional.ofNullable(clazz.cast(embeddedSourceSettings()));
        case "Scte20SourceSettings":
            return Optional.ofNullable(clazz.cast(scte20SourceSettings()));
        case "Scte27SourceSettings":
            return Optional.ofNullable(clazz.cast(scte27SourceSettings()));
        case "TeletextSourceSettings":
            return Optional.ofNullable(clazz.cast(teletextSourceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionSelectorSettings, T> g) {
        return obj -> g.apply((CaptionSelectorSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionSelectorSettings> {
        /**
         * Sets the value of the AribSourceSettings property for this object.
         *
         * @param aribSourceSettings
         *        The new value for the AribSourceSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aribSourceSettings(AribSourceSettings aribSourceSettings);

        /**
         * Sets the value of the AribSourceSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link AribSourceSettings.Builder} avoiding the need to
         * create one manually via {@link AribSourceSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AribSourceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #aribSourceSettings(AribSourceSettings)}.
         * 
         * @param aribSourceSettings
         *        a consumer that will call methods on {@link AribSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aribSourceSettings(AribSourceSettings)
         */
        default Builder aribSourceSettings(Consumer<AribSourceSettings.Builder> aribSourceSettings) {
            return aribSourceSettings(AribSourceSettings.builder().applyMutation(aribSourceSettings).build());
        }

        /**
         * Sets the value of the DvbSubSourceSettings property for this object.
         *
         * @param dvbSubSourceSettings
         *        The new value for the DvbSubSourceSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbSubSourceSettings(DvbSubSourceSettings dvbSubSourceSettings);

        /**
         * Sets the value of the DvbSubSourceSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link DvbSubSourceSettings.Builder} avoiding the need
         * to create one manually via {@link DvbSubSourceSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DvbSubSourceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #dvbSubSourceSettings(DvbSubSourceSettings)}.
         * 
         * @param dvbSubSourceSettings
         *        a consumer that will call methods on {@link DvbSubSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dvbSubSourceSettings(DvbSubSourceSettings)
         */
        default Builder dvbSubSourceSettings(Consumer<DvbSubSourceSettings.Builder> dvbSubSourceSettings) {
            return dvbSubSourceSettings(DvbSubSourceSettings.builder().applyMutation(dvbSubSourceSettings).build());
        }

        /**
         * Sets the value of the EmbeddedSourceSettings property for this object.
         *
         * @param embeddedSourceSettings
         *        The new value for the EmbeddedSourceSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embeddedSourceSettings(EmbeddedSourceSettings embeddedSourceSettings);

        /**
         * Sets the value of the EmbeddedSourceSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link EmbeddedSourceSettings.Builder} avoiding the
         * need to create one manually via {@link EmbeddedSourceSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmbeddedSourceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #embeddedSourceSettings(EmbeddedSourceSettings)}.
         * 
         * @param embeddedSourceSettings
         *        a consumer that will call methods on {@link EmbeddedSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #embeddedSourceSettings(EmbeddedSourceSettings)
         */
        default Builder embeddedSourceSettings(Consumer<EmbeddedSourceSettings.Builder> embeddedSourceSettings) {
            return embeddedSourceSettings(EmbeddedSourceSettings.builder().applyMutation(embeddedSourceSettings).build());
        }

        /**
         * Sets the value of the Scte20SourceSettings property for this object.
         *
         * @param scte20SourceSettings
         *        The new value for the Scte20SourceSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte20SourceSettings(Scte20SourceSettings scte20SourceSettings);

        /**
         * Sets the value of the Scte20SourceSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Scte20SourceSettings.Builder} avoiding the need
         * to create one manually via {@link Scte20SourceSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scte20SourceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #scte20SourceSettings(Scte20SourceSettings)}.
         * 
         * @param scte20SourceSettings
         *        a consumer that will call methods on {@link Scte20SourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte20SourceSettings(Scte20SourceSettings)
         */
        default Builder scte20SourceSettings(Consumer<Scte20SourceSettings.Builder> scte20SourceSettings) {
            return scte20SourceSettings(Scte20SourceSettings.builder().applyMutation(scte20SourceSettings).build());
        }

        /**
         * Sets the value of the Scte27SourceSettings property for this object.
         *
         * @param scte27SourceSettings
         *        The new value for the Scte27SourceSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte27SourceSettings(Scte27SourceSettings scte27SourceSettings);

        /**
         * Sets the value of the Scte27SourceSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Scte27SourceSettings.Builder} avoiding the need
         * to create one manually via {@link Scte27SourceSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scte27SourceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #scte27SourceSettings(Scte27SourceSettings)}.
         * 
         * @param scte27SourceSettings
         *        a consumer that will call methods on {@link Scte27SourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte27SourceSettings(Scte27SourceSettings)
         */
        default Builder scte27SourceSettings(Consumer<Scte27SourceSettings.Builder> scte27SourceSettings) {
            return scte27SourceSettings(Scte27SourceSettings.builder().applyMutation(scte27SourceSettings).build());
        }

        /**
         * Sets the value of the TeletextSourceSettings property for this object.
         *
         * @param teletextSourceSettings
         *        The new value for the TeletextSourceSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teletextSourceSettings(TeletextSourceSettings teletextSourceSettings);

        /**
         * Sets the value of the TeletextSourceSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link TeletextSourceSettings.Builder} avoiding the
         * need to create one manually via {@link TeletextSourceSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link TeletextSourceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #teletextSourceSettings(TeletextSourceSettings)}.
         * 
         * @param teletextSourceSettings
         *        a consumer that will call methods on {@link TeletextSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #teletextSourceSettings(TeletextSourceSettings)
         */
        default Builder teletextSourceSettings(Consumer<TeletextSourceSettings.Builder> teletextSourceSettings) {
            return teletextSourceSettings(TeletextSourceSettings.builder().applyMutation(teletextSourceSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AribSourceSettings aribSourceSettings;

        private DvbSubSourceSettings dvbSubSourceSettings;

        private EmbeddedSourceSettings embeddedSourceSettings;

        private Scte20SourceSettings scte20SourceSettings;

        private Scte27SourceSettings scte27SourceSettings;

        private TeletextSourceSettings teletextSourceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSelectorSettings model) {
            aribSourceSettings(model.aribSourceSettings);
            dvbSubSourceSettings(model.dvbSubSourceSettings);
            embeddedSourceSettings(model.embeddedSourceSettings);
            scte20SourceSettings(model.scte20SourceSettings);
            scte27SourceSettings(model.scte27SourceSettings);
            teletextSourceSettings(model.teletextSourceSettings);
        }

        public final AribSourceSettings.Builder getAribSourceSettings() {
            return aribSourceSettings != null ? aribSourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder aribSourceSettings(AribSourceSettings aribSourceSettings) {
            this.aribSourceSettings = aribSourceSettings;
            return this;
        }

        public final void setAribSourceSettings(AribSourceSettings.BuilderImpl aribSourceSettings) {
            this.aribSourceSettings = aribSourceSettings != null ? aribSourceSettings.build() : null;
        }

        public final DvbSubSourceSettings.Builder getDvbSubSourceSettings() {
            return dvbSubSourceSettings != null ? dvbSubSourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbSubSourceSettings(DvbSubSourceSettings dvbSubSourceSettings) {
            this.dvbSubSourceSettings = dvbSubSourceSettings;
            return this;
        }

        public final void setDvbSubSourceSettings(DvbSubSourceSettings.BuilderImpl dvbSubSourceSettings) {
            this.dvbSubSourceSettings = dvbSubSourceSettings != null ? dvbSubSourceSettings.build() : null;
        }

        public final EmbeddedSourceSettings.Builder getEmbeddedSourceSettings() {
            return embeddedSourceSettings != null ? embeddedSourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder embeddedSourceSettings(EmbeddedSourceSettings embeddedSourceSettings) {
            this.embeddedSourceSettings = embeddedSourceSettings;
            return this;
        }

        public final void setEmbeddedSourceSettings(EmbeddedSourceSettings.BuilderImpl embeddedSourceSettings) {
            this.embeddedSourceSettings = embeddedSourceSettings != null ? embeddedSourceSettings.build() : null;
        }

        public final Scte20SourceSettings.Builder getScte20SourceSettings() {
            return scte20SourceSettings != null ? scte20SourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder scte20SourceSettings(Scte20SourceSettings scte20SourceSettings) {
            this.scte20SourceSettings = scte20SourceSettings;
            return this;
        }

        public final void setScte20SourceSettings(Scte20SourceSettings.BuilderImpl scte20SourceSettings) {
            this.scte20SourceSettings = scte20SourceSettings != null ? scte20SourceSettings.build() : null;
        }

        public final Scte27SourceSettings.Builder getScte27SourceSettings() {
            return scte27SourceSettings != null ? scte27SourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder scte27SourceSettings(Scte27SourceSettings scte27SourceSettings) {
            this.scte27SourceSettings = scte27SourceSettings;
            return this;
        }

        public final void setScte27SourceSettings(Scte27SourceSettings.BuilderImpl scte27SourceSettings) {
            this.scte27SourceSettings = scte27SourceSettings != null ? scte27SourceSettings.build() : null;
        }

        public final TeletextSourceSettings.Builder getTeletextSourceSettings() {
            return teletextSourceSettings != null ? teletextSourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder teletextSourceSettings(TeletextSourceSettings teletextSourceSettings) {
            this.teletextSourceSettings = teletextSourceSettings;
            return this;
        }

        public final void setTeletextSourceSettings(TeletextSourceSettings.BuilderImpl teletextSourceSettings) {
            this.teletextSourceSettings = teletextSourceSettings != null ? teletextSourceSettings.build() : null;
        }

        @Override
        public CaptionSelectorSettings build() {
            return new CaptionSelectorSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
