/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Blackout Slate
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlackoutSlate implements SdkPojo, Serializable, ToCopyableBuilder<BlackoutSlate.Builder, BlackoutSlate> {
    private static final SdkField<InputLocation> BLACKOUT_SLATE_IMAGE_FIELD = SdkField
            .<InputLocation> builder(MarshallingType.SDK_POJO).getter(getter(BlackoutSlate::blackoutSlateImage))
            .setter(setter(Builder::blackoutSlateImage)).constructor(InputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blackoutSlateImage").build())
            .build();

    private static final SdkField<String> NETWORK_END_BLACKOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BlackoutSlate::networkEndBlackoutAsString)).setter(setter(Builder::networkEndBlackout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkEndBlackout").build())
            .build();

    private static final SdkField<InputLocation> NETWORK_END_BLACKOUT_IMAGE_FIELD = SdkField
            .<InputLocation> builder(MarshallingType.SDK_POJO).getter(getter(BlackoutSlate::networkEndBlackoutImage))
            .setter(setter(Builder::networkEndBlackoutImage)).constructor(InputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkEndBlackoutImage").build())
            .build();

    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BlackoutSlate::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BlackoutSlate::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACKOUT_SLATE_IMAGE_FIELD,
            NETWORK_END_BLACKOUT_FIELD, NETWORK_END_BLACKOUT_IMAGE_FIELD, NETWORK_ID_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final InputLocation blackoutSlateImage;

    private final String networkEndBlackout;

    private final InputLocation networkEndBlackoutImage;

    private final String networkId;

    private final String state;

    private BlackoutSlate(BuilderImpl builder) {
        this.blackoutSlateImage = builder.blackoutSlateImage;
        this.networkEndBlackout = builder.networkEndBlackout;
        this.networkEndBlackoutImage = builder.networkEndBlackoutImage;
        this.networkId = builder.networkId;
        this.state = builder.state;
    }

    /**
     * Blackout slate image to be used. Leave empty for solid black. Only bmp and png images are supported.
     * 
     * @return Blackout slate image to be used. Leave empty for solid black. Only bmp and png images are supported.
     */
    public InputLocation blackoutSlateImage() {
        return blackoutSlateImage;
    }

    /**
     * Setting to enabled causes the encoder to blackout the video, audio, and captions, and raise the
     * "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered. The
     * blackout will be lifted when the Network Start Segmentation Descriptor is encountered. The Network End and
     * Network Start descriptors must contain a network ID that matches the value entered in "Network ID".
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #networkEndBlackout} will return {@link BlackoutSlateNetworkEndBlackout#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #networkEndBlackoutAsString}.
     * </p>
     * 
     * @return Setting to enabled causes the encoder to blackout the video, audio, and captions, and raise the
     *         "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered. The
     *         blackout will be lifted when the Network Start Segmentation Descriptor is encountered. The Network End
     *         and Network Start descriptors must contain a network ID that matches the value entered in "Network ID".
     * @see BlackoutSlateNetworkEndBlackout
     */
    public BlackoutSlateNetworkEndBlackout networkEndBlackout() {
        return BlackoutSlateNetworkEndBlackout.fromValue(networkEndBlackout);
    }

    /**
     * Setting to enabled causes the encoder to blackout the video, audio, and captions, and raise the
     * "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered. The
     * blackout will be lifted when the Network Start Segmentation Descriptor is encountered. The Network End and
     * Network Start descriptors must contain a network ID that matches the value entered in "Network ID".
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #networkEndBlackout} will return {@link BlackoutSlateNetworkEndBlackout#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #networkEndBlackoutAsString}.
     * </p>
     * 
     * @return Setting to enabled causes the encoder to blackout the video, audio, and captions, and raise the
     *         "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered. The
     *         blackout will be lifted when the Network Start Segmentation Descriptor is encountered. The Network End
     *         and Network Start descriptors must contain a network ID that matches the value entered in "Network ID".
     * @see BlackoutSlateNetworkEndBlackout
     */
    public String networkEndBlackoutAsString() {
        return networkEndBlackout;
    }

    /**
     * Path to local file to use as Network End Blackout image. Image will be scaled to fill the entire output raster.
     * 
     * @return Path to local file to use as Network End Blackout image. Image will be scaled to fill the entire output
     *         raster.
     */
    public InputLocation networkEndBlackoutImage() {
        return networkEndBlackoutImage;
    }

    /**
     * Provides Network ID that matches EIDR ID format (e.g., "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
     * 
     * @return Provides Network ID that matches EIDR ID format (e.g., "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
     */
    public String networkId() {
        return networkId;
    }

    /**
     * When set to enabled, causes video, audio and captions to be blanked when indicated by program metadata.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link BlackoutSlateState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return When set to enabled, causes video, audio and captions to be blanked when indicated by program metadata.
     * @see BlackoutSlateState
     */
    public BlackoutSlateState state() {
        return BlackoutSlateState.fromValue(state);
    }

    /**
     * When set to enabled, causes video, audio and captions to be blanked when indicated by program metadata.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link BlackoutSlateState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return When set to enabled, causes video, audio and captions to be blanked when indicated by program metadata.
     * @see BlackoutSlateState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blackoutSlateImage());
        hashCode = 31 * hashCode + Objects.hashCode(networkEndBlackoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networkEndBlackoutImage());
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlackoutSlate)) {
            return false;
        }
        BlackoutSlate other = (BlackoutSlate) obj;
        return Objects.equals(blackoutSlateImage(), other.blackoutSlateImage())
                && Objects.equals(networkEndBlackoutAsString(), other.networkEndBlackoutAsString())
                && Objects.equals(networkEndBlackoutImage(), other.networkEndBlackoutImage())
                && Objects.equals(networkId(), other.networkId()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BlackoutSlate").add("BlackoutSlateImage", blackoutSlateImage())
                .add("NetworkEndBlackout", networkEndBlackoutAsString())
                .add("NetworkEndBlackoutImage", networkEndBlackoutImage()).add("NetworkId", networkId())
                .add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlackoutSlateImage":
            return Optional.ofNullable(clazz.cast(blackoutSlateImage()));
        case "NetworkEndBlackout":
            return Optional.ofNullable(clazz.cast(networkEndBlackoutAsString()));
        case "NetworkEndBlackoutImage":
            return Optional.ofNullable(clazz.cast(networkEndBlackoutImage()));
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlackoutSlate, T> g) {
        return obj -> g.apply((BlackoutSlate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlackoutSlate> {
        /**
         * Blackout slate image to be used. Leave empty for solid black. Only bmp and png images are supported.
         * 
         * @param blackoutSlateImage
         *        Blackout slate image to be used. Leave empty for solid black. Only bmp and png images are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blackoutSlateImage(InputLocation blackoutSlateImage);

        /**
         * Blackout slate image to be used. Leave empty for solid black. Only bmp and png images are supported. This is
         * a convenience that creates an instance of the {@link InputLocation.Builder} avoiding the need to create one
         * manually via {@link InputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #blackoutSlateImage(InputLocation)}.
         * 
         * @param blackoutSlateImage
         *        a consumer that will call methods on {@link InputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blackoutSlateImage(InputLocation)
         */
        default Builder blackoutSlateImage(Consumer<InputLocation.Builder> blackoutSlateImage) {
            return blackoutSlateImage(InputLocation.builder().applyMutation(blackoutSlateImage).build());
        }

        /**
         * Setting to enabled causes the encoder to blackout the video, audio, and captions, and raise the
         * "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered. The
         * blackout will be lifted when the Network Start Segmentation Descriptor is encountered. The Network End and
         * Network Start descriptors must contain a network ID that matches the value entered in "Network ID".
         * 
         * @param networkEndBlackout
         *        Setting to enabled causes the encoder to blackout the video, audio, and captions, and raise the
         *        "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered.
         *        The blackout will be lifted when the Network Start Segmentation Descriptor is encountered. The Network
         *        End and Network Start descriptors must contain a network ID that matches the value entered in
         *        "Network ID".
         * @see BlackoutSlateNetworkEndBlackout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlackoutSlateNetworkEndBlackout
         */
        Builder networkEndBlackout(String networkEndBlackout);

        /**
         * Setting to enabled causes the encoder to blackout the video, audio, and captions, and raise the
         * "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered. The
         * blackout will be lifted when the Network Start Segmentation Descriptor is encountered. The Network End and
         * Network Start descriptors must contain a network ID that matches the value entered in "Network ID".
         * 
         * @param networkEndBlackout
         *        Setting to enabled causes the encoder to blackout the video, audio, and captions, and raise the
         *        "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered.
         *        The blackout will be lifted when the Network Start Segmentation Descriptor is encountered. The Network
         *        End and Network Start descriptors must contain a network ID that matches the value entered in
         *        "Network ID".
         * @see BlackoutSlateNetworkEndBlackout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlackoutSlateNetworkEndBlackout
         */
        Builder networkEndBlackout(BlackoutSlateNetworkEndBlackout networkEndBlackout);

        /**
         * Path to local file to use as Network End Blackout image. Image will be scaled to fill the entire output
         * raster.
         * 
         * @param networkEndBlackoutImage
         *        Path to local file to use as Network End Blackout image. Image will be scaled to fill the entire
         *        output raster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkEndBlackoutImage(InputLocation networkEndBlackoutImage);

        /**
         * Path to local file to use as Network End Blackout image. Image will be scaled to fill the entire output
         * raster. This is a convenience that creates an instance of the {@link InputLocation.Builder} avoiding the need
         * to create one manually via {@link InputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #networkEndBlackoutImage(InputLocation)}.
         * 
         * @param networkEndBlackoutImage
         *        a consumer that will call methods on {@link InputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkEndBlackoutImage(InputLocation)
         */
        default Builder networkEndBlackoutImage(Consumer<InputLocation.Builder> networkEndBlackoutImage) {
            return networkEndBlackoutImage(InputLocation.builder().applyMutation(networkEndBlackoutImage).build());
        }

        /**
         * Provides Network ID that matches EIDR ID format (e.g., "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
         * 
         * @param networkId
         *        Provides Network ID that matches EIDR ID format (e.g., "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(String networkId);

        /**
         * When set to enabled, causes video, audio and captions to be blanked when indicated by program metadata.
         * 
         * @param state
         *        When set to enabled, causes video, audio and captions to be blanked when indicated by program
         *        metadata.
         * @see BlackoutSlateState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlackoutSlateState
         */
        Builder state(String state);

        /**
         * When set to enabled, causes video, audio and captions to be blanked when indicated by program metadata.
         * 
         * @param state
         *        When set to enabled, causes video, audio and captions to be blanked when indicated by program
         *        metadata.
         * @see BlackoutSlateState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlackoutSlateState
         */
        Builder state(BlackoutSlateState state);
    }

    static final class BuilderImpl implements Builder {
        private InputLocation blackoutSlateImage;

        private String networkEndBlackout;

        private InputLocation networkEndBlackoutImage;

        private String networkId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(BlackoutSlate model) {
            blackoutSlateImage(model.blackoutSlateImage);
            networkEndBlackout(model.networkEndBlackout);
            networkEndBlackoutImage(model.networkEndBlackoutImage);
            networkId(model.networkId);
            state(model.state);
        }

        public final InputLocation.Builder getBlackoutSlateImage() {
            return blackoutSlateImage != null ? blackoutSlateImage.toBuilder() : null;
        }

        @Override
        public final Builder blackoutSlateImage(InputLocation blackoutSlateImage) {
            this.blackoutSlateImage = blackoutSlateImage;
            return this;
        }

        public final void setBlackoutSlateImage(InputLocation.BuilderImpl blackoutSlateImage) {
            this.blackoutSlateImage = blackoutSlateImage != null ? blackoutSlateImage.build() : null;
        }

        public final String getNetworkEndBlackout() {
            return networkEndBlackout;
        }

        @Override
        public final Builder networkEndBlackout(String networkEndBlackout) {
            this.networkEndBlackout = networkEndBlackout;
            return this;
        }

        @Override
        public final Builder networkEndBlackout(BlackoutSlateNetworkEndBlackout networkEndBlackout) {
            this.networkEndBlackout(networkEndBlackout == null ? null : networkEndBlackout.toString());
            return this;
        }

        public final void setNetworkEndBlackout(String networkEndBlackout) {
            this.networkEndBlackout = networkEndBlackout;
        }

        public final InputLocation.Builder getNetworkEndBlackoutImage() {
            return networkEndBlackoutImage != null ? networkEndBlackoutImage.toBuilder() : null;
        }

        @Override
        public final Builder networkEndBlackoutImage(InputLocation networkEndBlackoutImage) {
            this.networkEndBlackoutImage = networkEndBlackoutImage;
            return this;
        }

        public final void setNetworkEndBlackoutImage(InputLocation.BuilderImpl networkEndBlackoutImage) {
            this.networkEndBlackoutImage = networkEndBlackoutImage != null ? networkEndBlackoutImage.build() : null;
        }

        public final String getNetworkId() {
            return networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BlackoutSlateState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public BlackoutSlate build() {
            return new BlackoutSlate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
