/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for Automatic Input Failover.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomaticInputFailoverSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomaticInputFailoverSettings.Builder, AutomaticInputFailoverSettings> {
    private static final SdkField<String> INPUT_PREFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomaticInputFailoverSettings::inputPreferenceAsString)).setter(setter(Builder::inputPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPreference").build()).build();

    private static final SdkField<String> SECONDARY_INPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomaticInputFailoverSettings::secondaryInputId)).setter(setter(Builder::secondaryInputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryInputId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_PREFERENCE_FIELD,
            SECONDARY_INPUT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputPreference;

    private final String secondaryInputId;

    private AutomaticInputFailoverSettings(BuilderImpl builder) {
        this.inputPreference = builder.inputPreference;
        this.secondaryInputId = builder.secondaryInputId;
    }

    /**
     * Input preference when deciding which input to make active when a previously failed input has recovered.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputPreference}
     * will return {@link InputPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inputPreferenceAsString}.
     * </p>
     * 
     * @return Input preference when deciding which input to make active when a previously failed input has recovered.
     * @see InputPreference
     */
    public InputPreference inputPreference() {
        return InputPreference.fromValue(inputPreference);
    }

    /**
     * Input preference when deciding which input to make active when a previously failed input has recovered.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputPreference}
     * will return {@link InputPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inputPreferenceAsString}.
     * </p>
     * 
     * @return Input preference when deciding which input to make active when a previously failed input has recovered.
     * @see InputPreference
     */
    public String inputPreferenceAsString() {
        return inputPreference;
    }

    /**
     * The input ID of the secondary input in the automatic input failover pair.
     * 
     * @return The input ID of the secondary input in the automatic input failover pair.
     */
    public String secondaryInputId() {
        return secondaryInputId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryInputId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomaticInputFailoverSettings)) {
            return false;
        }
        AutomaticInputFailoverSettings other = (AutomaticInputFailoverSettings) obj;
        return Objects.equals(inputPreferenceAsString(), other.inputPreferenceAsString())
                && Objects.equals(secondaryInputId(), other.secondaryInputId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AutomaticInputFailoverSettings").add("InputPreference", inputPreferenceAsString())
                .add("SecondaryInputId", secondaryInputId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputPreference":
            return Optional.ofNullable(clazz.cast(inputPreferenceAsString()));
        case "SecondaryInputId":
            return Optional.ofNullable(clazz.cast(secondaryInputId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomaticInputFailoverSettings, T> g) {
        return obj -> g.apply((AutomaticInputFailoverSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomaticInputFailoverSettings> {
        /**
         * Input preference when deciding which input to make active when a previously failed input has recovered.
         * 
         * @param inputPreference
         *        Input preference when deciding which input to make active when a previously failed input has
         *        recovered.
         * @see InputPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputPreference
         */
        Builder inputPreference(String inputPreference);

        /**
         * Input preference when deciding which input to make active when a previously failed input has recovered.
         * 
         * @param inputPreference
         *        Input preference when deciding which input to make active when a previously failed input has
         *        recovered.
         * @see InputPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputPreference
         */
        Builder inputPreference(InputPreference inputPreference);

        /**
         * The input ID of the secondary input in the automatic input failover pair.
         * 
         * @param secondaryInputId
         *        The input ID of the secondary input in the automatic input failover pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryInputId(String secondaryInputId);
    }

    static final class BuilderImpl implements Builder {
        private String inputPreference;

        private String secondaryInputId;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomaticInputFailoverSettings model) {
            inputPreference(model.inputPreference);
            secondaryInputId(model.secondaryInputId);
        }

        public final String getInputPreference() {
            return inputPreference;
        }

        @Override
        public final Builder inputPreference(String inputPreference) {
            this.inputPreference = inputPreference;
            return this;
        }

        @Override
        public final Builder inputPreference(InputPreference inputPreference) {
            this.inputPreference(inputPreference == null ? null : inputPreference.toString());
            return this;
        }

        public final void setInputPreference(String inputPreference) {
            this.inputPreference = inputPreference;
        }

        public final String getSecondaryInputId() {
            return secondaryInputId;
        }

        @Override
        public final Builder secondaryInputId(String secondaryInputId) {
            this.secondaryInputId = secondaryInputId;
            return this;
        }

        public final void setSecondaryInputId(String secondaryInputId) {
            this.secondaryInputId = secondaryInputId;
        }

        @Override
        public AutomaticInputFailoverSettings build() {
            return new AutomaticInputFailoverSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
