/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Audio Selector Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioSelectorSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioSelectorSettings.Builder, AudioSelectorSettings> {
    private static final SdkField<AudioLanguageSelection> AUDIO_LANGUAGE_SELECTION_FIELD = SdkField
            .<AudioLanguageSelection> builder(MarshallingType.SDK_POJO)
            .getter(getter(AudioSelectorSettings::audioLanguageSelection)).setter(setter(Builder::audioLanguageSelection))
            .constructor(AudioLanguageSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioLanguageSelection").build())
            .build();

    private static final SdkField<AudioPidSelection> AUDIO_PID_SELECTION_FIELD = SdkField
            .<AudioPidSelection> builder(MarshallingType.SDK_POJO).getter(getter(AudioSelectorSettings::audioPidSelection))
            .setter(setter(Builder::audioPidSelection)).constructor(AudioPidSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioPidSelection").build()).build();

    private static final SdkField<AudioTrackSelection> AUDIO_TRACK_SELECTION_FIELD = SdkField
            .<AudioTrackSelection> builder(MarshallingType.SDK_POJO).getter(getter(AudioSelectorSettings::audioTrackSelection))
            .setter(setter(Builder::audioTrackSelection)).constructor(AudioTrackSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTrackSelection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUDIO_LANGUAGE_SELECTION_FIELD, AUDIO_PID_SELECTION_FIELD, AUDIO_TRACK_SELECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AudioLanguageSelection audioLanguageSelection;

    private final AudioPidSelection audioPidSelection;

    private final AudioTrackSelection audioTrackSelection;

    private AudioSelectorSettings(BuilderImpl builder) {
        this.audioLanguageSelection = builder.audioLanguageSelection;
        this.audioPidSelection = builder.audioPidSelection;
        this.audioTrackSelection = builder.audioTrackSelection;
    }

    /**
     * Returns the value of the AudioLanguageSelection property for this object.
     * 
     * @return The value of the AudioLanguageSelection property for this object.
     */
    public AudioLanguageSelection audioLanguageSelection() {
        return audioLanguageSelection;
    }

    /**
     * Returns the value of the AudioPidSelection property for this object.
     * 
     * @return The value of the AudioPidSelection property for this object.
     */
    public AudioPidSelection audioPidSelection() {
        return audioPidSelection;
    }

    /**
     * Returns the value of the AudioTrackSelection property for this object.
     * 
     * @return The value of the AudioTrackSelection property for this object.
     */
    public AudioTrackSelection audioTrackSelection() {
        return audioTrackSelection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioLanguageSelection());
        hashCode = 31 * hashCode + Objects.hashCode(audioPidSelection());
        hashCode = 31 * hashCode + Objects.hashCode(audioTrackSelection());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelectorSettings)) {
            return false;
        }
        AudioSelectorSettings other = (AudioSelectorSettings) obj;
        return Objects.equals(audioLanguageSelection(), other.audioLanguageSelection())
                && Objects.equals(audioPidSelection(), other.audioPidSelection())
                && Objects.equals(audioTrackSelection(), other.audioTrackSelection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AudioSelectorSettings").add("AudioLanguageSelection", audioLanguageSelection())
                .add("AudioPidSelection", audioPidSelection()).add("AudioTrackSelection", audioTrackSelection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioLanguageSelection":
            return Optional.ofNullable(clazz.cast(audioLanguageSelection()));
        case "AudioPidSelection":
            return Optional.ofNullable(clazz.cast(audioPidSelection()));
        case "AudioTrackSelection":
            return Optional.ofNullable(clazz.cast(audioTrackSelection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioSelectorSettings, T> g) {
        return obj -> g.apply((AudioSelectorSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioSelectorSettings> {
        /**
         * Sets the value of the AudioLanguageSelection property for this object.
         *
         * @param audioLanguageSelection
         *        The new value for the AudioLanguageSelection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioLanguageSelection(AudioLanguageSelection audioLanguageSelection);

        /**
         * Sets the value of the AudioLanguageSelection property for this object.
         *
         * This is a convenience that creates an instance of the {@link AudioLanguageSelection.Builder} avoiding the
         * need to create one manually via {@link AudioLanguageSelection#builder()}.
         *
         * When the {@link Consumer} completes, {@link AudioLanguageSelection.Builder#build()} is called immediately and
         * its result is passed to {@link #audioLanguageSelection(AudioLanguageSelection)}.
         * 
         * @param audioLanguageSelection
         *        a consumer that will call methods on {@link AudioLanguageSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioLanguageSelection(AudioLanguageSelection)
         */
        default Builder audioLanguageSelection(Consumer<AudioLanguageSelection.Builder> audioLanguageSelection) {
            return audioLanguageSelection(AudioLanguageSelection.builder().applyMutation(audioLanguageSelection).build());
        }

        /**
         * Sets the value of the AudioPidSelection property for this object.
         *
         * @param audioPidSelection
         *        The new value for the AudioPidSelection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioPidSelection(AudioPidSelection audioPidSelection);

        /**
         * Sets the value of the AudioPidSelection property for this object.
         *
         * This is a convenience that creates an instance of the {@link AudioPidSelection.Builder} avoiding the need to
         * create one manually via {@link AudioPidSelection#builder()}.
         *
         * When the {@link Consumer} completes, {@link AudioPidSelection.Builder#build()} is called immediately and its
         * result is passed to {@link #audioPidSelection(AudioPidSelection)}.
         * 
         * @param audioPidSelection
         *        a consumer that will call methods on {@link AudioPidSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioPidSelection(AudioPidSelection)
         */
        default Builder audioPidSelection(Consumer<AudioPidSelection.Builder> audioPidSelection) {
            return audioPidSelection(AudioPidSelection.builder().applyMutation(audioPidSelection).build());
        }

        /**
         * Sets the value of the AudioTrackSelection property for this object.
         *
         * @param audioTrackSelection
         *        The new value for the AudioTrackSelection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioTrackSelection(AudioTrackSelection audioTrackSelection);

        /**
         * Sets the value of the AudioTrackSelection property for this object.
         *
         * This is a convenience that creates an instance of the {@link AudioTrackSelection.Builder} avoiding the need
         * to create one manually via {@link AudioTrackSelection#builder()}.
         *
         * When the {@link Consumer} completes, {@link AudioTrackSelection.Builder#build()} is called immediately and
         * its result is passed to {@link #audioTrackSelection(AudioTrackSelection)}.
         * 
         * @param audioTrackSelection
         *        a consumer that will call methods on {@link AudioTrackSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioTrackSelection(AudioTrackSelection)
         */
        default Builder audioTrackSelection(Consumer<AudioTrackSelection.Builder> audioTrackSelection) {
            return audioTrackSelection(AudioTrackSelection.builder().applyMutation(audioTrackSelection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AudioLanguageSelection audioLanguageSelection;

        private AudioPidSelection audioPidSelection;

        private AudioTrackSelection audioTrackSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSelectorSettings model) {
            audioLanguageSelection(model.audioLanguageSelection);
            audioPidSelection(model.audioPidSelection);
            audioTrackSelection(model.audioTrackSelection);
        }

        public final AudioLanguageSelection.Builder getAudioLanguageSelection() {
            return audioLanguageSelection != null ? audioLanguageSelection.toBuilder() : null;
        }

        @Override
        public final Builder audioLanguageSelection(AudioLanguageSelection audioLanguageSelection) {
            this.audioLanguageSelection = audioLanguageSelection;
            return this;
        }

        public final void setAudioLanguageSelection(AudioLanguageSelection.BuilderImpl audioLanguageSelection) {
            this.audioLanguageSelection = audioLanguageSelection != null ? audioLanguageSelection.build() : null;
        }

        public final AudioPidSelection.Builder getAudioPidSelection() {
            return audioPidSelection != null ? audioPidSelection.toBuilder() : null;
        }

        @Override
        public final Builder audioPidSelection(AudioPidSelection audioPidSelection) {
            this.audioPidSelection = audioPidSelection;
            return this;
        }

        public final void setAudioPidSelection(AudioPidSelection.BuilderImpl audioPidSelection) {
            this.audioPidSelection = audioPidSelection != null ? audioPidSelection.build() : null;
        }

        public final AudioTrackSelection.Builder getAudioTrackSelection() {
            return audioTrackSelection != null ? audioTrackSelection.toBuilder() : null;
        }

        @Override
        public final Builder audioTrackSelection(AudioTrackSelection audioTrackSelection) {
            this.audioTrackSelection = audioTrackSelection;
            return this;
        }

        public final void setAudioTrackSelection(AudioTrackSelection.BuilderImpl audioTrackSelection) {
            this.audioTrackSelection = audioTrackSelection != null ? audioTrackSelection.build() : null;
        }

        @Override
        public AudioSelectorSettings build() {
            return new AudioSelectorSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
