/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Audio Only Hls Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioOnlyHlsSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioOnlyHlsSettings.Builder, AudioOnlyHlsSettings> {
    private static final SdkField<String> AUDIO_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AudioOnlyHlsSettings::audioGroupId)).setter(setter(Builder::audioGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioGroupId").build()).build();

    private static final SdkField<InputLocation> AUDIO_ONLY_IMAGE_FIELD = SdkField
            .<InputLocation> builder(MarshallingType.SDK_POJO).getter(getter(AudioOnlyHlsSettings::audioOnlyImage))
            .setter(setter(Builder::audioOnlyImage)).constructor(InputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioOnlyImage").build()).build();

    private static final SdkField<String> AUDIO_TRACK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AudioOnlyHlsSettings::audioTrackTypeAsString)).setter(setter(Builder::audioTrackType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTrackType").build()).build();

    private static final SdkField<String> SEGMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AudioOnlyHlsSettings::segmentTypeAsString)).setter(setter(Builder::segmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_GROUP_ID_FIELD,
            AUDIO_ONLY_IMAGE_FIELD, AUDIO_TRACK_TYPE_FIELD, SEGMENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audioGroupId;

    private final InputLocation audioOnlyImage;

    private final String audioTrackType;

    private final String segmentType;

    private AudioOnlyHlsSettings(BuilderImpl builder) {
        this.audioGroupId = builder.audioGroupId;
        this.audioOnlyImage = builder.audioOnlyImage;
        this.audioTrackType = builder.audioTrackType;
        this.segmentType = builder.segmentType;
    }

    /**
     * Specifies the group to which the audio Rendition belongs.
     * 
     * @return Specifies the group to which the audio Rendition belongs.
     */
    public String audioGroupId() {
        return audioGroupId;
    }

    /**
     * Optional. Specifies the .jpg or .png image to use as the cover art for an audio-only output. We recommend a low
     * bit-size file because the image increases the output audio bandwidth.
     *
     * The image is attached to the audio as an ID3 tag, frame type APIC, picture type 0x10, as per the
     * "ID3 tag version 2.4.0 - Native Frames" standard.
     * 
     * @return Optional. Specifies the .jpg or .png image to use as the cover art for an audio-only output. We recommend
     *         a low bit-size file because the image increases the output audio bandwidth.
     *
     *         The image is attached to the audio as an ID3 tag, frame type APIC, picture type 0x10, as per the
     *         "ID3 tag version 2.4.0 - Native Frames" standard.
     */
    public InputLocation audioOnlyImage() {
        return audioOnlyImage;
    }

    /**
     * Four types of audio-only tracks are supported:
     *
     * Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth
     * scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
     *
     * Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default.
     * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
     *
     * Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by default.
     * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES
     *
     * Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default.
     * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioTrackType}
     * will return {@link AudioOnlyHlsTrackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioTrackTypeAsString}.
     * </p>
     * 
     * @return Four types of audio-only tracks are supported:
     *
     *         Audio-Only Variant Stream The client can play back this audio-only stream instead of video in
     *         low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
     *
     *         Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by
     *         default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
     *
     *         Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by
     *         default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES
     *
     *         Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by
     *         default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
     * @see AudioOnlyHlsTrackType
     */
    public AudioOnlyHlsTrackType audioTrackType() {
        return AudioOnlyHlsTrackType.fromValue(audioTrackType);
    }

    /**
     * Four types of audio-only tracks are supported:
     *
     * Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth
     * scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
     *
     * Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default.
     * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
     *
     * Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by default.
     * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES
     *
     * Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default.
     * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioTrackType}
     * will return {@link AudioOnlyHlsTrackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioTrackTypeAsString}.
     * </p>
     * 
     * @return Four types of audio-only tracks are supported:
     *
     *         Audio-Only Variant Stream The client can play back this audio-only stream instead of video in
     *         low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
     *
     *         Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by
     *         default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
     *
     *         Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by
     *         default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES
     *
     *         Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by
     *         default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
     * @see AudioOnlyHlsTrackType
     */
    public String audioTrackTypeAsString() {
        return audioTrackType;
    }

    /**
     * Specifies the segment type.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentType} will
     * return {@link AudioOnlyHlsSegmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #segmentTypeAsString}.
     * </p>
     * 
     * @return Specifies the segment type.
     * @see AudioOnlyHlsSegmentType
     */
    public AudioOnlyHlsSegmentType segmentType() {
        return AudioOnlyHlsSegmentType.fromValue(segmentType);
    }

    /**
     * Specifies the segment type.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentType} will
     * return {@link AudioOnlyHlsSegmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #segmentTypeAsString}.
     * </p>
     * 
     * @return Specifies the segment type.
     * @see AudioOnlyHlsSegmentType
     */
    public String segmentTypeAsString() {
        return segmentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(audioOnlyImage());
        hashCode = 31 * hashCode + Objects.hashCode(audioTrackTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioOnlyHlsSettings)) {
            return false;
        }
        AudioOnlyHlsSettings other = (AudioOnlyHlsSettings) obj;
        return Objects.equals(audioGroupId(), other.audioGroupId()) && Objects.equals(audioOnlyImage(), other.audioOnlyImage())
                && Objects.equals(audioTrackTypeAsString(), other.audioTrackTypeAsString())
                && Objects.equals(segmentTypeAsString(), other.segmentTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AudioOnlyHlsSettings").add("AudioGroupId", audioGroupId())
                .add("AudioOnlyImage", audioOnlyImage()).add("AudioTrackType", audioTrackTypeAsString())
                .add("SegmentType", segmentTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioGroupId":
            return Optional.ofNullable(clazz.cast(audioGroupId()));
        case "AudioOnlyImage":
            return Optional.ofNullable(clazz.cast(audioOnlyImage()));
        case "AudioTrackType":
            return Optional.ofNullable(clazz.cast(audioTrackTypeAsString()));
        case "SegmentType":
            return Optional.ofNullable(clazz.cast(segmentTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioOnlyHlsSettings, T> g) {
        return obj -> g.apply((AudioOnlyHlsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioOnlyHlsSettings> {
        /**
         * Specifies the group to which the audio Rendition belongs.
         * 
         * @param audioGroupId
         *        Specifies the group to which the audio Rendition belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioGroupId(String audioGroupId);

        /**
         * Optional. Specifies the .jpg or .png image to use as the cover art for an audio-only output. We recommend a
         * low bit-size file because the image increases the output audio bandwidth.
         *
         * The image is attached to the audio as an ID3 tag, frame type APIC, picture type 0x10, as per the
         * "ID3 tag version 2.4.0 - Native Frames" standard.
         * 
         * @param audioOnlyImage
         *        Optional. Specifies the .jpg or .png image to use as the cover art for an audio-only output. We
         *        recommend a low bit-size file because the image increases the output audio bandwidth.
         *
         *        The image is attached to the audio as an ID3 tag, frame type APIC, picture type 0x10, as per the
         *        "ID3 tag version 2.4.0 - Native Frames" standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioOnlyImage(InputLocation audioOnlyImage);

        /**
         * Optional. Specifies the .jpg or .png image to use as the cover art for an audio-only output. We recommend a
         * low bit-size file because the image increases the output audio bandwidth.
         *
         * The image is attached to the audio as an ID3 tag, frame type APIC, picture type 0x10, as per the
         * "ID3 tag version 2.4.0 - Native Frames" standard. This is a convenience that creates an instance of the
         * {@link InputLocation.Builder} avoiding the need to create one manually via {@link InputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #audioOnlyImage(InputLocation)}.
         * 
         * @param audioOnlyImage
         *        a consumer that will call methods on {@link InputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioOnlyImage(InputLocation)
         */
        default Builder audioOnlyImage(Consumer<InputLocation.Builder> audioOnlyImage) {
            return audioOnlyImage(InputLocation.builder().applyMutation(audioOnlyImage).build());
        }

        /**
         * Four types of audio-only tracks are supported:
         *
         * Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth
         * scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
         *
         * Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default.
         * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
         *
         * Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by
         * default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES
         *
         * Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default.
         * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
         * 
         * @param audioTrackType
         *        Four types of audio-only tracks are supported:
         *
         *        Audio-Only Variant Stream The client can play back this audio-only stream instead of video in
         *        low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
         *
         *        Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by
         *        default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
         *
         *        Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by
         *        default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES
         *
         *        Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by
         *        default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
         * @see AudioOnlyHlsTrackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioOnlyHlsTrackType
         */
        Builder audioTrackType(String audioTrackType);

        /**
         * Four types of audio-only tracks are supported:
         *
         * Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth
         * scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
         *
         * Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default.
         * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
         *
         * Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by
         * default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES
         *
         * Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default.
         * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
         * 
         * @param audioTrackType
         *        Four types of audio-only tracks are supported:
         *
         *        Audio-Only Variant Stream The client can play back this audio-only stream instead of video in
         *        low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
         *
         *        Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by
         *        default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
         *
         *        Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by
         *        default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES
         *
         *        Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by
         *        default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
         * @see AudioOnlyHlsTrackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioOnlyHlsTrackType
         */
        Builder audioTrackType(AudioOnlyHlsTrackType audioTrackType);

        /**
         * Specifies the segment type.
         * 
         * @param segmentType
         *        Specifies the segment type.
         * @see AudioOnlyHlsSegmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioOnlyHlsSegmentType
         */
        Builder segmentType(String segmentType);

        /**
         * Specifies the segment type.
         * 
         * @param segmentType
         *        Specifies the segment type.
         * @see AudioOnlyHlsSegmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioOnlyHlsSegmentType
         */
        Builder segmentType(AudioOnlyHlsSegmentType segmentType);
    }

    static final class BuilderImpl implements Builder {
        private String audioGroupId;

        private InputLocation audioOnlyImage;

        private String audioTrackType;

        private String segmentType;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioOnlyHlsSettings model) {
            audioGroupId(model.audioGroupId);
            audioOnlyImage(model.audioOnlyImage);
            audioTrackType(model.audioTrackType);
            segmentType(model.segmentType);
        }

        public final String getAudioGroupId() {
            return audioGroupId;
        }

        @Override
        public final Builder audioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
            return this;
        }

        public final void setAudioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
        }

        public final InputLocation.Builder getAudioOnlyImage() {
            return audioOnlyImage != null ? audioOnlyImage.toBuilder() : null;
        }

        @Override
        public final Builder audioOnlyImage(InputLocation audioOnlyImage) {
            this.audioOnlyImage = audioOnlyImage;
            return this;
        }

        public final void setAudioOnlyImage(InputLocation.BuilderImpl audioOnlyImage) {
            this.audioOnlyImage = audioOnlyImage != null ? audioOnlyImage.build() : null;
        }

        public final String getAudioTrackType() {
            return audioTrackType;
        }

        @Override
        public final Builder audioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
            return this;
        }

        @Override
        public final Builder audioTrackType(AudioOnlyHlsTrackType audioTrackType) {
            this.audioTrackType(audioTrackType == null ? null : audioTrackType.toString());
            return this;
        }

        public final void setAudioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
        }

        public final String getSegmentType() {
            return segmentType;
        }

        @Override
        public final Builder segmentType(String segmentType) {
            this.segmentType = segmentType;
            return this;
        }

        @Override
        public final Builder segmentType(AudioOnlyHlsSegmentType segmentType) {
            this.segmentType(segmentType == null ? null : segmentType.toString());
            return this;
        }

        public final void setSegmentType(String segmentType) {
            this.segmentType = segmentType;
        }

        @Override
        public AudioOnlyHlsSettings build() {
            return new AudioOnlyHlsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
